/*
 * Copyright (c) 2002 Isao SEKI <iseki@gongon.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * This file is included in WiStunbler package.
 *
 * $Id: gpscontrol.c,v 1.1 2002/08/09 07:21:06 iseki Exp $
 */

#include "stumbler.h"
#include <netinet/in.h>
#include <netdb.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/time.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <termios.h>
#include <string.h>

#define GPS_BUFSIZ 2048

int get_addr(host)
	char *host;
{
	struct hostent *h;
	static struct in_addr a;

	a.s_addr = inet_addr(host);
	if(a.s_addr != -1)
		return (int)a.s_addr;

	h = (struct hostent *)gethostbyname(host);
	if(h != NULL)
		return *(int *)(h->h_addr_list[0]);

	return (int)a.s_addr;
}

int gps_open(dev)
	char *dev;
{
	struct termios termios;
	struct sockaddr_in serv;
	char *t;
	unsigned short p;

	if ( open(dev,O_RDONLY,0)>= 0) // use file
	{
		gps_fd = -1;
		if (dev == NULL)
			return -1;
		if ((gps_fd = open(dev, O_RDONLY, 0)) < 0) {
			perror("open");
			return -1;
		}
		if (tcgetattr(gps_fd, &termios) != 0) {
			perror("tcgetattr");
			return -1;
		}
		cfsetospeed(&termios, B4800); cfsetispeed(&termios, B4800);
		termios.c_cflag &= ~(CSIZE|PARENB);
		termios.c_cflag |= CS8;
		termios.c_cflag |= CLOCAL;
		termios.c_iflag &= ~(ISTRIP|ICRNL);
		termios.c_oflag &= ~OPOST;
		termios.c_lflag &= ~(ICANON|ISIG|IEXTEN|ECHO);
		termios.c_lflag &= ~(IXON|IXOFF);
		termios.c_cc[VMIN] = 1;
		termios.c_cc[VTIME] = 0;
		if (tcsetattr(gps_fd, TCSAFLUSH, &termios) != 0) {
			perror("tcgetattr");
			return -1;
		}
	} else { // use network GPS

		serv.sin_family = AF_INET;

		p = 2947;
		t = strchr(dev, ':');
		if(t != NULL)
		{
			*t++ = '\0';
			p = atoi(t);
		}

		gps_fd = get_addr(dev);
		memcpy(&serv.sin_addr, &gps_fd, sizeof(int));
		serv.sin_port = htons(p);

		gps_fd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
		if(gps_fd < 0)
		{
			perror("socket");
			return -1;
		}
		if(connect(gps_fd, (struct sockaddr *)&serv, sizeof(serv)) < 0)
		{
			perror("connect");
			return -1;
		}
	}


	return gps_fd;
}

void gps_close()
{
	close(gps_fd);
	gps_fd = -1;
}

/* return -1: read() or select() error
 *         0: no date, should need retry
 *        >1: read byte
 */
int gps_read()
{
	struct timeval timeout;
	struct fd_set fdr;
	char buf[GPS_BUFSIZ];
	int len;

// i'm not sure if this code works fine on serial gps's TEST IT!
#if !OLDCODE
	if(gps_fd <= 0)
		return -1;

	if(write(gps_fd, "P\n", 2) < 0)
	{
		perror("write");
		return -1;
	}
#endif

	timeout.tv_sec = 0; timeout.tv_usec = 100;
	FD_ZERO(&fdr);
	FD_SET(gps_fd, &fdr);
	if (select(gps_fd+1, &fdr, NULL, NULL, &timeout) > 0) {
		if (FD_ISSET(gps_fd, &fdr)) {
			if ((len = read(gps_fd, buf, GPS_BUFSIZ)) < 0) {
				perror("cant read from GPS");
				return -1;
			}
			buf[len] = '\0';
			gps_parse(buf);
			return len;
		}
	}
	return 0;
}

void gps_parse(line)
	char *line;
{
	char *ptr, *line_p, buf[GPS_BUFSIZ];
	int nSatellite;

	strncpy(buf, line, GPS_BUFSIZ);
	line_p = buf;

	while ((ptr = index(line_p, '\n')) != NULL) {
		*ptr = '\0';
		if (!strncmp("$GPGGA,", line_p, 7)) {
			sscanf(line_p, "%*[^,],%*f,%f,%c,%f,%c,%*[^,],%d,",
					&dir.Ndeg, &dir.N, &dir.Edeg, &dir.E, &nSatellite);
			if (!strncmp("GPSD,", line_p, 4)) {
				sscanf(line_p, "GPSD,P=%f %f\n",
						&dir.Ndeg, &dir.Edeg);
				/* must look more than 3 Satellites */
#if OLDCODE
				if ((nSatellite < 3) || (!dir.Edeg) || (!dir.Ndeg)) {
					dir.Ndeg = 0.0; dir.N = 'N';
					dir.Edeg = 0.0; dir.E = 'E';
				} else {
					dir.Ndeg /= 100.0;
					dir.Edeg /= 100.0;
				}
#endif
				dir.N = 'S';
				dir.E = 'W';
				if(dir.N >= 0)
					dir.N = 'N';
				if(dir.E >= 0)
					dir.E = 'E';

				break;
			}
			line_p = ptr + 1;
		}
	}
}

#if 0
main()
{
	int gps = 1;

	if (gps)
		if (gps_open("/dev/dty00") <= 0) // localhost
			exit (-1);
	while (1) {
		if (gps_read() > 0)
			printf("gps: %c %f\t%c %f\n", dir.N, dir.Ndeg, dir.E, dir.Edeg);
		sleep(2);
	}
}
#endif
