/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class JideCursors {
    public static final int FIRST_CUSTOM_CURSOR = 20;
    public static final int HSPLIT_CURSOR = 20;
    public static final int VSPLIT_CURSOR = 21;
    public static final int DRAG_CURSOR = 22;
    public static final int DRAG_STOP_CURSOR = 23;
    public static final int NORTH_CURSOR = 24;
    public static final int SOUTH_CURSOR = 25;
    public static final int EAST_CURSOR = 26;
    public static final int WEST_CURSOR = 27;
    public static final int TAB_CURSOR = 28;
    public static final int FLOAT_CURSOR = 29;
    public static final int VERTICAL_CURSOR = 30;
    public static final int HORIZONTAL_CURSOR = 31;
    public static final int LAST_CUSTOM_CURSOR = 32;
    private static final Cursor[] a = new Cursor[12];

    public static Cursor getPredefinedCursor(int n) {
        if (n < 20 || n > 32) {
            throw new IllegalArgumentException("illegal cursor type");
        }
        if (a[n - 20] == null) {
            JideCursors.a[n - 20] = JideCursors.createCursor(n);
        }
        return a[n - 20];
    }

    protected static Cursor createCursor(int n) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getBestCursorSize(32, 32);
        int n2 = toolkit.getMaximumCursorColors();
        switch (n) {
            case 20: {
                if (dimension.width != 0 && n2 > 3) {
                    ImageIcon imageIcon = (ImageIcon)UIManager.getIcon("Cursor.hsplit");
                    if (imageIcon == null) {
                        return Cursor.getPredefinedCursor(11);
                    }
                    return toolkit.createCustomCursor(imageIcon.getImage(), new Point(15, 15), "Horizonal Split");
                }
                return Cursor.getPredefinedCursor(11);
            }
            case 21: {
                if (dimension.width != 0 && n2 > 3) {
                    ImageIcon imageIcon = (ImageIcon)UIManager.getIcon("Cursor.vsplit");
                    if (imageIcon == null) {
                        return Cursor.getPredefinedCursor(9);
                    }
                    return toolkit.createCustomCursor(imageIcon.getImage(), new Point(15, 15), "Vertical Split");
                }
                return Cursor.getPredefinedCursor(9);
            }
            case 22: {
                if (dimension.width != 0 && n2 > 3) {
                    ImageIcon imageIcon = (ImageIcon)UIManager.getIcon("Cursor.drag");
                    if (imageIcon == null) {
                        return Cursor.getPredefinedCursor(0);
                    }
                    return toolkit.createCustomCursor(imageIcon.getImage(), new Point(17, 12), "Drag");
                }
                return Cursor.getPredefinedCursor(0);
            }
            case 23: {
                if (dimension.width != 0 && n2 > 3) {
                    ImageIcon imageIcon = (ImageIcon)UIManager.getIcon("Cursor.dragStop");
                    if (imageIcon == null) {
                        return Cursor.getPredefinedCursor(0);
                    }
                    return toolkit.createCustomCursor(imageIcon.getImage(), new Point(17, 12), "Drag Stop");
                }
                return Cursor.getPredefinedCursor(0);
            }
            case 24: {
                if (dimension.width != 0 && n2 > 3) {
                    ImageIcon imageIcon = (ImageIcon)UIManager.getIcon("Cursor.north");
                    if (imageIcon == null) {
                        return Cursor.getPredefinedCursor(0);
                    }
                    return toolkit.createCustomCursor(imageIcon.getImage(), new Point(15, 10), "North");
                }
                return Cursor.getPredefinedCursor(0);
            }
            case 25: {
                if (dimension.width != 0 && n2 > 3) {
                    ImageIcon imageIcon = (ImageIcon)UIManager.getIcon("Cursor.south");
                    if (imageIcon == null) {
                        return Cursor.getPredefinedCursor(0);
                    }
                    return toolkit.createCustomCursor(imageIcon.getImage(), new Point(15, 20), "South");
                }
                return Cursor.getPredefinedCursor(0);
            }
            case 26: {
                if (dimension.width != 0 && n2 > 3) {
                    ImageIcon imageIcon = (ImageIcon)UIManager.getIcon("Cursor.east");
                    if (imageIcon == null) {
                        return Cursor.getPredefinedCursor(0);
                    }
                    return toolkit.createCustomCursor(imageIcon.getImage(), new Point(20, 15), "East");
                }
                return Cursor.getPredefinedCursor(0);
            }
            case 27: {
                if (dimension.width != 0 && n2 > 3) {
                    ImageIcon imageIcon = (ImageIcon)UIManager.getIcon("Cursor.west");
                    if (imageIcon == null) {
                        return Cursor.getPredefinedCursor(0);
                    }
                    return toolkit.createCustomCursor(imageIcon.getImage(), new Point(10, 15), "West");
                }
                return Cursor.getPredefinedCursor(0);
            }
            case 28: {
                if (dimension.width != 0 && n2 > 3) {
                    ImageIcon imageIcon = (ImageIcon)UIManager.getIcon("Cursor.tab");
                    if (imageIcon == null) {
                        return Cursor.getPredefinedCursor(0);
                    }
                    return toolkit.createCustomCursor(imageIcon.getImage(), new Point(15, 15), "Tabbed");
                }
                return Cursor.getPredefinedCursor(0);
            }
            case 29: {
                if (dimension.width != 0 && n2 > 3) {
                    ImageIcon imageIcon = (ImageIcon)UIManager.getIcon("Cursor.float");
                    if (imageIcon == null) {
                        return Cursor.getPredefinedCursor(0);
                    }
                    return toolkit.createCustomCursor(imageIcon.getImage(), new Point(15, 15), "Floating");
                }
                return Cursor.getPredefinedCursor(0);
            }
            case 30: {
                if (dimension.width != 0 && n2 > 3) {
                    ImageIcon imageIcon = (ImageIcon)UIManager.getIcon("Cursor.vertical");
                    if (imageIcon == null) {
                        return Cursor.getPredefinedCursor(0);
                    }
                    return toolkit.createCustomCursor(imageIcon.getImage(), new Point(15, 15), "Vertical");
                }
                return Cursor.getPredefinedCursor(0);
            }
            case 31: {
                if (dimension.width != 0 && n2 > 3) {
                    ImageIcon imageIcon = (ImageIcon)UIManager.getIcon("Cursor.horizontal");
                    if (imageIcon == null) {
                        return Cursor.getPredefinedCursor(0);
                    }
                    return toolkit.createCustomCursor(imageIcon.getImage(), new Point(15, 15), "Horizontal");
                }
                return Cursor.getPredefinedCursor(0);
            }
        }
        return null;
    }

    static {
        for (int i = 20; i < 32; ++i) {
            JideCursors.getPredefinedCursor(i);
        }
    }
}

