/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.LayoutPersistence;
import com.jidesoft.utils.SystemInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public abstract class AbstractLayoutPersistence
implements LayoutPersistence {
    protected short _version = (short)19;
    protected static final String DEFAULT_PROFILE_NAME = "default";
    protected String _profileKey = "profile";
    protected static final int MAX_PREF_BYTE_ARRAY_LENGTH = 6144;
    protected boolean _loadingLayoutData = false;
    protected boolean _useFrameBounds = true;
    protected boolean _useFrameState = true;
    protected boolean _usePref = true;
    protected static final String LAYOUT_COUNT_STRING = "_count";
    protected final String LAYOUT_POSTFIX = ".layout";
    protected String _layoutDirectory = null;

    public short getVersion() {
        return this._version;
    }

    public void setVersion(short s) {
        this._version = s;
    }

    public void setProfileKey(String string) {
        this._profileKey = string;
    }

    private static void a(Preferences preferences, String string, byte[] byArray) {
        block12: {
            int n;
            int n2;
            int n3;
            int n4;
            block13: {
                block14: {
                    n4 = JideSwingUtilities.a;
                    n3 = byArray.length;
                    if (n4 != 0) break block13;
                    if (n3 > 6144) break block14;
                    n2 = preferences.getInt(string + LAYOUT_COUNT_STRING, -99);
                    if (n4 == 0) {
                        if (n2 > 0) {
                            for (n = 0; n < n2; ++n) {
                                preferences.remove(string + "_" + n);
                                if (n4 == 0) {
                                    if (n4 == 0) continue;
                                }
                                break;
                            }
                        } else {
                            preferences.putByteArray(string, byArray);
                            preferences.putInt(string + LAYOUT_COUNT_STRING, 0);
                        }
                    }
                    if (n4 == 0) break block12;
                }
                n3 = preferences.getInt(string + LAYOUT_COUNT_STRING, -99);
            }
            int n5 = n2 = n3;
            if (n4 == 0) {
                if (n5 == 0) {
                    preferences.remove(string);
                }
                n5 = byArray.length / 6144 + 1;
            }
            n = n5;
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, byArray.length);
            byte[] byArray2 = new byte[6144];
            for (int i = 0; i < n; ++i) {
                block17: {
                    int n6;
                    int n7;
                    block15: {
                        block16: {
                            if (n4 != 0) break block12;
                            n7 = i;
                            n6 = n - 1;
                            if (n4 != 0) break block15;
                            if (n7 == n6) break block16;
                            byteBuffer.get(byArray2, 0, 6144);
                            if (n4 == 0) break block17;
                        }
                        n7 = byArray.length;
                        n6 = i * 6144;
                    }
                    int n8 = n7 - n6;
                    byArray2 = new byte[n8];
                    byteBuffer.get(byArray2, 0, n8);
                }
                preferences.putByteArray(string + "_" + i, byArray2);
                if (n4 == 0) continue;
            }
            preferences.putInt(string + LAYOUT_COUNT_STRING, n);
        }
    }

    private static byte[] a(Preferences preferences, String string) {
        int n;
        ByteBuffer byteBuffer;
        block4: {
            int n2;
            int n3 = JideSwingUtilities.a;
            byte[] byArray = new byte[]{};
            int n4 = n2 = preferences.getInt(string + LAYOUT_COUNT_STRING, 0);
            if (n3 == 0) {
                if (n4 == 0) {
                    return preferences.getByteArray(string, byArray);
                }
                n4 = n2 * 6144;
            }
            byteBuffer = ByteBuffer.allocate(n4);
            for (n = 0; n < n2; ++n) {
                byteBuffer.put(preferences.getByteArray(string + "_" + n, byArray));
                if (n3 == 0) {
                    if (n3 == 0) continue;
                }
                break block4;
            }
            n = byteBuffer.position();
        }
        byte[] byArray = new byte[n];
        byteBuffer.position(0);
        byteBuffer.get(byArray, 0, n);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLayoutData() {
        boolean bl = this._loadingLayoutData;
        this._loadingLayoutData = true;
        try {
            this.loadLayoutDataFrom(DEFAULT_PROFILE_NAME);
        }
        finally {
            this._loadingLayoutData = bl;
        }
    }

    public boolean isLayoutAvailable(String string) {
        int n;
        block8: {
            int n2;
            block9: {
                block7: {
                    n = JideSwingUtilities.a;
                    n2 = this._usePref;
                    if (n != 0) break block7;
                    if (n2 == 0) break block8;
                    n2 = SystemInfo.isWindows();
                }
                if (n != 0) break block9;
                if (n2 == 0) break block8;
                n2 = 0;
            }
            byte[] byArray = new byte[n2];
            Preferences preferences = Preferences.userRoot();
            byArray = AbstractLayoutPersistence.a(preferences.node(this._profileKey), string);
            boolean bl = byArray.length;
            if (n == 0) {
                if (!bl) {
                    return false;
                }
                bl = true;
            }
            return bl;
        }
        String string2 = this.getLayoutDirectory() + File.separator + string + ".layout";
        File file = new File(string2);
        boolean bl = file.exists();
        if (n == 0) {
            if (!bl) {
                return false;
            }
            bl = true;
        }
        return bl;
    }

    public List getAvailableLayouts() {
        File file;
        ArrayList<String> arrayList;
        int n;
        block16: {
            boolean bl;
            block15: {
                n = JideSwingUtilities.a;
                arrayList = new ArrayList<String>();
                bl = this._usePref;
                if (n != 0) break block15;
                if (!bl) break block16;
                bl = SystemInfo.isWindows();
            }
            if (bl) {
                Preferences preferences = Preferences.userRoot();
                try {
                    Preferences preferences2 = preferences.node(this._profileKey);
                    String[] stringArray = preferences2.keys();
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        String string = stringArray[n2];
                        if (n == 0) {
                            if (n == 0) {
                                if (string.endsWith(LAYOUT_COUNT_STRING)) {
                                    arrayList.add(string.substring(0, string.length() - LAYOUT_COUNT_STRING.length()));
                                }
                                ++n2;
                            }
                            if (n == 0) continue;
                        }
                        break;
                    }
                }
                catch (BackingStoreException backingStoreException) {
                    // empty catch block
                }
                return arrayList;
            }
        }
        String string = this.getLayoutDirectory() + File.separator;
        File file2 = file = new File(string);
        if (n == 0) {
            if (!file2.exists()) {
                return arrayList;
            }
            file2 = file;
        }
        File[] fileArray = file2.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                boolean bl = string.endsWith(".layout");
                if (JideSwingUtilities.a == 0) {
                    if (bl) {
                        return true;
                    }
                    bl = false;
                }
                return bl;
            }
        });
        int n3 = 0;
        while (n3 < fileArray.length) {
            String string2 = fileArray[n3].getName();
            if (n == 0) {
                if (string2.endsWith(".layout")) {
                    arrayList.add(string2.substring(0, string2.length() - ".layout".length()));
                }
                ++n3;
            }
            if (n == 0) continue;
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeLayout(String string) {
        Object object;
        Object object2;
        int n;
        block13: {
            boolean bl;
            block12: {
                n = JideSwingUtilities.a;
                bl = this._usePref;
                if (n != 0) break block12;
                if (!bl) break block13;
                bl = SystemInfo.isWindows();
            }
            if (bl) {
                block11: {
                    int n2;
                    int n3;
                    object2 = Preferences.userRoot();
                    object = ((Preferences)object2).node(this._profileKey);
                    int n4 = n3 = ((Preferences)object).getInt(string + LAYOUT_COUNT_STRING, 0);
                    if (n == 0) {
                        if (n4 == 0) {
                            return;
                        }
                        n4 = n2 = 0;
                    }
                    while (n2 < n3) {
                        ((Preferences)object).remove(string + "_" + n2);
                        ++n2;
                        if (n == 0) {
                            if (n == 0) continue;
                        }
                        break block11;
                    }
                    ((Preferences)object).remove(string + LAYOUT_COUNT_STRING);
                }
                if (n == 0) return;
            }
        }
        object2 = this.getLayoutDirectory() + File.separator + string + ".layout";
        try {
            object = new File((String)object2);
            boolean bl = ((File)object).exists();
            if (n == 0) {
                if (!bl) {
                    return;
                }
                bl = ((File)object).delete();
            }
            if (!bl) return;
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLayoutDataFrom(String string) {
        block11: {
            int n = JideSwingUtilities.a;
            boolean bl = this._loadingLayoutData;
            this._loadingLayoutData = true;
            try {
                byte[] byArray;
                block19: {
                    block18: {
                        byte[] byArray2;
                        block17: {
                            block14: {
                                Object object;
                                block13: {
                                    boolean bl2;
                                    block12: {
                                        byArray = new byte[]{};
                                        bl2 = this._usePref;
                                        if (n != 0) break block12;
                                        if (!bl2) break block13;
                                        bl2 = SystemInfo.isWindows();
                                    }
                                    if (!bl2) break block13;
                                    object = Preferences.userRoot();
                                    byArray = AbstractLayoutPersistence.a(((Preferences)object).node(this._profileKey), string);
                                    if (n == 0) break block14;
                                }
                                object = this.getLayoutDirectory() + File.separator + string + ".layout";
                                try {
                                    File file;
                                    block16: {
                                        boolean bl3;
                                        block15: {
                                            file = new File((String)object);
                                            bl3 = file.exists();
                                            if (n != 0) break block15;
                                            if (bl3) break block16;
                                            bl3 = file.createNewFile();
                                        }
                                        if (!bl3) {
                                            throw new IOException("Cannot open " + (String)object);
                                        }
                                    }
                                    FileInputStream fileInputStream = new FileInputStream(file);
                                    int n2 = fileInputStream.available();
                                    byArray = new byte[n2];
                                    fileInputStream.read(byArray);
                                    fileInputStream.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            byArray2 = byArray;
                            if (n != 0) break block17;
                            if (byArray2 == null) break block18;
                            byArray2 = byArray;
                        }
                        if (byArray2.length != 0) break block19;
                    }
                    this.resetToDefault();
                    if (n == 0) break block11;
                }
                this.loadLayoutFrom(new ByteArrayInputStream(byArray));
            }
            finally {
                this._loadingLayoutData = bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLayoutDataFromFile(String string) {
        block8: {
            int n = JideSwingUtilities.a;
            boolean bl = this._loadingLayoutData;
            this._loadingLayoutData = true;
            try {
                byte[] byArray;
                block11: {
                    block10: {
                        byte[] byArray2;
                        block9: {
                            byArray = null;
                            try {
                                File file = new File(string);
                                if (file.exists()) {
                                    FileInputStream fileInputStream = new FileInputStream(file);
                                    int n2 = fileInputStream.available();
                                    byArray = new byte[n2];
                                    fileInputStream.read(byArray);
                                    fileInputStream.close();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            byArray2 = byArray;
                            if (n != 0) break block9;
                            if (byArray2 == null) break block10;
                            byArray2 = byArray;
                        }
                        if (byArray2.length != 0) break block11;
                    }
                    this.resetToDefault();
                    if (n == 0) break block8;
                }
                this.loadLayoutFrom(new ByteArrayInputStream(byArray));
            }
            finally {
                this._loadingLayoutData = bl;
            }
        }
    }

    public void saveLayoutData() {
        AbstractLayoutPersistence abstractLayoutPersistence = this;
        if (JideSwingUtilities.a == 0) {
            if (abstractLayoutPersistence._loadingLayoutData) {
                return;
            }
            abstractLayoutPersistence = this;
        }
        abstractLayoutPersistence.saveLayoutDataAs(DEFAULT_PROFILE_NAME);
    }

    public String getLayoutDirectory() {
        String string;
        block4: {
            block5: {
                String string2;
                block7: {
                    boolean bl;
                    block6: {
                        int n = JideSwingUtilities.a;
                        string = this._layoutDirectory;
                        if (n != 0) break block4;
                        if (string != null) break block5;
                        string2 = System.getProperty("user.home") + File.separator + "." + this._profileKey;
                        File file = new File(string2);
                        bl = file.isDirectory();
                        if (n != 0) break block6;
                        if (bl) break block7;
                        bl = file.mkdirs();
                    }
                    if (!bl) {
                        System.err.println("Failed to create directory: " + string2);
                    }
                }
                return string2;
            }
            string = this._layoutDirectory;
        }
        return string;
    }

    public void setLayoutDirectory(String string) {
        this._layoutDirectory = string;
    }

    public void saveLayoutDataAs(String string) {
        block13: {
            int n = JideSwingUtilities.a;
            if (this._loadingLayoutData) {
                return;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                Object object;
                block15: {
                    boolean bl;
                    block14: {
                        this.saveLayoutTo(byteArrayOutputStream);
                        bl = this._usePref;
                        if (n != 0) break block14;
                        if (!bl) break block15;
                        bl = SystemInfo.isWindows();
                    }
                    if (bl) {
                        object = Preferences.userRoot();
                        AbstractLayoutPersistence.a(((Preferences)object).node(this._profileKey), string, byteArrayOutputStream.toByteArray());
                        if (n == 0) break block13;
                    }
                }
                object = this.getLayoutDirectory() + File.separator + string + ".layout";
                try {
                    File file;
                    block17: {
                        boolean bl;
                        block16: {
                            file = new File((String)object);
                            bl = file.exists();
                            if (n != 0) break block16;
                            if (bl) break block17;
                            bl = file.createNewFile();
                        }
                        if (!bl) {
                            throw new IOException("Cannot open " + (String)object);
                        }
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(byteArrayOutputStream.toByteArray());
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    System.err.println(exception.getLocalizedMessage());
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLayoutDataToFile(String string) {
        if (this._loadingLayoutData) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.saveLayoutTo(byteArrayOutputStream);
            try {
                File file;
                block12: {
                    boolean bl;
                    block11: {
                        file = new File(string);
                        bl = file.exists();
                        if (JideSwingUtilities.a != 0) break block11;
                        if (bl) break block12;
                        bl = file.createNewFile();
                    }
                    if (!bl) {
                        throw new IOException("Cannot open " + string);
                    }
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byteArrayOutputStream.toByteArray());
                fileOutputStream.close();
            }
            catch (Exception exception) {
                System.err.println(exception.getLocalizedMessage());
            }
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException.getLocalizedMessage());
        }
    }

    public void setLayoutData(String string) {
        this.loadLayoutFrom(new ByteArrayInputStream(string.getBytes()));
    }

    public String getLayoutData() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.saveLayoutTo(byteArrayOutputStream);
            return byteArrayOutputStream.toString();
        }
        catch (IOException iOException) {
            System.err.println(iOException.getLocalizedMessage());
            return "";
        }
    }

    public void setUsePref(boolean bl) {
        this._usePref = bl;
    }

    public void setUseFrameState(boolean bl) {
        this._useFrameState = bl;
    }

    public void setUseFrameBounds(boolean bl) {
        this._useFrameBounds = bl;
    }
}

