/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.icons.MaskFilter;
import com.jidesoft.plaf.JideTabbedPaneUI;
import com.jidesoft.plaf.basic.BasicJideTabbedPaneUI;
import com.jidesoft.plaf.basic.Painter;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.plaf.basic.a;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.PortingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class BasicDockableFrameTitlePane
extends JComponent
implements MouseListener {
    protected AbstractButton _autohideButton;
    protected AbstractButton _hideButton;
    protected AbstractButton _floatButton;
    protected AbstractButton _maximizeButton;
    protected JLabel _title;
    protected JPopupMenu _popupMenu;
    protected DockableFrame _frame;
    protected Color _backgroundColor;
    protected Color _selectedTitleColor;
    protected Color _selectedTextColor;
    protected Color _selectedTitleBorderColor;
    protected Color _notSelectedTitleColor;
    protected Color _notSelectedTextColor;
    protected Color _notSelectedTitleBorderColor;
    protected PropertyChangeListener propertyChangeListener;
    protected Action _hideAction;
    private JMenuItem a;
    protected Action _floatingAction;
    private JMenuItem b;
    protected Action _autohideAction;
    private JMenuItem c;
    protected Action _maximizeAction;
    private JMenuItem d;
    protected String _hideText;
    protected String _dockableText;
    protected String _autohideText;
    protected String _floatingText;
    protected String _maximizeText;
    protected String _hideButtonToolTip;
    protected String _autohideButtonToolTip;
    protected String _floatButtonToolTip;
    protected String _maximizeButtonToolTip;
    protected ImageIcon _hideIcon = (ImageIcon)UIManager.getIcon("DockableFrameTitlePane.hideIcon");
    protected ImageIcon _autohideIcon = (ImageIcon)UIManager.getIcon("DockableFrameTitlePane.autohideIcon");
    protected ImageIcon _stopAutohideIcon = (ImageIcon)UIManager.getIcon("DockableFrameTitlePane.stopAutohideIcon");
    protected ImageIcon _floatIcon = (ImageIcon)UIManager.getIcon("DockableFrameTitlePane.floatIcon");
    protected ImageIcon _unfloatIcon = (ImageIcon)UIManager.getIcon("DockableFrameTitlePane.unfloatIcon");
    protected ImageIcon _maximizeIcon = (ImageIcon)UIManager.getIcon("DockableFrameTitlePane.maximizeIcon");
    protected ImageIcon _restoreIcon = (ImageIcon)UIManager.getIcon("DockableFrameTitlePane.restoreIcon");
    protected int _gripperWidth = 6;
    protected boolean _titleBarComponentCanBeOneSameLine = false;
    protected boolean _alwaysShowAllButtons = false;
    protected boolean _showIcon = false;
    protected int _buttonsAlignment = 11;
    protected int _titleAlignment = 10;
    protected int _buttonGap = 2;
    protected Insets _titleInsets = new Insets(0, 0, 0, 0);
    private ThemePainter e;
    protected Painter _gripperPainter;
    private Dimension f = null;

    public BasicDockableFrameTitlePane(DockableFrame dockableFrame) {
        this._frame = dockableFrame;
        this.installTitlePane();
    }

    protected void installTitlePane() {
        this.installDefaults();
        this.installListeners();
        this.createActions();
        this.setLayout(this.createLayout());
        this.createComponents();
        this.addSubComponents();
    }

    protected Dimension getMaximumButtonSize() {
        Dimension dimension;
        block29: {
            block30: {
                block37: {
                    int n;
                    int n2;
                    block36: {
                        int n3;
                        block35: {
                            int n4;
                            boolean bl;
                            block34: {
                                int n5;
                                int n6;
                                block33: {
                                    block32: {
                                        block31: {
                                            bl = BasicJideTabbedPaneUI.t;
                                            dimension = this.f;
                                            if (bl) break block29;
                                            if (dimension != null) break block30;
                                            BasicDockableFrameTitlePane basicDockableFrameTitlePane = this;
                                            if (bl) break block31;
                                            if (basicDockableFrameTitlePane._hideIcon != null) break block32;
                                            basicDockableFrameTitlePane = this;
                                        }
                                        basicDockableFrameTitlePane.f = new Dimension(8, 8);
                                        if (!bl) break block30;
                                    }
                                    n4 = n6 = 8;
                                    n5 = this._hideIcon.getIconWidth();
                                    if (!bl) {
                                        if (n4 < n5) {
                                            n6 = this._hideIcon.getIconWidth();
                                        }
                                        n4 = n6;
                                        n5 = this._autohideIcon.getIconWidth();
                                    }
                                    if (!bl) {
                                        if (n4 < n5) {
                                            n6 = this._autohideIcon.getIconWidth();
                                        }
                                        n4 = n6;
                                        n5 = this._stopAutohideIcon.getIconWidth();
                                    }
                                    if (!bl) {
                                        if (n4 < n5) {
                                            n6 = this._stopAutohideIcon.getIconWidth();
                                        }
                                        n4 = n6;
                                        n5 = this._floatIcon.getIconWidth();
                                    }
                                    if (!bl) {
                                        if (n4 < n5) {
                                            n6 = this._floatIcon.getIconWidth();
                                        }
                                        n4 = n6;
                                        n5 = this._unfloatIcon.getIconWidth();
                                    }
                                    if (!bl) {
                                        if (n4 < n5) {
                                            n6 = this._unfloatIcon.getIconWidth();
                                        }
                                        n4 = n6;
                                        n5 = this._maximizeIcon.getIconWidth();
                                    }
                                    if (bl) break block33;
                                    if (n4 < n5) {
                                        n6 = this._maximizeIcon.getIconWidth();
                                    }
                                    n4 = n6;
                                    if (bl) break block34;
                                    n5 = this._restoreIcon.getIconWidth();
                                }
                                if (n4 < n5) {
                                    n6 = this._restoreIcon.getIconWidth();
                                }
                                n4 = 8;
                            }
                            n = n2 = n4;
                            n3 = this._hideIcon.getIconHeight();
                            if (!bl) {
                                if (n < n3) {
                                    n2 = this._hideIcon.getIconHeight();
                                }
                                n = n2;
                                n3 = this._autohideIcon.getIconHeight();
                            }
                            if (!bl) {
                                if (n < n3) {
                                    n2 = this._autohideIcon.getIconHeight();
                                }
                                n = n2;
                                n3 = this._stopAutohideIcon.getIconHeight();
                            }
                            if (!bl) {
                                if (n < n3) {
                                    n2 = this._stopAutohideIcon.getIconHeight();
                                }
                                n = n2;
                                n3 = this._floatIcon.getIconHeight();
                            }
                            if (!bl) {
                                if (n < n3) {
                                    n2 = this._floatIcon.getIconHeight();
                                }
                                n = n2;
                                n3 = this._unfloatIcon.getIconHeight();
                            }
                            if (!bl) {
                                if (n < n3) {
                                    n2 = this._unfloatIcon.getIconHeight();
                                }
                                n = n2;
                                n3 = this._maximizeIcon.getIconHeight();
                            }
                            if (bl) break block35;
                            if (n < n3) {
                                n2 = this._maximizeIcon.getIconHeight();
                            }
                            n = n2;
                            if (bl) break block36;
                            n3 = this._restoreIcon.getIconHeight();
                        }
                        if (n >= n3) break block37;
                        n = this._restoreIcon.getIconHeight();
                    }
                    n2 = n;
                }
                this.f = new Dimension(n6 += 2, n2 += 2);
            }
            dimension = this.f;
        }
        return dimension;
    }

    protected void addSubComponents() {
        this.add(this._title);
        if (this._alwaysShowAllButtons) {
            if (this._maximizeButton != null) {
                this.add(this._maximizeButton);
            }
            if (this._floatButton != null) {
                this.add(this._floatButton);
            }
            if (this._hideButton != null) {
                this.add(this._hideButton);
            }
            if (this._autohideButton != null) {
                this.add(this._autohideButton);
            }
        } else {
            if (this._frame.isDockable()) {
                this.add(this._maximizeButton);
            } else {
                this.remove(this._maximizeButton);
            }
            if (this._frame.isFloatable() && (this._frame.getDockingManager() == null || this._frame.getDockingManager().isFloatable())) {
                if (this._frame.isDockable()) {
                    this.add(this._floatButton);
                } else {
                    this.remove(this._floatButton);
                }
            } else {
                this.remove(this._floatButton);
            }
            if (this._frame.isAutohidable() && (this._frame.getDockingManager() == null || this._frame.getDockingManager().isAutohidable())) {
                this.add(this._autohideButton);
            } else {
                this.remove(this._autohideButton);
            }
            if (this._frame.isHidable() && (this._frame.getDockingManager() == null || this._frame.getDockingManager().isHidable())) {
                this.add(this._hideButton);
            } else {
                this.remove(this._hideButton);
            }
        }
        if (this._frame.getTitleBarComponent() != null) {
            this.add(this._frame.getTitleBarComponent());
        }
    }

    protected void createActions() {
        this._floatingAction = new FloatingAction();
        this._hideAction = new HideAction();
        this._autohideAction = new AutoHideAction();
        this._maximizeAction = new a_();
    }

    protected void installListeners() {
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = this.createPropertyChangeListener();
        }
        this._frame.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallListeners() {
        this._frame.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    protected void installDefaults() {
        boolean bl = BasicJideTabbedPaneUI.t;
        this.e = (ThemePainter)UIManager.get("Theme.painter");
        this._gripperPainter = (Painter)UIManager.get("DockableFrameTitlePane.gripperPainter");
        this.setBorder(UIManager.getBorder("DockableFrame.titleBorder"));
        this._backgroundColor = UIManager.getColor("DockableFrame.background");
        this._selectedTitleColor = UIManager.getColor("DockableFrame.activeTitleBackground");
        this._selectedTextColor = UIManager.getColor("DockableFrame.activeTitleForeground");
        this._selectedTitleBorderColor = UIManager.getColor("DockableFrame.activeTitleBorderColor");
        this._notSelectedTitleColor = UIManager.getColor("DockableFrame.inactiveTitleBackground");
        this._notSelectedTextColor = UIManager.getColor("DockableFrame.inactiveTitleForeground");
        this._notSelectedTitleBorderColor = UIManager.getColor("DockableFrame.inactiveTitleBorderColor");
        this.setFont(UIManager.getFont("DockableFrameTitlePane.font"));
        this._hideText = com.jidesoft.plaf.basic.a.a.getString("DockableFrameTitlePane.hideText");
        this._dockableText = com.jidesoft.plaf.basic.a.a.getString("DockableFrameTitlePane.dockableText");
        this._floatingText = com.jidesoft.plaf.basic.a.a.getString("DockableFrameTitlePane.floatingText");
        this._autohideText = com.jidesoft.plaf.basic.a.a.getString("DockableFrameTitlePane.autohideText");
        this._maximizeText = com.jidesoft.plaf.basic.a.a.getString("DockableFrameTitlePane.maximizeText");
        this._hideButtonToolTip = com.jidesoft.plaf.basic.a.a.getString("DockableFrameTitlePane.closeText");
        this._autohideButtonToolTip = com.jidesoft.plaf.basic.a.a.getString("DockableFrameTitlePane.autohideTooltip");
        this._floatButtonToolTip = com.jidesoft.plaf.basic.a.a.getString("DockableFrameTitlePane.floatingTooltip");
        this._maximizeButtonToolTip = com.jidesoft.plaf.basic.a.a.getString("DockableFrameTitlePane.maximizeTooltip");
        this._titleBarComponentCanBeOneSameLine = UIManager.getBoolean("DockableFrameTitlePane.titleBarComponent");
        this._showIcon = UIManager.getBoolean("DockableFrameTitlePane.showIcon");
        this._alwaysShowAllButtons = UIManager.getBoolean("DockableFrameTitlePane.alwaysShowAllButtons");
        this._buttonsAlignment = UIManager.getInt("DockableFrameTitlePane.buttonsAlignment");
        this._titleAlignment = UIManager.getInt("DockableFrameTitlePane.titleAlignment");
        this._buttonGap = UIManager.getInt("DockableFrameTitlePane.buttonGap");
        this._titleInsets = UIManager.getInsets("DockableFrameTitlePane.margin");
        this._gripperWidth = UIManager.getInt("Gripper.size");
        if (JideTabbedPaneUI.a != 0) {
            BasicJideTabbedPaneUI.t = !bl;
        }
    }

    protected void uninstallDefaults() {
        this._backgroundColor = null;
        this._selectedTitleColor = null;
        this._selectedTextColor = null;
        this._selectedTitleBorderColor = null;
        this._notSelectedTitleColor = null;
        this._notSelectedTextColor = null;
        this._notSelectedTitleBorderColor = null;
        this._hideText = null;
        this._dockableText = null;
        this._floatingText = null;
        this._autohideText = null;
        this._maximizeText = null;
        this._hideButtonToolTip = null;
        this._autohideButtonToolTip = null;
        this._floatButtonToolTip = null;
        this._maximizeButtonToolTip = null;
        this._titleInsets = null;
        this.setBorder(null);
        this.e = null;
        this._gripperPainter = null;
    }

    protected void createComponents() {
        this._title = new JLabel(this._frame.getTitle());
        this._title.setOpaque(false);
        this._title.setFont(this.getFont());
        this._title.setHorizontalAlignment(this._titleAlignment);
        this._title.setVerticalAlignment(0);
        if (this._frame.isActive()) {
            this._title.setForeground(this._selectedTextColor);
        } else {
            this._title.setForeground(this._notSelectedTextColor);
        }
        if (this._showIcon) {
            this._title.setIcon(this._frame.getIcon());
        }
        this._floatButton = this.createTitleBarButton();
        this._floatButton.addActionListener(this._floatingAction);
        this._floatButton.setName(this._floatingText);
        if (this._floatButtonToolTip != null && this._floatButtonToolTip.length() != 0) {
            this._floatButton.setToolTipText(this._floatButtonToolTip);
        }
        this._autohideButton = this.createTitleBarButton();
        this._autohideButton.addActionListener(this._autohideAction);
        this._autohideButton.setName(this._autohideText);
        if (this._autohideButtonToolTip != null && this._autohideButtonToolTip.length() != 0) {
            this._autohideButton.setToolTipText(this._autohideButtonToolTip);
        }
        this._hideButton = this.createTitleBarButton();
        this._hideButton.addActionListener(this._hideAction);
        this._hideButton.setName(this._hideText);
        if (this._hideButtonToolTip != null && this._hideButtonToolTip.length() != 0) {
            this._hideButton.setToolTipText(this._hideButtonToolTip);
        }
        this._maximizeButton = this.createTitleBarButton();
        this._maximizeButton.addActionListener(this._maximizeAction);
        this._maximizeButton.setName(this._maximizeText);
        if (this._maximizeButtonToolTip != null && this._maximizeButtonToolTip.length() != 0) {
            this._maximizeButton.setToolTipText(this._maximizeButtonToolTip);
        }
        this.setButtonIcons();
    }

    protected AbstractButton createTitleBarButton() {
        return new NoFocusButton();
    }

    protected void changeButtonType(AbstractButton abstractButton, int n) {
        block3: {
            AbstractButton abstractButton2;
            block2: {
                abstractButton2 = abstractButton;
                if (BasicJideTabbedPaneUI.t) break block2;
                if (!(abstractButton2 instanceof NoFocusButton)) break block3;
                abstractButton2 = abstractButton;
            }
            ((NoFocusButton)abstractButton2).setType(n);
        }
    }

    protected void setButtonIcons() {
        this.changeButtonType(this._hideButton, 0);
        if (!this._frame.isAutohideShowing()) {
            this.changeButtonType(this._autohideButton, 1);
        } else {
            this.changeButtonType(this._autohideButton, 2);
        }
        if (!this._frame.isFloated()) {
            this.changeButtonType(this._floatButton, 3);
        } else {
            this.changeButtonType(this._floatButton, 4);
        }
        if (!this._frame.isMaximized()) {
            this.changeButtonType(this._maximizeButton, 5);
        } else {
            this.changeButtonType(this._maximizeButton, 6);
        }
    }

    protected void addPopupMenuItems(JPopupMenu jPopupMenu) {
        this.a = jPopupMenu.add(new JCheckBoxMenuItem(this._hideAction));
        this.a.setMnemonic(com.jidesoft.plaf.basic.a.a.getString("DockableFrameTitlePane.hideMnemonic").charAt(0));
        this.b = jPopupMenu.add(new JCheckBoxMenuItem(this._floatingAction));
        this.b.setMnemonic(com.jidesoft.plaf.basic.a.a.getString("DockableFrameTitlePane.floatingMnemonic").charAt(0));
        this.c = jPopupMenu.add(new JCheckBoxMenuItem(this._autohideAction));
        this.c.setMnemonic(com.jidesoft.plaf.basic.a.a.getString("DockableFrameTitlePane.autohideMnemonic").charAt(0));
        this.d = jPopupMenu.add(new JCheckBoxMenuItem(this._maximizeAction));
        this.d.setMnemonic(com.jidesoft.plaf.basic.a.a.getString("DockableFrameTitlePane.maximizeMnemonic").charAt(0));
    }

    protected JPopupMenu createPopupMenu() {
        return new JidePopupMenu();
    }

    public void paintComponent(Graphics graphics) {
        Border border = this.getBorder();
        if (border != null) {
            border.paintBorder(this, graphics, 0, 0, this.getWidth(), this.getTitleBarHeight());
        }
        this.paintTitleBackground(graphics);
        this._title.setOpaque(false);
        this._title.setFont(this.getFont());
        if (this._frame.isActive()) {
            this._title.setForeground(this._selectedTextColor);
        } else {
            this._title.setForeground(this._notSelectedTextColor);
        }
        this.paintGripper(graphics);
    }

    protected void paintGripper(Graphics graphics) {
        if (!this._frame.isShowGripper()) {
            return;
        }
        Rectangle rectangle = null;
        rectangle = this._frame.getComponentOrientation().isLeftToRight() ? new Rectangle(2, 0, this._gripperWidth, this.getTitleBarHeight()) : new Rectangle(this.getWidth() - this._gripperWidth, 0, this.getWidth() - this._titleInsets.right, this.getTitleBarHeight());
        if (this._gripperPainter != null) {
            this._gripperPainter.paint(graphics, (Component)this._frame, rectangle, 0, this._frame.isActive() ? 3 : 0);
        } else {
            this.getPainter().paintGripper(graphics, rectangle, 0, this._frame.isActive() ? 3 : 0);
        }
    }

    protected void paintTitleBackground(Graphics graphics) {
        Cloneable cloneable;
        boolean bl = this._frame.isActive();
        int n = this.getTitleBarHeight();
        graphics.setColor(this._backgroundColor);
        graphics.fillRect(0, 0, this.getWidth(), this.getTitleBarHeight());
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getWidth() - 1;
        int n5 = n;
        if (this.getBorder() != null) {
            cloneable = this.getBorder().getBorderInsets(this);
            n2 += cloneable.left;
            n3 += cloneable.top;
            n4 -= cloneable.right + cloneable.left;
            n5 -= cloneable.top + cloneable.bottom;
        }
        cloneable = new Rectangle(n2 + 1, n3 + 1, n4 - 1, n5 - 1);
        if (bl) {
            graphics.setColor(this._selectedTitleBorderColor);
            if ("true".equals(System.getProperty("shadingtheme"))) {
                graphics.drawRoundRect(n2, n3, n4, n5, 2, 2);
            } else {
                graphics.drawRect(n2, n3, n4, n5);
            }
            graphics.setColor(this._selectedTitleColor);
            graphics.fillRect(((Rectangle)cloneable).x, ((Rectangle)cloneable).y, ((Rectangle)cloneable).width, ((Rectangle)cloneable).height);
        } else {
            graphics.setColor(this._notSelectedTitleBorderColor);
            graphics.drawRoundRect(n2, n3, n4, n5, 2, 2);
            graphics.setColor(this._notSelectedTitleColor);
            graphics.fillRect(((Rectangle)cloneable).x, ((Rectangle)cloneable).y, ((Rectangle)cloneable).width, ((Rectangle)cloneable).height);
        }
        if ("true".equals(System.getProperty("shadingtheme"))) {
            JideSwingUtilities.fillGradient(graphics, (Rectangle)cloneable, 0);
        }
    }

    protected String getTitle(String string, FontMetrics fontMetrics, int n) {
        block10: {
            int n2;
            String string2;
            boolean bl;
            block15: {
                int n3;
                block13: {
                    block14: {
                        String string3;
                        block11: {
                            block12: {
                                bl = BasicJideTabbedPaneUI.t;
                                string3 = string;
                                if (bl) break block11;
                                if (string3 == null) break block12;
                                n3 = string.equals("");
                                if (bl) break block13;
                                if (n3 == 0) break block14;
                            }
                            string3 = "";
                        }
                        return string3;
                    }
                    n3 = SwingUtilities.computeStringWidth(fontMetrics, string);
                }
                int n4 = n3;
                string2 = "...";
                n2 = n4;
                if (bl) break block15;
                if (n2 <= n) break block10;
                n2 = SwingUtilities.computeStringWidth(fontMetrics, string2);
            }
            int n5 = n2;
            int n6 = 0;
            while (n6 < string.length()) {
                n5 += fontMetrics.charWidth(string.charAt(n6));
                if (!bl) {
                    if (!bl) {
                        if (n5 > n && !bl) break;
                        ++n6;
                    }
                    if (!bl) continue;
                }
                break block10;
            }
            string = string.substring(0, n6) + string2;
        }
        return string;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    public void popupMenu(MouseEvent mouseEvent) {
        this._popupMenu.show(this, mouseEvent.getX() + 1, mouseEvent.getY() + 1);
        mouseEvent.consume();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popupMenu(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popupMenu(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popupMenu(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected int getLeftmostButtonX(int n, Container container) {
        int n2;
        block27: {
            int n3;
            block26: {
                JComponent jComponent;
                boolean bl;
                block25: {
                    block22: {
                        block23: {
                            int n4;
                            block24: {
                                int n5;
                                block20: {
                                    block21: {
                                        block18: {
                                            block19: {
                                                block16: {
                                                    block17: {
                                                        bl = BasicJideTabbedPaneUI.t;
                                                        n3 = n;
                                                        n5 = this.a();
                                                        if (bl) break block16;
                                                        if (n5 == 0) break block17;
                                                        n5 = n3;
                                                        if (bl) break block16;
                                                        if (n5 > this._hideButton.getX()) {
                                                            n3 = this._hideButton.getX();
                                                        }
                                                    }
                                                    n5 = this.b() ? 1 : 0;
                                                }
                                                if (bl) break block18;
                                                if (n5 == 0) break block19;
                                                n5 = n3;
                                                if (bl) break block18;
                                                if (n5 > this._autohideButton.getX()) {
                                                    n3 = this._autohideButton.getX();
                                                }
                                            }
                                            n5 = this.c() ? 1 : 0;
                                        }
                                        if (bl) break block20;
                                        if (n5 == 0) break block21;
                                        n5 = n3;
                                        if (bl) break block20;
                                        if (n5 > this._floatButton.getX()) {
                                            n3 = this._floatButton.getX();
                                        }
                                    }
                                    jComponent = this;
                                    if (bl) break block22;
                                    n5 = ((BasicDockableFrameTitlePane)jComponent).d() ? 1 : 0;
                                }
                                if (n5 == 0) break block23;
                                n4 = n3;
                                if (bl) break block24;
                                if (n4 <= this._maximizeButton.getX()) break block23;
                                n4 = this._maximizeButton.getX();
                            }
                            n3 = n4;
                        }
                        jComponent = this._frame.getTitleBarComponent();
                    }
                    if (bl) break block25;
                    if (jComponent == null) break block26;
                    jComponent = this._frame.getTitleBarComponent();
                }
                n2 = jComponent.isVisible();
                if (bl) break block27;
                if (n2 == 0) break block26;
                n2 = this.isSameLine(container) ? 1 : 0;
                if (bl) break block27;
                if (n2 != 0) {
                    n3 -= this._frame.getTitleBarComponent().getPreferredSize().width - this._buttonGap;
                }
            }
            n2 = n3;
        }
        return n2;
    }

    protected boolean isCloseButtonVisible() {
        boolean bl = this._frame.getAvailableButtons() & 1;
        if (!BasicJideTabbedPaneUI.t) {
            bl = bl;
        }
        return bl;
    }

    protected boolean isAutohideButtonVisible() {
        boolean bl = this._frame.getAvailableButtons() & 2;
        if (!BasicJideTabbedPaneUI.t) {
            bl = bl;
        }
        return bl;
    }

    protected boolean isFloatingButtonVisible() {
        boolean bl = this._frame.getAvailableButtons() & 4;
        if (!BasicJideTabbedPaneUI.t) {
            bl = bl;
        }
        return bl;
    }

    protected boolean isMaximizeButtonVisible() {
        boolean bl = this._frame.getAvailableButtons() & 8;
        if (!BasicJideTabbedPaneUI.t) {
            bl = bl;
        }
        return bl;
    }

    protected int getTitleBarHeight() {
        Dimension dimension = this.getMaximumButtonSize();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.getHeight() + 2;
        n = Math.max(dimension.height + (this._hideIcon == null ? 0 : 5), n);
        Insets insets = this.getInsets();
        if (this._frame != null && this._frame.getTitleBarComponent() != null && this._frame.getTitleBarComponent().isVisible() && this.isSameLine((Container)this._frame)) {
            Dimension dimension2 = this._frame.getTitleBarComponent().getPreferredSize();
            return Math.max(n + insets.top + insets.bottom + this._titleInsets.top + this._titleInsets.bottom, dimension2.height);
        }
        return n + insets.top + insets.bottom + this._titleInsets.top + this._titleInsets.bottom;
    }

    protected boolean isSameLine(Container container) {
        int n;
        int n2;
        if (!this._titleBarComponentCanBeOneSameLine) {
            return false;
        }
        Dimension dimension = null;
        dimension = this._frame.getTitleBarComponent() != null && this._frame.getTitleBarComponent().isVisible() ? this._frame.getTitleBarComponent().getPreferredSize() : new Dimension(0, 0);
        Dimension dimension2 = this.getMaximumButtonSize();
        int n3 = 3 * (dimension2.width + 6 + 2);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        String string = this._frame.getTitle();
        int n4 = string != null ? fontMetrics.stringWidth(string) : 0;
        int n5 = n2 = string != null ? string.length() : 0;
        n3 = n2 > 3 ? (n3 += n4 < (n = fontMetrics.stringWidth(string.substring(0, 3) + "...")) ? n4 : n) : (n3 += n4);
        n = 0;
        if (this._titleBarComponentCanBeOneSameLine && n3 + dimension.width < container.getWidth()) {
            n = 1;
        }
        return n != 0;
    }

    protected void enableButton(AbstractButton abstractButton, boolean bl) {
        block4: {
            block5: {
                boolean bl2;
                boolean bl3;
                block2: {
                    block3: {
                        bl3 = BasicJideTabbedPaneUI.t;
                        bl2 = this._alwaysShowAllButtons;
                        if (bl3) break block2;
                        if (!bl2) break block3;
                        abstractButton.setEnabled(bl);
                        if (!bl3) break block4;
                    }
                    bl2 = bl;
                }
                if (!bl2) break block5;
                this.add(abstractButton);
                if (!bl3) break block4;
            }
            this.remove(abstractButton);
        }
    }

    private boolean a() {
        return this.isCloseButtonVisible() && (this._alwaysShowAllButtons || this._frame.isHidable() && this._frame.getDockingManager() != null && this._frame.getDockingManager().isHidable() && (this._frame.getAvailableButtons() & 1) != 0);
    }

    private boolean b() {
        return this.isAutohideButtonVisible() && (this._alwaysShowAllButtons || !this._frame.isMaximized() && !this._frame.isFloated() && this._frame.isAutohidable() && (this._frame.getDockingManager() == null || this._frame.getDockingManager().isAutohidable()) && (this._frame.getAvailableButtons() & 2) != 0);
    }

    private boolean c() {
        return this.isFloatingButtonVisible() && (this._alwaysShowAllButtons || !this._frame.isMaximized() && this._frame.isFloatable() && this._frame.isDockable() && (this._frame.getDockingManager() == null || this._frame.getDockingManager().isFloatable()) && (this._frame.getAvailableButtons() & 4) != 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean d() {
        boolean bl = BasicJideTabbedPaneUI.t;
        boolean bl2 = this.isMaximizeButtonVisible();
        if (!bl) {
            if (!bl2) return false;
            bl2 = this._alwaysShowAllButtons;
        }
        if (bl) return bl2;
        if (bl2) return true;
        bl2 = this._frame.isMaximizable();
        if (!bl) {
            if (!bl2) return false;
            bl2 = this._frame.isFloated();
        }
        if (!bl) {
            if (bl2) return false;
            bl2 = this._frame.isAutohide();
        }
        if (!bl) {
            if (bl2) return false;
            bl2 = this._frame.isAutohideShowing();
        }
        if (bl) return bl2;
        if (bl2) return false;
        return true;
    }

    public ThemePainter getPainter() {
        return this.e;
    }

    public class NoFocusButton
    extends JButton
    implements MouseMotionListener,
    MouseListener {
        public static final int CLOSE_BUTTON = 0;
        public static final int AUTOHIDE_BUTTON = 1;
        public static final int STOP_AUTOHIDE_BUTTON = 2;
        public static final int FLOAT_BUTTON = 3;
        public static final int UNFLOAT_BUTTON = 4;
        public static final int MAXIMIZE_BUTTON = 5;
        public static final int RESTORE_BUTTON = 6;
        public static final int ACTION_BUTTON = 100;
        private int a;
        private boolean b = false;
        private boolean c = false;

        public void updateUI() {
            super.updateUI();
            this.setFocusPainted(false);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorder(null);
        }

        public NoFocusButton() {
            this.setOpaque(false);
            this.setContentAreaFilled(false);
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
        }

        public NoFocusButton(Action action) {
            this();
            this.setAction(action);
            this.a = 100;
        }

        protected void paintComponent(Graphics graphics) {
            if (this.b && this.c) {
                graphics.setColor(Color.black);
                graphics.drawLine(0, 0, this.getWidth() - 1, 0);
                graphics.drawLine(0, this.getHeight() - 2, 0, 1);
                if (BasicDockableFrameTitlePane.this._frame.isActive()) {
                    graphics.setColor(Color.lightGray);
                } else {
                    graphics.setColor(Color.white);
                }
                graphics.drawLine(this.getWidth() - 1, 1, this.getWidth() - 1, this.getHeight() - 2);
                graphics.drawLine(this.getWidth() - 1, this.getHeight() - 1, 0, this.getHeight() - 1);
            } else if (this.b) {
                if (BasicDockableFrameTitlePane.this._frame.isActive()) {
                    graphics.setColor(Color.lightGray);
                } else {
                    graphics.setColor(Color.white);
                }
                graphics.drawLine(0, 0, this.getWidth() - 1, 0);
                graphics.drawLine(0, this.getHeight() - 2, 0, 1);
                graphics.setColor(Color.black);
                graphics.drawLine(this.getWidth() - 1, 1, this.getWidth() - 1, this.getHeight() - 2);
                graphics.drawLine(this.getWidth() - 1, this.getHeight() - 1, 0, this.getHeight() - 1);
            }
            Color color = BasicDockableFrameTitlePane.this._frame.isActive() ? BasicDockableFrameTitlePane.this._selectedTextColor : BasicDockableFrameTitlePane.this._notSelectedTextColor;
            switch (this.a) {
                case 100: {
                    ImageIcon imageIcon = (ImageIcon)this.getAction().getValue("SmallIcon");
                    int n = imageIcon.getIconWidth() / 2;
                    int n2 = imageIcon.getIconHeight() / 2;
                    int n3 = this.getWidth() / 2 - n;
                    int n4 = this.getHeight() / 2 - n2;
                    new ImageIcon(MaskFilter.createImage(((ImageIcon)this.getAction().getValue("SmallIcon")).getImage(), Color.black, color)).paintIcon(this, graphics, n3, n4);
                    break;
                }
                case 0: {
                    ImageIcon imageIcon = BasicDockableFrameTitlePane.this._hideIcon;
                    int n = imageIcon.getIconWidth() / 2;
                    int n5 = imageIcon.getIconHeight() / 2;
                    int n6 = this.getWidth() / 2 - n;
                    int n7 = this.getHeight() / 2 - n5;
                    new ImageIcon(MaskFilter.createImage(imageIcon.getImage(), Color.black, color)).paintIcon(this, graphics, n6, n7);
                    break;
                }
                case 1: {
                    ImageIcon imageIcon = BasicDockableFrameTitlePane.this._autohideIcon;
                    int n = imageIcon.getIconWidth() / 2;
                    int n8 = imageIcon.getIconHeight() / 2;
                    int n9 = this.getWidth() / 2 - n;
                    int n10 = this.getHeight() / 2 - n8;
                    new ImageIcon(MaskFilter.createImage(imageIcon.getImage(), Color.black, color)).paintIcon(this, graphics, n9, n10);
                    break;
                }
                case 2: {
                    ImageIcon imageIcon = BasicDockableFrameTitlePane.this._stopAutohideIcon;
                    int n = imageIcon.getIconWidth() / 2;
                    int n11 = imageIcon.getIconHeight() / 2;
                    int n12 = this.getWidth() / 2 - n;
                    int n13 = this.getHeight() / 2 - n11;
                    new ImageIcon(MaskFilter.createImage(imageIcon.getImage(), Color.black, color)).paintIcon(this, graphics, n12, n13);
                    break;
                }
                case 3: {
                    ImageIcon imageIcon = BasicDockableFrameTitlePane.this._floatIcon;
                    int n = imageIcon.getIconWidth() / 2;
                    int n14 = imageIcon.getIconHeight() / 2;
                    int n15 = this.getWidth() / 2 - n;
                    int n16 = this.getHeight() / 2 - n14;
                    new ImageIcon(MaskFilter.createImage(imageIcon.getImage(), Color.black, color)).paintIcon(this, graphics, n15, n16);
                    break;
                }
                case 4: {
                    ImageIcon imageIcon = BasicDockableFrameTitlePane.this._unfloatIcon;
                    int n = imageIcon.getIconWidth() / 2;
                    int n17 = imageIcon.getIconHeight() / 2;
                    int n18 = this.getWidth() / 2 - n;
                    int n19 = this.getHeight() / 2 - n17;
                    new ImageIcon(MaskFilter.createImage(imageIcon.getImage(), Color.black, color)).paintIcon(this, graphics, n18, n19);
                    break;
                }
                case 5: {
                    ImageIcon imageIcon = BasicDockableFrameTitlePane.this._maximizeIcon;
                    int n = imageIcon.getIconWidth() / 2;
                    int n20 = imageIcon.getIconHeight() / 2;
                    int n21 = this.getWidth() / 2 - n;
                    int n22 = this.getHeight() / 2 - n20;
                    new ImageIcon(MaskFilter.createImage(imageIcon.getImage(), Color.black, color)).paintIcon(this, graphics, n21, n22);
                    break;
                }
                case 6: {
                    ImageIcon imageIcon = BasicDockableFrameTitlePane.this._restoreIcon;
                    int n = imageIcon.getIconWidth() / 2;
                    int n23 = imageIcon.getIconHeight() / 2;
                    int n24 = this.getWidth() / 2 - n;
                    int n25 = this.getHeight() / 2 - n23;
                    new ImageIcon(MaskFilter.createImage(imageIcon.getImage(), Color.black, color)).paintIcon(this, graphics, n24, n25);
                }
            }
        }

        public boolean isFocusable() {
            return false;
        }

        public void requestFocus() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.a(506, mouseEvent, (Component)BasicDockableFrameTitlePane.this._frame);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.b = true;
            this.repaint();
            this.a(503, mouseEvent, (Component)BasicDockableFrameTitlePane.this._frame);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.c = false;
            this.b = false;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.c = true;
            this.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.c = false;
            this.b = false;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.b = true;
            this.repaint();
            this.a(504, mouseEvent, (Component)BasicDockableFrameTitlePane.this._frame);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.b = false;
            this.c = false;
            this.repaint();
            this.a(504, mouseEvent, (Component)BasicDockableFrameTitlePane.this._frame);
        }

        private void a(int n, MouseEvent mouseEvent, Component component) {
            if (component == null) {
                return;
            }
            Point point = SwingUtilities.convertPoint(this, mouseEvent.getX(), mouseEvent.getY(), component);
            MouseEvent mouseEvent2 = new MouseEvent(component, n, mouseEvent.getWhen(), PortingUtils.getMouseModifiers(mouseEvent), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            component.dispatchEvent(mouseEvent2);
        }

        public int getType() {
            return this.a;
        }

        public void setType(int n) {
            this.a = n;
        }
    }

    private class a_
    extends AbstractAction {
        public a_() {
            super(BasicDockableFrameTitlePane.this._maximizeText);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!BasicDockableFrameTitlePane.this._frame.isMaximized()) {
                BasicDockableFrameTitlePane.this._frame.getDockingManager().maximizeFrame(BasicDockableFrameTitlePane.this._frame.getKey());
            } else {
                BasicDockableFrameTitlePane.this._frame.getDockingManager().restoreFrame();
            }
        }
    }

    public class AutoHideAction
    extends AbstractAction {
        public AutoHideAction() {
            super(BasicDockableFrameTitlePane.this._autohideText);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block3: {
                DockingManager dockingManager;
                block2: {
                    dockingManager = BasicDockableFrameTitlePane.this._frame.getDockingManager();
                    if (BasicJideTabbedPaneUI.t) break block2;
                    if (dockingManager == null) break block3;
                    BasicDockableFrameTitlePane.this._frame.getDockingManager().addUndo(com.jidesoft.plaf.basic.a.a.getString("Undo.toggleAutohide"));
                    dockingManager = BasicDockableFrameTitlePane.this._frame.getDockingManager();
                }
                dockingManager.toggleAutohideState(BasicDockableFrameTitlePane.this._frame.getKey());
            }
        }
    }

    public class FloatingAction
    extends AbstractAction {
        public FloatingAction() {
            super(BasicDockableFrameTitlePane.this._floatingText);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block3: {
                DockingManager dockingManager;
                block2: {
                    dockingManager = BasicDockableFrameTitlePane.this._frame.getDockingManager();
                    if (BasicJideTabbedPaneUI.t) break block2;
                    if (dockingManager == null) break block3;
                    BasicDockableFrameTitlePane.this._frame.getDockingManager().addUndo(com.jidesoft.plaf.basic.a.a.getString("Undo.toggle"));
                    dockingManager = BasicDockableFrameTitlePane.this._frame.getDockingManager();
                }
                dockingManager.toggleState(BasicDockableFrameTitlePane.this._frame, false);
            }
        }
    }

    public class HideAction
    extends AbstractAction {
        public HideAction() {
            super(BasicDockableFrameTitlePane.this._hideText);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicDockableFrameTitlePane.this._frame.getDockingManager() != null && !BasicDockableFrameTitlePane.this._frame.isHidden()) {
                BasicDockableFrameTitlePane.this._frame.getDockingManager().addUndo(com.jidesoft.plaf.basic.a.a.getString("Undo.hide"));
                BasicDockableFrameTitlePane.this._frame.getDockingManager().hideFrame(BasicDockableFrameTitlePane.this._frame.getKey());
            }
        }
    }

    public class TitlePaneLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public Dimension minimumLayoutSize(Container container) {
            int n;
            int n2;
            int n3 = 0;
            int n4 = 0;
            Dimension dimension = null;
            dimension = BasicDockableFrameTitlePane.this._frame.getTitleBarComponent() != null && BasicDockableFrameTitlePane.this._frame.getTitleBarComponent().isVisible() ? BasicDockableFrameTitlePane.this._frame.getTitleBarComponent().getPreferredSize() : new Dimension(0, 0);
            Dimension dimension2 = BasicDockableFrameTitlePane.this.getMaximumButtonSize();
            n3 += 3 * (dimension2.width + 6 + BasicDockableFrameTitlePane.this._buttonGap);
            FontMetrics fontMetrics = BasicDockableFrameTitlePane.this.getFontMetrics(BasicDockableFrameTitlePane.this.getFont());
            String string = BasicDockableFrameTitlePane.this._frame.getTitle();
            int n5 = string != null ? fontMetrics.stringWidth(string) : 0;
            int n6 = n2 = string != null ? string.length() : 0;
            n3 = n2 > 3 ? (n3 += n5 < (n = fontMetrics.stringWidth(string.substring(0, 3) + "...")) ? n5 : n) : (n3 += n5);
            n4 = Math.max(fontMetrics.getHeight() + 2, n4);
            n4 = Math.max(dimension2.height + (BasicDockableFrameTitlePane.this._hideIcon == null ? 0 : 5), n4);
            if (BasicDockableFrameTitlePane.this.getBorder() != null) {
                Insets insets = BasicDockableFrameTitlePane.this.getBorder().getBorderInsets(container);
                n4 += insets.top + insets.bottom;
                n3 += insets.left + insets.right;
            }
            n4 += BasicDockableFrameTitlePane.this._titleInsets.top + BasicDockableFrameTitlePane.this._titleInsets.bottom;
            n4 = BasicDockableFrameTitlePane.this.isSameLine(container) ? Math.max(dimension.height, n4) : n4 + dimension.height + 1;
            Dimension dimension3 = new Dimension(n3, n4);
            return dimension3;
        }

        public void layoutContainer(Container container) {
            int n;
            boolean bl = BasicJideTabbedPaneUI.t;
            boolean bl2 = BasicDockableFrameTitlePane.this._frame.getComponentOrientation().isLeftToRight() && BasicDockableFrameTitlePane.this._buttonsAlignment == 11;
            int n2 = container.getWidth() - BasicDockableFrameTitlePane.this._titleInsets.left - BasicDockableFrameTitlePane.this._titleInsets.right;
            int n3 = BasicDockableFrameTitlePane.this.getTitleBarHeight() - BasicDockableFrameTitlePane.this._titleInsets.top - BasicDockableFrameTitlePane.this._titleInsets.bottom;
            Dimension dimension = BasicDockableFrameTitlePane.this.getMaximumButtonSize();
            int n4 = dimension.height + (BasicDockableFrameTitlePane.this._hideIcon == null ? 0 : 2);
            int n5 = dimension.width + BasicDockableFrameTitlePane.this._buttonGap;
            int n6 = n = bl2 ? BasicDockableFrameTitlePane.this.getWidth() - BasicDockableFrameTitlePane.this._titleInsets.right : BasicDockableFrameTitlePane.this._titleInsets.left;
            if (!bl2) {
                n -= BasicDockableFrameTitlePane.this._frame.isShowGripper() ? BasicDockableFrameTitlePane.this._gripperWidth + 0 : 0;
            }
            int n7 = bl2 ? -(n5 + BasicDockableFrameTitlePane.this._buttonGap) : n5 + BasicDockableFrameTitlePane.this._buttonGap;
            int n8 = 0;
            boolean bl3 = true;
            if (BasicDockableFrameTitlePane.this.a()) {
                if (bl3) {
                    n += bl2 ? n7 : 0;
                    bl3 = false;
                } else {
                    n += n7;
                }
                BasicDockableFrameTitlePane.this._hideButton.setBounds(n, BasicDockableFrameTitlePane.this._titleInsets.top + (n3 - n4) / 2 + n8, n5, n4);
            } else if (BasicDockableFrameTitlePane.this._hideButton != null) {
                BasicDockableFrameTitlePane.this._hideButton.setBounds(0, 0, 0, 0);
            }
            if (BasicDockableFrameTitlePane.this.b()) {
                if (bl3) {
                    n += bl2 ? n7 : 0;
                    bl3 = false;
                } else {
                    n += n7;
                }
                BasicDockableFrameTitlePane.this._autohideButton.setBounds(n, BasicDockableFrameTitlePane.this._titleInsets.top + (n3 - n4) / 2 + n8, n5, n4);
            } else if (BasicDockableFrameTitlePane.this._autohideButton != null) {
                BasicDockableFrameTitlePane.this._autohideButton.setBounds(0, 0, 0, 0);
            }
            if (BasicDockableFrameTitlePane.this.c()) {
                if (bl3) {
                    n += bl2 ? n7 : 0;
                    bl3 = false;
                } else {
                    n += n7;
                }
                BasicDockableFrameTitlePane.this._floatButton.setBounds(n, BasicDockableFrameTitlePane.this._titleInsets.top + (n3 - n4) / 2 + n8, n5, n4);
            } else if (BasicDockableFrameTitlePane.this._floatButton != null) {
                BasicDockableFrameTitlePane.this._floatButton.setBounds(0, 0, 0, 0);
            }
            if (BasicDockableFrameTitlePane.this.d()) {
                if (bl3) {
                    n += bl2 ? n7 : 0;
                    bl3 = false;
                } else {
                    n += n7;
                }
                BasicDockableFrameTitlePane.this._maximizeButton.setBounds(n, BasicDockableFrameTitlePane.this._titleInsets.top + (n3 - n4) / 2 + n8, n5, n4);
            } else if (BasicDockableFrameTitlePane.this._maximizeButton != null) {
                BasicDockableFrameTitlePane.this._maximizeButton.setBounds(0, 0, 0, 0);
            }
            Insets insets = BasicDockableFrameTitlePane.this.getInsets();
            if (BasicDockableFrameTitlePane.this._frame.getTitleBarComponent() != null && BasicDockableFrameTitlePane.this._frame.getTitleBarComponent().isVisible()) {
                int n9 = BasicDockableFrameTitlePane.this._frame.getTitleBarComponent().getPreferredSize().width - 5;
                if (BasicDockableFrameTitlePane.this.isSameLine(container)) {
                    BasicDockableFrameTitlePane.this._frame.getTitleBarComponent().setBounds(n -= n9, insets.top + 1, n9, n3 - 2);
                } else {
                    BasicDockableFrameTitlePane.this._frame.getTitleBarComponent().setBounds(insets.left, n3 + 2, container.getWidth() - insets.left - insets.right, BasicDockableFrameTitlePane.this.getHeight() - n3 - 2 - insets.top - insets.bottom);
                }
            }
            if (BasicDockableFrameTitlePane.this._titleAlignment == 0) {
                if (bl2) {
                    if ((n2 + BasicDockableFrameTitlePane.this._title.getPreferredSize().width) / 2 > n - BasicDockableFrameTitlePane.this._titleInsets.left - (BasicDockableFrameTitlePane.this._frame.isShowGripper() ? BasicDockableFrameTitlePane.this._gripperWidth + 0 : 0)) {
                        BasicDockableFrameTitlePane.this._title.setBounds(BasicDockableFrameTitlePane.this._titleInsets.left + (BasicDockableFrameTitlePane.this._frame.isShowGripper() ? BasicDockableFrameTitlePane.this._gripperWidth + 0 : 0), BasicDockableFrameTitlePane.this._titleInsets.top, n - BasicDockableFrameTitlePane.this._titleInsets.left - (BasicDockableFrameTitlePane.this._frame.isShowGripper() ? BasicDockableFrameTitlePane.this._gripperWidth + 0 : 0), n3);
                        BasicDockableFrameTitlePane.this._title.setHorizontalAlignment(11);
                    } else {
                        BasicDockableFrameTitlePane.this._title.setBounds(BasicDockableFrameTitlePane.this._titleInsets.left + (BasicDockableFrameTitlePane.this._frame.isShowGripper() ? BasicDockableFrameTitlePane.this._gripperWidth + 0 : 0), BasicDockableFrameTitlePane.this._titleInsets.top, n2, n3);
                        BasicDockableFrameTitlePane.this._title.setHorizontalAlignment(0);
                    }
                } else if ((n2 - BasicDockableFrameTitlePane.this._title.getPreferredSize().width) / 2 < (n += n7)) {
                    BasicDockableFrameTitlePane.this._title.setBounds(n, BasicDockableFrameTitlePane.this._titleInsets.top, n2 - n - (BasicDockableFrameTitlePane.this._frame.isShowGripper() ? BasicDockableFrameTitlePane.this._gripperWidth + 0 : 0), n3);
                    BasicDockableFrameTitlePane.this._title.setHorizontalAlignment(10);
                } else {
                    BasicDockableFrameTitlePane.this._title.setBounds(BasicDockableFrameTitlePane.this._titleInsets.left, BasicDockableFrameTitlePane.this._titleInsets.top, n2, n3);
                    BasicDockableFrameTitlePane.this._title.setHorizontalAlignment(0);
                }
            } else if (bl2) {
                BasicDockableFrameTitlePane.this._title.setBounds(BasicDockableFrameTitlePane.this._titleInsets.left + (BasicDockableFrameTitlePane.this._frame.isShowGripper() ? BasicDockableFrameTitlePane.this._gripperWidth + 0 : 0), BasicDockableFrameTitlePane.this._titleInsets.top, n - BasicDockableFrameTitlePane.this._titleInsets.left - (BasicDockableFrameTitlePane.this._frame.isShowGripper() ? BasicDockableFrameTitlePane.this._gripperWidth + 0 : 0), n3);
            } else {
                BasicDockableFrameTitlePane.this._title.setBounds(n, BasicDockableFrameTitlePane.this._titleInsets.top, n2 - n - (BasicDockableFrameTitlePane.this._frame.isShowGripper() ? BasicDockableFrameTitlePane.this._gripperWidth + 0 : 0), n3);
            }
            if (bl) {
                int n10 = JideTabbedPaneUI.a;
                JideTabbedPaneUI.a = ++n10;
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("selected".equals(string)) {
                boolean bl = propertyChangeEvent.getNewValue().equals(Boolean.TRUE);
                if (bl) {
                    BasicDockableFrameTitlePane.this._title.setForeground(BasicDockableFrameTitlePane.this._selectedTextColor);
                } else {
                    BasicDockableFrameTitlePane.this._title.setForeground(BasicDockableFrameTitlePane.this._notSelectedTextColor);
                }
                return;
            }
            if (string.equals("maximizable")) {
                if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                    BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._maximizeButton, true);
                } else {
                    BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._maximizeButton, false);
                }
            }
            if (string.equals("hidable")) {
                if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE) & BasicDockableFrameTitlePane.this._frame.isHidable() && BasicDockableFrameTitlePane.this._frame.getDockingManager() != null && BasicDockableFrameTitlePane.this._frame.getDockingManager().isHidable()) {
                    BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._hideButton, true);
                } else {
                    BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._hideButton, false);
                }
            }
            if (string.equals("dockable")) {
                if (propertyChangeEvent.getNewValue().equals(Boolean.FALSE) && !BasicDockableFrameTitlePane.this._frame.isDockable()) {
                    BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._floatButton, false);
                } else if (BasicDockableFrameTitlePane.this._frame.isFloatable() && BasicDockableFrameTitlePane.this._frame.getDockingManager() != null && BasicDockableFrameTitlePane.this._frame.getDockingManager().isFloatable()) {
                    BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._floatButton, true);
                }
            } else if (string.equals("autohiable")) {
                if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE) && BasicDockableFrameTitlePane.this._frame.isAutohidable() && BasicDockableFrameTitlePane.this._frame.getDockingManager() != null && BasicDockableFrameTitlePane.this._frame.getDockingManager().isAutohidable()) {
                    BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._autohideButton, true);
                } else {
                    BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._autohideButton, false);
                }
            } else if (string.equals("floatable")) {
                if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE) && BasicDockableFrameTitlePane.this._frame.isFloatable() && BasicDockableFrameTitlePane.this._frame.getDockingManager() != null && BasicDockableFrameTitlePane.this._frame.getDockingManager().isFloatable()) {
                    if (BasicDockableFrameTitlePane.this._frame.isDockable()) {
                        BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._floatButton, true);
                    } else {
                        BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._floatButton, false);
                    }
                } else {
                    BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._floatButton, false);
                }
            } else if (string.equals("autohide_showing") || string.equals("autohide")) {
                if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE) && BasicDockableFrameTitlePane.this._frame.isAutohidable() && BasicDockableFrameTitlePane.this._frame.getDockingManager() != null && BasicDockableFrameTitlePane.this._frame.getDockingManager().isAutohidable()) {
                    BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._autohideButton, true);
                    BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._floatButton, false);
                }
                BasicDockableFrameTitlePane.this.changeButtonType(BasicDockableFrameTitlePane.this._autohideButton, 2);
            } else if (string.equals("docked")) {
                if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                    if (BasicDockableFrameTitlePane.this._frame.isDockable()) {
                        BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._autohideButton, true);
                        BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._floatButton, true);
                    } else {
                        BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._autohideButton, false);
                        BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._floatButton, false);
                    }
                    BasicDockableFrameTitlePane.this.changeButtonType(BasicDockableFrameTitlePane.this._floatButton, 3);
                }
                BasicDockableFrameTitlePane.this.changeButtonType(BasicDockableFrameTitlePane.this._autohideButton, 1);
            } else if (string.equals("maximized")) {
                if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                    BasicDockableFrameTitlePane.this.changeButtonType(BasicDockableFrameTitlePane.this._maximizeButton, 6);
                } else {
                    BasicDockableFrameTitlePane.this.changeButtonType(BasicDockableFrameTitlePane.this._maximizeButton, 5);
                }
            } else if (string.equals("floated")) {
                if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                    BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._autohideButton, false);
                    if (BasicDockableFrameTitlePane.this._frame.isDockable()) {
                        BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._floatButton, true);
                    } else {
                        BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._floatButton, false);
                    }
                    BasicDockableFrameTitlePane.this.changeButtonType(BasicDockableFrameTitlePane.this._floatButton, 4);
                }
            } else if (string.equals("buttons")) {
                BasicDockableFrameTitlePane.this.invalidate();
            } else if (string.equals("title")) {
                if (BasicDockableFrameTitlePane.this._title != null) {
                    BasicDockableFrameTitlePane.this._title.setText(BasicDockableFrameTitlePane.this._frame.getTitle());
                }
                BasicDockableFrameTitlePane.this.invalidate();
            } else if (string.equals("frameIcon")) {
                if (BasicDockableFrameTitlePane.this._showIcon && BasicDockableFrameTitlePane.this._title != null) {
                    BasicDockableFrameTitlePane.this._title.setIcon(BasicDockableFrameTitlePane.this._frame.getIcon());
                }
                BasicDockableFrameTitlePane.this.invalidate();
            } else if (string.equals("visible")) {
                if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                    BasicDockableFrameTitlePane.this.addSubComponents();
                    BasicDockableFrameTitlePane.this.invalidate();
                }
                this.a();
            } else if (string.equals("gripper")) {
                BasicDockableFrameTitlePane.this.invalidate();
            } else if (string.equals("show_titlebar")) {
                BasicDockableFrameTitlePane.this.invalidate();
            } else if (string.equals("titleBarButtons")) {
                if (BasicDockableFrameTitlePane.this._frame.getTitleBarComponent() != null) {
                    BasicDockableFrameTitlePane.this.add(BasicDockableFrameTitlePane.this._frame.getTitleBarComponent());
                }
                BasicDockableFrameTitlePane.this.invalidate();
            }
            BasicDockableFrameTitlePane.this.revalidate();
            BasicDockableFrameTitlePane.this.repaint();
        }

        private void a() {
            block10: {
                AbstractButton abstractButton;
                block9: {
                    boolean bl = BasicJideTabbedPaneUI.t;
                    abstractButton = BasicDockableFrameTitlePane.this._hideButton;
                    if (!bl) {
                        if (abstractButton != null) {
                            BasicDockableFrameTitlePane.this._hideButton.getModel().setRollover(false);
                        }
                        abstractButton = BasicDockableFrameTitlePane.this._autohideButton;
                    }
                    if (!bl) {
                        if (abstractButton != null) {
                            BasicDockableFrameTitlePane.this._autohideButton.getModel().setRollover(false);
                        }
                        abstractButton = BasicDockableFrameTitlePane.this._floatButton;
                    }
                    if (!bl) {
                        if (abstractButton != null) {
                            BasicDockableFrameTitlePane.this._floatButton.getModel().setRollover(false);
                        }
                        abstractButton = BasicDockableFrameTitlePane.this._maximizeButton;
                    }
                    if (bl) break block9;
                    if (abstractButton == null) break block10;
                    abstractButton = BasicDockableFrameTitlePane.this._maximizeButton;
                }
                abstractButton.getModel().setRollover(false);
            }
        }
    }
}

