/*
 * Decompiled with CFR 0.152.
 */
package novaworx.viewarea;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.Vector;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import novaworx.gui.IconCache;
import novaworx.log.Log;
import novaworx.swing.XRootPane;
import novaworx.viewarea.ViewArea;
import novaworx.viewarea.ViewDivider;
import novaworx.viewarea.ViewHeader;
import novaworx.viewarea.ViewPaneEvent;
import novaworx.viewarea.ViewPaneListener;
import novaworx.viewarea.ViewPaneVetoException;

public abstract class ViewPane
extends JComponent
implements SwingConstants,
RootPaneContainer {
    private boolean mbSelected;
    double mdX1 = 0.0;
    double mdY1 = 0.0;
    double mdX2 = 1.0;
    double mdY2 = 1.0;
    ViewDivider moNorthDivider;
    ViewDivider moEastDivider;
    ViewDivider moSouthDivider;
    ViewDivider moWestDivider;
    private ViewHeader moViewHeader;
    private JRootPane moRootPane;
    private Vector mvViewPaneListeners;
    private MaximizeAction moMaximizeAction;
    private RestoreAction moRestoreAction;
    private CloseAction moCloseAction;
    private Preferences moPreferences;
    private PreferenceChangeHandler moPreferenceChangeHandler;

    protected ViewPane(ViewHeader aoViewHeader) {
        if (aoViewHeader == null) {
            throw new IllegalArgumentException("Header can not be null.");
        }
        this.moViewHeader = aoViewHeader;
        aoViewHeader.setViewPane(this);
        this.mvViewPaneListeners = new Vector();
        this.moPreferenceChangeHandler = new PreferenceChangeHandler();
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.moRootPane = new XRootPane();
        this.add((Component)this.moRootPane, "Center");
        this.moMaximizeAction = new MaximizeAction();
        this.moRestoreAction = new RestoreAction();
        this.moCloseAction = new CloseAction();
        aoViewHeader.getMaximizeButton().addActionListener(this.moMaximizeAction);
        aoViewHeader.getCloseButton().addActionListener(this.moCloseAction);
    }

    protected void select() {
    }

    protected void unselect() {
    }

    public boolean isSelected() {
        ViewArea oViewArea = this.getViewArea();
        if (oViewArea == null) {
            return true;
        }
        return oViewArea.getSelectedViewPane() == this;
    }

    public void setIcon(Icon aoIcon) {
        this.moViewHeader.setIcon(aoIcon);
    }

    public void setTitle(String asTitle) {
        this.moViewHeader.setTitle(asTitle);
    }

    public ViewArea getViewArea() {
        Container oParent = this.getParent();
        return oParent instanceof ViewArea ? (ViewArea)oParent : null;
    }

    public ViewHeader getViewHeader() {
        return this.moViewHeader;
    }

    public boolean isValidateRoot() {
        return true;
    }

    public JRootPane getRootPane() {
        return this.moRootPane;
    }

    public void setGlassPane(Component aoPane) {
        this.moRootPane.setGlassPane(aoPane);
    }

    public Component getGlassPane() {
        return this.moRootPane.getGlassPane();
    }

    public void setLayeredPane(JLayeredPane aoPane) {
        this.moRootPane.setLayeredPane(aoPane);
    }

    public JLayeredPane getLayeredPane() {
        return this.moRootPane.getLayeredPane();
    }

    public void setContentPane(Container aoPane) {
        this.moRootPane.setContentPane(aoPane);
    }

    public Container getContentPane() {
        return this.moRootPane.getContentPane();
    }

    public void maximize() throws ViewPaneVetoException {
        this.firePaneWillMaximize();
        this.getViewHeader().getMaximizeButton().removeActionListener(this.moMaximizeAction);
        ViewArea oViewArea = this.getViewArea();
        if (oViewArea != null) {
            oViewArea.setMaximizedPane(this);
        }
        this.getViewHeader().getMaximizeButton().addActionListener(this.moRestoreAction);
        this.getViewHeader().getMaximizeButton().setIcon(IconCache.getIcon("pane.restore"));
        this.getViewHeader().getMaximizeButton().setPressedIcon(IconCache.filterIcon(IconCache.getIcon("pane.restore"), IconCache.PRESSED_FILTER));
        this.firePaneMaximized();
    }

    public void restore() throws ViewPaneVetoException {
        this.firePaneWillRestore();
        this.getViewHeader().getMaximizeButton().removeActionListener(this.moRestoreAction);
        ViewArea oViewArea = this.getViewArea();
        if (oViewArea != null) {
            oViewArea.setMaximizedPane(null);
        }
        this.getViewHeader().getMaximizeButton().addActionListener(this.moMaximizeAction);
        this.getViewHeader().getMaximizeButton().setIcon(IconCache.getIcon("pane.maximize"));
        this.getViewHeader().getMaximizeButton().setPressedIcon(IconCache.filterIcon(IconCache.getIcon("pane.maximize"), IconCache.PRESSED_FILTER));
        this.firePaneRestored();
    }

    public void close() throws ViewPaneVetoException {
        this.firePaneWillClose();
        this.firePaneClosed();
    }

    protected void drop(ViewPane aoSourcePane, ViewPane aoNewPane) {
    }

    public void addViewPaneListener(ViewPaneListener aoListener) {
        this.mvViewPaneListeners.add(aoListener);
    }

    public void removeViewPaneListener(ViewPaneListener aoListener) {
        this.mvViewPaneListeners.remove(aoListener);
    }

    protected void firePaneResized() {
        Vector vListeners = (Vector)this.mvViewPaneListeners.clone();
        int iSize = vListeners.size();
        for (int iIndex = 0; iIndex < iSize; ++iIndex) {
            ((ViewPaneListener)vListeners.get(iIndex)).paneResized(new ViewPaneEvent(this));
        }
    }

    protected void firePaneActivated() {
        Vector vListeners = (Vector)this.mvViewPaneListeners.clone();
        int iSize = vListeners.size();
        for (int iIndex = 0; iIndex < iSize; ++iIndex) {
            ((ViewPaneListener)vListeners.get(iIndex)).paneActivated(new ViewPaneEvent(this));
        }
    }

    protected void firePaneDeactivated() {
        Vector vListeners = (Vector)this.mvViewPaneListeners.clone();
        int iSize = vListeners.size();
        for (int iIndex = 0; iIndex < iSize; ++iIndex) {
            ((ViewPaneListener)vListeners.get(iIndex)).paneDeactivated(new ViewPaneEvent(this));
        }
    }

    protected void firePaneWillSplit() throws ViewPaneVetoException {
        Vector vListeners = (Vector)this.mvViewPaneListeners.clone();
        int iSize = vListeners.size();
        for (int iIndex = 0; iIndex < iSize; ++iIndex) {
            ((ViewPaneListener)vListeners.get(iIndex)).paneWillSplit(new ViewPaneEvent(this));
        }
    }

    protected void firePaneSplit() {
        Vector vListeners = (Vector)this.mvViewPaneListeners.clone();
        int iSize = vListeners.size();
        for (int iIndex = 0; iIndex < iSize; ++iIndex) {
            ((ViewPaneListener)vListeners.get(iIndex)).paneSplit(new ViewPaneEvent(this));
        }
    }

    protected void firePaneWillMerge() throws ViewPaneVetoException {
        Vector vListeners = (Vector)this.mvViewPaneListeners.clone();
        int iSize = vListeners.size();
        for (int iIndex = 0; iIndex < iSize; ++iIndex) {
            ((ViewPaneListener)vListeners.get(iIndex)).paneWillMerge(new ViewPaneEvent(this));
        }
    }

    protected void firePaneMerged() {
        Vector vListeners = (Vector)this.mvViewPaneListeners.clone();
        int iSize = vListeners.size();
        for (int iIndex = 0; iIndex < iSize; ++iIndex) {
            ((ViewPaneListener)vListeners.get(iIndex)).paneMerged(new ViewPaneEvent(this));
        }
    }

    protected void firePaneWillMaximize() throws ViewPaneVetoException {
        Vector vListeners = (Vector)this.mvViewPaneListeners.clone();
        int iSize = vListeners.size();
        for (int iIndex = 0; iIndex < iSize; ++iIndex) {
            ((ViewPaneListener)vListeners.get(iIndex)).paneWillMaximize(new ViewPaneEvent(this));
        }
    }

    protected void firePaneMaximized() {
        Vector vListeners = (Vector)this.mvViewPaneListeners.clone();
        int iSize = vListeners.size();
        for (int iIndex = 0; iIndex < iSize; ++iIndex) {
            ((ViewPaneListener)vListeners.get(iIndex)).paneMaximized(new ViewPaneEvent(this));
        }
    }

    protected void firePaneWillRestore() throws ViewPaneVetoException {
        Vector vListeners = (Vector)this.mvViewPaneListeners.clone();
        int iSize = vListeners.size();
        for (int iIndex = 0; iIndex < iSize; ++iIndex) {
            ((ViewPaneListener)vListeners.get(iIndex)).paneWillRestore(new ViewPaneEvent(this));
        }
    }

    protected void firePaneRestored() {
        Vector vListeners = (Vector)this.mvViewPaneListeners.clone();
        int iSize = vListeners.size();
        for (int iIndex = 0; iIndex < iSize; ++iIndex) {
            ((ViewPaneListener)vListeners.get(iIndex)).paneRestored(new ViewPaneEvent(this));
        }
    }

    protected void firePaneWillClose() throws ViewPaneVetoException {
        Vector vListeners = (Vector)this.mvViewPaneListeners.clone();
        int iSize = vListeners.size();
        for (int iIndex = 0; iIndex < iSize; ++iIndex) {
            ((ViewPaneListener)vListeners.get(iIndex)).paneWillClose(new ViewPaneEvent(this));
        }
    }

    protected void firePaneClosed() {
        Vector vListeners = (Vector)this.mvViewPaneListeners.clone();
        int iSize = vListeners.size();
        for (int iIndex = 0; iIndex < iSize; ++iIndex) {
            ((ViewPaneListener)vListeners.get(iIndex)).paneClosed(new ViewPaneEvent(this));
        }
    }

    public void setPreferences(Preferences aoPreferences, Preferences aoDefaultPreferences) {
        if (aoPreferences == this.moPreferences) {
            return;
        }
        this.moPreferences = aoPreferences;
        if (aoPreferences != null) {
            this.moPreferenceChangeHandler.init(aoPreferences, aoDefaultPreferences);
        }
    }

    public Preferences getPreferences() {
        return this.moPreferences;
    }

    private void loadPreferences(Preferences aoPreferences, Preferences aoDefaultPreferences) {
    }

    private class PreferenceChangeHandler
    implements PreferenceChangeListener {
        private PreferenceChangeHandler() {
        }

        public void init(Preferences aoPreferences, Preferences aoDefaultPreferences) {
            aoPreferences.addPreferenceChangeListener(this);
        }

        public void preferenceChange(PreferenceChangeEvent aoEvent) {
            Preferences oPreferences = aoEvent.getNode();
            String sPath = oPreferences.absolutePath();
            String sKey = aoEvent.getKey();
            String sValue = aoEvent.getNewValue();
            if (oPreferences == ViewPane.this.moPreferences) {
                // empty if block
            }
        }
    }

    private class CloseAction
    extends AbstractAction {
        private CloseAction() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            try {
                ViewPane.this.close();
            }
            catch (ViewPaneVetoException aoException) {
                Log.write(2, (Throwable)aoException);
            }
        }
    }

    private class RestoreAction
    extends AbstractAction {
        private RestoreAction() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            try {
                ViewPane.this.restore();
            }
            catch (ViewPaneVetoException aoException) {
                Log.write(2, (Throwable)aoException);
            }
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        private MaximizeAction() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            try {
                ViewPane.this.maximize();
            }
            catch (ViewPaneVetoException aoException) {
                Log.write(2, (Throwable)aoException);
            }
        }
    }
}

