/*
 * Decompiled with CFR 0.152.
 */
package novaworx.viewarea;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.SwingConstants;
import novaworx.viewarea.ViewArea;
import novaworx.viewarea.ViewHeader;

class ViewHeaderLayout
implements LayoutManager,
SwingConstants {
    public void layoutContainer(Container aoContainer) {
        if (!(aoContainer instanceof ViewHeader)) {
            return;
        }
        ViewHeader oViewHeader = (ViewHeader)aoContainer;
        ViewArea oViewArea = oViewHeader.getViewPane().getViewArea();
        this.layoutContextButton(oViewArea, oViewHeader);
        this.layoutContentButton(oViewArea, oViewHeader);
        this.layoutSelectButton(oViewArea, oViewHeader);
        this.layoutMaximizeButton(oViewArea, oViewHeader);
        this.layoutCloseButton(oViewArea, oViewHeader);
    }

    private void layoutContextButton(ViewArea aoViewArea, ViewHeader aoViewHeader) {
        int iGap = aoViewHeader.getGap();
        int iButtonX = 0;
        int iButtonY = 0;
        int iButtonW = 0;
        int iButtonH = 0;
        Dimension oSize = aoViewHeader.getSize();
        int iOrientation = aoViewArea.getOrientation();
        if (iOrientation == 1 || iOrientation == 5) {
            iButtonX = iGap;
            iButtonY = iGap;
            iButtonW = oSize.height - iGap * 2;
            iButtonH = oSize.height - iGap * 2;
        } else {
            iButtonX = iGap;
            iButtonY = iGap;
            iButtonW = oSize.width - iGap * 2;
            iButtonH = oSize.width - iGap * 2;
        }
        aoViewHeader.getContextButton().setBounds(iButtonX, iButtonY, iButtonW, iButtonH);
    }

    private void layoutContentButton(ViewArea aoViewArea, ViewHeader aoViewHeader) {
        int iGap = aoViewHeader.getGap();
        int iButtonX = 0;
        int iButtonY = 0;
        int iButtonW = 0;
        int iButtonH = 0;
        Dimension oSize = aoViewHeader.getSize();
        int iOrientation = aoViewArea.getOrientation();
        if (iOrientation == 1 || iOrientation == 5) {
            iButtonX = oSize.height;
            iButtonY = iGap;
            iButtonW = oSize.height - iGap * 2;
            iButtonH = oSize.height - iGap * 2;
        } else {
            iButtonX = iGap;
            iButtonY = oSize.width;
            iButtonW = oSize.width - iGap * 2;
            iButtonH = oSize.width - iGap * 2;
        }
        aoViewHeader.getContentButton().setBounds(iButtonX, iButtonY, iButtonW, iButtonH);
    }

    private void layoutSelectButton(ViewArea aoViewArea, ViewHeader aoViewHeader) {
        int iGap = aoViewHeader.getGap();
        int iButtonX = 0;
        int iButtonY = 0;
        int iButtonW = 0;
        int iButtonH = 0;
        Dimension oSize = aoViewHeader.getSize();
        int iOrientation = aoViewArea.getOrientation();
        if (iOrientation == 1 || iOrientation == 5) {
            iButtonX = oSize.width - (oSize.height - iGap) * 3;
            iButtonY = iGap;
            iButtonW = oSize.height - iGap * 2;
            iButtonH = oSize.height - iGap * 2;
            if (iButtonX < 2 * (oSize.height - iGap) + iGap) {
                iButtonX = 2 * (oSize.height - iGap) + iGap;
            }
        } else {
            iButtonX = iGap;
            iButtonY = oSize.height - (oSize.width - iGap) * 3;
            iButtonW = oSize.width - iGap * 2;
            iButtonH = oSize.width - iGap * 2;
            if (iButtonY < 2 * (oSize.width - iGap) + iGap) {
                iButtonY = 2 * (oSize.width - iGap) + iGap;
            }
        }
        aoViewHeader.getSelectButton().setBounds(iButtonX, iButtonY, iButtonW, iButtonH);
    }

    private void layoutMaximizeButton(ViewArea aoViewArea, ViewHeader aoViewHeader) {
        int iGap = aoViewHeader.getGap();
        int iButtonX = 0;
        int iButtonY = 0;
        int iButtonW = 0;
        int iButtonH = 0;
        Dimension oSize = aoViewHeader.getSize();
        int iOrientation = aoViewArea.getOrientation();
        if (iOrientation == 1 || iOrientation == 5) {
            iButtonX = oSize.width - (oSize.height - iGap) * 2;
            iButtonY = iGap;
            iButtonW = oSize.height - iGap * 2;
            iButtonH = oSize.height - iGap * 2;
            if (iButtonX < 3 * (oSize.height - iGap) + iGap) {
                iButtonX = 3 * (oSize.height - iGap) + iGap;
            }
        } else {
            iButtonX = iGap;
            iButtonY = oSize.height - (oSize.width - iGap) * 2;
            iButtonW = oSize.width - iGap * 2;
            iButtonH = oSize.width - iGap * 2;
            if (iButtonY < 3 * (oSize.width - iGap) + iGap) {
                iButtonY = 3 * (oSize.width - iGap) + iGap;
            }
        }
        aoViewHeader.getMaximizeButton().setBounds(iButtonX, iButtonY, iButtonW, iButtonH);
    }

    private void layoutCloseButton(ViewArea aoViewArea, ViewHeader aoViewHeader) {
        int iGap = aoViewHeader.getGap();
        int iButtonX = 0;
        int iButtonY = 0;
        int iButtonW = 0;
        int iButtonH = 0;
        Dimension oSize = aoViewHeader.getSize();
        int iOrientation = aoViewArea.getOrientation();
        if (iOrientation == 1 || iOrientation == 5) {
            iButtonX = oSize.width - (oSize.height - iGap);
            iButtonY = iGap;
            iButtonW = oSize.height - iGap * 2;
            iButtonH = oSize.height - iGap * 2;
            if (iButtonX < 4 * (oSize.height - iGap) + iGap) {
                iButtonX = 4 * (oSize.height - iGap) + iGap;
            }
        } else {
            iButtonX = iGap;
            iButtonY = oSize.height - (oSize.width - iGap);
            iButtonW = oSize.width - iGap * 2;
            iButtonH = oSize.width - iGap * 2;
            if (iButtonY < 4 * (oSize.width - iGap) + iGap) {
                iButtonY = 4 * (oSize.width - iGap) + iGap;
            }
        }
        aoViewHeader.getCloseButton().setBounds(iButtonX, iButtonY, iButtonW, iButtonH);
    }

    public Dimension minimumLayoutSize(Container aoContainer) {
        return aoContainer.getMinimumSize();
    }

    public Dimension preferredLayoutSize(Container aoContainer) {
        return aoContainer.getPreferredSize();
    }

    public void addLayoutComponent(String asName, Component aoComponent) {
    }

    public void removeLayoutComponent(Component aoComponent) {
    }
}

