/*
 * Decompiled with CFR 0.152.
 */
package novaworx.viewarea;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import novaworx.gui.CursorCache;
import novaworx.gui.IconCache;
import novaworx.swing.XButton;
import novaworx.viewarea.ViewArea;
import novaworx.viewarea.ViewPane;

public abstract class ViewHeader
extends JComponent
implements SwingConstants {
    private static final int NONE = -1;
    ViewPane moPane;
    private int miGap;
    private String msTitle;
    JButton moContextButton;
    JButton moContentButton;
    JButton moSelectButton;
    JButton moMaximizeButton;
    JButton moCloseButton;
    private MouseHandler moMouseHandler;
    private Point moDragOffset;
    private Point moDragAnchor;
    private JComponent moDragComponent;
    private JComponent moHoverComponent;
    private Dimension moPreferredSize;

    protected ViewHeader() {
        this.setOpaque(false);
        this.moMouseHandler = new MouseHandler();
        this.addMouseListener(this.moMouseHandler);
        this.addMouseMotionListener(this.moMouseHandler);
        this.moContextButton = new XButton(IconCache.getIcon("pane"));
        this.moContextButton.setPressedIcon(IconCache.filterIcon(IconCache.getIcon("pane"), IconCache.PRESSED_FILTER));
        this.initHeaderButton(this.moContextButton);
        this.add(this.moContextButton);
        this.moContentButton = new XButton(IconCache.getIcon("null"));
        this.moContentButton.setPressedIcon(IconCache.filterIcon(IconCache.getIcon("null"), IconCache.PRESSED_FILTER));
        this.initHeaderButton(this.moContentButton);
        this.add(this.moContentButton);
        this.moSelectButton = new XButton(IconCache.getIcon("dropdown"));
        this.moSelectButton.setPressedIcon(IconCache.filterIcon(IconCache.getIcon("dropdown"), IconCache.PRESSED_FILTER));
        this.initHeaderButton(this.moSelectButton);
        this.add(this.moSelectButton);
        this.moMaximizeButton = new XButton(IconCache.getIcon("pane.maximize"));
        this.moMaximizeButton.setPressedIcon(IconCache.filterIcon(IconCache.getIcon("pane.maximize"), IconCache.PRESSED_FILTER));
        this.initHeaderButton(this.moMaximizeButton);
        this.add(this.moMaximizeButton);
        this.moCloseButton = new XButton(IconCache.getIcon("pane.close"));
        this.moCloseButton.setPressedIcon(IconCache.filterIcon(IconCache.getIcon("pane.close"), IconCache.PRESSED_FILTER));
        this.initHeaderButton(this.moCloseButton);
        this.add(this.moCloseButton);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void init() {
        this.setLookAndFeelValues();
    }

    public void setGap(int aiGap) {
        this.miGap = aiGap;
        this.repaint();
    }

    public int getGap() {
        return this.miGap;
    }

    public void setIcon(Icon aoIcon) {
        if (aoIcon == null) {
            this.moContentButton.setIcon(IconCache.getIcon("null"));
            this.moContentButton.setPressedIcon(IconCache.filterIcon(IconCache.getIcon("null"), IconCache.PRESSED_FILTER));
        } else {
            this.moContentButton.setIcon(aoIcon);
            this.moContentButton.setPressedIcon(IconCache.filterIcon(aoIcon, IconCache.PRESSED_FILTER));
        }
        this.repaint();
    }

    public Icon getIcon() {
        return this.moContentButton.getIcon();
    }

    void setContextIcon(Icon aoIcon) {
        if (aoIcon == null) {
            this.moContextButton.setIcon(IconCache.getIcon("pane"));
            this.moContextButton.setPressedIcon(IconCache.filterIcon(IconCache.getIcon("pane"), IconCache.PRESSED_FILTER));
        } else {
            this.moContextButton.setIcon(aoIcon);
            this.moContextButton.setPressedIcon(IconCache.filterIcon(aoIcon, IconCache.PRESSED_FILTER));
        }
        this.repaint();
    }

    Icon getContextIcon() {
        return this.moContextButton.getIcon();
    }

    public void setTitle(String asTitle) {
        this.msTitle = asTitle;
        this.repaint();
    }

    public String getTitle() {
        return this.msTitle;
    }

    void setViewPane(ViewPane aoViewPane) {
        this.moPane = aoViewPane;
    }

    public ViewPane getViewPane() {
        return this.moPane;
    }

    public ViewArea getViewArea() {
        Container oParent = this.getParent();
        return oParent instanceof ViewArea ? (ViewArea)oParent : null;
    }

    public JButton getContextButton() {
        return this.moContextButton;
    }

    public JButton getContentButton() {
        return this.moContentButton;
    }

    public JButton getSelectButton() {
        return this.moSelectButton;
    }

    public JButton getMaximizeButton() {
        return this.moMaximizeButton;
    }

    public JButton getCloseButton() {
        return this.moCloseButton;
    }

    public Dimension getPreferredSize() {
        return this.moPreferredSize == null ? new Dimension(0, 0) : this.moPreferredSize;
    }

    private JButton initHeaderButton(JButton aoButton) {
        aoButton.setBorder(null);
        aoButton.setMargin(new Insets(0, 0, 0, 0));
        aoButton.setFocusPainted(false);
        aoButton.setContentAreaFilled(false);
        aoButton.setCursor(Cursor.getPredefinedCursor(0));
        return aoButton;
    }

    public void updateUI() {
        this.setLookAndFeelValues();
        super.updateUI();
    }

    private void setLookAndFeelValues() {
        int iIconWidth = 0;
        iIconWidth = Math.max(iIconWidth, this.moContextButton.getIcon().getIconWidth());
        iIconWidth = Math.max(iIconWidth, this.moContentButton.getIcon().getIconWidth());
        iIconWidth = Math.max(iIconWidth, this.moSelectButton.getIcon().getIconWidth());
        iIconWidth = Math.max(iIconWidth, this.moMaximizeButton.getIcon().getIconWidth());
        iIconWidth = Math.max(iIconWidth, this.moCloseButton.getIcon().getIconWidth());
        int iIconHeight = 0;
        iIconHeight = Math.max(iIconHeight, this.moContextButton.getIcon().getIconHeight());
        iIconHeight = Math.max(iIconHeight, this.moContentButton.getIcon().getIconHeight());
        iIconHeight = Math.max(iIconHeight, this.moSelectButton.getIcon().getIconHeight());
        iIconHeight = Math.max(iIconHeight, this.moMaximizeButton.getIcon().getIconHeight());
        int iSize = iIconHeight = Math.max(iIconHeight, this.moCloseButton.getIcon().getIconHeight());
        int iOrientation = this.getViewArea().getOrientation();
        if (iOrientation == 3 || iOrientation == 7) {
            iSize = iIconWidth;
        }
        this.miGap = iSize / 8;
        int iPreferredWidth = iIconWidth + 2 * this.miGap;
        int iPreferredHeight = iIconHeight + 2 * this.miGap;
        this.moPreferredSize = new Dimension(iPreferredWidth, iPreferredHeight);
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private ViewPane moDropViewPane;
        private int moDropOrientation = -1;

        private MouseHandler() {
        }

        public void mousePressed(MouseEvent aoEvent) {
            ViewArea oViewArea = ViewHeader.this.getViewArea();
            oViewArea.requestFocusInWindow();
            oViewArea.setSelectedViewPane(ViewHeader.this.getViewPane());
            ViewHeader.this.moDragOffset = aoEvent.getPoint();
            ViewHeader.this.moDragAnchor = SwingUtilities.convertPoint(ViewHeader.this, aoEvent.getPoint(), oViewArea);
        }

        public void mouseReleased(MouseEvent aoEvent) {
            ViewHeader.this.moDragAnchor = null;
            JLayeredPane oLayeredPane = ViewHeader.this.getRootPane().getLayeredPane();
            if (ViewHeader.this.moDragComponent != null) {
                oLayeredPane.remove(ViewHeader.this.moDragComponent);
                Rectangle oBounds = ViewHeader.this.moDragComponent.getBounds();
                oLayeredPane.paintImmediately(oBounds.x, oBounds.y, oBounds.width, oBounds.height);
                ViewHeader.this.moDragComponent = null;
                if (this.moDropViewPane != null) {
                    this.dropPane();
                }
            }
        }

        public void mouseDragged(MouseEvent aoEvent) {
            if (aoEvent.getModifiers() == 16) {
                this.dragHeader(aoEvent);
            }
        }

        public void mouseMoved(MouseEvent e) {
        }

        private void dropPane() {
            ViewArea oViewArea = ViewHeader.this.getViewArea();
            ViewPane oViewPane = ViewHeader.this.getViewPane();
            switch (this.moDropOrientation) {
                case 0: {
                    this.moDropViewPane.drop(oViewPane, this.moDropViewPane);
                    oViewArea.setSelectedViewPane(this.moDropViewPane);
                    break;
                }
                case 1: {
                    ViewPane oNewPane = oViewArea.splitNorth(this.moDropViewPane);
                    this.moDropViewPane.drop(oViewPane, oNewPane);
                    oViewArea.setSelectedViewPane(oNewPane);
                    break;
                }
                case 5: {
                    ViewPane oNewPane = ViewHeader.this.getViewArea().splitSouth(this.moDropViewPane);
                    this.moDropViewPane.drop(oViewPane, oNewPane);
                    oViewArea.setSelectedViewPane(oNewPane);
                    break;
                }
                case 3: {
                    ViewPane oNewPane = ViewHeader.this.getViewArea().splitEast(this.moDropViewPane);
                    this.moDropViewPane.drop(oViewPane, oNewPane);
                    oViewArea.setSelectedViewPane(oNewPane);
                    break;
                }
                case 7: {
                    ViewPane oNewPane = ViewHeader.this.getViewArea().splitWest(this.moDropViewPane);
                    this.moDropViewPane.drop(oViewPane, oNewPane);
                    oViewArea.setSelectedViewPane(oNewPane);
                    break;
                }
            }
        }

        private void dragHeader(MouseEvent aoEvent) {
            ViewArea oViewArea = ViewHeader.this.getViewArea();
            JLayeredPane oLayeredPane = ViewHeader.this.getRootPane().getLayeredPane();
            Point oDragPoint = SwingUtilities.convertPoint(ViewHeader.this, aoEvent.getPoint(), oLayeredPane);
            Point oCursorPoint = SwingUtilities.convertPoint(ViewHeader.this, aoEvent.getPoint(), oViewArea);
            Point oDeltaPoint = new Point(oDragPoint.x - ((ViewHeader)ViewHeader.this).moDragOffset.x, oDragPoint.y - ((ViewHeader)ViewHeader.this).moDragOffset.y);
            if (ViewHeader.this.moDragComponent == null) {
                ViewHeader.this.moDragComponent = new DragComponent();
                ViewHeader.this.moDragComponent.setSize(ViewHeader.this.getSize());
                ViewHeader.this.moDragComponent.setLocation(oDeltaPoint);
                oLayeredPane.add((Component)ViewHeader.this.moDragComponent, JLayeredPane.DRAG_LAYER);
            } else {
                ViewHeader.this.moDragComponent.setLocation(oDeltaPoint);
            }
            JComponent oHoverComponent = (JComponent)oViewArea.getComponentAt(oCursorPoint);
            Cursor oDragCursor = Cursor.getPredefinedCursor(0);
            if (oHoverComponent instanceof ViewPane) {
                this.determineViewPaneDrop((ViewPane)oHoverComponent, oCursorPoint, oViewArea.getOrientation());
            } else if (oHoverComponent instanceof ViewHeader) {
                this.determineViewHeaderDrop((ViewHeader)oHoverComponent, oCursorPoint, oViewArea.getOrientation());
            } else {
                this.setDropOrientation(null, -1);
            }
        }

        private void determineViewPaneDrop(ViewPane aoViewPane, Point aoPoint, int aiOrientation) {
            Rectangle oBounds = aoViewPane.getBounds();
            int iActiveZone = 10;
            int iOrientation = 0;
            int iWestLimit = oBounds.x;
            int iNorthLimit = oBounds.y;
            int iEastLimit = oBounds.x + oBounds.width;
            int iSouthLimit = oBounds.y + oBounds.height;
            switch (aiOrientation) {
                case 1: {
                    if (iOrientation == 0 && aoPoint.x >= iWestLimit & aoPoint.x <= iWestLimit + iActiveZone) {
                        iOrientation = 7;
                    }
                    if (iOrientation == 0 && aoPoint.x >= iEastLimit - iActiveZone & aoPoint.x <= iEastLimit) {
                        iOrientation = 3;
                    }
                    if (iOrientation != 0 || !(aoPoint.y >= iSouthLimit - iActiveZone & aoPoint.y <= iSouthLimit)) break;
                    iOrientation = 5;
                    break;
                }
                case 5: {
                    if (iOrientation == 0 && aoPoint.x >= iWestLimit & aoPoint.x <= iWestLimit + iActiveZone) {
                        iOrientation = 7;
                    }
                    if (iOrientation == 0 && aoPoint.x >= iEastLimit - iActiveZone & aoPoint.x <= iEastLimit) {
                        iOrientation = 3;
                    }
                    if (iOrientation != 0 || !(aoPoint.y >= iNorthLimit & aoPoint.y <= iNorthLimit + iActiveZone)) break;
                    iOrientation = 1;
                    break;
                }
                case 3: {
                    if (iOrientation == 0 && aoPoint.y >= iNorthLimit & aoPoint.y <= iNorthLimit + iActiveZone) {
                        iOrientation = 1;
                    }
                    if (iOrientation == 0 && aoPoint.y >= iSouthLimit - iActiveZone & aoPoint.y <= iSouthLimit) {
                        iOrientation = 5;
                    }
                    if (iOrientation != 0 || !(aoPoint.x >= iWestLimit & aoPoint.x <= iWestLimit + iActiveZone)) break;
                    iOrientation = 7;
                    break;
                }
                case 7: {
                    if (iOrientation == 0 && aoPoint.y >= iNorthLimit & aoPoint.y <= iNorthLimit + iActiveZone) {
                        iOrientation = 1;
                    }
                    if (iOrientation == 0 && aoPoint.y >= iSouthLimit - iActiveZone & aoPoint.y <= iSouthLimit) {
                        iOrientation = 5;
                    }
                    if (iOrientation != 0 || !(aoPoint.x >= iEastLimit - iActiveZone & aoPoint.x <= iEastLimit)) break;
                    iOrientation = 3;
                }
            }
            this.setDropOrientation(aoViewPane, iOrientation);
        }

        private void determineViewHeaderDrop(ViewHeader aoViewHeader, Point aoPoint, int aiOrientation) {
            Rectangle oBounds = aoViewHeader.getBounds();
            int iActiveZone = 10;
            int iOrientation = 0;
            int iWestLimit = oBounds.x;
            int iNorthLimit = oBounds.y;
            int iEastLimit = oBounds.x + oBounds.width;
            int iSouthLimit = oBounds.y + oBounds.height;
            switch (aiOrientation) {
                case 1: {
                    if (iOrientation == 0 && aoPoint.x >= iWestLimit & aoPoint.x <= iWestLimit + iActiveZone) {
                        iOrientation = 7;
                    }
                    if (iOrientation == 0 && aoPoint.x >= iEastLimit - iActiveZone & aoPoint.x <= iEastLimit) {
                        iOrientation = 3;
                    }
                    if (iOrientation != 0 || !(aoPoint.y >= iNorthLimit & aoPoint.y <= iNorthLimit + iActiveZone)) break;
                    iOrientation = 1;
                    break;
                }
                case 5: {
                    if (iOrientation == 0 && aoPoint.x >= iWestLimit & aoPoint.x <= iWestLimit + iActiveZone) {
                        iOrientation = 7;
                    }
                    if (iOrientation == 0 && aoPoint.x >= iEastLimit - iActiveZone & aoPoint.x <= iEastLimit) {
                        iOrientation = 3;
                    }
                    if (iOrientation != 0 || !(aoPoint.y >= iSouthLimit - iActiveZone & aoPoint.y <= iSouthLimit)) break;
                    iOrientation = 5;
                    break;
                }
                case 3: {
                    if (iOrientation == 0 && aoPoint.y >= iNorthLimit & aoPoint.y <= iNorthLimit + iActiveZone) {
                        iOrientation = 1;
                    }
                    if (iOrientation == 0 && aoPoint.y >= iSouthLimit - iActiveZone & aoPoint.y <= iSouthLimit) {
                        iOrientation = 5;
                    }
                    if (iOrientation != 0 || !(aoPoint.x >= iEastLimit - iActiveZone & aoPoint.x <= iEastLimit)) break;
                    iOrientation = 3;
                    break;
                }
                case 7: {
                    if (iOrientation == 0 && aoPoint.y >= iNorthLimit & aoPoint.y <= iNorthLimit + iActiveZone) {
                        iOrientation = 1;
                    }
                    if (iOrientation == 0 && aoPoint.y >= iSouthLimit - iActiveZone & aoPoint.y <= iSouthLimit) {
                        iOrientation = 5;
                    }
                    if (iOrientation != 0 || !(aoPoint.x >= iWestLimit & aoPoint.x <= iWestLimit + iActiveZone)) break;
                    iOrientation = 7;
                }
            }
            this.setDropOrientation(aoViewHeader.getViewPane(), iOrientation);
        }

        private void setDropOrientation(ViewPane aoViewPane, int aiOrientation) {
            this.moDropViewPane = aoViewPane;
            this.moDropOrientation = aiOrientation;
            switch (aiOrientation) {
                case 1: {
                    ViewHeader.this.moDragComponent.setCursor(CursorCache.getCursor("north.drop.cursor"));
                    break;
                }
                case 5: {
                    ViewHeader.this.moDragComponent.setCursor(CursorCache.getCursor("south.drop.cursor"));
                    break;
                }
                case 3: {
                    ViewHeader.this.moDragComponent.setCursor(CursorCache.getCursor("east.drop.cursor"));
                    break;
                }
                case 7: {
                    ViewHeader.this.moDragComponent.setCursor(CursorCache.getCursor("west.drop.cursor"));
                    break;
                }
                case 0: {
                    ViewHeader.this.moDragComponent.setCursor(Cursor.getPredefinedCursor(12));
                    break;
                }
                default: {
                    ViewHeader.this.moDragComponent.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }

        private void slideHeader(MouseEvent aoEvent) {
            int iDelta = 0;
            int iMovement = 0;
            ViewArea oViewArea = ViewHeader.this.getViewArea();
            int iOrientation = oViewArea.getOrientation();
            Point oDragPoint = SwingUtilities.convertPoint(ViewHeader.this, aoEvent.getPoint(), oViewArea);
            switch (iOrientation) {
                case 1: {
                    if (ViewHeader.this.moPane.moNorthDivider == null || (iMovement = oViewArea.moveDividerVertical(ViewHeader.this.moPane.moNorthDivider, iDelta = oDragPoint.y - ((ViewHeader)ViewHeader.this).moDragAnchor.y)) == iDelta) break;
                    oDragPoint.y += iMovement - iDelta;
                    break;
                }
                case 3: {
                    if (ViewHeader.this.moPane.moEastDivider == null || (iMovement = oViewArea.moveDividerHorizontal(ViewHeader.this.moPane.moEastDivider, iDelta = oDragPoint.x - ((ViewHeader)ViewHeader.this).moDragAnchor.x)) == iDelta) break;
                    oDragPoint.x += iMovement - iDelta;
                    break;
                }
                case 5: {
                    if (ViewHeader.this.moPane.moSouthDivider == null || (iMovement = oViewArea.moveDividerVertical(ViewHeader.this.moPane.moSouthDivider, iDelta = oDragPoint.y - ((ViewHeader)ViewHeader.this).moDragAnchor.y)) == iDelta) break;
                    oDragPoint.y += iMovement - iDelta;
                    break;
                }
                case 7: {
                    if (ViewHeader.this.moPane.moWestDivider == null || (iMovement = oViewArea.moveDividerHorizontal(ViewHeader.this.moPane.moWestDivider, iDelta = oDragPoint.x - ((ViewHeader)ViewHeader.this).moDragAnchor.x)) == iDelta) break;
                    oDragPoint.x += iMovement - iDelta;
                }
            }
            ViewHeader.this.moDragAnchor = oDragPoint;
        }
    }

    private class DragComponent
    extends JComponent {
        public DragComponent() {
            Icon oCursorIcon = IconCache.getIcon("null");
            Image oCursorImage = IconCache.createIconImage(oCursorIcon);
        }

        public void paint(Graphics aoGraphics) {
            Graphics2D oGraphics = (Graphics2D)aoGraphics;
            Composite oComposite = oGraphics.getComposite();
            oGraphics.setComposite(AlphaComposite.getInstance(3, 0.5f));
            ViewHeader.this.paint(oGraphics);
            oGraphics.setComposite(oComposite);
        }
    }
}

