/*
 * Decompiled with CFR 0.152.
 */
package novaworx.viewarea;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import novaworx.viewarea.ViewArea;

public abstract class ViewDivider
extends JComponent
implements SwingConstants {
    int miOrientation;
    double mdA;
    double mdB;
    double mdLocation;
    ViewDivider moDividerA;
    ViewDivider moDividerB;
    Vector mvPanesA;
    Vector mvPanesB;
    Vector moNorthPanes;
    Vector moEastPanes;
    Vector moSouthPanes;
    Vector moWestPanes;
    private MouseHandler moMouseHandler;
    private MouseMotionHandler moMouseMotionHandler;
    private Point moDragAnchor;

    public ViewDivider(int aiOrientation) {
        this.miOrientation = aiOrientation;
        this.mvPanesA = new Vector();
        this.mvPanesB = new Vector();
        this.moNorthPanes = this.mvPanesA;
        this.moEastPanes = this.mvPanesB;
        this.moSouthPanes = this.mvPanesB;
        this.moWestPanes = this.mvPanesA;
        this.setOpaque(false);
        this.moMouseHandler = new MouseHandler();
        this.addMouseListener(this.moMouseHandler);
        this.moMouseMotionHandler = new MouseMotionHandler();
        this.addMouseMotionListener(this.moMouseMotionHandler);
        this.setCursor(Cursor.getPredefinedCursor(aiOrientation == 0 ? 9 : 11));
    }

    public ViewArea getViewArea() {
        Container oParent = this.getParent();
        return oParent instanceof ViewArea ? (ViewArea)oParent : null;
    }

    public int getOrientation() {
        return this.miOrientation;
    }

    private class MouseMotionHandler
    extends MouseMotionAdapter {
        private MouseMotionHandler() {
        }

        public void mouseDragged(MouseEvent aoEvent) {
            int iDelta = 0;
            int iMovement = 0;
            ViewArea oViewArea = ViewDivider.this.getViewArea();
            Point oDragPoint = SwingUtilities.convertPoint(ViewDivider.this, aoEvent.getPoint(), oViewArea);
            if (ViewDivider.this.miOrientation == 1) {
                iDelta = oDragPoint.x - ((ViewDivider)ViewDivider.this).moDragAnchor.x;
                iMovement = oViewArea.moveDividerHorizontal(ViewDivider.this, iDelta);
                if (iMovement != iDelta) {
                    oDragPoint.x += iMovement - iDelta;
                }
            } else {
                iDelta = oDragPoint.y - ((ViewDivider)ViewDivider.this).moDragAnchor.y;
                iMovement = oViewArea.moveDividerVertical(ViewDivider.this, iDelta);
                if (iMovement != iDelta) {
                    oDragPoint.y += iMovement - iDelta;
                }
            }
            ViewDivider.this.moDragAnchor = oDragPoint;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mousePressed(MouseEvent aoEvent) {
            ViewArea oViewArea = ViewDivider.this.getViewArea();
            oViewArea.requestFocusInWindow();
            ViewDivider.this.moDragAnchor = SwingUtilities.convertPoint(ViewDivider.this, aoEvent.getPoint(), oViewArea);
        }

        public void mouseReleased(MouseEvent aoEvent) {
            ViewDivider.this.moDragAnchor = null;
        }
    }
}

