/*
 * Decompiled with CFR 0.152.
 */
package novaworx.viewarea;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.SwingConstants;
import novaworx.viewarea.ViewArea;
import novaworx.viewarea.ViewDivider;
import novaworx.viewarea.ViewHeader;
import novaworx.viewarea.ViewPane;

class ViewAreaLayout
implements LayoutManager,
SwingConstants {
    public void layoutContainer(Container aoContainer) {
        if (!(aoContainer instanceof ViewArea)) {
            return;
        }
        ViewArea oViewArea = (ViewArea)aoContainer;
        int iCount = aoContainer.getComponentCount();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            Component oComponent = aoContainer.getComponent(iIndex);
            if (oComponent instanceof ViewPane) {
                this.layoutViewPane(oViewArea, (ViewPane)oComponent);
                continue;
            }
            if (oComponent instanceof ViewHeader) {
                this.layoutViewHeader(oViewArea, (ViewHeader)oComponent);
                continue;
            }
            if (!(oComponent instanceof ViewDivider)) continue;
            this.layoutViewDivider(oViewArea, (ViewDivider)oComponent);
        }
    }

    void layoutViewPane(ViewArea aoViewArea, ViewPane aoPane) {
        Dimension oSize = aoViewArea.getSize();
        Insets oInsets = aoPane.getInsets();
        if (oSize.width == 0 | oSize.height == 0) {
            return;
        }
        int iOrientation = aoViewArea.getOrientation();
        int iDividerSize = aoViewArea.getDividerSize();
        int iDividerHalf = iDividerSize / 2;
        int iDividerRest = iDividerSize - iDividerHalf;
        int iPreferredHeaderSize = aoPane.getViewHeader().getPreferredSize().height;
        if (iOrientation == 3 || iOrientation == 7) {
            iPreferredHeaderSize = aoPane.getViewHeader().getPreferredSize().width;
        }
        int iHeaderSize = iPreferredHeaderSize;
        ViewPane oMaximizedPane = aoViewArea.getMaximizedPane();
        if (oMaximizedPane != null) {
            if (aoPane == oMaximizedPane) {
                switch (iOrientation) {
                    case 1: {
                        aoPane.setBounds(0, iHeaderSize - oInsets.top, oSize.width, oSize.height - (iHeaderSize - oInsets.top));
                        break;
                    }
                    case 3: {
                        aoPane.setBounds(0, 0, oSize.width - (iHeaderSize - oInsets.right), oSize.height);
                        break;
                    }
                    case 5: {
                        aoPane.setBounds(0, 0, oSize.width, oSize.height - (iHeaderSize - oInsets.bottom));
                        break;
                    }
                    case 7: {
                        aoPane.setBounds(iHeaderSize - oInsets.right, 0, oSize.width - (iHeaderSize - oInsets.right), oSize.height);
                    }
                }
            } else {
                aoPane.setBounds(0, 0, 0, 0);
            }
            return;
        }
        double dX1 = aoPane.mdX1;
        double dY1 = aoPane.mdY1;
        double dX2 = aoPane.mdX2;
        double dY2 = aoPane.mdY2;
        int iNewX = 0;
        int iNewY = 0;
        int iNewWidth = 0;
        int iNewHeight = 0;
        iNewX = (int)Math.floor(dX1 * (double)oSize.width);
        iNewY = (int)Math.floor(dY1 * (double)oSize.height);
        iNewWidth = (int)Math.floor(dX2 * (double)oSize.width) - iNewX;
        iNewHeight = (int)Math.floor(dY2 * (double)oSize.height) - iNewY;
        int iNorth = 0;
        int iSouth = 0;
        int iWest = 0;
        int iEast = 0;
        if (aoPane.moNorthDivider != null) {
            iNorth = iDividerRest;
        }
        if (aoPane.moSouthDivider != null) {
            iSouth = iDividerHalf;
        }
        if (aoPane.moWestDivider != null) {
            iWest = iDividerRest;
        }
        if (aoPane.moEastDivider != null) {
            iEast = iDividerHalf;
        }
        iNewX += iWest;
        iNewWidth -= iWest + iEast;
        iNewY += iNorth;
        iNewHeight -= iNorth + iSouth;
        switch (iOrientation) {
            case 1: {
                iNewY += iHeaderSize - oInsets.top;
                iNewHeight -= iHeaderSize - oInsets.top;
                break;
            }
            case 3: {
                iNewWidth -= iHeaderSize - oInsets.right;
                break;
            }
            case 5: {
                iNewHeight -= iHeaderSize - oInsets.bottom;
                break;
            }
            case 7: {
                iNewX += iHeaderSize - oInsets.left;
                iNewWidth -= iHeaderSize - oInsets.left;
            }
        }
        aoPane.setBounds(iNewX, iNewY, iNewWidth, iNewHeight);
    }

    void layoutViewHeader(ViewArea aoViewArea, ViewHeader aoHeader) {
        Dimension oSize = aoViewArea.getSize();
        if (oSize.width == 0 | oSize.height == 0) {
            return;
        }
        int iOrientation = aoViewArea.getOrientation();
        int iDividerSize = aoViewArea.getDividerSize();
        int iDividerHalf = iDividerSize / 2;
        int iDividerRest = iDividerSize - iDividerHalf;
        int iPreferredHeaderSize = aoHeader.getPreferredSize().height;
        if (iOrientation == 3 || iOrientation == 7) {
            iPreferredHeaderSize = aoHeader.getPreferredSize().width;
        }
        int iHeaderSize = iPreferredHeaderSize;
        ViewPane oMaximizedPane = aoViewArea.getMaximizedPane();
        if (oMaximizedPane != null) {
            if (aoHeader == oMaximizedPane.getViewHeader()) {
                switch (iOrientation) {
                    case 1: {
                        aoHeader.setBounds(0, 0, oSize.width, iHeaderSize);
                        break;
                    }
                    case 3: {
                        aoHeader.setBounds(oSize.width - iHeaderSize, 0, iHeaderSize, oSize.height);
                        break;
                    }
                    case 5: {
                        aoHeader.setBounds(0, oSize.height - iHeaderSize, oSize.width, iHeaderSize);
                        break;
                    }
                    case 7: {
                        aoHeader.setBounds(0, 0, iHeaderSize, oSize.height);
                    }
                }
            } else {
                aoHeader.setBounds(0, 0, 0, 0);
            }
            return;
        }
        double dA = 0.0;
        double dB = 0.0;
        double dLocation = 0.0;
        int iNewX = 0;
        int iNewY = 0;
        int iNewWidth = 0;
        int iNewHeight = 0;
        switch (iOrientation) {
            case 1: {
                dA = aoHeader.moPane.mdX1;
                dB = aoHeader.moPane.mdX2;
                dLocation = aoHeader.moPane.mdY1;
                iNewX = (int)Math.floor(dA * (double)oSize.width);
                iNewX = (int)Math.floor(dA * (double)oSize.width);
                iNewWidth = (int)Math.floor(dB * (double)oSize.width) - iNewX;
                iNewY = (int)Math.floor(dLocation * (double)oSize.height);
                iNewHeight = iHeaderSize;
                break;
            }
            case 3: {
                dA = aoHeader.moPane.mdY1;
                dB = aoHeader.moPane.mdY2;
                dLocation = aoHeader.moPane.mdX2;
                iNewX = (int)Math.floor(dLocation * (double)oSize.width) - iHeaderSize;
                iNewWidth = iHeaderSize;
                iNewY = (int)Math.floor(dA * (double)oSize.height);
                iNewHeight = (int)Math.floor(dB * (double)oSize.height) - iNewY;
                break;
            }
            case 5: {
                dA = aoHeader.moPane.mdX1;
                dB = aoHeader.moPane.mdX2;
                dLocation = aoHeader.moPane.mdY2;
                iNewX = (int)Math.floor(dA * (double)oSize.width);
                iNewWidth = (int)Math.floor(dB * (double)oSize.width) - iNewX;
                iNewY = (int)Math.floor(dLocation * (double)oSize.height) - iHeaderSize;
                iNewHeight = iHeaderSize;
                break;
            }
            case 7: {
                dA = aoHeader.moPane.mdY1;
                dB = aoHeader.moPane.mdY2;
                dLocation = aoHeader.moPane.mdX1;
                iNewX = (int)Math.floor(dLocation * (double)oSize.width);
                iNewWidth = iHeaderSize;
                iNewY = (int)Math.floor(dA * (double)oSize.height);
                iNewHeight = (int)Math.floor(dB * (double)oSize.height) - iNewY;
            }
        }
        int iNorth = 0;
        int iSouth = 0;
        int iWest = 0;
        int iEast = 0;
        if (aoHeader.moPane.moNorthDivider != null) {
            iNorth = iDividerRest;
        }
        if (aoHeader.moPane.moSouthDivider != null) {
            iSouth = iDividerHalf;
        }
        if (aoHeader.moPane.moWestDivider != null) {
            iWest = iDividerRest;
        }
        if (aoHeader.moPane.moEastDivider != null) {
            iEast = iDividerHalf;
        }
        if (iOrientation == 1) {
            iNewY += iNorth;
            iNewX += iWest;
            iNewWidth -= iWest + iEast;
        }
        if (iOrientation == 5) {
            iNewY -= iSouth;
            iNewX += iWest;
            iNewWidth -= iWest + iEast;
        }
        if (iOrientation == 7) {
            iNewX += iWest;
            iNewY += iNorth;
            iNewHeight -= iNorth + iSouth;
        }
        if (iOrientation == 3) {
            iNewX -= iEast;
            iNewY += iNorth;
            iNewHeight -= iNorth + iSouth;
        }
        aoHeader.setBounds(iNewX, iNewY, iNewWidth, iNewHeight);
    }

    void layoutViewDivider(ViewArea aoViewArea, ViewDivider aoDivider) {
        Dimension oSize = aoViewArea.getSize();
        if (oSize.width == 0 | oSize.height == 0) {
            return;
        }
        int iDividerSize = aoViewArea.getDividerSize();
        int iDividerHalf = iDividerSize / 2;
        int iDividerRest = iDividerSize - iDividerHalf;
        ViewPane oMaximizedPane = aoViewArea.getMaximizedPane();
        if (oMaximizedPane != null) {
            aoDivider.setBounds(0, 0, 0, 0);
            return;
        }
        double dA = aoDivider.mdA;
        double dB = aoDivider.mdB;
        double dLocation = aoDivider.mdLocation;
        int iNewX = 0;
        int iNewY = 0;
        int iNewWidth = 0;
        int iNewHeight = 0;
        int iOrientation = aoViewArea.getOrientation();
        if (aoDivider.miOrientation == 1) {
            iNewX = (int)Math.floor(dLocation * (double)oSize.width - (double)iDividerHalf);
            iNewY = (int)Math.floor(dA * (double)oSize.height);
            iNewWidth = iDividerSize;
            iNewHeight = (int)Math.floor(dB * (double)oSize.height) - iNewY;
            int iNorth = aoDivider.moDividerA == null ? 0 : iDividerRest;
            int iSouth = aoDivider.moDividerB == null ? 0 : iDividerHalf;
            iNewY += iNorth;
            iNewHeight -= iNorth + iSouth;
        } else {
            iNewX = (int)Math.floor(dA * (double)oSize.width);
            iNewY = (int)Math.floor(dLocation * (double)oSize.height - (double)iDividerHalf);
            iNewWidth = (int)Math.floor(dB * (double)oSize.width) - iNewX;
            iNewHeight = iDividerSize;
            int iWest = aoDivider.moDividerA == null ? 0 : iDividerRest;
            int iEast = aoDivider.moDividerB == null ? 0 : iDividerHalf;
            iNewX += iWest;
            iNewWidth -= iWest + iEast;
        }
        aoDivider.setBounds(iNewX, iNewY, iNewWidth, iNewHeight);
    }

    public Dimension minimumLayoutSize(Container aoContainer) {
        return aoContainer.getMinimumSize();
    }

    public Dimension preferredLayoutSize(Container aoContainer) {
        return aoContainer.getPreferredSize();
    }

    public void addLayoutComponent(String asName, Component aoComponent) {
    }

    public void removeLayoutComponent(Component aoComponent) {
    }
}

