/*
 * Decompiled with CFR 0.152.
 */
package novaworx.viewarea;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import novaworx.PreferenceEngine;
import novaworx.gui.IconCache;
import novaworx.log.Log;
import novaworx.viewarea.DefaultViewAreaFactory;
import novaworx.viewarea.ViewAreaEvent;
import novaworx.viewarea.ViewAreaFactory;
import novaworx.viewarea.ViewAreaLayout;
import novaworx.viewarea.ViewAreaListener;
import novaworx.viewarea.ViewDivider;
import novaworx.viewarea.ViewHeader;
import novaworx.viewarea.ViewPane;
import novaworx.viewarea.ViewPaneAdapter;
import novaworx.viewarea.ViewPaneEvent;
import novaworx.viewarea.ViewPaneVetoException;

public class ViewArea
extends JComponent
implements SwingConstants {
    static final double COLOR_CHANGE_FACTOR = 0.8;
    private Vector mvViewPanes = new Vector();
    private Vector mvViewHeaders = new Vector();
    private Vector mvViewDividers = new Vector();
    private Vector mvViewListeners = new Vector();
    private ViewAreaFactory moViewAreaFactory;
    private boolean mbLocked;
    private boolean mbAntiAliasText;
    private int miOrientation;
    private Icon moPaneContextIcon;
    private Icon moDefaultPaneIcon;
    private Icon moHeaderSelectIcon;
    private Icon moHeaderCloseIcon;
    private int miDividerSize;
    private int miMinimumFontSize;
    private int miHeaderMovementSize;
    private int miDividerMovementSize;
    private Color moDividerForeground;
    private Color moDividerBackground;
    private Color moHeaderForeground;
    private Color moHeaderBackground;
    private Color moHeaderSelectedForeground;
    private Color moHeaderSelectedBackground;
    private ViewPane moSelectedPane;
    private ViewPane moDefaultPane;
    private ViewPane moMaximizedPane;
    private ViewPaneHandler moViewPaneHandler;
    private Preferences moPreferences;
    private PreferenceChangeHandler moPreferenceChangeHandler;

    public ViewArea() {
        this(new DefaultViewAreaFactory());
    }

    public ViewArea(ViewAreaFactory aoViewAreaFactory) {
        this.moViewAreaFactory = aoViewAreaFactory;
        this.moPreferenceChangeHandler = new PreferenceChangeHandler();
        this.setLayout(new ViewAreaLayout());
        this.setOrientation(1);
        this.setDividerSize(5);
        this.setMinimumFontSize(4);
        this.setHeaderMovementSize(10);
        this.setDividerMovementSize(5);
        this.setPaneContextIcon(IconCache.getIcon("pane"));
        this.setDefaultPaneIcon(IconCache.getIcon("pane.default"));
        this.setHeaderSelectIcon(IconCache.getIcon("dropdown"));
        this.setHeaderCloseIcon(IconCache.getIcon("pane.close"));
        this.setLookAndFeelValues();
        InputMap oInputMap = this.getInputMap(1);
        oInputMap.put(KeyStroke.getKeyStroke(122, 0), "split.horizontal");
        oInputMap.put(KeyStroke.getKeyStroke(123, 0), "split.vertical");
        oInputMap.put(KeyStroke.getKeyStroke(112, 0), "orientation.north");
        oInputMap.put(KeyStroke.getKeyStroke(113, 0), "orientation.east");
        oInputMap.put(KeyStroke.getKeyStroke(114, 0), "orientation.south");
        oInputMap.put(KeyStroke.getKeyStroke(115, 0), "orientation.west");
        oInputMap.put(KeyStroke.getKeyStroke(38, 3), "merge.north");
        oInputMap.put(KeyStroke.getKeyStroke(39, 3), "merge.east");
        oInputMap.put(KeyStroke.getKeyStroke(40, 3), "merge.south");
        oInputMap.put(KeyStroke.getKeyStroke(37, 3), "merge.west");
        ActionMap oActionMap = this.getActionMap();
        oActionMap.put("default.pane", new DefaultViewPaneAction());
        oActionMap.put("split.horizontal", new SplitHorizontalAction());
        oActionMap.put("split.vertical", new SplitVerticalAction());
        oActionMap.put("orientation.north", new OrientNorthAction());
        oActionMap.put("orientation.east", new OrientEastAction());
        oActionMap.put("orientation.south", new OrientSouthAction());
        oActionMap.put("orientation.west", new OrientWestAction());
        oActionMap.put("merge.north", new MergeNorthAction());
        oActionMap.put("merge.east", new MergeEastAction());
        oActionMap.put("merge.south", new MergeSouthAction());
        oActionMap.put("merge.west", new MergeWestAction());
        oActionMap.put("close", new CloseWorkpaneAction());
        this.moViewPaneHandler = new ViewPaneHandler();
        ViewHeader oViewHeader = this.moViewAreaFactory.createViewHeader();
        this.addViewHeader(oViewHeader);
        ViewPane oViewPane = this.moViewAreaFactory.createViewPane(oViewHeader);
        this.addViewPane(oViewPane);
        this.setSelectedViewPane(oViewPane);
    }

    public ViewPane getViewPane(int aiIndex) {
        return (ViewPane)this.mvViewPanes.get(aiIndex);
    }

    public int getViewPaneCount() {
        return this.mvViewPanes.size();
    }

    public void setSelectedViewPane(ViewPane aoPane) {
        if (aoPane == null) {
            return;
        }
        ViewPane oPreviousPane = this.moSelectedPane;
        this.moSelectedPane = aoPane;
        if (oPreviousPane != null) {
            oPreviousPane.unselect();
            oPreviousPane.getViewHeader().repaint();
        }
        aoPane.select();
        aoPane.getViewHeader().repaint();
        int iIndex = this.mvViewPanes.indexOf(aoPane);
        if (this.moPreferences != null) {
            this.moPreferences.putInt("viewarea.pane.active", iIndex);
        }
        Log.write(6, "Selected pane set: " + iIndex);
    }

    public ViewPane getSelectedViewPane() {
        return this.moSelectedPane;
    }

    public void setDefaultViewPane(ViewPane aoPane) {
        if (aoPane == null) {
            return;
        }
        ViewPane oPreviousPane = this.moDefaultPane;
        this.moDefaultPane = aoPane;
        if (oPreviousPane != null) {
            oPreviousPane.getViewHeader().setContextIcon(null);
        }
        aoPane.getViewHeader().setContextIcon(this.getDefaultPaneIcon());
        int iIndex = this.mvViewPanes.indexOf(aoPane);
        if (this.moPreferences != null) {
            this.moPreferences.putInt("viewarea.pane.default", iIndex);
        }
        Log.write(6, "Default pane set: " + iIndex);
    }

    public ViewPane getDefaultViewPane() {
        return this.moDefaultPane;
    }

    public ViewPane getLargestViewPane() {
        ViewPane oPane = null;
        double dLargestArea = 0.0;
        int iCount = this.getViewPaneCount();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            ViewPane oTestPane = this.getViewPane(iIndex);
            double dArea = (oTestPane.mdX2 - oTestPane.mdX1) * (oTestPane.mdY2 - oTestPane.mdY1);
            if (!(dArea > dLargestArea)) continue;
            dLargestArea = dArea;
            oPane = oTestPane;
        }
        return oPane;
    }

    void setMaximizedPane(ViewPane aoPane) {
        this.moMaximizedPane = aoPane;
        this.revalidate();
        this.repaint();
    }

    ViewPane getMaximizedPane() {
        return this.moMaximizedPane;
    }

    public void setAntiAliasText(boolean abAntiAlias) {
        this.mbAntiAliasText = abAntiAlias;
        this.repaint();
    }

    public boolean isAntiAliasText() {
        return this.mbAntiAliasText;
    }

    public void setOrientation(int aiOrientation) {
        if (aiOrientation == this.miOrientation) {
            return;
        }
        if (aiOrientation != 1 & aiOrientation != 5 & aiOrientation != 7 & aiOrientation != 3) {
            return;
        }
        this.miOrientation = aiOrientation;
        this.revalidate();
        this.repaint();
    }

    public int getOrientation() {
        return this.miOrientation;
    }

    public void setDividerSize(int aiDividerSize) {
        this.miDividerSize = aiDividerSize;
        this.revalidate();
        this.repaint();
    }

    public int getDividerSize() {
        return this.miDividerSize;
    }

    public void setMinimumFontSize(int aiSize) {
        this.miMinimumFontSize = aiSize;
        this.repaint();
    }

    public int getMinimumFontSize() {
        return this.miMinimumFontSize;
    }

    public void setHeaderMovementSize(int aiSize) {
        this.miHeaderMovementSize = aiSize;
    }

    public int getHeaderMovementSize() {
        return this.miHeaderMovementSize;
    }

    public void setDividerMovementSize(int aiSize) {
        this.miDividerMovementSize = aiSize;
    }

    public int getDividerMovementSize() {
        return this.miDividerMovementSize;
    }

    public void setPaneContextIcon(Icon aoIcon) {
        this.moPaneContextIcon = aoIcon;
        this.repaint();
    }

    public Icon getPaneContextIcon() {
        return this.moPaneContextIcon;
    }

    public void setDefaultPaneIcon(Icon aoIcon) {
        this.moDefaultPaneIcon = aoIcon;
        this.repaint();
    }

    public Icon getDefaultPaneIcon() {
        return this.moDefaultPaneIcon;
    }

    public void setHeaderSelectIcon(Icon aoIcon) {
        this.moHeaderSelectIcon = aoIcon;
        this.repaint();
    }

    public Icon getHeaderSelectIcon() {
        return this.moHeaderSelectIcon;
    }

    public void setHeaderCloseIcon(Icon aoIcon) {
        this.moHeaderCloseIcon = aoIcon;
        this.repaint();
    }

    public Icon getHeaderCloseIcon() {
        return this.moHeaderCloseIcon;
    }

    public void setHeaderForeground(Color aoColor) {
        this.moHeaderForeground = aoColor;
        this.repaint();
    }

    public Color getHeaderForeground() {
        return this.moHeaderForeground;
    }

    public void setHeaderBackground(Color aoColor) {
        this.moHeaderBackground = aoColor;
        this.repaint();
    }

    public Color getHeaderBackground() {
        return this.moHeaderBackground;
    }

    public void setHeaderSelectedForeground(Color aoColor) {
        this.moHeaderSelectedForeground = aoColor;
        this.repaint();
    }

    public Color getHeaderSelectedForeground() {
        return this.moHeaderSelectedForeground;
    }

    public void setHeaderSelectedBackground(Color aoColor) {
        this.moHeaderSelectedBackground = aoColor;
        this.repaint();
    }

    public Color getHeaderSelectedBackground() {
        return this.moHeaderSelectedBackground;
    }

    public void setDividerForeground(Color aoColor) {
        this.moDividerForeground = aoColor;
        this.repaint();
    }

    public Color getDividerForeground() {
        return this.moDividerForeground;
    }

    public void setDividerBackground(Color aoColor) {
        this.moDividerBackground = aoColor;
        this.repaint();
    }

    public Color getDividerBackground() {
        return this.moDividerBackground;
    }

    ViewPane addViewPane(ViewPane aoViewPane) {
        this.mvViewPanes.add(aoViewPane);
        aoViewPane.addViewPaneListener(this.moViewPaneHandler);
        super.add(aoViewPane);
        return aoViewPane;
    }

    ViewPane removeViewPane(ViewPane aoViewPane) {
        super.remove(aoViewPane);
        aoViewPane.removeViewPaneListener(this.moViewPaneHandler);
        this.mvViewPanes.remove(aoViewPane);
        return aoViewPane;
    }

    ViewHeader addViewHeader(ViewHeader aoViewHeader) {
        this.mvViewHeaders.add(aoViewHeader);
        super.add(aoViewHeader);
        aoViewHeader.init();
        return aoViewHeader;
    }

    ViewHeader removeViewHeader(ViewHeader aoViewHeader) {
        super.remove(aoViewHeader);
        this.mvViewHeaders.remove(aoViewHeader);
        return aoViewHeader;
    }

    ViewDivider addViewDivider(ViewDivider aoViewDivider) {
        this.mvViewDividers.add(aoViewDivider);
        super.add(aoViewDivider);
        return aoViewDivider;
    }

    ViewDivider removeViewDivider(ViewDivider aoViewDivider) {
        super.remove(aoViewDivider);
        this.mvViewDividers.remove(aoViewDivider);
        return aoViewDivider;
    }

    public void setViewAreaFactory(ViewAreaFactory aoFactory) {
        this.moViewAreaFactory = aoFactory == null ? new DefaultViewAreaFactory() : aoFactory;
    }

    public ViewAreaFactory getViewAreaFactory() {
        return this.moViewAreaFactory;
    }

    public boolean isValidateRoot() {
        return true;
    }

    public boolean closePane(ViewPane aoViewPane) {
        if (aoViewPane == null) {
            return false;
        }
        try {
            aoViewPane.close();
        }
        catch (ViewPaneVetoException aoException) {
            return false;
        }
        return true;
    }

    public ViewPane splitVertical(ViewPane aoViewPane) {
        return this.splitSouth(aoViewPane, 0.5);
    }

    public ViewPane splitVertical(ViewPane aoViewPane, double adPercent) {
        return this.splitSouth(aoViewPane, adPercent);
    }

    public ViewPane splitNorth(ViewPane aoViewPane) {
        return this.splitNorth(aoViewPane, 0.5);
    }

    public ViewPane splitNorth(ViewPane aoViewPane, double adPercent) {
        if (aoViewPane == null) {
            return null;
        }
        if (adPercent < 0.0 | adPercent > 1.0) {
            return null;
        }
        try {
            aoViewPane.firePaneWillSplit();
        }
        catch (ViewPaneVetoException aoException) {
            return null;
        }
        double dNewY = (aoViewPane.mdY2 - aoViewPane.mdY1) * adPercent + aoViewPane.mdY1;
        ViewHeader oNewHeader = this.moViewAreaFactory.createViewHeader();
        this.addViewHeader(oNewHeader);
        ViewPane oNewPane = this.moViewAreaFactory.createViewPane(oNewHeader);
        oNewPane.mdX1 = aoViewPane.mdX1;
        oNewPane.mdX2 = aoViewPane.mdX2;
        oNewPane.mdY1 = aoViewPane.mdY1;
        oNewPane.mdY2 = dNewY;
        this.addViewPane(oNewPane);
        ViewDivider oDivider = this.moViewAreaFactory.createViewDivider(0);
        oDivider.mdA = aoViewPane.mdX1;
        oDivider.mdB = aoViewPane.mdX2;
        oDivider.mdLocation = dNewY;
        oDivider.moDividerA = aoViewPane.moWestDivider;
        oDivider.moDividerB = aoViewPane.moEastDivider;
        this.addViewDivider(oDivider);
        oDivider.moNorthPanes.add(oNewPane);
        oDivider.moSouthPanes.add(aoViewPane);
        if (aoViewPane.moNorthDivider != null) {
            aoViewPane.moNorthDivider.moSouthPanes.set(aoViewPane.moNorthDivider.moSouthPanes.indexOf(aoViewPane), oNewPane);
        }
        if (aoViewPane.moWestDivider != null) {
            aoViewPane.moWestDivider.moEastPanes.add(aoViewPane.moWestDivider.moEastPanes.indexOf(aoViewPane), oNewPane);
        }
        if (aoViewPane.moEastDivider != null) {
            aoViewPane.moEastDivider.moWestPanes.add(aoViewPane.moEastDivider.moWestPanes.indexOf(aoViewPane), oNewPane);
        }
        oNewPane.moSouthDivider = oDivider;
        oNewPane.moWestDivider = aoViewPane.moWestDivider;
        oNewPane.moEastDivider = aoViewPane.moEastDivider;
        oNewPane.moNorthDivider = aoViewPane.moNorthDivider;
        aoViewPane.moNorthDivider = oDivider;
        aoViewPane.mdY1 = dNewY;
        aoViewPane.firePaneSplit();
        this.firePaneAdded(oNewPane);
        this.savePreferences();
        this.revalidate();
        return oNewPane;
    }

    public ViewPane splitSouth(ViewPane aoViewPane) {
        return this.splitSouth(aoViewPane, 0.5);
    }

    public ViewPane splitSouth(ViewPane aoViewPane, double adPercent) {
        if (aoViewPane == null) {
            return null;
        }
        if (adPercent < 0.0 | adPercent > 1.0) {
            return null;
        }
        try {
            aoViewPane.firePaneWillSplit();
        }
        catch (ViewPaneVetoException aoException) {
            return null;
        }
        double dNewY = (aoViewPane.mdY2 - aoViewPane.mdY1) * adPercent + aoViewPane.mdY1;
        ViewHeader oNewHeader = this.moViewAreaFactory.createViewHeader();
        this.addViewHeader(oNewHeader);
        ViewPane oNewPane = this.moViewAreaFactory.createViewPane(oNewHeader);
        oNewPane.mdX1 = aoViewPane.mdX1;
        oNewPane.mdX2 = aoViewPane.mdX2;
        oNewPane.mdY1 = dNewY;
        oNewPane.mdY2 = aoViewPane.mdY2;
        this.addViewPane(oNewPane);
        ViewDivider oDivider = this.moViewAreaFactory.createViewDivider(0);
        oDivider.mdA = aoViewPane.mdX1;
        oDivider.mdB = aoViewPane.mdX2;
        oDivider.mdLocation = dNewY;
        oDivider.moDividerA = aoViewPane.moWestDivider;
        oDivider.moDividerB = aoViewPane.moEastDivider;
        this.addViewDivider(oDivider);
        oDivider.moNorthPanes.add(aoViewPane);
        oDivider.moSouthPanes.add(oNewPane);
        if (aoViewPane.moSouthDivider != null) {
            aoViewPane.moSouthDivider.moNorthPanes.set(aoViewPane.moSouthDivider.moNorthPanes.indexOf(aoViewPane), oNewPane);
        }
        if (aoViewPane.moWestDivider != null) {
            aoViewPane.moWestDivider.moEastPanes.add(aoViewPane.moWestDivider.moEastPanes.indexOf(aoViewPane) + 1, oNewPane);
        }
        if (aoViewPane.moEastDivider != null) {
            aoViewPane.moEastDivider.moWestPanes.add(aoViewPane.moEastDivider.moWestPanes.indexOf(aoViewPane) + 1, oNewPane);
        }
        oNewPane.moNorthDivider = oDivider;
        oNewPane.moWestDivider = aoViewPane.moWestDivider;
        oNewPane.moEastDivider = aoViewPane.moEastDivider;
        oNewPane.moSouthDivider = aoViewPane.moSouthDivider;
        aoViewPane.moSouthDivider = oDivider;
        aoViewPane.mdY2 = dNewY;
        aoViewPane.firePaneSplit();
        this.firePaneAdded(oNewPane);
        this.savePreferences();
        this.revalidate();
        return oNewPane;
    }

    public ViewPane splitHorizontal(ViewPane aoViewPane) {
        return this.splitEast(aoViewPane, 0.5);
    }

    public ViewPane splitHorizontal(ViewPane aoViewPane, double adPercent) {
        return this.splitEast(aoViewPane, adPercent);
    }

    public ViewPane splitWest(ViewPane aoViewPane) {
        return this.splitWest(aoViewPane, 0.5);
    }

    public ViewPane splitWest(ViewPane aoViewPane, double adPercent) {
        if (aoViewPane == null) {
            return null;
        }
        if (adPercent < 0.0 | adPercent > 1.0) {
            return null;
        }
        try {
            aoViewPane.firePaneWillSplit();
        }
        catch (ViewPaneVetoException aoException) {
            return null;
        }
        double dNewX = (aoViewPane.mdX2 - aoViewPane.mdX1) * adPercent + aoViewPane.mdX1;
        ViewHeader oNewHeader = this.moViewAreaFactory.createViewHeader();
        this.addViewHeader(oNewHeader);
        ViewPane oNewPane = this.moViewAreaFactory.createViewPane(oNewHeader);
        oNewPane.mdX1 = aoViewPane.mdX1;
        oNewPane.mdX2 = dNewX;
        oNewPane.mdY1 = aoViewPane.mdY1;
        oNewPane.mdY2 = aoViewPane.mdY2;
        this.addViewPane(oNewPane);
        ViewDivider oDivider = this.moViewAreaFactory.createViewDivider(1);
        oDivider.mdA = aoViewPane.mdY1;
        oDivider.mdB = aoViewPane.mdY2;
        oDivider.mdLocation = dNewX;
        oDivider.moDividerA = aoViewPane.moNorthDivider;
        oDivider.moDividerB = aoViewPane.moSouthDivider;
        this.addViewDivider(oDivider);
        oDivider.moWestPanes.add(oNewPane);
        oDivider.moEastPanes.add(aoViewPane);
        if (aoViewPane.moWestDivider != null) {
            aoViewPane.moWestDivider.moEastPanes.set(aoViewPane.moWestDivider.moEastPanes.indexOf(aoViewPane), oNewPane);
        }
        if (aoViewPane.moNorthDivider != null) {
            aoViewPane.moNorthDivider.moSouthPanes.add(aoViewPane.moNorthDivider.moSouthPanes.indexOf(aoViewPane) + 1, oNewPane);
        }
        if (aoViewPane.moSouthDivider != null) {
            aoViewPane.moSouthDivider.moNorthPanes.add(aoViewPane.moSouthDivider.moNorthPanes.indexOf(aoViewPane) + 1, oNewPane);
        }
        oNewPane.moEastDivider = oDivider;
        oNewPane.moNorthDivider = aoViewPane.moNorthDivider;
        oNewPane.moSouthDivider = aoViewPane.moSouthDivider;
        oNewPane.moWestDivider = aoViewPane.moWestDivider;
        aoViewPane.moWestDivider = oDivider;
        aoViewPane.mdX1 = dNewX;
        aoViewPane.firePaneSplit();
        this.firePaneAdded(oNewPane);
        this.savePreferences();
        this.revalidate();
        return oNewPane;
    }

    public ViewPane splitEast(ViewPane aoViewPane) {
        return this.splitEast(aoViewPane, 0.5);
    }

    public ViewPane splitEast(ViewPane aoViewPane, double adPercent) {
        if (aoViewPane == null) {
            return null;
        }
        if (adPercent < 0.0 | adPercent > 1.0) {
            return null;
        }
        try {
            aoViewPane.firePaneWillSplit();
        }
        catch (ViewPaneVetoException aoException) {
            return null;
        }
        double dNewX = (aoViewPane.mdX2 - aoViewPane.mdX1) * adPercent + aoViewPane.mdX1;
        ViewHeader oNewHeader = this.moViewAreaFactory.createViewHeader();
        this.addViewHeader(oNewHeader);
        ViewPane oNewPane = this.moViewAreaFactory.createViewPane(oNewHeader);
        oNewPane.mdX1 = dNewX;
        oNewPane.mdX2 = aoViewPane.mdX2;
        oNewPane.mdY1 = aoViewPane.mdY1;
        oNewPane.mdY2 = aoViewPane.mdY2;
        this.addViewPane(oNewPane);
        ViewDivider oDivider = this.moViewAreaFactory.createViewDivider(1);
        oDivider.mdA = aoViewPane.mdY1;
        oDivider.mdB = aoViewPane.mdY2;
        oDivider.mdLocation = dNewX;
        oDivider.moDividerA = aoViewPane.moNorthDivider;
        oDivider.moDividerB = aoViewPane.moSouthDivider;
        this.addViewDivider(oDivider);
        oDivider.moWestPanes.add(aoViewPane);
        oDivider.moEastPanes.add(oNewPane);
        if (aoViewPane.moEastDivider != null) {
            aoViewPane.moEastDivider.moWestPanes.set(aoViewPane.moEastDivider.moWestPanes.indexOf(aoViewPane), oNewPane);
        }
        if (aoViewPane.moNorthDivider != null) {
            aoViewPane.moNorthDivider.moSouthPanes.add(aoViewPane.moNorthDivider.moSouthPanes.indexOf(aoViewPane) + 1, oNewPane);
        }
        if (aoViewPane.moSouthDivider != null) {
            aoViewPane.moSouthDivider.moNorthPanes.add(aoViewPane.moSouthDivider.moNorthPanes.indexOf(aoViewPane) + 1, oNewPane);
        }
        oNewPane.moWestDivider = oDivider;
        oNewPane.moNorthDivider = aoViewPane.moNorthDivider;
        oNewPane.moSouthDivider = aoViewPane.moSouthDivider;
        oNewPane.moEastDivider = aoViewPane.moEastDivider;
        aoViewPane.moEastDivider = oDivider;
        aoViewPane.mdX2 = dNewX;
        aoViewPane.firePaneSplit();
        this.firePaneAdded(oNewPane);
        this.savePreferences();
        this.revalidate();
        return oNewPane;
    }

    public boolean mergeNorth(ViewPane aoViewPane) {
        ViewDivider oNorthDivider;
        if (aoViewPane == null || aoViewPane.moNorthDivider == null) {
            return false;
        }
        ViewPane oMatchPane = null;
        int iSize = aoViewPane.moNorthDivider.moNorthPanes.size();
        for (int iIndex = 0; iIndex < iSize; ++iIndex) {
            ViewPane oPane = (ViewPane)aoViewPane.moNorthDivider.moNorthPanes.get(iIndex);
            if (!(oPane.mdX1 == aoViewPane.mdX1 & oPane.mdX2 == aoViewPane.mdX2)) continue;
            oMatchPane = oPane;
            break;
        }
        if (oMatchPane == null) {
            return false;
        }
        try {
            aoViewPane.firePaneWillMerge();
        }
        catch (ViewPaneVetoException aoException) {
            return false;
        }
        ViewDivider oCommonDivider = aoViewPane.moNorthDivider;
        aoViewPane.moNorthDivider = oNorthDivider = oMatchPane.moNorthDivider;
        aoViewPane.mdY1 = oMatchPane.mdY1;
        if (oNorthDivider != null) {
            int iIndex = oNorthDivider.moSouthPanes.indexOf(oMatchPane);
            oNorthDivider.moSouthPanes.add(iIndex, aoViewPane);
        }
        this.mergeClean(aoViewPane, oMatchPane, oCommonDivider);
        return true;
    }

    public boolean mergeEast(ViewPane aoViewPane) {
        ViewDivider oEastDivider;
        if (aoViewPane == null) {
            return false;
        }
        if (aoViewPane.moEastDivider == null) {
            return false;
        }
        ViewPane oMatchPane = null;
        int iSize = aoViewPane.moEastDivider.moEastPanes.size();
        for (int iIndex = 0; iIndex < iSize; ++iIndex) {
            ViewPane oPane = (ViewPane)aoViewPane.moEastDivider.moEastPanes.get(iIndex);
            if (!(oPane.mdY1 == aoViewPane.mdY1 & oPane.mdY2 == aoViewPane.mdY2)) continue;
            oMatchPane = oPane;
            break;
        }
        if (oMatchPane == null) {
            return false;
        }
        try {
            aoViewPane.firePaneWillMerge();
        }
        catch (ViewPaneVetoException aoException) {
            return false;
        }
        ViewDivider oCommonDivider = aoViewPane.moEastDivider;
        aoViewPane.moEastDivider = oEastDivider = oMatchPane.moEastDivider;
        aoViewPane.mdX2 = oMatchPane.mdX2;
        if (oEastDivider != null) {
            int iIndex = oEastDivider.moWestPanes.indexOf(oMatchPane);
            oEastDivider.moWestPanes.add(iIndex, aoViewPane);
        }
        this.mergeClean(aoViewPane, oMatchPane, oCommonDivider);
        return true;
    }

    public boolean mergeSouth(ViewPane aoViewPane) {
        ViewDivider oSouthDivider;
        if (aoViewPane == null) {
            return false;
        }
        if (aoViewPane.moSouthDivider == null) {
            return false;
        }
        ViewPane oMatchPane = null;
        int iSize = aoViewPane.moSouthDivider.moSouthPanes.size();
        for (int iIndex = 0; iIndex < iSize; ++iIndex) {
            ViewPane oPane = (ViewPane)aoViewPane.moSouthDivider.moSouthPanes.get(iIndex);
            if (!(oPane.mdX1 == aoViewPane.mdX1 & oPane.mdX2 == aoViewPane.mdX2)) continue;
            oMatchPane = oPane;
            break;
        }
        if (oMatchPane == null) {
            return false;
        }
        try {
            aoViewPane.firePaneWillMerge();
        }
        catch (ViewPaneVetoException aoException) {
            return false;
        }
        ViewDivider oCommonDivider = aoViewPane.moSouthDivider;
        aoViewPane.moSouthDivider = oSouthDivider = oMatchPane.moSouthDivider;
        aoViewPane.mdY2 = oMatchPane.mdY2;
        if (oSouthDivider != null) {
            int iIndex = oSouthDivider.moNorthPanes.indexOf(oMatchPane);
            oSouthDivider.moNorthPanes.add(iIndex, aoViewPane);
        }
        this.mergeClean(aoViewPane, oMatchPane, oCommonDivider);
        return true;
    }

    public boolean mergeWest(ViewPane aoViewPane) {
        ViewDivider oWestDivider;
        if (aoViewPane == null) {
            return false;
        }
        if (aoViewPane.moWestDivider == null) {
            return false;
        }
        ViewPane oMatchPane = null;
        int iSize = aoViewPane.moWestDivider.moWestPanes.size();
        for (int iIndex = 0; iIndex < iSize; ++iIndex) {
            ViewPane oPane = (ViewPane)aoViewPane.moWestDivider.moWestPanes.get(iIndex);
            if (!(oPane.mdY1 == aoViewPane.mdY1 & oPane.mdY2 == aoViewPane.mdY2)) continue;
            oMatchPane = oPane;
            break;
        }
        if (oMatchPane == null) {
            return false;
        }
        try {
            aoViewPane.firePaneWillMerge();
        }
        catch (ViewPaneVetoException aoException) {
            return false;
        }
        ViewDivider oCommonDivider = aoViewPane.moWestDivider;
        aoViewPane.moWestDivider = oWestDivider = oMatchPane.moWestDivider;
        aoViewPane.mdX1 = oMatchPane.mdX1;
        if (oWestDivider != null) {
            int iIndex = oWestDivider.moEastPanes.indexOf(oMatchPane);
            oWestDivider.moEastPanes.add(iIndex, aoViewPane);
        }
        this.mergeClean(aoViewPane, oMatchPane, oCommonDivider);
        return true;
    }

    private void mergeClean(ViewPane aoViewPane, ViewPane aoOldPane, ViewDivider aoDivider) {
        if (aoOldPane.moNorthDivider != null) {
            aoOldPane.moNorthDivider.moSouthPanes.remove(aoOldPane);
            aoOldPane.moNorthDivider = null;
        }
        if (aoOldPane.moEastDivider != null) {
            aoOldPane.moEastDivider.moWestPanes.remove(aoOldPane);
            aoOldPane.moEastDivider = null;
        }
        if (aoOldPane.moSouthDivider != null) {
            aoOldPane.moSouthDivider.moNorthPanes.remove(aoOldPane);
            aoOldPane.moSouthDivider = null;
        }
        if (aoOldPane.moWestDivider != null) {
            aoOldPane.moWestDivider.moEastPanes.remove(aoOldPane);
            aoOldPane.moWestDivider = null;
        }
        aoDivider.moDividerA = null;
        aoDivider.moDividerB = null;
        this.removeViewPane(aoOldPane);
        this.removeViewHeader(aoOldPane.getViewHeader());
        this.removeViewDivider(aoDivider);
        if (aoOldPane == this.getSelectedViewPane()) {
            this.setSelectedViewPane(aoViewPane);
        }
        if (aoOldPane == this.getDefaultViewPane()) {
            this.setDefaultViewPane(aoViewPane);
        }
        aoViewPane.firePaneMerged();
        this.firePaneRemoved(aoOldPane);
        this.savePreferences();
        this.revalidate();
    }

    public void moveNorthEdge(ViewPane aoViewPane, int aiOffset) {
    }

    public void moveEastEdge(ViewPane aoViewPane, int aiOffset) {
    }

    public void moveSouthEdge(ViewPane aoViewPane, int aiOffset) {
    }

    public void moveWestEdge(ViewPane aoViewPane, int aiOffset) {
    }

    public int moveDivider(ViewDivider aoDivider, int aiOffset) {
        if (aoDivider.getOrientation() == 0) {
            return this.moveDividerVertical(aoDivider, aiOffset);
        }
        return this.moveDividerHorizontal(aoDivider, aiOffset);
    }

    int moveDividerVertical(ViewDivider aoDivider, int aiDelta) {
        int iResult;
        ViewPane oPane;
        int iIndex;
        Dimension oPaneSize;
        if (aiDelta == 0) {
            return 0;
        }
        int iDelta = aiDelta;
        Rectangle oDividerBounds = aoDivider.getBounds();
        Rectangle oViewAreaBounds = this.getBounds();
        int iDividerSize = this.miDividerSize;
        int iOrientation = this.miOrientation;
        double dOldLocation = aoDivider.mdLocation;
        ViewDivider oBlockingDivider = null;
        int iCount = 0;
        if (aiDelta < 0) {
            oPaneSize = null;
            iCount = aoDivider.moNorthPanes.size();
            for (iIndex = 0; iIndex < iCount; ++iIndex) {
                oPane = (ViewPane)aoDivider.moNorthPanes.get(iIndex);
                oPaneSize = this.getInternalPaneSize(oPane);
                if (oPaneSize.height >= -iDelta) continue;
                iDelta = -oPaneSize.height;
                oBlockingDivider = oPane.moNorthDivider;
            }
            if (aiDelta - iDelta < 0 && oBlockingDivider != null) {
                iResult = this.moveDividerVertical(oBlockingDivider, aiDelta - iDelta);
                iDelta += iResult;
            }
        } else if (aiDelta > 0) {
            oPaneSize = null;
            iCount = aoDivider.moSouthPanes.size();
            for (iIndex = 0; iIndex < iCount; ++iIndex) {
                oPane = (ViewPane)aoDivider.moSouthPanes.get(iIndex);
                oPaneSize = this.getInternalPaneSize(oPane);
                if (oPaneSize.height >= iDelta) continue;
                iDelta = oPaneSize.height;
                oBlockingDivider = oPane.moSouthDivider;
            }
            if (aiDelta - iDelta > 0 && oBlockingDivider != null) {
                iResult = this.moveDividerVertical(oBlockingDivider, aiDelta - iDelta);
                iDelta += iResult;
            }
        }
        aoDivider.mdLocation += (double)iDelta / (double)oViewAreaBounds.height;
        this.fireDividerChanged(aoDivider);
        int iSize = aoDivider.moNorthPanes.size();
        for (iIndex = 0; iIndex < iSize; ++iIndex) {
            oPane = (ViewPane)aoDivider.moNorthPanes.get(iIndex);
            oPane.mdY2 = aoDivider.mdLocation;
            oPane.firePaneResized();
            if (oPane.moWestDivider != null && oPane.moWestDivider.mdB == dOldLocation) {
                oPane.moWestDivider.mdB = aoDivider.mdLocation;
                this.fireDividerChanged(oPane.moWestDivider);
            }
            if (oPane.moEastDivider == null || oPane.moEastDivider.mdB != dOldLocation) continue;
            oPane.moEastDivider.mdB = aoDivider.mdLocation;
            this.fireDividerChanged(oPane.moEastDivider);
        }
        iSize = aoDivider.moSouthPanes.size();
        for (iIndex = 0; iIndex < iSize; ++iIndex) {
            oPane = (ViewPane)aoDivider.moSouthPanes.get(iIndex);
            oPane.mdY1 = aoDivider.mdLocation;
            oPane.firePaneResized();
            if (oPane.moWestDivider != null && oPane.moWestDivider.mdA == dOldLocation) {
                oPane.moWestDivider.mdA = aoDivider.mdLocation;
                this.fireDividerChanged(oPane.moWestDivider);
            }
            if (oPane.moEastDivider == null || oPane.moEastDivider.mdA != dOldLocation) continue;
            oPane.moEastDivider.mdA = aoDivider.mdLocation;
            this.fireDividerChanged(oPane.moEastDivider);
        }
        this.revalidate();
        return iDelta;
    }

    int moveDividerHorizontal(ViewDivider aoDivider, int aiDelta) {
        int iResult;
        ViewPane oPane;
        int iIndex;
        Dimension oPaneSize;
        if (aiDelta == 0) {
            return 0;
        }
        int iDelta = aiDelta;
        Rectangle oDividerBounds = aoDivider.getBounds();
        Rectangle oViewAreaBounds = this.getBounds();
        int iDividerSize = this.miDividerSize;
        int iOrientation = this.miOrientation;
        double dOldLocation = aoDivider.mdLocation;
        ViewDivider oBlockingDivider = null;
        int iCount = 0;
        if (aiDelta < 0) {
            oPaneSize = null;
            iCount = aoDivider.moWestPanes.size();
            for (iIndex = 0; iIndex < iCount; ++iIndex) {
                oPane = (ViewPane)aoDivider.moWestPanes.get(iIndex);
                oPaneSize = this.getInternalPaneSize(oPane);
                if (oPaneSize.width >= -iDelta) continue;
                iDelta = -oPaneSize.width;
                oBlockingDivider = oPane.moWestDivider;
            }
            if (aiDelta - iDelta < 0 && oBlockingDivider != null) {
                iResult = this.moveDividerHorizontal(oBlockingDivider, aiDelta - iDelta);
                iDelta += iResult;
            }
        } else if (aiDelta > 0) {
            oPaneSize = null;
            iCount = aoDivider.moEastPanes.size();
            for (iIndex = 0; iIndex < iCount; ++iIndex) {
                oPane = (ViewPane)aoDivider.moEastPanes.get(iIndex);
                oPaneSize = this.getInternalPaneSize(oPane);
                if (oPaneSize.width >= iDelta) continue;
                iDelta = oPaneSize.width;
                oBlockingDivider = oPane.moEastDivider;
            }
            if (aiDelta - iDelta > 0 && oBlockingDivider != null) {
                iResult = this.moveDividerHorizontal(oBlockingDivider, aiDelta - iDelta);
                iDelta += iResult;
            }
        }
        aoDivider.mdLocation += (double)iDelta / (double)oViewAreaBounds.width;
        this.fireDividerChanged(aoDivider);
        int iSize = aoDivider.moWestPanes.size();
        for (iIndex = 0; iIndex < iSize; ++iIndex) {
            oPane = (ViewPane)aoDivider.moWestPanes.get(iIndex);
            oPane.mdX2 = aoDivider.mdLocation;
            oPane.firePaneResized();
            if (oPane.moNorthDivider != null && oPane.moNorthDivider.mdB == dOldLocation) {
                oPane.moNorthDivider.mdB = aoDivider.mdLocation;
                this.fireDividerChanged(oPane.moNorthDivider);
            }
            if (oPane.moSouthDivider == null || oPane.moSouthDivider.mdB != dOldLocation) continue;
            oPane.moSouthDivider.mdB = aoDivider.mdLocation;
            this.fireDividerChanged(oPane.moSouthDivider);
        }
        iSize = aoDivider.moEastPanes.size();
        for (iIndex = 0; iIndex < iSize; ++iIndex) {
            oPane = (ViewPane)aoDivider.moEastPanes.get(iIndex);
            oPane.mdX1 = aoDivider.mdLocation;
            oPane.firePaneResized();
            if (oPane.moNorthDivider != null && oPane.moNorthDivider.mdA == dOldLocation) {
                oPane.moNorthDivider.mdA = aoDivider.mdLocation;
                this.fireDividerChanged(oPane.moNorthDivider);
            }
            if (oPane.moSouthDivider == null || oPane.moSouthDivider.mdA != dOldLocation) continue;
            oPane.moSouthDivider.mdA = aoDivider.mdLocation;
            this.fireDividerChanged(oPane.moSouthDivider);
        }
        this.revalidate();
        return iDelta;
    }

    private void fireDividerChanged(ViewDivider aoDivider) {
        int iIndex = this.mvViewDividers.indexOf(aoDivider);
        Preferences oDividerPrefs = this.moPreferences.node("viewdivider-" + iIndex);
        oDividerPrefs.putDouble("location", aoDivider.mdLocation);
        oDividerPrefs.putDouble("start", aoDivider.mdA);
        oDividerPrefs.putDouble("end", aoDivider.mdB);
    }

    private void firePaneAdded(ViewPane aoPane) {
        int iSize = this.mvViewListeners.size();
        for (int iIndex = 0; iIndex < iSize; ++iIndex) {
            ((ViewAreaListener)this.mvViewListeners.get(iIndex)).paneAdded(new ViewAreaEvent(this, aoPane));
        }
    }

    private void firePaneRemoved(ViewPane aoPane) {
        int iSize = this.mvViewListeners.size();
        for (int iIndex = 0; iIndex < iSize; ++iIndex) {
            ((ViewAreaListener)this.mvViewListeners.get(iIndex)).paneRemoved(new ViewAreaEvent(this, aoPane));
        }
    }

    public void setPreferences(Preferences aoPreferences, Preferences aoDefaultPreferences) {
        if (aoPreferences == this.moPreferences) {
            return;
        }
        this.moPreferences = aoPreferences;
        if (aoPreferences != null) {
            this.loadPreferences(aoPreferences, aoDefaultPreferences);
            this.moPreferenceChangeHandler.init(aoPreferences, aoDefaultPreferences);
        }
    }

    public Preferences getPreferences() {
        this.savePreferences();
        return this.moPreferences;
    }

    private void loadPreferences(Preferences aoPreferences, Preferences aoDefaultPreferences) {
        int iIndex;
        if (aoPreferences == null) {
            return;
        }
        PreferenceEngine oPreferenceEngine = PreferenceEngine.get();
        int iPaneCount = oPreferenceEngine.getIntegerValue(aoPreferences, "viewarea.pane.count", aoDefaultPreferences);
        int iSelectedPane = oPreferenceEngine.getIntegerValue(aoPreferences, "viewarea.pane.active", aoDefaultPreferences);
        int iDefaultPane = oPreferenceEngine.getIntegerValue(aoPreferences, "viewarea.pane.default", aoDefaultPreferences);
        if (iPaneCount == 0) {
            this.savePreferences();
            return;
        }
        int iOldPaneCount = this.mvViewPanes.size();
        for (int iIndex2 = 0; iIndex2 < iOldPaneCount; ++iIndex2) {
            ViewPane oPane = (ViewPane)this.mvViewPanes.get(iIndex2);
            this.removeViewPane(oPane);
        }
        int iOldHeaderCount = this.mvViewHeaders.size();
        for (int iIndex3 = 0; iIndex3 < iOldHeaderCount; ++iIndex3) {
            ViewHeader oHeader = (ViewHeader)this.mvViewHeaders.get(iIndex3);
            this.removeViewHeader(oHeader);
        }
        int iOldDividerCount = this.mvViewPanes.size();
        for (int iIndex4 = 0; iIndex4 < iOldDividerCount; ++iIndex4) {
            ViewDivider oDivider = (ViewDivider)this.mvViewDividers.get(iIndex4);
            this.removeViewDivider(oDivider);
        }
        ViewDivider oDivider = null;
        int iDividerCount = iPaneCount - 1;
        int[] aDividerA = new int[iDividerCount];
        int[] aDividerB = new int[iDividerCount];
        for (iIndex = 0; iIndex < iDividerCount; ++iIndex) {
            Preferences oDividerDefaultPreferences;
            Preferences oDividerPreferences = aoPreferences.node("viewdivider-" + iIndex);
            int iOrientation = "vertical".equals(oPreferenceEngine.getStringValue(oDividerPreferences, "orientation", oDividerDefaultPreferences = aoDefaultPreferences.node("viewdivider-" + iIndex), "vertical")) ? 1 : 0;
            double dA = oPreferenceEngine.getDecimalValue(oDividerPreferences, "start", oDividerDefaultPreferences, -1.0);
            double dB = oPreferenceEngine.getDecimalValue(oDividerPreferences, "end", oDividerDefaultPreferences, -1.0);
            double dLocation = oPreferenceEngine.getDecimalValue(oDividerPreferences, "location", oDividerDefaultPreferences, -1.0);
            int iDividerA = oPreferenceEngine.getIntegerValue(oDividerPreferences, "a", oDividerDefaultPreferences, -1);
            int iDividerB = oPreferenceEngine.getIntegerValue(oDividerPreferences, "b", oDividerDefaultPreferences, -1);
            oDivider = this.moViewAreaFactory.createViewDivider(iOrientation);
            oDivider.mdLocation = dLocation;
            oDivider.mdA = dA;
            oDivider.mdB = dB;
            aDividerA[iIndex] = iDividerA;
            aDividerB[iIndex] = iDividerB;
            this.addViewDivider(oDivider);
        }
        for (iIndex = 0; iIndex < iDividerCount; ++iIndex) {
            oDivider = (ViewDivider)this.mvViewDividers.get(iIndex);
            int iDividerA = aDividerA[iIndex];
            int iDividerB = aDividerB[iIndex];
            ViewDivider oDividerA = iDividerA < 0 ? null : this.mvViewDividers.get(iDividerA);
            ViewDivider oDividerB = iDividerB < 0 ? null : this.mvViewDividers.get(iDividerB);
            oDivider.moDividerA = oDividerA;
            oDivider.moDividerB = oDividerB;
        }
        for (iIndex = 0; iIndex < iPaneCount; ++iIndex) {
            ViewPane oPeer;
            int iCount;
            int iPeerIndex;
            int iPeer;
            Preferences oViewPanePreferences = aoPreferences.node("viewpane-" + iIndex);
            Preferences oViewPaneDefaultPreferences = aoDefaultPreferences.node("viewpane-" + iIndex);
            double dX1 = oPreferenceEngine.getDecimalValue(oViewPanePreferences, "x1", oViewPaneDefaultPreferences, -1.0);
            double dY1 = oPreferenceEngine.getDecimalValue(oViewPanePreferences, "y1", oViewPaneDefaultPreferences, -1.0);
            double dX2 = oPreferenceEngine.getDecimalValue(oViewPanePreferences, "x2", oViewPaneDefaultPreferences, -1.0);
            double dY2 = oPreferenceEngine.getDecimalValue(oViewPanePreferences, "y2", oViewPaneDefaultPreferences, -1.0);
            int iNorth = oPreferenceEngine.getIntegerValue(oViewPanePreferences, "n", oViewPaneDefaultPreferences, -1);
            int iEast = oPreferenceEngine.getIntegerValue(oViewPanePreferences, "e", oViewPaneDefaultPreferences, -1);
            int iSouth = oPreferenceEngine.getIntegerValue(oViewPanePreferences, "s", oViewPaneDefaultPreferences, -1);
            int iWest = oPreferenceEngine.getIntegerValue(oViewPanePreferences, "w", oViewPaneDefaultPreferences, -1);
            ViewHeader oHeader = this.addViewHeader(this.moViewAreaFactory.createViewHeader());
            this.addViewHeader(oHeader);
            ViewPane oPane = this.moViewAreaFactory.createViewPane(oHeader);
            oPane.setPreferences(oViewPanePreferences, oViewPaneDefaultPreferences);
            oPane.mdX1 = dX1;
            oPane.mdY1 = dY1;
            oPane.mdX2 = dX2;
            oPane.mdY2 = dY2;
            this.addViewPane(oPane);
            if (iNorth >= 0) {
                oPane.moNorthDivider = oDivider = (ViewDivider)this.mvViewDividers.get(iNorth);
                iPeer = 0;
                iPeerIndex = 0;
                iCount = oDivider.mvPanesB.size();
                if (iPeerIndex < iCount) {
                    oPeer = (ViewPane)oDivider.mvPanesB.get(iPeerIndex);
                    if (oPeer.mdX2 <= oPane.mdX1) {
                        iPeer = iPeerIndex;
                    }
                }
                oDivider.mvPanesB.add(iPeer, oPane);
            }
            if (iEast >= 0) {
                oPane.moEastDivider = oDivider = (ViewDivider)this.mvViewDividers.get(iEast);
                iPeer = 0;
                iPeerIndex = 0;
                iCount = oDivider.mvPanesA.size();
                if (iPeerIndex < iCount) {
                    oPeer = (ViewPane)oDivider.mvPanesA.get(iPeerIndex);
                    if (oPeer.mdY2 <= oPane.mdY1) {
                        iPeer = iPeerIndex;
                    }
                }
                oDivider.mvPanesA.add(iPeer, oPane);
            }
            if (iSouth >= 0) {
                oPane.moSouthDivider = oDivider = (ViewDivider)this.mvViewDividers.get(iSouth);
                iPeer = 0;
                iPeerIndex = 0;
                iCount = oDivider.mvPanesA.size();
                if (iPeerIndex < iCount) {
                    oPeer = (ViewPane)oDivider.mvPanesA.get(iPeerIndex);
                    if (oPeer.mdX2 <= oPane.mdX1) {
                        iPeer = iPeerIndex;
                    }
                }
                oDivider.mvPanesA.add(iPeer, oPane);
            }
            if (iWest < 0) continue;
            oPane.moWestDivider = oDivider = (ViewDivider)this.mvViewDividers.get(iWest);
            iPeer = 0;
            iPeerIndex = 0;
            iCount = oDivider.mvPanesB.size();
            if (iPeerIndex < iCount) {
                oPeer = (ViewPane)oDivider.mvPanesB.get(iPeerIndex);
                if (oPeer.mdY2 <= oPane.mdY1) {
                    iPeer = iPeerIndex;
                }
            }
            oDivider.mvPanesB.add(iPeer, oPane);
        }
        if (iDefaultPane >= 0) {
            this.setDefaultViewPane((ViewPane)this.mvViewPanes.get(iDefaultPane));
        }
        if (iSelectedPane >= 0) {
            this.setSelectedViewPane((ViewPane)this.mvViewPanes.get(iSelectedPane));
        }
    }

    private void savePreferences() {
        try {
            int iPaneCount = this.mvViewPanes.size();
            for (int iIndex = 0; iIndex < iPaneCount; ++iIndex) {
                ((ViewPane)this.mvViewPanes.get(iIndex)).setPreferences(null, null);
            }
            String[] aKeys = this.moPreferences.keys();
            for (int iIndex = 0; iIndex < aKeys.length; ++iIndex) {
                if (!aKeys[iIndex].startsWith("viewarea")) continue;
                this.moPreferences.remove(aKeys[iIndex]);
            }
            String[] aNodeNames = this.moPreferences.childrenNames();
            for (int iIndex = 0; iIndex < aNodeNames.length; ++iIndex) {
                if (aNodeNames[iIndex].startsWith("viewpane")) {
                    this.moPreferences.node(aNodeNames[iIndex]).removeNode();
                }
                if (!aNodeNames[iIndex].startsWith("viewdivider")) continue;
                this.moPreferences.node(aNodeNames[iIndex]).removeNode();
            }
        }
        catch (BackingStoreException aoException) {
            Log.write(2, (Throwable)aoException);
        }
        this.moPreferences.putInt("viewarea.pane.count", this.mvViewPanes.size());
        this.moPreferences.putInt("viewarea.pane.active", this.mvViewPanes.indexOf(this.moSelectedPane));
        this.moPreferences.putInt("viewarea.pane.default", this.mvViewPanes.indexOf(this.moDefaultPane));
        int iDividerCount = this.mvViewDividers.size();
        for (int iIndex = 0; iIndex < iDividerCount; ++iIndex) {
            ViewDivider oDivider = (ViewDivider)this.mvViewDividers.get(iIndex);
            Preferences oDividerPreferences = this.moPreferences.node("viewdivider-" + iIndex);
            oDividerPreferences.put("orientation", oDivider.miOrientation == 1 ? "vertical" : "horizontal");
            oDividerPreferences.putDouble("start", oDivider.mdA);
            oDividerPreferences.putDouble("end", oDivider.mdB);
            oDividerPreferences.putDouble("location", oDivider.mdLocation);
            int iDividerA = this.mvViewDividers.indexOf(oDivider.moDividerA);
            int iDividerB = this.mvViewDividers.indexOf(oDivider.moDividerB);
            oDividerPreferences.putInt("a", iDividerA < 0 ? -1 : iDividerA);
            oDividerPreferences.putInt("b", iDividerB < 0 ? -1 : iDividerB);
        }
        int iPaneCount = this.mvViewPanes.size();
        for (int iIndex = 0; iIndex < iPaneCount; ++iIndex) {
            ViewPane oPane = (ViewPane)this.mvViewPanes.get(iIndex);
            Preferences oPanePreferences = this.moPreferences.node("viewpane-" + iIndex);
            oPane.setPreferences(oPanePreferences, null);
            oPanePreferences.putDouble("x1", oPane.mdX1);
            oPanePreferences.putDouble("y1", oPane.mdY1);
            oPanePreferences.putDouble("x2", oPane.mdX2);
            oPanePreferences.putDouble("y2", oPane.mdY2);
            int iNorth = this.mvViewDividers.indexOf(oPane.moNorthDivider);
            int iEast = this.mvViewDividers.indexOf(oPane.moEastDivider);
            int iSouth = this.mvViewDividers.indexOf(oPane.moSouthDivider);
            int iWest = this.mvViewDividers.indexOf(oPane.moWestDivider);
            oPanePreferences.putInt("n", iNorth < 0 ? -1 : iNorth);
            oPanePreferences.putInt("e", iEast < 0 ? -1 : iEast);
            oPanePreferences.putInt("s", iSouth < 0 ? -1 : iSouth);
            oPanePreferences.putInt("w", iWest < 0 ? -1 : iWest);
        }
    }

    public void updateUI() {
        this.setLookAndFeelValues();
        super.updateUI();
    }

    private void setLookAndFeelValues() {
        Font oFont = UIManager.getFont("InternalFrame.titleFont");
        if (oFont == null) {
            oFont = UIManager.getFont("captionFont");
        }
        this.setFont(oFont);
        this.setForeground(UIManager.getColor("black"));
        this.setBackground(UIManager.getColor("white"));
        Color oHeaderForeground = UIManager.getColor("InternalFrame.inactiveTitleForeground");
        if (oHeaderForeground == null) {
            oHeaderForeground = UIManager.getColor("inactiveCaptionText");
        }
        this.setHeaderForeground(oHeaderForeground);
        Color oHeaderBackground = UIManager.getColor("InternalFrame.inactiveTitleBackground");
        if (oHeaderBackground == null) {
            oHeaderBackground = UIManager.getColor("ininactiveCaption");
        }
        this.setHeaderBackground(oHeaderBackground);
        Color oHeaderSelectedForeground = UIManager.getColor("InternalFrame.activeTitleForeground");
        if (oHeaderSelectedForeground == null) {
            oHeaderSelectedForeground = UIManager.getColor("activeCaptionText");
        }
        this.setHeaderSelectedForeground(oHeaderSelectedForeground);
        Color oHeaderSelectedBackground = UIManager.getColor("InternalFrame.activeTitleBackground");
        if (oHeaderSelectedBackground == null) {
            oHeaderSelectedBackground = UIManager.getColor("activeCaption");
        }
        this.setHeaderSelectedBackground(oHeaderSelectedBackground);
        Color oDividerForeground = UIManager.getColor("InternalFrame.inactiveTitleForeground");
        if (oDividerForeground == null) {
            oDividerForeground = UIManager.getColor("inactiveCaptionText");
        }
        this.setDividerForeground(oDividerForeground);
        Color oDividerBackground = UIManager.getColor("InternalFrame.inactiveTitleBackground");
        if (oDividerBackground == null) {
            oDividerBackground = UIManager.getColor("ininactiveCaption");
        }
        this.setDividerBackground(oDividerBackground);
    }

    private Rectangle getInsideBounds(JComponent aoComponent) {
        Rectangle oBounds = aoComponent.getBounds();
        Insets oInsets = aoComponent.getInsets();
        return new Rectangle(oBounds.x + oInsets.left, oBounds.y + oInsets.top, oBounds.width - (oInsets.left + oInsets.right), oBounds.height - (oInsets.top + oInsets.bottom));
    }

    private Dimension getInternalPaneSize(ViewPane aoPane) {
        Rectangle oBounds = aoPane.getBounds();
        Insets oInsets = aoPane.getInsets();
        int iWidth = oBounds.width;
        int iHeight = oBounds.height;
        switch (this.miOrientation) {
            case 1: {
                iHeight -= oInsets.top;
                break;
            }
            case 3: {
                iWidth -= oInsets.right;
                break;
            }
            case 5: {
                iHeight -= oInsets.bottom;
                break;
            }
            case 7: {
                iWidth -= oInsets.left;
            }
        }
        return new Dimension(iWidth, iHeight);
    }

    private class PreferenceChangeHandler
    implements PreferenceChangeListener {
        private PreferenceChangeHandler() {
        }

        public void init(Preferences aoPreferences, Preferences aoDefaultPreferences) {
            aoPreferences.addPreferenceChangeListener(this);
        }

        public void preferenceChange(PreferenceChangeEvent aoEvent) {
            Preferences oPreferences = aoEvent.getNode();
            String sPath = oPreferences.absolutePath();
            String sKey = aoEvent.getKey();
            String sValue = aoEvent.getNewValue();
            if (oPreferences == ViewArea.this.moPreferences) {
                // empty if block
            }
        }
    }

    public class CloseWorkpaneAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent aoEvent) {
            ViewArea.this.closePane(ViewArea.this.getSelectedViewPane());
        }
    }

    public class OrientWestAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent aoEvent) {
            Log.write(6, "Organizer orientation set to: WEST");
            ViewArea.this.setOrientation(7);
        }
    }

    public class OrientSouthAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent aoEvent) {
            Log.write(6, "Organizer orientation set to: SOUTH");
            ViewArea.this.setOrientation(5);
        }
    }

    public class OrientEastAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent aoEvent) {
            Log.write(6, "Organizer orientation set to: EAST");
            ViewArea.this.setOrientation(3);
        }
    }

    public class OrientNorthAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent aoEvent) {
            Log.write(6, "Organizer orientation set to: NORTH");
            ViewArea.this.setOrientation(1);
        }
    }

    public class MoveWestEdgeAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent aoEvent) {
            ViewArea.this.moveWestEdge(ViewArea.this.getSelectedViewPane(), ViewArea.this.miOrientation == 7 ? ViewArea.this.miHeaderMovementSize : ViewArea.this.miDividerMovementSize);
        }
    }

    public class MoveSouthEdgeAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent aoEvent) {
            ViewArea.this.moveSouthEdge(ViewArea.this.getSelectedViewPane(), ViewArea.this.miOrientation == 5 ? ViewArea.this.miHeaderMovementSize : ViewArea.this.miDividerMovementSize);
        }
    }

    public class MoveEastEdgeAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent aoEvent) {
            ViewArea.this.moveEastEdge(ViewArea.this.getSelectedViewPane(), ViewArea.this.miOrientation == 3 ? ViewArea.this.miHeaderMovementSize : ViewArea.this.miDividerMovementSize);
        }
    }

    public class MoveNorthEdgeAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent aoEvent) {
            ViewArea.this.moveNorthEdge(ViewArea.this.getSelectedViewPane(), ViewArea.this.miOrientation == 1 ? ViewArea.this.miHeaderMovementSize : ViewArea.this.miDividerMovementSize);
        }
    }

    public class MergeWestAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent aoEvent) {
            ViewArea.this.mergeWest(ViewArea.this.getSelectedViewPane());
        }
    }

    public class MergeSouthAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent aoEvent) {
            ViewArea.this.mergeSouth(ViewArea.this.getSelectedViewPane());
        }
    }

    public class MergeEastAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent aoEvent) {
            ViewArea.this.mergeEast(ViewArea.this.getSelectedViewPane());
        }
    }

    public class MergeNorthAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent aoEvent) {
            ViewArea.this.mergeNorth(ViewArea.this.getSelectedViewPane());
        }
    }

    public class SplitHorizontalAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent aoEvent) {
            ViewArea.this.splitHorizontal(ViewArea.this.getSelectedViewPane());
        }
    }

    public class SplitVerticalAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent aoEvent) {
            ViewArea.this.splitVertical(ViewArea.this.getSelectedViewPane());
        }
    }

    public class DefaultViewPaneAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent aoEvent) {
            ViewArea.this.setDefaultViewPane(ViewArea.this.getSelectedViewPane());
        }
    }

    private class ViewPaneHandler
    extends ViewPaneAdapter {
        private ViewPaneHandler() {
        }

        public void paneResized(ViewPaneEvent aoEvent) {
            ViewPane oPane = aoEvent.getViewPane();
            int iIndex = ViewArea.this.mvViewPanes.indexOf(oPane);
            Preferences oPanePreferences = ViewArea.this.moPreferences.node("viewpane-" + iIndex);
            oPanePreferences.putDouble("x1", oPane.mdX1);
            oPanePreferences.putDouble("y1", oPane.mdY1);
            oPanePreferences.putDouble("x2", oPane.mdX2);
            oPanePreferences.putDouble("y2", oPane.mdY2);
        }
    }
}

