/*
 * Decompiled with CFR 0.152.
 */
package novaworx.viewarea;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;
import novaworx.viewarea.ViewArea;
import novaworx.viewarea.ViewHeader;
import novaworx.viewarea.ViewHeaderLayout;

public class DefaultViewHeader
extends ViewHeader {
    public DefaultViewHeader() {
        this.setLayout(new ViewHeaderLayout());
        this.setLookAndFeelValues();
    }

    public void updateUI() {
        this.setLookAndFeelValues();
        super.updateUI();
    }

    private void setLookAndFeelValues() {
        this.setBorder(new MatteBorder(1, 1, 1, 1, UIManager.getColor("controlDkShadow")));
    }

    public void paint(Graphics aoGraphics) {
        boolean bShowTitle;
        int iGap = this.getGap();
        Dimension oSize = this.getSize();
        Graphics2D oGraphics = (Graphics2D)aoGraphics;
        ViewArea oViewArea = this.moPane.getViewArea();
        if (!this.isVisible() || oSize.width == 0 || oSize.height == 0) {
            return;
        }
        int iViewOrientation = oViewArea.getOrientation();
        boolean iOrientation = iViewOrientation != 1 && iViewOrientation != 5;
        boolean bDefault = this.getViewPane() == oViewArea.getDefaultViewPane();
        boolean bSelected = this.getViewPane() == oViewArea.getSelectedViewPane();
        Color oForeground = oViewArea.getHeaderForeground();
        Color oBackground = oViewArea.getHeaderBackground();
        if (bSelected) {
            oForeground = oViewArea.getHeaderSelectedForeground();
            oBackground = oViewArea.getHeaderSelectedBackground();
        }
        oGraphics.setColor(oBackground);
        oGraphics.fillRect(0, 0, oSize.width, oSize.height);
        Font oCurrentFont = oViewArea.getFont();
        FontMetrics oCurrentMetrics = this.getFontMetrics(oCurrentFont);
        int iFontHeight = oCurrentMetrics.getAscent();
        String sTitle = this.getTitle();
        boolean bl = bShowTitle = iFontHeight >= oViewArea.getMinimumFontSize();
        if (sTitle != null && bShowTitle) {
            if (oViewArea.isAntiAliasText()) {
                oGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            oGraphics.setColor(oForeground);
            oGraphics.setFont(oCurrentFont);
            int iAscent = oCurrentMetrics.getAscent();
            if (!iOrientation) {
                double dOrigenX = ((double)oSize.height - (double)iGap) * 2.0 + (double)iGap;
                double dOrigenY = (double)oSize.height - (((double)oSize.height - (double)iAscent) / 2.0 + 2.0);
                double dAvailable = (double)oSize.width - dOrigenX - (((double)oSize.height - (double)iGap) * 3.0 + (double)iGap);
                sTitle = this.getTitle(sTitle, oCurrentMetrics, (int)dAvailable);
                double dLength = oCurrentMetrics.stringWidth(sTitle);
                while (sTitle.length() > 0 && dLength > dAvailable) {
                    sTitle = sTitle.substring(0, sTitle.length() - 1);
                    dLength = oCurrentMetrics.stringWidth(sTitle);
                }
                oGraphics.drawString(sTitle, (float)dOrigenX, (float)dOrigenY);
            } else {
                double dOrigenX = ((double)oSize.width - (double)iAscent) / 2.0 + 2.0;
                double dOrigenY = ((double)oSize.width - (double)iGap) * 2.0 + (double)iGap;
                double dAvailable = (double)oSize.height - dOrigenY - (((double)oSize.width - (double)iGap) * 3.0 + (double)iGap);
                sTitle = this.getTitle(sTitle, oCurrentMetrics, (int)dAvailable);
                double dLength = oCurrentMetrics.stringWidth(sTitle);
                while (sTitle.length() > 0 && dLength > dAvailable) {
                    sTitle = sTitle.substring(0, sTitle.length() - 1);
                    dLength = oCurrentMetrics.stringWidth(sTitle);
                }
                oGraphics.rotate(1.5707963267948966, dOrigenX, dOrigenY);
                oGraphics.drawString(sTitle, (float)dOrigenX, (float)dOrigenY);
                oGraphics.rotate(-1.5707963267948966, dOrigenX, dOrigenY);
            }
        }
        this.paintChildren(aoGraphics);
        this.paintBorder(aoGraphics);
    }

    protected String getTitle(String aoText, FontMetrics aoFontMetrics, int aiAvailableSpace) {
        if (aoText == null || aoText.equals("")) {
            return "";
        }
        int aoTextWidth = SwingUtilities.computeStringWidth(aoFontMetrics, aoText);
        String sClipString = "...";
        if (aoTextWidth > aiAvailableSpace) {
            int iCharacterIndex;
            int iTotalWidth = SwingUtilities.computeStringWidth(aoFontMetrics, sClipString);
            for (iCharacterIndex = 0; iCharacterIndex < aoText.length() && (iTotalWidth += aoFontMetrics.charWidth(aoText.charAt(iCharacterIndex))) <= aiAvailableSpace; ++iCharacterIndex) {
            }
            aoText = aoText.substring(0, iCharacterIndex) + sClipString;
        }
        return aoText;
    }
}

