/*
 * Decompiled with CFR 0.152.
 */
package novaworx.view.workspace;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import novaworx.PreferenceEngine;
import novaworx.ResourceEngine;
import novaworx.WorkView;
import novaworx.WorkViewException;
import novaworx.Workspace;
import novaworx.bus.Message;
import novaworx.bus.MessageBus;
import novaworx.bus.MessageListener;
import novaworx.data.DataNode;
import novaworx.data.Node;
import novaworx.data.NodeEvent;
import novaworx.data.NodeListModel;
import novaworx.data.NodeListener;
import novaworx.data.ViewNode;
import novaworx.gui.ActionLibrary;
import novaworx.gui.IconCache;
import novaworx.gui.ProgramAction;
import novaworx.gui.ProgramListCellRenderer;
import novaworx.log.Log;
import novaworx.message.RequestResourceClose;
import novaworx.message.RequestResourceSave;
import novaworx.message.ResourceClose;
import novaworx.message.ResourceSelect;
import novaworx.message.ResourceUnselect;
import novaworx.resource.Resource;
import novaworx.swing.XColor;
import novaworx.swing.XList;
import novaworx.viewarea.ViewPaneAdapter;
import novaworx.viewarea.ViewPaneEvent;

public class WorkspaceManager
extends WorkView {
    private JList moList;
    private int miLastIndex = -1;
    private Workspace moWorkspace;
    private MessageHandler moMessageHandler;
    private ViewPaneHandler moViewPaneHandler;
    private SelectionHandler moSelectionHandler;
    private SaveActionHandler moSaveActionHandler;
    private SaveAllActionHandler moSaveAllActionHandler;
    private CloseActionHandler moCloseActionHandler;
    private CloseAllActionHandler moCloseAllActionHandler;
    private NodeListModel moEmptyModel = new NodeListModel(new DataNode());
    protected PreferenceChangeHandler moPreferenceChangeHandler;
    static /* synthetic */ Class class$novaworx$message$ResourceSelect;
    static /* synthetic */ Class class$novaworx$message$ResourceUnselect;
    static /* synthetic */ Class class$novaworx$message$ResourceClose;
    static /* synthetic */ Class class$novaworx$message$WorkspaceSelect;
    static /* synthetic */ Class class$novaworx$message$WorkspaceUnselect;

    public WorkspaceManager() {
        this.moSaveAllActionHandler = new SaveAllActionHandler();
        this.moCloseActionHandler = new CloseActionHandler();
        this.moCloseAllActionHandler = new CloseAllActionHandler();
        this.moViewPaneHandler = new ViewPaneHandler();
        this.moPreferenceChangeHandler = new PreferenceChangeHandler();
        this.moList = new XList();
        ProgramListCellRenderer oRenderer = new ProgramListCellRenderer();
        this.moList.setCellRenderer(oRenderer);
        JScrollPane oScroller = new JScrollPane(this.moList);
        oScroller.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setOpaque(false);
        this.moList.setOpaque(false);
        oScroller.setOpaque(false);
        oScroller.getViewport().setOpaque(false);
        this.moSelectionHandler = new SelectionHandler();
        this.moList.addListSelectionListener(this.moSelectionHandler);
        this.setLayout(new BorderLayout());
        this.add((Component)oScroller, "Center");
        this.setIcon(IconCache.getIcon("workspace"));
        this.setTitle("Workspace");
        this.moMessageHandler = new MessageHandler();
        MessageBus.registerListener(this.moMessageHandler, class$novaworx$message$ResourceSelect == null ? (class$novaworx$message$ResourceSelect = WorkspaceManager.class$("novaworx.message.ResourceSelect")) : class$novaworx$message$ResourceSelect);
        MessageBus.registerListener(this.moMessageHandler, class$novaworx$message$ResourceUnselect == null ? (class$novaworx$message$ResourceUnselect = WorkspaceManager.class$("novaworx.message.ResourceUnselect")) : class$novaworx$message$ResourceUnselect);
        MessageBus.registerListener(this.moMessageHandler, class$novaworx$message$ResourceClose == null ? (class$novaworx$message$ResourceClose = WorkspaceManager.class$("novaworx.message.ResourceClose")) : class$novaworx$message$ResourceClose);
        MessageBus.registerListener(this.moMessageHandler, class$novaworx$message$WorkspaceSelect == null ? (class$novaworx$message$WorkspaceSelect = WorkspaceManager.class$("novaworx.message.WorkspaceSelect")) : class$novaworx$message$WorkspaceSelect);
        MessageBus.registerListener(this.moMessageHandler, class$novaworx$message$WorkspaceUnselect == null ? (class$novaworx$message$WorkspaceUnselect = WorkspaceManager.class$("novaworx.message.WorkspaceUnselect")) : class$novaworx$message$WorkspaceUnselect);
        this.moPreferenceChangeHandler.init();
    }

    public void setWorkspace(Workspace aoWorkspace) {
        this.moWorkspace = aoWorkspace;
        this.moList.setModel(aoWorkspace == null ? this.moEmptyModel : new NodeListModel(aoWorkspace));
    }

    public Workspace getWorkspace() {
        return this.moWorkspace;
    }

    public void allocate() {
        this.setWorkspace(ResourceEngine.get().getDefaultWorkspace());
    }

    public void display() throws WorkViewException {
        this.getWorkPane().addViewPaneListener(this.moViewPaneHandler);
    }

    public void select() throws WorkViewException {
    }

    public void unselect() throws WorkViewException {
    }

    public void conceal() throws WorkViewException {
        this.getWorkPane().removeViewPaneListener(this.moViewPaneHandler);
    }

    public void selectResource(Resource aoResource) {
        int iIndex = -1;
        Node oNode = ((NodeListModel)this.moList.getModel()).getNode();
        iIndex = oNode.getIndex(aoResource);
        if (iIndex >= 0) {
            this.moList.setSelectedIndex(iIndex);
            this.miLastIndex = iIndex;
        }
        ((ProgramAction)ActionLibrary.get("save")).setEnabled(iIndex >= 0 && aoResource.isModified());
        ((ProgramAction)ActionLibrary.get("close")).setEnabled(iIndex >= 0);
    }

    private int selectNextResource() {
        int iNewIndex = -1;
        int iSize = this.moList.getModel().getSize();
        if (iSize > 0) {
            iNewIndex = this.miLastIndex < 0 ? 0 : (this.miLastIndex < iSize ? this.miLastIndex : iSize - 1);
            this.moList.setSelectedIndex(iNewIndex);
        }
        ((ProgramAction)ActionLibrary.get("close.all")).setEnabled(this.moList.getModel().getSize() > 0);
        return iNewIndex;
    }

    private Resource[] getSelectedResources() {
        int[] aIndices = this.moList.getSelectedIndices();
        Resource[] aResources = new Resource[aIndices.length];
        for (int iIndex = 0; iIndex < aIndices.length; ++iIndex) {
            Object oObject = this.moList.getModel().getElementAt(aIndices[iIndex]);
            while (oObject instanceof ViewNode) {
                oObject = ((ViewNode)oObject).getNode();
            }
            aResources[iIndex] = (Resource)oObject;
        }
        return aResources;
    }

    private Resource[] getAllResources() {
        int iCount = this.moList.getModel().getSize();
        Resource[] aResources = new Resource[iCount];
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            Object oObject = this.moList.getModel().getElementAt(iIndex);
            while (oObject instanceof ViewNode) {
                oObject = ((ViewNode)oObject).getNode();
            }
            aResources[iIndex] = (Resource)oObject;
        }
        return aResources;
    }

    public void saveSelectedResources() {
        MessageBus.send(new RequestResourceSave((Object)this, this.getSelectedResources()));
    }

    public void saveAllResources() {
        MessageBus.send(new RequestResourceSave((Object)this, this.getAllResources()));
    }

    public void closeSelectedResources() {
        MessageBus.send(new RequestResourceClose((Object)this, this.getSelectedResources()));
    }

    public void closeAllResources() {
        MessageBus.send(new RequestResourceClose((Object)this, this.getAllResources()));
    }

    public boolean requestFocusInWindow() {
        return this.moList.requestFocusInWindow();
    }

    public void setForeground(Color aoColor) {
        super.setForeground(aoColor);
        this.moList.setForeground(aoColor);
    }

    public void setBackground(Color aoColor) {
        super.setBackground(aoColor);
    }

    public void addFocusListener(FocusListener aoListener) {
        if (this.moList != null) {
            this.moList.addFocusListener(aoListener);
        }
    }

    public void removeFocusListener(FocusListener aoListener) {
        if (this.moList != null) {
            this.moList.removeFocusListener(aoListener);
        }
    }

    public void setDropTarget(DropTarget aoDropTarget) {
        this.moList.setDropTarget(aoDropTarget);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class PreferenceChangeHandler
    implements PreferenceChangeListener {
        private Preferences moWorkareaPreferences = PreferenceEngine.get().getPreferences("/program/workarea");

        public PreferenceChangeHandler() {
            this.moWorkareaPreferences.addPreferenceChangeListener(this);
        }

        public void init() {
            PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "default", this);
            PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "highlight", this);
            PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "selection", this);
            PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "textfield", this);
            PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "caret", this);
        }

        public void preferenceChange(PreferenceChangeEvent aoEvent) {
            Preferences oPreferences = aoEvent.getNode();
            String sPath = oPreferences.absolutePath();
            String sKey = aoEvent.getKey();
            String sValue = aoEvent.getNewValue();
            if (oPreferences == this.moWorkareaPreferences) {
                if ("default".equals(sKey)) {
                    WorkspaceManager.this.setForeground(XColor.decodeForeground(sValue));
                    WorkspaceManager.this.setBackground(XColor.decodeBackground(sValue));
                } else if (!"highlight".equals(sKey) && !"textfield".equals(sKey)) {
                    if ("selection".equals(sKey)) {
                        WorkspaceManager.this.moList.setSelectionForeground(XColor.decodeForeground(sValue));
                        WorkspaceManager.this.moList.setSelectionBackground(XColor.decodeBackground(sValue));
                    } else if ("caret".equals(sKey)) {
                        // empty if block
                    }
                }
                WorkspaceManager.this.repaint();
            }
        }
    }

    private class SelectNextResource
    implements Runnable {
        public SelectNextResource() {
            EventQueue.invokeLater(this);
        }

        public void run() {
            WorkspaceManager.this.selectNextResource();
        }
    }

    private class ClearSelection
    implements Runnable {
        private boolean mbSendMessages;

        public ClearSelection() {
            this(true);
        }

        public ClearSelection(boolean abSendMessages) {
            this.mbSendMessages = abSendMessages;
            EventQueue.invokeLater(this);
        }

        public void run() {
            if (!this.mbSendMessages) {
                WorkspaceManager.this.moList.removeListSelectionListener(WorkspaceManager.this.moSelectionHandler);
            }
            WorkspaceManager.this.moList.clearSelection();
            if (!this.mbSendMessages) {
                WorkspaceManager.this.moList.addListSelectionListener(WorkspaceManager.this.moSelectionHandler);
            }
        }
    }

    private class SelectResource
    implements Runnable {
        private Resource moResource;
        private boolean mbSendMessages;

        public SelectResource(Resource aoResource) {
            this(aoResource, true);
        }

        public SelectResource(Resource aoResource, boolean abSendMessages) {
            this.moResource = aoResource;
            this.mbSendMessages = abSendMessages;
            EventQueue.invokeLater(this);
        }

        public void run() {
            if (!this.mbSendMessages) {
                WorkspaceManager.this.moList.removeListSelectionListener(WorkspaceManager.this.moSelectionHandler);
            }
            WorkspaceManager.this.selectResource(this.moResource);
            if (!this.mbSendMessages) {
                WorkspaceManager.this.moList.addListSelectionListener(WorkspaceManager.this.moSelectionHandler);
            }
        }
    }

    private class MessageHandler
    implements MessageListener {
        private MessageHandler() {
        }

        public void messageReceived(Message aoMessage) {
            if (aoMessage instanceof ResourceSelect) {
                if (aoMessage.getSource() == WorkspaceManager.this) {
                    return;
                }
                new SelectResource(((ResourceSelect)aoMessage).getResource(), false);
            } else if (aoMessage instanceof ResourceUnselect) {
                if (aoMessage.getSource() == WorkspaceManager.this) {
                    return;
                }
                new ClearSelection(false);
            } else if (aoMessage instanceof ResourceClose) {
                if (aoMessage.getSource() == WorkspaceManager.this) {
                    return;
                }
                new SelectNextResource();
            }
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private Resource moPreviousResource;

        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent aoEvent) {
            if (aoEvent.getValueIsAdjusting()) {
                return;
            }
            JList oList = (JList)aoEvent.getSource();
            int iIndex = oList.getSelectedIndex();
            Resource oResource = null;
            if (iIndex >= 0) {
                oResource = (Resource)((Node)oList.getModel().getElementAt(iIndex)).getRealNode();
            }
            if (oResource == this.moPreviousResource) {
                return;
            }
            if (this.moPreviousResource != null) {
                Log.write(6, "Unselecting: " + this.moPreviousResource.getName());
                MessageBus.send(new ResourceUnselect((Object)WorkspaceManager.this, this.moPreviousResource));
            }
            if (oResource == null) {
                WorkspaceManager.this.miLastIndex = -1;
            } else {
                WorkspaceManager.this.miLastIndex = iIndex;
                Log.write(6, "Selecting: " + oResource.getName());
                MessageBus.send(new ResourceSelect((Object)WorkspaceManager.this, oResource));
                this.moPreviousResource = oResource;
            }
            ((ProgramAction)ActionLibrary.get("close")).setEnabled(iIndex >= 0);
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mousePressed(MouseEvent aoEvent) {
            Point oPoint = aoEvent.getPoint();
            int iIndex = WorkspaceManager.this.moList.locationToIndex(oPoint);
            int iSelectedIndex = WorkspaceManager.this.moList.getSelectedIndex();
            if (iIndex >= 0 && iIndex == iSelectedIndex) {
                Object oObject = WorkspaceManager.this.moList.getModel().getElementAt(iIndex);
                while (oObject instanceof ViewNode) {
                    oObject = ((ViewNode)oObject).getNode();
                }
                if (oObject == null) {
                    return;
                }
                Resource oResource = (Resource)oObject;
                MessageBus.send(new ResourceSelect((Object)WorkspaceManager.this, oResource));
            }
        }
    }

    public class ViewPaneHandler
    extends ViewPaneAdapter {
        public void paneClosed(ViewPaneEvent aoEvent) {
            WorkspaceManager.this.closeSelectedResources();
        }
    }

    private class WorkspaceHandler
    implements NodeListener {
        private WorkspaceHandler() {
        }

        public void nodeEventOccurred(NodeEvent aoEvent) {
            int iEventType = aoEvent.getType();
            switch (iEventType) {
                default: 
            }
        }
    }

    private class CloseAllActionHandler
    implements ActionListener {
        private CloseAllActionHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            WorkspaceManager.this.closeAllResources();
        }
    }

    private class CloseActionHandler
    implements ActionListener {
        private CloseActionHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            WorkspaceManager.this.closeSelectedResources();
        }
    }

    private class SaveAllActionHandler
    implements ActionListener {
        private SaveAllActionHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            WorkspaceManager.this.saveAllResources();
        }
    }

    private class SaveActionHandler
    implements ActionListener {
        private SaveActionHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            WorkspaceManager.this.saveSelectedResources();
        }
    }

    private class ShowAction
    extends AbstractAction {
        private ShowAction() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
        }
    }
}

