/*
 * Decompiled with CFR 0.152.
 */
package novaworx.view.terminal;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import novaworx.GuiEngine;
import novaworx.PreferenceEngine;
import novaworx.WorkArea;
import novaworx.WorkFrame;
import novaworx.WorkPane;
import novaworx.WorkView;
import novaworx.WorkViewException;
import novaworx.bus.Message;
import novaworx.bus.MessageBus;
import novaworx.bus.MessageListener;
import novaworx.gui.IconCache;
import novaworx.swing.XColor;
import novaworx.view.terminal.ProcessShell;
import novaworx.view.terminal.Terminal;
import novaworx.view.terminal.VDU;
import novaworx.viewarea.ViewPaneAdapter;
import novaworx.viewarea.ViewPaneEvent;

public class TerminalView
extends WorkView {
    private VDU moDisplay;
    private JViewport moViewport;
    private ViewPaneHandler moViewPaneHandler;
    private MessageHandler moMessageHandler;
    private ShowActionHandler moShowActionHandler;
    protected PreferenceChangeHandler moPreferenceChangeHandler = new PreferenceChangeHandler();
    static /* synthetic */ Class class$novaworx$message$ProgramStart;

    public TerminalView() {
        this.moViewPaneHandler = new ViewPaneHandler();
        this.moShowActionHandler = new ShowActionHandler();
        this.setIcon(IconCache.getIcon("terminal"));
        this.setTitle("Terminal");
        this.setBackground(XColor.CLEAR);
        Terminal oTerminal = new Terminal();
        this.moDisplay = oTerminal.getDisplay();
        JScrollBar oScrollBar = new JScrollBar(1);
        this.moDisplay.setScrollbar(oScrollBar);
        oTerminal.setShell(new ProcessShell());
        this.setLayout(new BorderLayout());
        this.add((Component)this.moDisplay, "Center");
        this.add((Component)oScrollBar, "East");
        this.moPreferenceChangeHandler.init();
    }

    public void allocate() throws WorkViewException {
    }

    public void display() throws WorkViewException {
        this.getWorkPane().addViewPaneListener(this.moViewPaneHandler);
        this.repaint();
    }

    public void conceal() throws WorkViewException {
        this.getWorkPane().removeViewPaneListener(this.moViewPaneHandler);
    }

    public void select() throws WorkViewException {
        if (this.moDisplay != null) {
            this.moDisplay.requestFocus();
        }
    }

    public void unselect() throws WorkViewException {
    }

    public void deallocate() throws WorkViewException {
    }

    public void setForeground(Color aoColor) {
        super.setForeground(aoColor);
        if (this.moDisplay != null) {
            this.moDisplay.setForeground(aoColor);
        }
    }

    public void setBackground(Color aoColor) {
        super.setBackground(aoColor);
    }

    public void setDropTarget(DropTarget aoDropTarget) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ClassMessageHandler oMessageHandler = new ClassMessageHandler();
        MessageBus.registerListener(oMessageHandler, class$novaworx$message$ProgramStart == null ? (class$novaworx$message$ProgramStart = TerminalView.class$("novaworx.message.ProgramStart")) : class$novaworx$message$ProgramStart);
    }

    protected class PreferenceChangeHandler
    implements PreferenceChangeListener {
        private Preferences moWorkareaPreferences = PreferenceEngine.get().getPreferences("/program/workarea");

        public PreferenceChangeHandler() {
            this.moWorkareaPreferences.addPreferenceChangeListener(this);
        }

        public void init() {
            PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "default", this);
        }

        public void preferenceChange(PreferenceChangeEvent aoEvent) {
            Preferences oPreferences = aoEvent.getNode();
            String sPath = oPreferences.absolutePath();
            String sKey = aoEvent.getKey();
            String sValue = aoEvent.getNewValue();
            if (oPreferences == this.moWorkareaPreferences && "default".equals(sKey)) {
                TerminalView.this.setForeground(XColor.decodeForeground(sValue));
                TerminalView.this.setBackground(XColor.decodeBackground(sValue));
            }
        }
    }

    private static class ClassMessageHandler
    implements MessageListener {
        private ClassMessageHandler() {
        }

        public void messageReceived(Message aoMessage) {
        }
    }

    private class MessageHandler
    implements MessageListener {
        private MessageHandler() {
        }

        public void messageReceived(Message aoMessage) {
        }
    }

    private class ViewPaneHandler
    extends ViewPaneAdapter {
        private ViewPaneHandler() {
        }

        public void paneClosed(ViewPaneEvent aoEvent) {
        }
    }

    private class ShowActionHandler
    extends AbstractAction {
        private ShowActionHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            WorkFrame oWorkFrame = GuiEngine.get().getSelectedWorkFrame();
            WorkArea oWorkArea = oWorkFrame.getSelectedWorkArea();
            WorkPane oWorkPane = oWorkArea.getSelectedWorkPane();
            oWorkPane.push(TerminalView.this);
            TerminalView.this.requestFocusInWindow();
        }
    }
}

