/*
 * Decompiled with CFR 0.152.
 */
package novaworx.view.terminal;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.util.Hashtable;
import novaworx.log.Log;
import novaworx.util.thread.Worker;
import novaworx.view.terminal.Shell;
import novaworx.view.terminal.VDU;
import novaworx.view.terminal.vt320;

public class Terminal
extends Worker
implements ClipboardOwner,
Runnable {
    private Shell moShell;
    private static final boolean personalJava = false;
    private static final int debug = 0;
    protected String id = "terminal";
    protected vt320 terminal;
    protected String encoding = "latin1";
    protected Menu menu;
    private Hashtable colors = new Hashtable();
    private boolean localecho_overridden = false;

    public Terminal() {
        this.colors.put("default", Color.GRAY);
        this.colors.put("black", Color.black);
        this.colors.put("red", Color.red);
        this.colors.put("green", Color.green);
        this.colors.put("yellow", Color.yellow);
        this.colors.put("blue", Color.blue);
        this.colors.put("magenta", Color.magenta);
        this.colors.put("orange", Color.orange);
        this.colors.put("pink", Color.pink);
        this.colors.put("cyan", Color.cyan);
        this.colors.put("white", Color.white);
        this.colors.put("gray", Color.gray);
        this.colors.put("darkgray", Color.darkGray);
        this.terminal = new vt320(){

            public void write(byte[] b) {
                try {
                    Terminal.this.write(b);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            public void beep() {
                Toolkit.getDefaultToolkit().beep();
            }

            public void sendTelnetCommand(byte cmd) {
            }
        };
        this.terminal.setLocalEcho(true);
        this.terminal.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent evt) {
                Terminal.this.terminal.setCursor(Cursor.getPredefinedCursor(2));
            }

            public void focusLost(FocusEvent evt) {
                Terminal.this.terminal.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.start();
    }

    public VDU getDisplay() {
        return this.terminal;
    }

    private Color codeToColor(String code) {
        Log.write(new Throwable("Color code: " + code));
        if (this.colors.get(code) != null) {
            return (Color)this.colors.get(code);
        }
        try {
            if (Color.getColor(code) != null) {
                return Color.getColor(code);
            }
            return Color.decode(code);
        }
        catch (Exception e) {
            this.error("ignoring unknown color code: " + code);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        byte[] b = new byte[256];
        int n = 0;
        while (n >= 0 && this.isExecuting()) {
            Terminal terminal = this;
            synchronized (terminal) {
                while (this.moShell == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException aoException) {
                        Log.write(aoException);
                        return;
                    }
                }
            }
            try {
                n = this.read(b);
                if (n > 0) {
                    this.terminal.putString(new String(b, 0, n, this.encoding));
                }
                this.terminal.repaint();
            }
            catch (IOException e) {
                break;
            }
        }
    }

    public synchronized void setShell(Shell aoShell) {
        this.moShell = aoShell;
        this.notifyAll();
    }

    public int read(byte[] aaBuffer) throws IOException {
        int iLength = 0;
        iLength = this.moShell == null ? 0 : this.moShell.read(aaBuffer);
        return iLength;
    }

    public void write(byte[] aaBuffer) throws IOException {
        if (this.moShell != null) {
            this.moShell.write(aaBuffer);
        }
    }

    public void copy(Clipboard clipboard) {
        String data = this.terminal.getSelection();
        if (data == null) {
            return;
        }
        StringSelection selection = new StringSelection(data);
        clipboard.setContents(selection, this);
    }

    public void paste(Clipboard clipboard) {
        if (clipboard == null) {
            return;
        }
        Transferable t = clipboard.getContents(this);
        try {
            byte[] buffer = ((String)t.getTransferData(DataFlavor.stringFlavor)).getBytes();
            try {
                this.write(buffer);
            }
            catch (IOException e) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        this.terminal.clearSelection();
    }

    public void print(Graphics g) {
        this.terminal.print(g);
    }

    public void error(String msg) {
        String name = this.getClass().toString();
        name = name.substring(name.lastIndexOf(46) + 1);
        System.err.println(name + (this.id != null ? "(" + this.id + ")" : "") + ": " + msg);
    }
}

