/*
 * Decompiled with CFR 0.152.
 */
package novaworx.view.terminal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import novaworx.log.Log;
import novaworx.util.InputStreamPump;
import novaworx.util.thread.Worker;
import novaworx.view.terminal.Shell;

public class ProcessShell
implements Shell {
    private String msCommand;
    private ProcessStarter moProcessStarter;
    private Process moProcess;
    private InputStream moInputStream;
    private OutputStream moOutputStream;

    public ProcessShell() {
        this("bash -li");
    }

    public ProcessShell(String asCommand) {
        this.msCommand = asCommand;
        this.moProcessStarter = new ProcessStarter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] aaBuffer) throws IOException {
        ProcessStarter processStarter = this.moProcessStarter;
        synchronized (processStarter) {
            try {
                while (this.moProcess == null) {
                    this.moProcessStarter.wait();
                }
            }
            catch (InterruptedException aoException) {
                return -1;
            }
        }
        return this.moInputStream.read(aaBuffer);
    }

    public void write(byte[] aaBuffer) throws IOException {
        if (this.moOutputStream != null) {
            this.moOutputStream.write(aaBuffer);
            this.moOutputStream.flush();
        }
    }

    private class CombinedInputStream
    extends InputStream {
        private InputStream moStreamOne;
        private InputStream moStreamTwo;
        private InputStream moInputStream;

        public CombinedInputStream(InputStream aoStreamOne, InputStream aoStreamTwo) throws IOException {
            this.moStreamOne = aoStreamOne;
            this.moStreamTwo = aoStreamTwo;
            PipedOutputStream oPipedOutputStream = new PipedOutputStream();
            this.moInputStream = new PipedInputStream(oPipedOutputStream);
            new InputStreamPump(aoStreamOne, oPipedOutputStream).start();
            new InputStreamPump(aoStreamTwo, oPipedOutputStream).start();
        }

        public int available() throws IOException {
            return this.moInputStream.available();
        }

        public void close() throws IOException {
            IOException oExceptionOne = null;
            IOException oExceptionTwo = null;
            try {
                this.moInputStream.close();
            }
            catch (IOException aoException) {
                Log.write(aoException);
            }
            try {
                this.moStreamOne.close();
            }
            catch (IOException aoException) {
                oExceptionOne = aoException;
            }
            try {
                this.moStreamTwo.close();
            }
            catch (IOException aoException) {
                oExceptionTwo = aoException;
            }
            if (oExceptionOne != null & oExceptionTwo != null) {
                throw new IOException("Failure closing both streams:\n  Stream One: " + oExceptionOne.getMessage() + "\n  Stream Two: " + oExceptionTwo.getMessage());
            }
            if (oExceptionOne != null & oExceptionTwo == null) {
                throw oExceptionOne;
            }
            if (oExceptionOne == null & oExceptionTwo != null) {
                throw oExceptionTwo;
            }
        }

        public boolean markSupported() {
            return false;
        }

        public int read() throws IOException {
            return this.moInputStream.read();
        }

        public int read(byte[] aaBuffer) throws IOException {
            return this.moInputStream.read(aaBuffer);
        }

        public int read(byte[] aaBuffer, int aiOffset, int aiLength) throws IOException {
            return this.moInputStream.read(aaBuffer, aiOffset, aiLength);
        }

        public long skip(long aiLength) throws IOException {
            return this.moInputStream.skip(aiLength);
        }
    }

    private class ProcessStarter
    extends Worker {
        public ProcessStarter() {
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Log.write(6, "Starting new shell process...");
            try {
                ProcessShell.this.moProcess = Runtime.getRuntime().exec(ProcessShell.this.msCommand);
                ProcessShell.this.moInputStream = new CombinedInputStream(ProcessShell.this.moProcess.getInputStream(), ProcessShell.this.moProcess.getErrorStream());
                ProcessShell.this.moOutputStream = ProcessShell.this.moProcess.getOutputStream();
                ProcessStarter processStarter = this;
                synchronized (processStarter) {
                    this.notifyAll();
                }
            }
            catch (IOException aoException) {
                Log.write(aoException);
            }
            Log.write(6, "New shell process started.");
            try {
                ProcessShell.this.moProcess.waitFor();
            }
            catch (InterruptedException aoException) {
                return;
            }
            Log.write("Process terminated with exit code: " + ProcessShell.this.moProcess.exitValue());
        }
    }
}

