/*
 * Decompiled with CFR 0.152.
 */
package novaworx.view.terminal;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import novaworx.view.terminal.DisplayLine;
import novaworx.view.terminal.DisplayModelEvent;
import novaworx.view.terminal.DisplayModelListener;

public class DisplayModel {
    private int miBufferSize;
    private LinkedList moLines;
    private List moDisplayModelListeners;

    DisplayModel() {
        this(50);
    }

    DisplayModel(int aiBufferSize) {
        this.miBufferSize = aiBufferSize;
        this.moLines = new LinkedList();
        this.ensureBufferSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayLine[] getLines() {
        LinkedList linkedList = this.moLines;
        synchronized (linkedList) {
            DisplayLine[] aLines = new DisplayLine[this.moLines.size()];
            return this.moLines.toArray(aLines);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBufferSize(int aiBufferSize) {
        LinkedList linkedList = this.moLines;
        synchronized (linkedList) {
            this.miBufferSize = aiBufferSize;
            this.ensureBufferSize();
        }
    }

    public int getBufferSize() {
        return this.miBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertLine(DisplayLine aoLine) {
        LinkedList linkedList = this.moLines;
        synchronized (linkedList) {
            this.moLines.addFirst(aoLine);
            this.ensureBufferSize();
            this.fireModified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLine() {
        LinkedList linkedList = this.moLines;
        synchronized (linkedList) {
            this.moLines.removeFirst();
            this.fireModified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureBufferSize() {
        LinkedList linkedList = this.moLines;
        synchronized (linkedList) {
            if (this.miBufferSize < this.moLines.size()) {
                int iDelta = this.moLines.size() - this.miBufferSize;
                for (int iIndex = 0; iIndex < iDelta; ++iIndex) {
                    this.moLines.removeLast();
                }
            } else if (this.miBufferSize > this.moLines.size()) {
                int iDelta = this.miBufferSize - this.moLines.size();
                for (int iIndex = 0; iIndex < iDelta; ++iIndex) {
                    this.moLines.addLast(new DisplayLine());
                }
            }
        }
    }

    public void addDisplayModelListener(DisplayModelListener aoListener) {
        if (this.moDisplayModelListeners == null) {
            this.moDisplayModelListeners = new Vector();
        }
        this.moDisplayModelListeners.add(aoListener);
    }

    public void removeDisplayModelListener(DisplayModelListener aoListener) {
        if (this.moDisplayModelListeners == null) {
            return;
        }
        this.moDisplayModelListeners.remove(aoListener);
    }

    protected void fireModified() {
        this.fireModified(0, this.moLines.size());
    }

    protected void fireModified(int aiLowerLine, int aiUpperLine) {
        DisplayModelEvent oEvent = new DisplayModelEvent(this, aiLowerLine, aiUpperLine);
        List oListeners = Collections.unmodifiableList(this.moDisplayModelListeners);
        int iCount = oListeners.size();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            ((DisplayModelListener)oListeners.get(iIndex)).modified(oEvent);
        }
    }
}

