/*
 * Decompiled with CFR 0.152.
 */
package novaworx.view.terminal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import novaworx.swing.XColor;
import novaworx.view.terminal.DisplayCell;
import novaworx.view.terminal.DisplayLine;
import novaworx.view.terminal.DisplayModel;
import novaworx.view.terminal.DisplayModelEvent;
import novaworx.view.terminal.DisplayModelListener;
import novaworx.view.terminal.Emulator;
import novaworx.view.terminal.JavaShell;
import novaworx.view.terminal.Shell;

public class Display
extends JComponent
implements Scrollable {
    private int miColumns;
    private int miRows;
    private double mdColumnWidth;
    private int miRowHeight;
    private double mdFontScale;
    private InputLine moInputLine;
    private Shell moShell;
    private Emulator moEmulator;
    private DisplayModel moDisplayModel;
    private DisplayModelHandler moDisplayModelHandler;
    private int miPreviousWidth;

    public Display() {
        this(80, 50);
    }

    public Display(int aiColumns, int aiRows) {
        this(aiColumns, aiRows, new JavaShell());
    }

    public Display(int aiColumns, int aiRows, Shell aoShell) {
        this(aiColumns, aiRows, aoShell, null);
    }

    public Display(int aiColumns, int aiRows, Shell aoShell, Emulator aoEmulator) {
        this.moShell = aoShell;
        this.miColumns = aiColumns;
        this.miRows = aiRows;
        this.moInputLine = new InputLine();
        this.moDisplayModelHandler = new DisplayModelHandler();
        this.setDisplayModel(new DisplayModel(aiRows));
        this.moEmulator = aoEmulator;
        this.setOpaque(false);
        this.setForeground(Color.BLACK);
        this.setBackground(XColor.SEMI_WHITE);
        this.setFont(new Font("monospaced", 0, 1));
    }

    public void setFont(Font aoFont) {
        super.setFont(aoFont.deriveFont(1.0f));
    }

    public void setSize(Dimension aoSize) {
        int iWidth = aoSize.width;
        int iHeight = aoSize.height;
        if (iWidth == this.miPreviousWidth) {
            return;
        }
        this.miPreviousWidth = iWidth;
        Font oFont = this.getFont();
        Graphics oGraphics = this.getGraphics();
        FontMetrics oFontMetrics = this.getFontMetrics(oFont);
        Rectangle2D oLineBounds = oFontMetrics.getStringBounds("0", oGraphics);
        LineMetrics oLineMetrics = oFontMetrics.getLineMetrics("0", oGraphics);
        this.mdColumnWidth = (double)iWidth / (double)this.miColumns;
        this.mdFontScale = this.mdColumnWidth / oLineBounds.getWidth();
        this.miRowHeight = (int)(oLineBounds.getHeight() * this.mdFontScale);
        int iPreferredHeight = this.miRows * this.miRowHeight;
        this.moInputLine.setBounds(new Rectangle(0, iPreferredHeight - this.miRowHeight, iWidth, this.miRowHeight));
        super.setPreferredSize(new Dimension(iWidth, iPreferredHeight));
        super.setSize(new Dimension(iWidth, iPreferredHeight));
    }

    public void setDisplayModel(DisplayModel aoDisplayModel) {
        if (this.moDisplayModel != null) {
            this.moDisplayModel.removeDisplayModelListener(this.moDisplayModelHandler);
        }
        this.moDisplayModel = aoDisplayModel;
        if (this.moDisplayModel != null) {
            this.moDisplayModel.addDisplayModelListener(this.moDisplayModelHandler);
        }
    }

    public DisplayModel getDisplayModel() {
        return this.moDisplayModel;
    }

    public void setColumnCount(int aiColumns) {
        this.miColumns = aiColumns;
    }

    public int getColumnCount() {
        return this.miColumns;
    }

    public void setRowCount(int aiRows) {
        this.miRows = aiRows;
    }

    public int getRowCount() {
        return this.miRows;
    }

    public int getLineIndex(Point aoPoint) {
        int iIndex = this.getRowCount() - 1 - aoPoint.y / this.miRowHeight;
        if (iIndex < 0) {
            iIndex = 0;
        }
        return iIndex;
    }

    public int getLineIndex(int aiX, int aiY) {
        return this.getLineIndex(new Point(aiX, aiY));
    }

    public void showLine(int aiLineIndex) {
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public int getScrollableUnitIncrement(Rectangle aoVisibleArea, int aiOrientation, int aiDirection) {
        return this.miRowHeight;
    }

    public int getScrollableBlockIncrement(Rectangle aoVisibleArea, int aiOrientation, int aiDirection) {
        return aoVisibleArea.height;
    }

    public void paint(Graphics aoGraphics) {
        Graphics2D oGraphics = (Graphics2D)aoGraphics;
        oGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        oGraphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        oGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        oGraphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        Dimension oSize = this.getSize();
        int iWidth = oSize.width;
        int iHeight = oSize.height;
        oGraphics.setColor(this.getBackground());
        oGraphics.fillRect(0, 0, iWidth, iHeight);
        float fColumnWidth = (float)iWidth / (float)this.miColumns;
        Rectangle oClipBounds = oGraphics.getClipBounds();
        int iUpperLine = this.getLineIndex(oClipBounds.x, oClipBounds.y);
        int iLowerLine = this.getLineIndex(oClipBounds.x, oClipBounds.y + oClipBounds.height);
        DisplayLine[] aRows = this.moDisplayModel.getLines();
        if (iUpperLine > aRows.length) {
            iUpperLine = aRows.length;
        }
        if (iLowerLine > aRows.length) {
            iLowerLine = aRows.length;
        }
        for (int iIndex = iLowerLine; iIndex <= iUpperLine; ++iIndex) {
            this.paintLine(oGraphics, aRows, iIndex);
        }
        oGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.moInputLine.paint(oGraphics);
    }

    private void paintLine(Graphics2D aoGraphics, DisplayLine[] aaRows, int aiRowIndex) {
        int iRowHeight = this.miRowHeight;
        double dColumnWidth = this.mdColumnWidth;
        double dFontScale = this.mdFontScale;
        double dBotton = (double)(this.getSize().height - 1) / dFontScale;
        AffineTransform oOldTransform = aoGraphics.getTransform();
        AffineTransform oNewTransform = (AffineTransform)oOldTransform.clone();
        oNewTransform.scale(dFontScale, dFontScale);
        aoGraphics.setTransform(oNewTransform);
        if (aiRowIndex >= aaRows.length) {
            return;
        }
        DisplayCell[] aCells = aaRows[aiRowIndex].getCells();
        for (int iCellIndex = 0; iCellIndex < aCells.length; ++iCellIndex) {
            Color oForeground;
            DisplayCell oCell = aCells[iCellIndex];
            char cChar = oCell.getCharacter();
            if (cChar == '\u0000') continue;
            Color oBackground = oCell.getBackground();
            if (oBackground != null) {
                aoGraphics.setColor(oBackground);
                Rectangle2D.Double oBackgroundArea = new Rectangle2D.Double((double)iCellIndex * (dColumnWidth / dFontScale), dBotton - (double)(aiRowIndex + 1) * ((double)iRowHeight / dFontScale), dColumnWidth / dFontScale, (double)iRowHeight / dFontScale);
                aoGraphics.fill(oBackgroundArea);
            }
            aoGraphics.setColor((oForeground = oCell.getForeground()) == null ? this.getForeground() : oForeground);
            aoGraphics.drawString(String.valueOf(cChar), (float)((double)iCellIndex * (dColumnWidth / dFontScale)), (float)(dBotton - (double)(aiRowIndex + 1) * ((double)iRowHeight / dFontScale)));
        }
        aoGraphics.setTransform(oOldTransform);
    }

    public class DisplayModelHandler
    implements DisplayModelListener {
        public void modified(DisplayModelEvent aoEvent) {
            Display.this.repaint();
        }
    }

    public class InputLine
    extends JComponent {
        public void paint(Graphics aoGraphics) {
            Rectangle oBounds = this.getBounds();
            aoGraphics.setColor(Color.RED);
            aoGraphics.drawRect(oBounds.x, oBounds.y, oBounds.width - 1, oBounds.height - 1);
        }
    }
}

