/*
 * Decompiled with CFR 0.152.
 */
package novaworx.view.search;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.util.Vector;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import novaworx.GuiEngine;
import novaworx.PreferenceEngine;
import novaworx.WorkArea;
import novaworx.WorkFrame;
import novaworx.WorkPane;
import novaworx.WorkView;
import novaworx.bus.Message;
import novaworx.bus.MessageBus;
import novaworx.bus.MessageListener;
import novaworx.gui.ActionLibrary;
import novaworx.gui.IconCache;
import novaworx.gui.InformationPage;
import novaworx.gui.ProgramAction;
import novaworx.gui.TablePanel;
import novaworx.message.ProgramStart;
import novaworx.swing.XColor;
import novaworx.swing.XTextField;
import novaworx.viewarea.ViewPaneAdapter;
import novaworx.viewarea.ViewPaneEvent;

public class SearchView
extends WorkView {
    private InformationPage moSearchPanel;
    private Vector mvTitles;
    private Vector mvLabels = new Vector();
    private XTextField moSearch;
    private XTextField moReplace;
    private ViewPaneHandler moViewPaneHandler;
    private MessageHandler moMessageHandler;
    private ShowActionHandler moShowActionHandler;
    protected PreferenceChangeHandler moPreferenceChangeHandler;
    static /* synthetic */ Class class$novaworx$message$ProgramStart;

    public SearchView() {
        this.mvTitles = new Vector();
        this.moViewPaneHandler = new ViewPaneHandler();
        this.moShowActionHandler = new ShowActionHandler();
        this.moPreferenceChangeHandler = new PreferenceChangeHandler();
        this.setIcon(IconCache.getIcon("search"));
        this.setTitle("Search");
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.moSearchPanel = new InformationPage();
        this.createSearchPanel(this.moSearchPanel);
        this.moSearchPanel.done();
        JScrollPane oScroller = new JScrollPane(this.moSearchPanel, 20, 31);
        oScroller.setOpaque(false);
        oScroller.getViewport().setOpaque(false);
        oScroller.setBorder(null);
        this.add((Component)oScroller, "Center");
        this.moPreferenceChangeHandler.init();
    }

    public void allocate() {
        ProgramAction oSearchAction = (ProgramAction)ActionLibrary.get("search");
        oSearchAction.pushListener(this.moShowActionHandler);
    }

    public void display() {
        this.getWorkPane().addViewPaneListener(this.moViewPaneHandler);
        ProgramAction oSearchAction = (ProgramAction)ActionLibrary.get("search");
        oSearchAction.setEnabled(false);
    }

    public void conceal() {
        this.getWorkPane().removeViewPaneListener(this.moViewPaneHandler);
        ProgramAction oSearchAction = (ProgramAction)ActionLibrary.get("search");
        oSearchAction.setEnabled(true);
    }

    public void deallocate() {
        ProgramAction oSearchAction = (ProgramAction)ActionLibrary.get("search");
        oSearchAction.pullListener(this.moShowActionHandler);
    }

    private void createSearchPanel(TablePanel aoPanel) {
        this.moSearch = new XTextField(50);
        this.moReplace = new XTextField(50);
        aoPanel.row();
        aoPanel.add(this.createLabel("This tool is under construction"));
        aoPanel.row();
        aoPanel.width(0);
        aoPanel.add(this.createLabel("Search: "));
        aoPanel.width(1);
        aoPanel.add(this.moSearch);
        aoPanel.row();
        aoPanel.width(0);
        aoPanel.add(this.createLabel("Replace: "));
        aoPanel.width(1);
        aoPanel.add(this.moReplace);
    }

    private JLabel createLabel(String asLabel) {
        JLabel oLabel = new JLabel(asLabel);
        oLabel.setFont(oLabel.getFont().deriveFont(0));
        this.mvLabels.add(oLabel);
        return oLabel;
    }

    public void setForeground(Color aoColor) {
        super.setForeground(aoColor);
    }

    public void setBackground(Color aoColor) {
        super.setBackground(aoColor);
    }

    public void setDropTarget(DropTarget aoDropTarget) {
        this.moSearchPanel.setDropTarget(aoDropTarget);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ClassMessageHandler oMessageHandler = new ClassMessageHandler();
        MessageBus.registerListener(oMessageHandler, class$novaworx$message$ProgramStart == null ? (class$novaworx$message$ProgramStart = SearchView.class$("novaworx.message.ProgramStart")) : class$novaworx$message$ProgramStart);
    }

    protected class PreferenceChangeHandler
    implements PreferenceChangeListener {
        private Preferences moWorkareaPreferences = PreferenceEngine.get().getPreferences("/program/workarea");

        public PreferenceChangeHandler() {
            this.moWorkareaPreferences.addPreferenceChangeListener(this);
        }

        public void init() {
            PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "default", this);
            PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "highlight", this);
            PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "selection", this);
            PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "textfield", this);
            PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "caret", this);
        }

        public void preferenceChange(PreferenceChangeEvent aoEvent) {
            Preferences oPreferences = aoEvent.getNode();
            String sPath = oPreferences.absolutePath();
            String sKey = aoEvent.getKey();
            String sValue = aoEvent.getNewValue();
            if (oPreferences == this.moWorkareaPreferences) {
                if ("default".equals(sKey)) {
                    SearchView.this.moSearchPanel.setForeground(XColor.decodeForeground(sValue));
                    SearchView.this.moSearchPanel.setBackground(XColor.decodeBackground(sValue));
                } else if ("highlight".equals(sKey)) {
                    SearchView.this.moSearchPanel.setSeparatorForeground(XColor.decodeForeground(sValue));
                    SearchView.this.moSearchPanel.setSeparatorBackground(XColor.decodeBackground(sValue));
                } else if ("textfield".equals(sKey)) {
                    SearchView.this.moSearchPanel.setTextEntryBackground(XColor.decode(sValue));
                } else if ("selection".equals(sKey)) {
                    SearchView.this.moSearchPanel.setSelectionForeground(XColor.decodeForeground(sValue));
                    SearchView.this.moSearchPanel.setSelectionBackground(XColor.decodeBackground(sValue));
                } else if ("caret".equals(sKey)) {
                    SearchView.this.moSearchPanel.setTextCaretForeground(XColor.decode(sValue));
                }
                SearchView.this.repaint();
            }
        }
    }

    private static class ClassMessageHandler
    implements MessageListener {
        private ClassMessageHandler() {
        }

        public void messageReceived(Message aoMessage) {
            if (aoMessage instanceof ProgramStart) {
                // empty if block
            }
        }
    }

    private class MessageHandler
    implements MessageListener {
        private MessageHandler() {
        }

        public void messageReceived(Message aoMessage) {
        }
    }

    private class ViewPaneHandler
    extends ViewPaneAdapter {
        private ViewPaneHandler() {
        }

        public void paneClosed(ViewPaneEvent aoEvent) {
            SearchView.this.getWorkPane().pull(SearchView.this);
        }
    }

    private class ShowActionHandler
    extends AbstractAction {
        private ShowActionHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            WorkFrame oWorkFrame = GuiEngine.get().getSelectedWorkFrame();
            WorkArea oWorkArea = oWorkFrame.getSelectedWorkArea();
            WorkPane oWorkPane = oWorkArea.getSelectedWorkPane();
            oWorkPane.push(SearchView.this);
            SearchView.this.requestFocusInWindow();
        }
    }
}

