/*
 * Decompiled with CFR 0.152.
 */
package novaworx.view.resource;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import novaworx.GuiEngine;
import novaworx.MainEngine;
import novaworx.OperatingSystem;
import novaworx.PreferenceEngine;
import novaworx.ResourceEngine;
import novaworx.WorkArea;
import novaworx.WorkFrame;
import novaworx.WorkPane;
import novaworx.WorkView;
import novaworx.WorkViewException;
import novaworx.bus.Message;
import novaworx.bus.MessageBus;
import novaworx.bus.MessageListener;
import novaworx.data.Node;
import novaworx.data.NodeComparator;
import novaworx.data.NodeFilter;
import novaworx.data.ViewNode;
import novaworx.gui.ActionLibrary;
import novaworx.gui.IconCache;
import novaworx.gui.ProgramAction;
import novaworx.log.Log;
import novaworx.message.ProgramStart;
import novaworx.message.ProgramStopRequested;
import novaworx.message.RequestOutline;
import novaworx.resource.DefaultResourceComparator;
import novaworx.resource.Resource;
import novaworx.resource.ResourceCodec;
import novaworx.resource.ResourceComparator;
import novaworx.resource.ResourceException;
import novaworx.resource.ResourceFilter;
import novaworx.swing.XButton;
import novaworx.swing.XCheckBox;
import novaworx.swing.XColor;
import novaworx.swing.XLabel;
import novaworx.swing.XPanel;
import novaworx.swing.XTextField;
import novaworx.swing.XToolBar;
import novaworx.util.thread.ThreadPool;
import novaworx.view.outline.OutlineListener;
import novaworx.view.outline.OutlineModel;
import novaworx.view.outline.OutlineModelFactory;
import novaworx.view.resource.ResourceTableCellEditor;
import novaworx.view.resource.ResourceTableCellRenderer;
import novaworx.view.resource.ResourceTableHeaderCellRenderer;
import novaworx.view.resource.ResourceTableModel;
import novaworx.viewarea.ViewPaneAdapter;
import novaworx.viewarea.ViewPaneEvent;

public class ResourceView
extends WorkView
implements SwingConstants {
    public static final String OPEN = "action.OPEN";
    public static final String SAVE = "action.save";
    public static final String ACCEPT_SELECTION = "accept.selection";
    public static final String CANCEL_SELECTION = "cancel.selection";
    private static final int FIELD_ACCEPT_SOURCE = 0;
    private static final int TABLE_ACCEPT_SOURCE = 1;
    private boolean mbShowUriInPath = false;
    private Object moAction = "action.OPEN";
    private ResourceFilter moResourceFilter;
    private ResourceComparator moResourceComparator;
    private Resource moRoot;
    private ViewNode moRootView;
    private Resource moCurrentContainer;
    private int miAcceptSource;
    private FocusHandler moFocusHandler;
    private OutlineModel moOutlineModel;
    private OutlineHandler moOutlineHandler;
    private static final String msViewbar = "back forward parent refresh";
    private XPanel moHeaderPanel;
    private XToolBar moToolBar;
    private XButton moPathButton;
    private XLabel moPathLabel;
    private XTextField moPathField;
    private XButton moPathDropButton;
    private JButton moAcceptButton;
    private JButton moCancelButton;
    private XPanel moPathFieldPanel;
    private XCheckBox moFilterButton;
    private XLabel moFilterLabel;
    private XTextField moFilterField;
    private XButton moFilterDropButton;
    private XButton moFilterPlaceHolderButton;
    private XPanel moOptionPanel;
    private JTable moTable;
    private XPanel moTablePanel;
    private ResourceTableModel moTableModel;
    private BackActionHandler moBackActionHandler;
    private ForwardActionHandler moForwardActionHandler;
    private ParentActionHandler moParentActionHandler;
    private RefreshActionHandler moRefreshActionHandler;
    private AcceptActionHandler moAcceptActionHandler;
    private CancelActionHandler moCancelActionHandler;
    private ViewPaneHandler moViewPaneHandler;
    private MessageHandler moMessageHandler;
    private Preferences moResourceViewPrefs;
    private PreferenceChangeHandler moPreferenceChangeHandler;
    private Vector mvSelectedResources;
    private Vector mvActionListeners = new Vector();
    private boolean mbLoading;
    private ShowResource moShowResource;
    static /* synthetic */ Class class$java$lang$Object;

    public ResourceView() {
        this.mvSelectedResources = new Vector();
        this.moFocusHandler = new FocusHandler();
        this.moOutlineHandler = new OutlineHandler();
        this.moViewPaneHandler = new ViewPaneHandler();
        this.moBackActionHandler = new BackActionHandler();
        this.moForwardActionHandler = new ForwardActionHandler();
        this.moParentActionHandler = new ParentActionHandler();
        this.moRefreshActionHandler = new RefreshActionHandler();
        this.moAcceptActionHandler = new AcceptActionHandler();
        this.moCancelActionHandler = new CancelActionHandler();
        this.moPreferenceChangeHandler = new PreferenceChangeHandler();
        this.setResourceComparator(new DefaultResourceComparator());
        this.setTitle("Resource Manager");
        this.setIcon(IconCache.getIcon("open"));
        this.moCurrentContainer = this.moRoot = ResourceEngine.get().createResource("root:resources");
        this.setLayout(new BorderLayout());
        this.moToolBar = GuiEngine.get().createToolBar(msViewbar, false, true);
        this.moToolBar.add(Box.createHorizontalGlue());
        this.moToolBar.setFloatable(false);
        this.moToolBar.setMargin(new Insets(0, 0, 0, 0));
        this.moToolBar.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.moToolBar.setOpaque(false);
        this.moToolBar.setBackground(XColor.CLEAR);
        this.moPathButton = new XButton(IconCache.getIcon("file"));
        this.moPathButton.setPressedIcon(IconCache.filterIcon(IconCache.getIcon("file"), IconCache.PRESSED_FILTER));
        this.moPathButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.moPathButton.setMargin(new Insets(0, 0, 0, 0));
        this.moPathButton.setFocusPainted(false);
        this.moPathButton.setContentAreaFilled(false);
        this.moPathButton.setBackground(XColor.CLEAR);
        this.moPathLabel = new XLabel("Path: ");
        this.moPathLabel.setBackground(XColor.CLEAR);
        this.moPathField = new XTextField();
        this.moPathField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.moPathField.addFocusListener(this.moFocusHandler);
        this.moPathDropButton = new XButton(IconCache.getIcon("dropdown"));
        this.moPathDropButton.setPressedIcon(IconCache.filterIcon(IconCache.getIcon("dropdown"), IconCache.PRESSED_FILTER));
        this.moPathDropButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.moPathDropButton.setMargin(new Insets(0, 0, 0, 0));
        this.moPathDropButton.setFocusPainted(false);
        this.moPathDropButton.setContentAreaFilled(false);
        this.moPathDropButton.setBackground(XColor.CLEAR);
        this.moAcceptButton = new XButton(ActionLibrary.get("accept"));
        this.moAcceptButton.setPressedIcon(IconCache.filterIcon(IconCache.getIcon("accept"), IconCache.PRESSED_FILTER));
        this.moAcceptButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.moAcceptButton.setMargin(new Insets(0, 0, 0, 0));
        this.moAcceptButton.setFocusPainted(false);
        this.moAcceptButton.setContentAreaFilled(false);
        this.moAcceptButton.setBackground(XColor.CLEAR);
        GridBagLayout oPathPanelLayout = new GridBagLayout();
        GridBagConstraints oPathPanelConstraints = new GridBagConstraints();
        this.moPathFieldPanel = new XPanel();
        this.moPathFieldPanel.setLayout(oPathPanelLayout);
        oPathPanelConstraints.fill = 3;
        this.moPathFieldPanel.add((Component)this.moPathButton, oPathPanelConstraints);
        this.moPathFieldPanel.add((Component)this.moPathLabel, oPathPanelConstraints);
        oPathPanelConstraints.weightx = 1.0;
        oPathPanelConstraints.fill = 2;
        this.moPathFieldPanel.add((Component)this.moPathField, oPathPanelConstraints);
        oPathPanelConstraints.weightx = 0.0;
        oPathPanelConstraints.fill = 3;
        this.moPathFieldPanel.add((Component)this.moPathDropButton, oPathPanelConstraints);
        oPathPanelConstraints.fill = 3;
        oPathPanelConstraints.gridwidth = 0;
        this.moPathFieldPanel.add((Component)this.moAcceptButton, oPathPanelConstraints);
        this.moFilterButton = new XCheckBox(IconCache.getIcon("checkbox"));
        this.moFilterButton.setSelectedIcon(IconCache.getIcon("checkbox.selected"));
        this.moFilterButton.setPressedIcon(IconCache.filterIcon(IconCache.getIcon("checkbox"), IconCache.PRESSED_FILTER));
        this.moFilterButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.moFilterButton.setMargin(new Insets(0, 0, 0, 0));
        this.moFilterButton.setFocusPainted(false);
        this.moFilterButton.setContentAreaFilled(false);
        this.moFilterButton.setBackground(XColor.CLEAR);
        this.moFilterButton.addActionListener(new FilterButtonHandler());
        this.moFilterLabel = new XLabel("Filter: ");
        this.moFilterLabel.setBackground(XColor.CLEAR);
        this.moFilterField = new XTextField("*[^#~]");
        this.moFilterField.setEnabled(false);
        this.moFilterField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.moFilterDropButton = new XButton(IconCache.getIcon("dropdown"));
        this.moFilterDropButton.setPressedIcon(IconCache.filterIcon(IconCache.getIcon("dropdown"), IconCache.PRESSED_FILTER));
        this.moFilterDropButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.moFilterDropButton.setMargin(new Insets(0, 0, 0, 0));
        this.moFilterDropButton.setFocusPainted(false);
        this.moFilterDropButton.setContentAreaFilled(false);
        this.moFilterDropButton.setBackground(XColor.CLEAR);
        this.moFilterPlaceHolderButton = new XButton(IconCache.getIcon("null"));
        this.moFilterPlaceHolderButton.setPressedIcon(IconCache.filterIcon(IconCache.getIcon("null"), IconCache.PRESSED_FILTER));
        this.moFilterPlaceHolderButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.moFilterPlaceHolderButton.setMargin(new Insets(0, 0, 0, 0));
        this.moFilterPlaceHolderButton.setFocusPainted(false);
        this.moFilterPlaceHolderButton.setContentAreaFilled(false);
        this.moFilterPlaceHolderButton.setBackground(XColor.CLEAR);
        this.moFilterPlaceHolderButton.setEnabled(false);
        GridBagLayout oOptionPanelLayout = oPathPanelLayout;
        GridBagConstraints oOptionPanelConstraints = oPathPanelConstraints;
        this.moOptionPanel = this.moPathFieldPanel;
        this.moOptionPanel.setLayout(oOptionPanelLayout);
        oOptionPanelConstraints.fill = 3;
        oPathPanelConstraints.gridwidth = 1;
        this.moOptionPanel.add((Component)this.moFilterButton, oOptionPanelConstraints);
        this.moOptionPanel.add((Component)this.moFilterLabel, oOptionPanelConstraints);
        oOptionPanelConstraints.weightx = 1.0;
        oOptionPanelConstraints.fill = 2;
        this.moOptionPanel.add((Component)this.moFilterField, oOptionPanelConstraints);
        oOptionPanelConstraints.weightx = 0.0;
        oOptionPanelConstraints.fill = 3;
        this.moOptionPanel.add((Component)this.moFilterDropButton, oOptionPanelConstraints);
        this.moOptionPanel.add((Component)this.moFilterPlaceHolderButton, oOptionPanelConstraints);
        this.moHeaderPanel = new XPanel();
        this.moHeaderPanel.setLayout(new BoxLayout(this.moHeaderPanel, 1));
        this.moHeaderPanel.add(this.moToolBar);
        this.moHeaderPanel.add(this.moPathFieldPanel);
        this.moHeaderPanel.add(this.moOptionPanel);
        this.moTableModel = new ResourceTableModel();
        this.moTable = new JTable(this.moTableModel);
        this.moTable.setRowHeight(IconCache.getIcon("null").getIconHeight());
        this.moTable.setFont(this.getFont());
        this.moTable.setBorder(null);
        this.moTable.setShowGrid(false);
        this.moTable.setRowSelectionAllowed(true);
        this.moTable.setIntercellSpacing(new Dimension(0, 0));
        this.moTable.setBackground(XColor.CLEAR);
        this.moTable.addFocusListener(this.moFocusHandler);
        TableMouseHandler oMouseHandler = new TableMouseHandler();
        this.moTable.addMouseListener(oMouseHandler);
        this.moTable.addMouseMotionListener(oMouseHandler);
        JTableHeader oHeader = this.moTable.getTableHeader();
        if (oHeader != null) {
            oHeader.setBackground(new Color(oHeader.getBackground().getRGB() + Integer.MIN_VALUE, true));
        }
        ResourceTableCellRenderer oRenderer = new ResourceTableCellRenderer();
        this.moTable.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = ResourceView.class$("java.lang.Object")) : class$java$lang$Object, oRenderer);
        ResourceTableHeaderCellRenderer oHeaderRenderer = new ResourceTableHeaderCellRenderer();
        this.moTable.getTableHeader().setDefaultRenderer(oHeaderRenderer);
        ResourceTableCellEditor oEditor = new ResourceTableCellEditor();
        this.moTable.setDefaultEditor(class$java$lang$Object == null ? (class$java$lang$Object = ResourceView.class$("java.lang.Object")) : class$java$lang$Object, oEditor);
        TableColumn oIconColumn = this.moTable.getColumnModel().getColumn(0);
        oIconColumn.setMinWidth(this.moTable.getRowHeight() + 1);
        oIconColumn.setMaxWidth(oIconColumn.getMinWidth());
        TableColumn oNameColumn = this.moTable.getColumnModel().getColumn(1);
        oNameColumn.setPreferredWidth(this.moTable.getRowHeight() * 5);
        TableColumn oTypeColumn = this.moTable.getColumnModel().getColumn(2);
        oTypeColumn.setPreferredWidth(this.moTable.getRowHeight() * 2);
        TableColumn oSizeColumn = this.moTable.getColumnModel().getColumn(3);
        oSizeColumn.setPreferredWidth(this.moTable.getRowHeight() * 1);
        TableColumn oModifiedColumn = this.moTable.getColumnModel().getColumn(4);
        oModifiedColumn.setPreferredWidth(this.moTable.getRowHeight() * 3);
        TableColumn oAttributeColumn = this.moTable.getColumnModel().getColumn(5);
        oAttributeColumn.setPreferredWidth(this.moTable.getRowHeight() * 1);
        JScrollPane oTableScroller = new JScrollPane(this.moTable);
        oTableScroller.setBorder(new EmptyBorder(0, 0, 0, 0));
        ContainerMouseHandler oContainerMouseHandler = new ContainerMouseHandler();
        oTableScroller.addMouseListener(oContainerMouseHandler);
        XPanel oTablePanel = new XPanel();
        oTablePanel.setLayout(new BorderLayout());
        oTablePanel.add((Component)this.moHeaderPanel, "North");
        oTablePanel.add((Component)oTableScroller, "Center");
        this.add((Component)oTablePanel, "Center");
        this.moTable.setOpaque(false);
        oTableScroller.setOpaque(false);
        oTableScroller.getViewport().setOpaque(false);
        this.moMessageHandler = new MessageHandler();
        this.moPreferenceChangeHandler.init();
        this.showResource(this.moRoot);
    }

    public void allocate() throws WorkViewException {
    }

    public synchronized void display() throws WorkViewException {
        this.getWorkPane().addViewPaneListener(this.moViewPaneHandler);
        while (this.mbLoading) {
            try {
                this.wait();
            }
            catch (InterruptedException aoException) {
                return;
            }
        }
        ActionLibrary.get("open").setEnabled(false);
        if (this.moOutlineModel != null) {
            Icon oIcon = (Icon)this.moRoot.getResource("display.icon");
            String sName = (String)this.moRoot.getResource("display.name");
            MessageBus.send(new RequestOutline(this, oIcon, sName, this.moOutlineModel, this.moOutlineHandler));
        }
        ((ProgramAction)ActionLibrary.get("back")).pushListener(this.moBackActionHandler, false);
        ((ProgramAction)ActionLibrary.get("forward")).pushListener(this.moForwardActionHandler, false);
        ((ProgramAction)ActionLibrary.get("parent")).pushListener(this.moParentActionHandler, false);
        ((ProgramAction)ActionLibrary.get("refresh")).pushListener(this.moRefreshActionHandler);
        ((ProgramAction)ActionLibrary.get("accept")).pushListener(this.moAcceptActionHandler);
        ((ProgramAction)ActionLibrary.get("cancel")).pushListener(this.moCancelActionHandler);
    }

    public void select() throws WorkViewException {
    }

    public void unselect() throws WorkViewException {
    }

    public void conceal() throws WorkViewException {
        ((ProgramAction)ActionLibrary.get("back")).pullListener(this.moBackActionHandler);
        ((ProgramAction)ActionLibrary.get("forward")).pullListener(this.moForwardActionHandler);
        ((ProgramAction)ActionLibrary.get("parent")).pullListener(this.moParentActionHandler);
        ((ProgramAction)ActionLibrary.get("refresh")).pullListener(this.moRefreshActionHandler);
        ((ProgramAction)ActionLibrary.get("accept")).pullListener(this.moAcceptActionHandler);
        ((ProgramAction)ActionLibrary.get("cancel")).pullListener(this.moCancelActionHandler);
        if (this.moOutlineModel != null) {
            this.moOutlineModel.setVisible(false);
        }
        this.getWorkPane().removeViewPaneListener(this.moViewPaneHandler);
        ActionLibrary.get("open").setEnabled(true);
    }

    public void refresh() {
        this.showResource(this.moCurrentContainer);
    }

    private synchronized void showResource(Resource aoResource) {
        if (aoResource == null) {
            aoResource = this.moRoot;
        }
        if (this.moShowResource != null) {
            this.moShowResource.stop();
        }
        this.mbLoading = true;
        this.moPathField.requestFocusInWindow();
        this.moShowResource = new ShowResource(aoResource);
    }

    private synchronized void doneLoading() {
        this.mbLoading = false;
        this.notifyAll();
    }

    private void updatePathField(Resource aoResource) {
        Icon oIcon = (Icon)aoResource.getResource("display.icon");
        String sText = this.mbShowUriInPath ? aoResource.getUri().toString() : aoResource.toString();
        this.moPathButton.setIcon(oIcon);
        this.moPathButton.setPressedIcon(IconCache.filterIcon(oIcon, IconCache.PRESSED_FILTER));
        this.moPathField.setText(sText);
        ResourceCodec oCodec = aoResource.getCodec();
        Object[] aOptions = null;
        if (this.moAction == OPEN) {
            aOptions = oCodec.getOptions("action.load");
        } else if (this.moAction == SAVE) {
            aOptions = oCodec.getOptions(SAVE);
        } else {
            Log.write(2, "Unknown ResourceView action: " + this.moAction);
        }
        if (aOptions != null) {
            int iCount = aOptions.length;
            for (int iIndex = 0; iIndex < iCount; ++iIndex) {
                Log.write(-1, aOptions[iIndex].toString());
            }
        }
    }

    private void showDialog() {
        WorkFrame oWorkFrame = GuiEngine.get().getSelectedWorkFrame();
        WorkArea oWorkArea = oWorkFrame.getSelectedWorkArea();
        WorkPane oWorkPane = oWorkArea.getDefaultWorkPane();
        oWorkPane.push(this);
        this.requestFocusInWindow();
    }

    public void showOpenDialog() {
        this.moAction = OPEN;
        this.moAcceptButton.setText(null);
        this.moAcceptButton.setIcon(IconCache.getIcon("open"));
        this.moAcceptButton.setPressedIcon(IconCache.filterIcon(IconCache.getIcon("open"), IconCache.PRESSED_FILTER));
        this.showDialog();
    }

    public void showSaveDialog() {
        this.moAction = SAVE;
        this.moAcceptButton.setText(null);
        this.moAcceptButton.setIcon(IconCache.getIcon("save"));
        this.moAcceptButton.setPressedIcon(IconCache.filterIcon(IconCache.getIcon("save"), IconCache.PRESSED_FILTER));
        this.showDialog();
    }

    public void acceptSelection() {
        Resource oResource = null;
        this.mvSelectedResources.clear();
        switch (this.miAcceptSource) {
            case 0: {
                String sPath = this.moPathField.getText();
                if ("".equals(sPath)) {
                    oResource = this.moRoot;
                } else if (sPath.indexOf(92) < 0 & sPath.indexOf(47) < 0 & sPath.indexOf(58) < 0) {
                    sPath = this.moCurrentContainer.getUri() + "/" + sPath;
                    oResource = ResourceEngine.get().createResource(sPath);
                } else {
                    oResource = ResourceEngine.get().createResource(sPath);
                }
                try {
                    if (oResource.isContainer()) {
                        this.showResource(oResource);
                        return;
                    }
                    this.mvSelectedResources.add(oResource);
                }
                catch (ResourceException aoException) {
                    Log.write(2, (Throwable)aoException);
                }
                break;
            }
            case 1: {
                int[] aRows = this.moTable.getSelectedRows();
                if (aRows.length == 0) {
                    return;
                }
                for (int iIndex = 0; iIndex < aRows.length; ++iIndex) {
                    oResource = (Resource)this.moTable.getModel().getValueAt(aRows[iIndex], 0);
                    if (oResource == null) continue;
                    try {
                        if (oResource.isContainer()) {
                            this.showResource(oResource);
                            return;
                        }
                        this.mvSelectedResources.add(oResource);
                        continue;
                    }
                    catch (ResourceException aoException) {
                        Log.write(2, (Throwable)aoException);
                    }
                }
                break;
            }
            default: {
                Log.write(3, "Accept source not specified.");
                return;
            }
        }
        this.fireActionEvent(new ActionEvent(this, 1001, ACCEPT_SELECTION));
        if (this.isAllocated()) {
            this.getWorkPane().pull(this);
        }
    }

    public void cancelSelection() {
        this.fireActionEvent(new ActionEvent(this, 1001, CANCEL_SELECTION));
        if (this.isAllocated()) {
            this.getWorkPane().pull(this);
        }
    }

    public void setContainer(Resource aoResource) {
        this.showResource(aoResource);
    }

    public Resource getContainer() {
        return this.moCurrentContainer;
    }

    public void setSelectedResource(Resource aoResource) {
        this.showResource(aoResource);
    }

    public Resource getSelectedResource() {
        return this.mvSelectedResources.size() < 1 ? null : (Resource)this.mvSelectedResources.get(0);
    }

    public Resource[] getSelectedResources() {
        Resource[] aResources = new Resource[this.mvSelectedResources.size()];
        return this.mvSelectedResources.toArray(aResources);
    }

    public void setResourceFilter(ResourceFilter aoFilter) {
        this.moResourceFilter = aoFilter;
    }

    public ResourceFilter getResourceFilter() {
        return this.moResourceFilter;
    }

    public void setResourceComparator(ResourceComparator aoComparator) {
        this.moResourceComparator = aoComparator;
    }

    public ResourceComparator getResourceComparator() {
        return this.moResourceComparator;
    }

    public void addActionListener(ActionListener aoListener) {
        this.mvActionListeners.add(aoListener);
    }

    public void removeActionListener(ActionListener aoListener) {
        this.mvActionListeners.remove(aoListener);
    }

    public ActionListener[] getActionListeners() {
        return this.mvActionListeners.toArray(new ActionListener[this.mvActionListeners.size()]);
    }

    private void fireActionEvent(ActionEvent aoEvent) {
        Vector vListeners = (Vector)this.mvActionListeners.clone();
        int iCount = vListeners.size();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            ((ActionListener)vListeners.get(iIndex)).actionPerformed(aoEvent);
        }
    }

    public static void filterResources(Resource aoResource, ResourceFilter aoFilter) {
        if (aoFilter != null) {
            aoResource.filter(new ResourceFilterAdapter(aoFilter));
        }
    }

    public static void sortResources(Resource aoResource, ResourceComparator aoComparator) {
        if (aoComparator != null) {
            aoResource.sort(new ResourceComparatorAdapter(aoComparator));
        }
    }

    public void setForeground(Color aoColor) {
        super.setForeground(aoColor);
        this.moPathLabel.setForeground(aoColor);
        this.moFilterLabel.setForeground(aoColor);
        this.moPathField.setForeground(aoColor);
        this.moFilterField.setForeground(aoColor);
        JTableHeader oHeader = this.moTable.getTableHeader();
        if (oHeader != null) {
            oHeader.setForeground(aoColor);
        }
        this.moTable.setForeground(aoColor);
    }

    public void setBackground(Color aoColor) {
        super.setBackground(aoColor);
        this.moPathField.setBackground(aoColor);
        this.moTable.setBackground(aoColor);
    }

    private static Resource findNextResource(Resource aoParent, Resource aoTarget) {
        String sTargetPath = aoTarget.getUri().getPath();
        boolean bIsTargetSchemeFile = "file".equals(aoTarget.getUri().getScheme());
        int iCount = aoParent.getChildCount();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            Resource oCheckResource = (Resource)aoParent.getChild(iIndex);
            String sCheckPath = oCheckResource.getUri().getPath();
            if (bIsTargetSchemeFile && !OperatingSystem.isFileSystemCaseSensitive()) {
                sTargetPath = sTargetPath.toLowerCase();
                sCheckPath = sCheckPath.toLowerCase();
            }
            if (!sTargetPath.startsWith(sCheckPath)) continue;
            return oCheckResource;
        }
        return null;
    }

    private static Resource findChildResource(Resource aoParent, String asFindPath) {
        int iCount = aoParent.getChildCount();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            Resource oCheckResource = (Resource)aoParent.getChild(iIndex);
            String sCheckPath = oCheckResource.getUri().getPath();
            if ("file".equals(aoParent.getUri().getScheme()) && OperatingSystem.isFileSystemCaseSensitive()) {
                asFindPath = asFindPath.toLowerCase();
                sCheckPath = sCheckPath.toLowerCase();
            }
            if (!asFindPath.equals(sCheckPath)) continue;
            return oCheckResource;
        }
        Log.write(3, "Did not find child resource!");
        return null;
    }

    public void setDropTarget(DropTarget aoDropTarget) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class PreferenceChangeHandler
    implements PreferenceChangeListener {
        private Preferences moWorkareaPreferences = PreferenceEngine.get().getPreferences("/program/workarea");

        public PreferenceChangeHandler() {
            this.moWorkareaPreferences.addPreferenceChangeListener(this);
        }

        public void init() {
            PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "default", this);
            PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "highlight", this);
            PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "textfield", this);
            PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "selection", this);
            PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "caret", this);
            PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "orientation", this);
        }

        public void preferenceChange(PreferenceChangeEvent aoEvent) {
            Preferences oPreferences = aoEvent.getNode();
            String sPath = oPreferences.absolutePath();
            String sKey = aoEvent.getKey();
            String sValue = aoEvent.getNewValue();
            if (oPreferences == this.moWorkareaPreferences) {
                if ("default".equals(sKey)) {
                    Color oForeground = XColor.decodeForeground(sValue);
                    Color oBackground = XColor.decodeBackground(sValue);
                    ResourceView.this.setForeground(oForeground);
                } else if ("highlight".equals(sKey)) {
                    Color oForeground = XColor.decodeForeground(sValue);
                    Color oBackground = XColor.decodeBackground(sValue);
                } else if ("textfield".equals(sKey)) {
                    Color oBackground = XColor.decode(sValue);
                    ResourceView.this.moPathField.setBackground(oBackground);
                    ResourceView.this.moPathField.setBorder(new LineBorder(new XColor(oBackground, 255), 1));
                    ResourceView.this.moFilterField.setBackground(oBackground);
                    ResourceView.this.moFilterField.setBorder(new LineBorder(new XColor(oBackground, 255), 1));
                } else if ("selection".equals(sKey)) {
                    Color oForeground = XColor.decodeForeground(sValue);
                    Color oBackground = XColor.decodeBackground(sValue);
                    ResourceView.this.moTable.setSelectionForeground(oForeground);
                    ResourceView.this.moTable.setSelectionBackground(oBackground);
                    ResourceView.this.moPathField.setSelectedTextColor(oForeground);
                    ResourceView.this.moPathField.setSelectionColor(oBackground);
                    ResourceView.this.moFilterField.setSelectedTextColor(oForeground);
                    ResourceView.this.moFilterField.setSelectionColor(oBackground);
                } else if ("caret".equals(sKey)) {
                    ResourceView.this.moPathField.setCaretColor(XColor.decode(sValue));
                    ResourceView.this.moFilterField.setCaretColor(XColor.decode(sValue));
                } else if ("orientation".equals(sKey)) {
                    int iOrientation = 0;
                    String sOrientation = "North";
                    switch (Integer.parseInt(sValue)) {
                        case 1: {
                            sOrientation = "North";
                            iOrientation = 0;
                            break;
                        }
                        case 3: {
                            sOrientation = "East";
                            iOrientation = 1;
                            break;
                        }
                        case 5: {
                            sOrientation = "South";
                            iOrientation = 0;
                            break;
                        }
                        case 7: {
                            sOrientation = "West";
                            iOrientation = 1;
                        }
                    }
                    ResourceView.this.moToolBar.setOrientation(iOrientation);
                }
                ResourceView.this.repaint();
            }
        }
    }

    private static class ResourceComparatorAdapter
    implements NodeComparator {
        private ResourceComparator moComparator;

        public ResourceComparatorAdapter(ResourceComparator aoComparator) {
            if (aoComparator == null) {
                throw new IllegalArgumentException("ResourceComparator can not be null.");
            }
            this.moComparator = aoComparator;
        }

        public String getDescription() {
            return this.moComparator.getDescription();
        }

        public int compare(Node aoNode1, Node aoNode2) {
            return this.moComparator.compare((Resource)aoNode1, (Resource)aoNode2);
        }
    }

    private static class ResourceFilterAdapter
    implements NodeFilter {
        private ResourceFilter moFilter;

        public ResourceFilterAdapter(ResourceFilter aoFilter) {
            if (aoFilter == null) {
                throw new IllegalArgumentException("ResourceFilter can not be null.");
            }
            this.moFilter = aoFilter;
        }

        public String getDescription() {
            return this.moFilter.getDescription();
        }

        public boolean accept(Node aoNode) {
            return this.moFilter.accept((Resource)aoNode);
        }
    }

    public class TableMouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        public void mousePressed(MouseEvent aoEvent) {
            switch (aoEvent.getClickCount()) {
                case 1: {
                    int iRow = ResourceView.this.moTable.rowAtPoint(aoEvent.getPoint());
                    if (iRow < 0) {
                        ResourceView.this.moTable.clearSelection();
                        ResourceView.this.updatePathField(ResourceView.this.moCurrentContainer);
                        break;
                    }
                    Resource oResource = (Resource)ResourceView.this.moTable.getModel().getValueAt(iRow, 0);
                    ResourceView.this.updatePathField(oResource);
                    break;
                }
                case 2: {
                    ResourceView.this.acceptSelection();
                }
            }
        }

        public void mouseMoved(MouseEvent aoEvent) {
        }

        public void mouseDragged(MouseEvent aoEvent) {
            int iRow = ResourceView.this.moTable.rowAtPoint(aoEvent.getPoint());
            if (iRow >= 0) {
                Resource oResource = (Resource)ResourceView.this.moTable.getModel().getValueAt(iRow, 0);
                ResourceView.this.updatePathField(oResource);
            }
        }
    }

    public class ContainerMouseHandler
    extends MouseAdapter {
        public void mousePressed(MouseEvent aoEvent) {
            ResourceView.this.moTable.clearSelection();
            ResourceView.this.updatePathField(ResourceView.this.moCurrentContainer);
            ResourceView.this.moPathField.requestFocusInWindow();
        }
    }

    private class FocusHandler
    extends FocusAdapter {
        private FocusHandler() {
        }

        public void focusGained(FocusEvent aoEvent) {
            Object oObject = aoEvent.getSource();
            if (oObject == ResourceView.this.moPathField) {
                ResourceView.this.miAcceptSource = 0;
                Log.write(6, "Path field gained focus.");
            } else if (oObject == ResourceView.this.moTable) {
                ResourceView.this.miAcceptSource = 1;
                Log.write(6, "Table gained focus.");
            }
        }
    }

    private class OutlineHandler
    implements OutlineListener {
        private OutlineHandler() {
        }

        public void selectLink(Node aoNode) {
            ResourceView.this.showResource((Resource)aoNode);
        }

        public void selectDecl(Node aoNode) {
        }

        public void selectNode(Node aoNode) {
        }
    }

    private class ViewPaneHandler
    extends ViewPaneAdapter {
        private ViewPaneHandler() {
        }

        public void paneClosed(ViewPaneEvent aoEvent) {
            ResourceView.this.cancelSelection();
        }
    }

    private static class ClassMessageHandler
    implements MessageListener {
        private ClassMessageHandler() {
        }

        public void messageReceived(Message aoMessage) {
            if (aoMessage instanceof ProgramStart) {
                // empty if block
            }
        }
    }

    private class MessageHandler
    implements MessageListener {
        private MessageHandler() {
        }

        public void messageReceived(Message aoMessage) {
            if (aoMessage instanceof ProgramStopRequested) {
                ResourceView.this.cancelSelection();
            }
        }
    }

    private class FilterButtonHandler
    implements ActionListener {
        private FilterButtonHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            XCheckBox oFilterButton = (XCheckBox)aoEvent.getSource();
            ResourceView.this.moFilterField.setEnabled(oFilterButton.isSelected());
        }
    }

    private class CancelActionHandler
    implements ActionListener {
        private CancelActionHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            ResourceView.this.cancelSelection();
        }
    }

    private class AcceptActionHandler
    implements ActionListener {
        private AcceptActionHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            ResourceView.this.acceptSelection();
        }
    }

    private class RefreshActionHandler
    implements ActionListener {
        private RefreshActionHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            ResourceView.this.refresh();
        }
    }

    private class ParentActionHandler
    implements ActionListener {
        private ParentActionHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            ResourceView.this.showResource((Resource)ResourceView.this.moCurrentContainer.getParent());
        }
    }

    private class ForwardActionHandler
    implements ActionListener {
        private ForwardActionHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
        }
    }

    private class BackActionHandler
    implements ActionListener {
        private BackActionHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
        }
    }

    private class ShowResource
    implements Runnable {
        private Resource moResource;
        private boolean mbStop;
        private Thread moThread;

        public ShowResource(Resource aoResource) {
            this.moResource = aoResource;
            ThreadPool oThreadPool = (ThreadPool)MainEngine.get().getResource("thread.pool");
            oThreadPool.execute(this);
        }

        public void run() {
            this.viewResource(this.moResource);
            ResourceView.this.doneLoading();
        }

        public synchronized void stop() {
            this.mbStop = true;
        }

        private void viewResource(Resource aoResource) {
            if (aoResource == null) {
                throw new IllegalArgumentException("Resource can not be null.");
            }
            Resource oResource = this.locateResource(aoResource);
            Resource oContainer = null;
            if (oResource != null) {
                try {
                    if (oResource.isContainer()) {
                        oContainer = oResource;
                        oResource = null;
                    } else {
                        oContainer = (Resource)oResource.getParent();
                    }
                }
                catch (ResourceException aoException) {
                    // empty catch block
                }
            }
            if (oContainer == null) {
                this.openContainer(ResourceView.this.moRoot);
            } else {
                this.openContainer(oContainer);
                if (oResource != null) {
                    // empty if block
                }
            }
        }

        private Resource locateResource(Resource aoResource) {
            if (aoResource == null | aoResource == ResourceView.this.moRoot) {
                return null;
            }
            Resource oContainer = null;
            URI oURI = aoResource.getUri();
            String sScheme = oURI.getScheme();
            String sTargetPath = oURI.getPath();
            String sQuery = oURI.getQuery();
            if (sTargetPath == null) {
                return null;
            }
            Resource oChild = ResourceView.this.moRoot;
            Resource oParent = ResourceView.this.moRoot;
            while (oChild != null) {
                if (this.mbStop) {
                    return null;
                }
                oChild = ResourceView.findNextResource(oParent, aoResource);
                if (oChild == null) continue;
                oParent = oChild;
            }
            String sCurrentPath = oParent.getUri().getPath();
            if (sCurrentPath == null) {
                sCurrentPath = "";
            }
            while (sTargetPath.length() > sCurrentPath.length()) {
                if (this.mbStop) {
                    return null;
                }
                int iPathIndex = sTargetPath.indexOf("/", sCurrentPath.endsWith("/") ? sCurrentPath.length() : sCurrentPath.length() + 1);
                sCurrentPath = iPathIndex < 0 ? sTargetPath : sTargetPath.substring(0, iPathIndex);
                URI oCurrentURI = null;
                String sAuthority = oURI.getAuthority() == null ? "" : oURI.getAuthority();
                try {
                    oCurrentURI = new URI(oURI.getScheme(), sAuthority, sCurrentPath, null, null);
                }
                catch (URISyntaxException aoException) {
                    Log.write(2, (Throwable)aoException);
                    return null;
                }
                oChild = ResourceEngine.get().createResource(oCurrentURI);
                oParent.add(oChild);
                try {
                    if (!oChild.isContainer()) break;
                    oParent = oChild;
                }
                catch (ResourceException aoException) {
                    Log.write(2, (Throwable)aoException);
                }
            }
            oContainer = oParent;
            return oContainer;
        }

        private synchronized void openContainer(Resource aoContainer) {
            if (aoContainer == null) {
                throw new IllegalArgumentException("Resource can not be null.");
            }
            Log.write(6, "Opening container: " + aoContainer.getUri().toString());
            try {
                if (!aoContainer.isContainer()) {
                    throw new IllegalArgumentException("Resource is not a container.\n  " + aoContainer.getUri().toString());
                }
            }
            catch (ResourceException aoException) {
                Log.write(2, (Throwable)aoException);
            }
            ResourceView.this.moCurrentContainer = aoContainer;
            ResourceView.this.updatePathField(aoContainer);
            ResourceView.this.moTableModel.setNode(aoContainer);
            this.loadContainer(aoContainer);
            ActionLibrary.get("parent").setEnabled(aoContainer != ResourceView.this.moRoot);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loadContainer(Resource aoContainer) {
            if (aoContainer == null) {
                return;
            }
            Log.write(6, "Loading container: " + aoContainer.getUri().toString());
            Resource resource = aoContainer;
            synchronized (resource) {
                boolean bLoading;
                boolean bl = bLoading = aoContainer.getResource("loading.children") != null;
                if (bLoading) {
                    return;
                }
                aoContainer.setResource("loading.children", new Object());
            }
            ResourceView.this.moTableModel.setNode(null);
            aoContainer.clear();
            try {
                Resource[] aResources = aoContainer.listResources();
                if (aResources != null) {
                    for (int iIndex = 0; iIndex < aResources.length; ++iIndex) {
                        Resource oChildResource = aResources[iIndex];
                        oChildResource.clear();
                        aoContainer.add(oChildResource);
                    }
                }
            }
            catch (ResourceException aoException) {
                Log.write(2, (Throwable)aoException);
            }
            ResourceView.filterResources(aoContainer, ResourceView.this.moResourceFilter);
            ResourceView.sortResources(aoContainer, ResourceView.this.moResourceComparator);
            ResourceView.this.moTableModel.setNode(aoContainer);
            Icon oIcon = IconCache.getIcon(ResourceView.this.moRoot.getIcon());
            String sName = ResourceView.this.moRoot.getName();
            if (ResourceView.this.isAllocated()) {
                ResourceView.this.moOutlineModel = OutlineModelFactory.createModel((Object)ResourceView.this.moRoot);
                MessageBus.send(new RequestOutline(ResourceView.this, oIcon, sName, ResourceView.this.moOutlineModel, ResourceView.this.moOutlineHandler));
            }
            aoContainer.setResource("loading.children", null);
        }
    }
}

