/*
 * Decompiled with CFR 0.152.
 */
package novaworx.view.resource;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import novaworx.data.Node;

public class ResourceTableCellRenderer
extends DefaultTableCellRenderer {
    private JTable moTable;
    private boolean mbSelected;
    private Border moBorder;

    public ResourceTableCellRenderer() {
        this.setFont(this.getFont().deriveFont(0));
        this.setOpaque(false);
        this.moBorder = new EmptyBorder(0, 0, 0, 3);
    }

    public Component getTableCellRendererComponent(JTable aoTable, Object aoValue, boolean abSelected, boolean abFocus, int aiRow, int aiColumn) {
        Node oNode = (Node)aoValue;
        this.moTable = aoTable;
        this.mbSelected = abSelected;
        TableColumnModel oColumnModel = aoTable.getColumnModel();
        int iColumn = oColumnModel.getColumn(aiColumn).getModelIndex();
        Color oForeground = null;
        Color oBackground = null;
        if (oForeground == null) {
            oForeground = (Color)oNode.getResource("display.foreground");
        }
        if (oBackground == null) {
            oBackground = (Color)oNode.getResource("display.background");
        }
        if (oForeground == null) {
            oForeground = abSelected ? aoTable.getSelectionForeground() : aoTable.getForeground();
        }
        if (oBackground == null) {
            oBackground = abSelected ? aoTable.getSelectionBackground() : aoTable.getBackground();
        }
        this.setOpaque(aoTable.isOpaque());
        this.setForeground(oForeground);
        this.setBackground(oBackground);
        this.setFont(aoTable.getFont());
        this.setIcon(null);
        this.setText("");
        this.setHorizontalAlignment(2);
        this.setBorder(this.moBorder);
        if (oNode == null) {
            return this;
        }
        switch (iColumn) {
            case 0: {
                this.setIcon((Icon)oNode.getResource("display.icon"));
                break;
            }
            case 1: {
                this.setIcon(null);
                this.setText((String)oNode.getResource("display.name"));
                break;
            }
            case 2: {
                this.setIcon(null);
                this.setText((String)oNode.getResource("display.desc"));
                break;
            }
            case 3: {
                this.setIcon(null);
                this.setText((String)oNode.getResource("display.size"));
                this.setHorizontalAlignment(4);
                break;
            }
            case 4: {
                this.setIcon(null);
                this.setText((String)oNode.getResource("display.modified"));
                break;
            }
            case 5: {
                this.setIcon(null);
            }
        }
        return this;
    }

    public void paint(Graphics aoGraphics) {
        Graphics2D oGraphics = (Graphics2D)aoGraphics;
        Color oBackground = this.moTable.getBackground();
        if (this.mbSelected) {
            oBackground = this.moTable.getSelectionBackground();
        }
        oGraphics.setColor(oBackground);
        oGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paint(aoGraphics);
    }
}

