/*
 * Decompiled with CFR 0.152.
 */
package novaworx.view.preference;

import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JTextField;
import novaworx.PreferenceNode;
import novaworx.gui.TablePanel;
import novaworx.swing.XColor;
import novaworx.view.preference.ColorPairPreferenceDocument;
import novaworx.view.preference.ColorPairPreferenceType;
import novaworx.view.preference.PreferenceType;

public class SyntaxStylePreferenceType
extends PreferenceType {
    private JTextField moField;
    private JTextField moStyleField;
    private static final Vector mvStyleOptions = new Vector();
    private static final Hashtable mhStyleLabels = new Hashtable();
    private static final Hashtable mhStyleLookup = new Hashtable();

    public SyntaxStylePreferenceType(PreferenceNode aoPreference) {
        super(aoPreference);
    }

    protected void setPreferenceValue(String asValue) {
        String sColors = this.moField.getText();
        String sStyle = (String)mhStyleLookup.get(this.moStyleField.getText());
        String sValue = sColors + "-" + sStyle;
        Color oForeground = SyntaxStylePreferenceType.decodeForeground(sValue);
        Color oBackground = SyntaxStylePreferenceType.decodeBackground(sValue);
        int iFontStyle = SyntaxStylePreferenceType.decodeFontStyle(sValue);
        String sOverride = (String)this.moField.getClientProperty("background.override");
        if (sOverride != null) {
            oBackground = XColor.decode(sOverride);
        }
        this.moField.setForeground(oForeground);
        this.moField.setBackground(oBackground);
        this.moField.setFont(this.moField.getFont().deriveFont(iFontStyle));
        super.setPreferenceValue(sValue);
    }

    public void addPreferenceRow(TablePanel aoPage) {
        String sValue = this.getPreferenceValue();
        String sLabel = this.moPreference.get("label");
        Color oForeground = SyntaxStylePreferenceType.decodeForeground(sValue);
        Color oBackground = SyntaxStylePreferenceType.decodeBackground(sValue);
        int iFontStyle = SyntaxStylePreferenceType.decodeFontStyle(sValue);
        String sStyle = "PLAIN";
        if (iFontStyle == 3) {
            sStyle = "BOLDITALIC";
        } else if (iFontStyle == 1) {
            sStyle = "BOLD";
        } else if (iFontStyle == 2) {
            sStyle = "ITALIC";
        }
        sStyle = (String)mhStyleLabels.get(sStyle);
        this.addLabel(aoPage, sLabel);
        aoPage.colspan(5);
        this.moField = this.addTextField(aoPage, sValue, true, 4);
        this.moField.setDocument(new ColorPairPreferenceDocument());
        this.moField.putClientProperty("foreground.exempt", "true");
        this.moField.putClientProperty("background.exempt", "true");
        this.moField.setText(sValue);
        this.moField.setForeground(oForeground);
        this.moField.setBackground(oBackground);
        this.moField.setFont(this.moField.getFont().deriveFont(iFontStyle));
        JButton oButton = this.addIconButton(aoPage, "dropdown");
        oButton.addActionListener(new ColorPairPreferenceType.ColorPairPopupTriggerHandler(this.moField));
        this.moStyleField = this.addTextField(aoPage, sStyle, false, 1);
        JButton oStyleButton = this.addIconButton(aoPage, "dropdown");
        this.addComboBoxPopup(this.moStyleField, oStyleButton, mvStyleOptions, mhStyleLabels, mhStyleLookup, sStyle);
    }

    public static final Color decodeForeground(String asValue) {
        Color oColor = Color.BLACK;
        int iIndex = asValue.indexOf(45);
        oColor = iIndex >= 0 ? XColor.decodeForeground(asValue.substring(0, iIndex)) : XColor.decodeForeground(asValue);
        return oColor;
    }

    public static final Color decodeBackground(String asValue) {
        Color oColor = Color.BLACK;
        int iIndex = asValue.indexOf(45);
        oColor = iIndex >= 0 ? XColor.decodeBackground(asValue.substring(0, iIndex)) : XColor.decodeBackground(asValue);
        return oColor;
    }

    public static final int decodeFontStyle(String asValue) {
        int iFontStyle = 0;
        int iIndex = asValue.indexOf(45);
        if (iIndex < 0) {
            return iFontStyle;
        }
        String sFontStyle = asValue.substring(iIndex + 1);
        if (sFontStyle.indexOf("BOLD") >= 0) {
            iFontStyle |= 1;
        }
        if (sFontStyle.indexOf("ITALIC") >= 0) {
            iFontStyle |= 2;
        }
        return iFontStyle;
    }

    static {
        mvStyleOptions.add("PLAIN");
        mvStyleOptions.add("BOLD");
        mvStyleOptions.add("ITALIC");
        mvStyleOptions.add("BOLDITALIC");
        mhStyleLabels.put("PLAIN", "Plain");
        mhStyleLabels.put("BOLD", "Bold");
        mhStyleLabels.put("ITALIC", "Italic");
        mhStyleLabels.put("BOLDITALIC", "Bold Italic");
        mhStyleLookup.put("Plain", "PLAIN");
        mhStyleLookup.put("Bold", "BOLD");
        mhStyleLookup.put("Italic", "ITALIC");
        mhStyleLookup.put("Bold Italic", "BOLDITALIC");
    }
}

