/*
 * Decompiled with CFR 0.152.
 */
package novaworx.view.preference;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import novaworx.PreferenceNode;
import novaworx.ResourceEngine;
import novaworx.WorkViewEngine;
import novaworx.gui.TablePanel;
import novaworx.resource.Resource;
import novaworx.view.preference.PreferenceType;
import novaworx.view.resource.ResourceView;

public class ResourcePreferenceType
extends PreferenceType {
    public static final String SELECT_RESOURCE = "select.resource";

    public ResourcePreferenceType(PreferenceNode aoPreference) {
        super(aoPreference);
    }

    public void addPreferenceRow(TablePanel aoPage) {
        String sValue = this.getPreferenceValue();
        String sLabel = this.moPreference.get("label");
        this.addLabel(aoPage, sLabel);
        aoPage.colspan(7);
        JTextField oField = this.addTextField(aoPage, sValue, true, 4);
        JButton oButton = this.addIconButton(aoPage, "open");
        oButton.setActionCommand(SELECT_RESOURCE);
        ResourceTriggerHandler oTriggerHandler = new ResourceTriggerHandler(oField);
        oButton.addActionListener(oTriggerHandler);
    }

    private class ResourceTriggerHandler
    implements ActionListener {
        private JTextComponent moField;

        public ResourceTriggerHandler(JTextComponent aoField) {
            this.moField = aoField;
        }

        public void actionPerformed(ActionEvent aoEvent) {
            if (aoEvent.getActionCommand() == ResourcePreferenceType.SELECT_RESOURCE) {
                String sValue = ResourcePreferenceType.this.getPreferenceValue();
                Resource oResource = ResourceEngine.get().createResource(sValue);
                ResourceView oResourceView = (ResourceView)WorkViewEngine.get().getView("novaworx.view.resource.ResourceView");
                oResourceView.addActionListener(this);
                oResourceView.setSelectedResource(oResource);
                oResourceView.showOpenDialog();
            } else if (aoEvent.getActionCommand() == "accept.selection") {
                ResourceView oResourceView = (ResourceView)aoEvent.getSource();
                oResourceView.removeActionListener(this);
                Resource oResource = oResourceView.getSelectedResource();
                WorkViewEngine.get().returnView(oResourceView);
                String sValue = oResource.toString();
                this.moField.setText(sValue);
                ResourcePreferenceType.this.setPreferenceValue(sValue);
            } else if (aoEvent.getActionCommand() == "cancel.selection") {
                ResourceView oResourceView = (ResourceView)aoEvent.getSource();
                oResourceView.removeActionListener(this);
                WorkViewEngine.get().returnView(oResourceView);
            }
        }
    }
}

