/*
 * Decompiled with CFR 0.152.
 */
package novaworx.view.preference;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import novaworx.PreferenceEngine;
import novaworx.PreferenceNode;
import novaworx.gui.IconCache;
import novaworx.gui.TablePanel;
import novaworx.swing.XButton;
import novaworx.swing.XColor;
import novaworx.swing.XLabel;
import novaworx.swing.XListPopup;
import novaworx.swing.XPopup;
import novaworx.swing.XTextField;
import novaworx.swing.event.PopupEvent;
import novaworx.swing.event.PopupListener;

public abstract class PreferenceType {
    protected String NOT_DEFINED = "NOT DEFINED";
    protected PreferenceNode moPreference;

    protected PreferenceType(PreferenceNode aoPreference) {
        this.moPreference = aoPreference;
    }

    public abstract void addPreferenceRow(TablePanel var1);

    protected void setPreferenceValue(String asValue) {
        String sPath = (String)this.moPreference.getResource("path");
        String sName = (String)this.moPreference.getResource("name");
        Preferences oPreferences = PreferenceEngine.get().getPreferences(sPath);
        if (asValue == null) {
            throw new NullPointerException("Preference values should not be null: " + sName);
        }
        oPreferences.put(sName, asValue == null ? "" : asValue);
    }

    protected String getPreferenceValue() {
        String sPath = (String)this.moPreference.getResource("path");
        String sName = (String)this.moPreference.getResource("name");
        Preferences oPreferences = PreferenceEngine.get().getPreferences(sPath);
        return oPreferences.get(sName, this.moPreference.get("default"));
    }

    protected JLabel addLabel(TablePanel aoPage, String asLabel) {
        XLabel oLabel = new XLabel(asLabel);
        oLabel.setBackground(XColor.CLEAR);
        aoPage.row();
        aoPage.width(1);
        aoPage.add(oLabel);
        return oLabel;
    }

    protected JTextField addTextField(TablePanel aoPage, String asValue, boolean abEditable, int aiWidth) {
        XTextField oField = new XTextField(1);
        oField.setText(asValue);
        oField.setEditable(abEditable);
        oField.setDisabledTextColor(oField.getForeground());
        String sOverride = this.moPreference.get("override");
        if (sOverride != null) {
            StringTokenizer oTokenizer = new StringTokenizer(sOverride, ":");
            String sKey = oTokenizer.nextToken();
            String sValue = oTokenizer.nextToken();
            if ("background".equals(sKey)) {
                oField.putClientProperty("background.override", sValue);
            }
        }
        if (abEditable) {
            TextFieldAcceptHandler oAcceptHandler = new TextFieldAcceptHandler(oField);
            oField.addFocusListener(oAcceptHandler);
            oField.addKeyListener(oAcceptHandler);
        }
        aoPage.width(aiWidth);
        aoPage.add(oField);
        return oField;
    }

    protected JButton addIconButton(TablePanel aoPage, String asIcon) {
        XButton oButton = new XButton(IconCache.getIcon(asIcon, 16));
        oButton.setPressedIcon(IconCache.filterIcon(oButton.getIcon(), IconCache.PRESSED_FILTER, 16));
        oButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        oButton.setMargin(new Insets(0, 0, 0, 0));
        oButton.setFocusPainted(false);
        oButton.setContentAreaFilled(false);
        oButton.setOpaque(false);
        oButton.setBackground(XColor.CLEAR);
        aoPage.width(0);
        aoPage.add(oButton);
        return oButton;
    }

    protected void addComboBoxPopup(JTextField aoField, JButton aoTrigger, Vector avOptions, Object aoSelected) {
        this.addComboBoxPopup(aoField, aoTrigger, avOptions, null, null, aoSelected);
    }

    protected void addComboBoxPopup(JTextField aoField, JButton aoTrigger, Vector avOptions, Hashtable ahLabels, Hashtable ahLookup, Object aoSelected) {
        this.addComboBoxPopup(aoField, aoTrigger, avOptions, ahLabels, ahLookup, aoSelected, 0);
    }

    protected void addComboBoxPopup(JTextField aoField, JButton aoTrigger, Vector avOptions, Hashtable ahLabels, Hashtable ahLookup, Object aoSelected, int aiMaxRows) {
        if (avOptions == null) {
            return;
        }
        ListPopupTriggerHandler oTriggerHandler = new ListPopupTriggerHandler(aoField, avOptions, ahLabels, ahLookup, aoSelected, aiMaxRows);
        aoTrigger.addActionListener(oTriggerHandler);
    }

    protected class PopupSelectionHandler
    implements PopupListener {
        private JTextComponent moField;
        private Hashtable mhLookup;

        public PopupSelectionHandler(JTextComponent aoField, Hashtable ahLookup) {
            this.moField = aoField;
            this.mhLookup = ahLookup;
        }

        public void selectionMade(PopupEvent aoEvent) {
            ((XPopup)aoEvent.getSource()).removePopupListener(this);
            Object oSelection = aoEvent.getSelection();
            String sValue = null;
            sValue = oSelection instanceof Color ? XColor.encode((Color)oSelection) : oSelection.toString();
            this.moField.setText(sValue);
            PreferenceType.this.setPreferenceValue(this.mhLookup != null ? (String)this.mhLookup.get(sValue) : sValue);
        }
    }

    private class ListPopupTriggerHandler
    implements ActionListener {
        private JTextComponent moField;
        private Vector mvOptions;
        private Hashtable mhLabels;
        private Hashtable mhLookup;
        private Object moSelected;
        private int miMaxRows;

        public ListPopupTriggerHandler(JTextComponent aoField, Vector avOptions, Hashtable ahLabels, Hashtable ahLookup, Object aoSelected, int aiMaxRows) {
            this.moField = aoField;
            this.mvOptions = avOptions;
            this.mhLabels = ahLabels;
            this.mhLookup = ahLookup;
            this.moSelected = aoSelected;
            this.miMaxRows = aiMaxRows;
        }

        public void actionPerformed(ActionEvent aoEvent) {
            XListPopup oPopup = new XListPopup();
            oPopup.setMaximumRowCount(this.miMaxRows);
            oPopup.setForeground(this.moField.getForeground());
            oPopup.setBackground(this.moField.getBackground());
            int iCount = this.mvOptions.size();
            for (int iIndex = 0; iIndex < iCount; ++iIndex) {
                Object oOption = this.mvOptions.get(iIndex);
                boolean bSelected = oOption.equals(this.moSelected);
                String sLabel = oOption.toString();
                if (this.mhLabels != null) {
                    sLabel = (String)this.mhLabels.get(oOption);
                }
                oPopup.add(sLabel);
            }
            int iFieldWidth = this.moField.getWidth();
            Dimension oPreferredSize = oPopup.getPreferredSize();
            int iWidth = Math.max(oPreferredSize.width, iFieldWidth);
            PopupSelectionHandler oSelectionHandler = new PopupSelectionHandler(this.moField, this.mhLookup);
            oPopup.addPopupListener(oSelectionHandler);
            oPopup.setSize(iWidth, oPreferredSize.height);
            oPopup.show(this.moField, 0, this.moField.getSize().height);
        }
    }

    private class TextFieldAcceptHandler
    extends KeyAdapter
    implements FocusListener {
        private JTextField moField;

        public TextFieldAcceptHandler(JTextField aoField) {
            this.moField = aoField;
        }

        public void focusGained(FocusEvent aoEvent) {
        }

        public void focusLost(FocusEvent aoEvent) {
            PreferenceType.this.setPreferenceValue(this.moField.getText());
        }

        public void keyPressed(KeyEvent aoEvent) {
            if (aoEvent.getKeyCode() == 10) {
                PreferenceType.this.setPreferenceValue(this.moField.getText());
            }
        }
    }
}

