/*
 * Decompiled with CFR 0.152.
 */
package novaworx.view.preference;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.util.Vector;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import novaworx.GuiEngine;
import novaworx.PreferenceEngine;
import novaworx.PreferenceGroup;
import novaworx.PreferenceNode;
import novaworx.WorkArea;
import novaworx.WorkFrame;
import novaworx.WorkPane;
import novaworx.WorkView;
import novaworx.WorkViewEngine;
import novaworx.WorkViewException;
import novaworx.bus.Message;
import novaworx.bus.MessageBus;
import novaworx.bus.MessageListener;
import novaworx.data.Node;
import novaworx.gui.ActionLibrary;
import novaworx.gui.IconCache;
import novaworx.gui.InformationPage;
import novaworx.gui.ProgramAction;
import novaworx.gui.TablePanel;
import novaworx.log.Log;
import novaworx.message.ProgramStart;
import novaworx.message.ProgramStopRequested;
import novaworx.message.RequestOutline;
import novaworx.swing.XColor;
import novaworx.swing.XLabel;
import novaworx.view.outline.OutlineListener;
import novaworx.view.outline.OutlineModel;
import novaworx.view.outline.OutlineModelFactory;
import novaworx.view.preference.BooleanPreferenceType;
import novaworx.view.preference.ColorPairPreferenceType;
import novaworx.view.preference.ColorPreferenceType;
import novaworx.view.preference.FontPreferenceType;
import novaworx.view.preference.IntegerPreferenceType;
import novaworx.view.preference.KeymapPreferenceType;
import novaworx.view.preference.KeystrokePreferenceType;
import novaworx.view.preference.PreferenceType;
import novaworx.view.preference.ResourcePreferenceType;
import novaworx.view.preference.SyntaxStylePreferenceType;
import novaworx.view.preference.TextPreferenceType;
import novaworx.viewarea.ViewPaneAdapter;
import novaworx.viewarea.ViewPaneEvent;

public class PreferenceManager
extends WorkView {
    private static PreferenceManager moInstance;
    private PreferenceNode moOutlineRoot;
    private OutlineModel moOutlineModel;
    private OutlineHandler moOutlineHandler;
    private InformationPage moCurrentPage;
    private static ShowActionHandler moShowActionHandler;
    private CancelActionHandler moCancelActionHandler;
    private ViewPaneHandler moViewPaneHandler;
    private MessageHandler moMessageHandler;
    protected PreferenceChangeHandler moPreferenceChangeHandler;
    private Color moTextCaretForeground = XColor.YELLOW;
    private Color moTextCaretBackground = XColor.CLEAR;
    private Color moTextEntryForeground = XColor.WHITE;
    private Color moTextEntryBackground = XColor.SEMI_WHITE;
    private Color moSelectionForeground = XColor.WHITE;
    private Color moSelectionBackground = XColor.decode("808080FF");
    private Color moSeparatorForeground = XColor.WHITE;
    private Color moSeparatorBackground = XColor.SEMI_WHITE;
    private Color moDisabledForeground = XColor.WHITE;
    private Color moDisabledBackground = XColor.SEMI_WHITE;
    static /* synthetic */ Class class$novaworx$message$ProgramStart;
    static /* synthetic */ Class class$novaworx$message$ProgramStopRequested;
    static /* synthetic */ Class class$novaworx$view$preference$PreferenceManager;

    public PreferenceManager() {
        moInstance = this;
        this.moOutlineRoot = new PreferenceNode();
        this.moOutlineHandler = new OutlineHandler();
        moShowActionHandler = new ShowActionHandler();
        this.moCancelActionHandler = new CancelActionHandler();
        this.moViewPaneHandler = new ViewPaneHandler();
        this.moPreferenceChangeHandler = new PreferenceChangeHandler();
        this.setIcon(IconCache.getIcon("preferences"));
        this.setTitle("Preference Manager");
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.moMessageHandler = new MessageHandler();
        MessageBus.registerListener(this.moMessageHandler, class$novaworx$message$ProgramStopRequested == null ? (class$novaworx$message$ProgramStopRequested = PreferenceManager.class$("novaworx.message.ProgramStopRequested")) : class$novaworx$message$ProgramStopRequested);
        this.moPreferenceChangeHandler.init();
        PreferenceGroup oRoot = PreferenceEngine.get().getPreferenceRoot();
        PreferenceManager.createPages(oRoot);
        this.moOutlineModel = OutlineModelFactory.createModel((Object)oRoot);
    }

    public void display() throws WorkViewException {
        this.getWorkPane().addViewPaneListener(this.moViewPaneHandler);
        PreferenceGroup oGroup = (PreferenceGroup)PreferenceEngine.get().getPreferenceRoot().getChild(0);
        if (this.moCurrentPage == null) {
            this.showPage(oGroup);
        }
        this.select();
    }

    public void select() throws WorkViewException {
        MessageBus.send(new RequestOutline(this, IconCache.getIcon("preferences"), "Preferences", this.moOutlineModel, this.moOutlineHandler));
        ((ProgramAction)ActionLibrary.get("cancel")).pushListener(this.moCancelActionHandler);
    }

    public void unselect() throws WorkViewException {
        ((ProgramAction)ActionLibrary.get("cancel")).pullListener(this.moCancelActionHandler);
    }

    public void conceal() throws WorkViewException {
        this.getWorkPane().removeViewPaneListener(this.moViewPaneHandler);
        this.moOutlineModel.setVisible(false);
    }

    public void destroy() throws WorkViewException {
    }

    private static void createPages(PreferenceGroup aoGroup) {
        if (aoGroup == null) {
            return;
        }
        PreferenceManager.createPage(aoGroup);
        int iCount = aoGroup.getChildCount();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            Node oChild = aoGroup.getChild(iIndex);
            if (!(oChild instanceof PreferenceGroup)) continue;
            PreferenceManager.createPages((PreferenceGroup)oChild);
        }
    }

    private static void createPage(PreferenceGroup aoGroup) {
        if (aoGroup == null) {
            return;
        }
        String sGroupName = (String)aoGroup.getResource("display.name");
        InformationPage oPage = new InformationPage();
        String sLabel = sGroupName;
        XLabel oHeader = new XLabel(sLabel);
        oHeader.putClientProperty("change.background.color", "true");
        oHeader.setFont(oHeader.getFont().deriveFont((float)oHeader.getFont().getSize() * 2.0f));
        oHeader.setHorizontalAlignment(0);
        boolean bTopRow = true;
        Vector vPreferences = (Vector)aoGroup.getResource("preferences");
        if (vPreferences == null) {
            return;
        }
        int iCount = vPreferences.size();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            PreferenceNode oNode = (PreferenceNode)vPreferences.get(iIndex);
            if ("true".equals((String)oNode.getResource("hidden"))) continue;
            String sType = (String)oNode.getResource("type");
            PreferenceType oPreferenceType = null;
            if ("separator".equals(sType)) {
                oPage.addSeparator((String)oNode.getResource("name"));
            } else if ("boolean".equals(sType)) {
                oPreferenceType = new BooleanPreferenceType(oNode);
            } else if ("integer".equals(sType)) {
                oPreferenceType = new IntegerPreferenceType(oNode);
            } else if ("text".equals(sType)) {
                oPreferenceType = new TextPreferenceType(oNode);
            } else if ("path".equals(sType)) {
                oPreferenceType = new ResourcePreferenceType(oNode);
            } else if ("font".equals(sType)) {
                oPreferenceType = new FontPreferenceType(oNode);
            } else if ("color".equals(sType)) {
                oPreferenceType = new ColorPreferenceType(oNode);
            } else if ("color-pair".equals(sType)) {
                oPreferenceType = new ColorPairPreferenceType(oNode);
            } else if ("keymap".equals(sType)) {
                oPreferenceType = new KeymapPreferenceType(oNode);
            } else if ("keystroke".equals(sType)) {
                oPreferenceType = new KeystrokePreferenceType(oNode);
            } else if ("syntaxstyle".equals(sType)) {
                oPreferenceType = new SyntaxStylePreferenceType(oNode);
            } else {
                Log.write(2, "Unknown preference type: " + sType);
            }
            bTopRow = false;
            if (oPreferenceType == null) continue;
            ((PreferenceType)oPreferenceType).addPreferenceRow(oPage);
        }
        oPage.done();
        oPage.putClientProperty("preference.group", aoGroup);
        aoGroup.setResource("page", oPage);
    }

    private void showPage(Node aoNode) {
        if (aoNode == null) {
            return;
        }
        InformationPage oPage = (InformationPage)aoNode.getResource("page");
        this.showPage(oPage);
    }

    private void showPage(InformationPage aoPage) {
        this.removeAll();
        Node oNode = (Node)aoPage.getClientProperty("preference.group");
        String sName = (String)oNode.getResource("display.name");
        this.setTitle(sName);
        this.moCurrentPage = aoPage;
        this.moCurrentPage.setForeground(this.getForeground());
        this.moCurrentPage.setBackground(this.getBackground());
        this.moCurrentPage.setTextCaretForeground(this.moTextCaretForeground);
        this.moCurrentPage.setTextCaretBackground(this.moTextCaretBackground);
        this.moCurrentPage.setTextEntryForeground(this.moTextEntryForeground);
        this.moCurrentPage.setTextEntryBackground(this.moTextEntryBackground);
        this.moCurrentPage.setSelectionForeground(this.moSelectionForeground);
        this.moCurrentPage.setSelectionBackground(this.moSelectionBackground);
        this.moCurrentPage.setSeparatorForeground(this.moSeparatorForeground);
        this.moCurrentPage.setSeparatorBackground(this.moSeparatorBackground);
        this.moCurrentPage.setDisabledForeground(this.moDisabledForeground);
        this.moCurrentPage.setDisabledBackground(this.moDisabledBackground);
        JScrollPane oScroller = new JScrollPane(aoPage);
        oScroller.setOpaque(false);
        oScroller.getViewport().setOpaque(false);
        oScroller.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.add((Component)oScroller, "Center");
        this.revalidate();
        this.repaint();
        this.requestFocusInWindow();
    }

    public void cancel() {
        WorkPane oWorkPane = this.getWorkPane();
        if (oWorkPane != null) {
            oWorkPane.pull(this);
        }
    }

    public void setForeground(Color aoColor) {
        super.setForeground(aoColor);
        if (this.moCurrentPage != null) {
            this.moCurrentPage.setForeground(aoColor);
        }
    }

    public void setBackground(Color aoColor) {
        super.setBackground(aoColor);
        if (this.moCurrentPage != null) {
            this.moCurrentPage.setBackground(aoColor);
        }
    }

    public void setTextCaretForeground(Color aoColor) {
        this.moTextCaretForeground = aoColor;
        if (this.moCurrentPage != null) {
            this.moCurrentPage.setTextCaretForeground(aoColor);
        }
    }

    public void setTextCaretBackground(Color aoColor) {
        this.moTextCaretBackground = aoColor;
        if (this.moCurrentPage != null) {
            this.moCurrentPage.setTextCaretBackground(aoColor);
        }
    }

    public void setTextEntryForeground(Color aoColor) {
        this.moTextEntryForeground = aoColor;
        if (this.moCurrentPage != null) {
            this.moCurrentPage.setTextEntryForeground(aoColor);
        }
    }

    public void setTextEntryBackground(Color aoColor) {
        this.moTextEntryBackground = aoColor;
        if (this.moCurrentPage != null) {
            this.moCurrentPage.setTextEntryBackground(aoColor);
        }
    }

    public void setSelectionForeground(Color aoColor) {
        this.moSelectionForeground = aoColor;
        if (this.moCurrentPage != null) {
            this.moCurrentPage.setSelectionForeground(aoColor);
        }
    }

    public void setSelectionBackground(Color aoColor) {
        this.moSelectionBackground = aoColor;
        if (this.moCurrentPage != null) {
            this.moCurrentPage.setSelectionBackground(aoColor);
        }
    }

    public void setSeparatorForeground(Color aoColor) {
        this.moSeparatorForeground = aoColor;
        if (this.moCurrentPage != null) {
            this.moCurrentPage.setSeparatorForeground(aoColor);
        }
    }

    public void setSeparatorBackground(Color aoColor) {
        this.moSeparatorBackground = aoColor;
        if (this.moCurrentPage != null) {
            this.moCurrentPage.setSeparatorBackground(aoColor);
        }
    }

    public void setDisabledForeground(Color aoColor) {
        this.moDisabledForeground = aoColor;
        if (this.moCurrentPage != null) {
            this.moCurrentPage.setDisabledForeground(aoColor);
        }
    }

    public void setDisabledBackground(Color aoColor) {
        this.moDisabledBackground = aoColor;
        if (this.moCurrentPage != null) {
            this.moCurrentPage.setDisabledBackground(aoColor);
        }
    }

    public void paint(Graphics aoGraphics) {
        super.paint(aoGraphics);
    }

    public void setDropTarget(DropTarget aoDropTarget) {
    }

    private static void addSeparator(TablePanel aoPage, String asLabel, boolean abTopRow) {
        XLabel oLabel;
        if (!abTopRow) {
            aoPage.row();
            oLabel = new XLabel(" ");
            oLabel.setAntialias(true);
            oLabel.setBackground(XColor.CLEAR);
            oLabel.setHorizontalAlignment(0);
            aoPage.colspan(3);
            aoPage.add(oLabel);
        }
        aoPage.row();
        oLabel = new XLabel(asLabel);
        oLabel.setBackground(XColor.CLEAR);
        oLabel.putClientProperty("separator.type", "true");
        oLabel.setFont(oLabel.getFont().deriveFont(1, (float)oLabel.getFont().getSize() * 1.25f));
        aoPage.colspan(3);
        aoPage.add(oLabel);
    }

    public void addFocusListener(FocusListener aoListener) {
        super.addFocusListener(aoListener);
        if (this.moCurrentPage != null) {
            this.moCurrentPage.addFocusListener(aoListener);
        }
    }

    public void removeFocusListener(FocusListener aoListener) {
        super.removeFocusListener(aoListener);
        if (this.moCurrentPage != null) {
            this.moCurrentPage.removeFocusListener(aoListener);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ClassMessageHandler oMessageHandler = new ClassMessageHandler();
        MessageBus.registerListener(oMessageHandler, class$novaworx$message$ProgramStart == null ? (class$novaworx$message$ProgramStart = PreferenceManager.class$("novaworx.message.ProgramStart")) : class$novaworx$message$ProgramStart);
        moShowActionHandler = new ShowActionHandler();
        ProgramAction oAction = (ProgramAction)ActionLibrary.get("preferences");
        oAction.pushListener(moShowActionHandler);
    }

    protected class PreferenceChangeHandler
    implements PreferenceChangeListener {
        private Preferences moWorkAreaPreferences = PreferenceEngine.get().getPreferences("/program/workarea");

        public PreferenceChangeHandler() {
            this.moWorkAreaPreferences.addPreferenceChangeListener(this);
        }

        public void init() {
            PreferenceEngine.get().initPreference(this.moWorkAreaPreferences, "default", this);
            PreferenceEngine.get().initPreference(this.moWorkAreaPreferences, "highlight", this);
            PreferenceEngine.get().initPreference(this.moWorkAreaPreferences, "selection", this);
            PreferenceEngine.get().initPreference(this.moWorkAreaPreferences, "textfield", this);
            PreferenceEngine.get().initPreference(this.moWorkAreaPreferences, "caret", this);
        }

        public void preferenceChange(PreferenceChangeEvent aoEvent) {
            Preferences oPreferences = aoEvent.getNode();
            String sPath = oPreferences.absolutePath();
            String sKey = aoEvent.getKey();
            String sValue = aoEvent.getNewValue();
            if (oPreferences == this.moWorkAreaPreferences) {
                if ("default".equals(sKey)) {
                    PreferenceManager.this.setForeground(XColor.decodeForeground(sValue));
                    PreferenceManager.this.setBackground(XColor.decodeBackground(sValue));
                    PreferenceManager.this.setSelectionForeground(XColor.decodeForeground(sValue));
                } else if ("highlight".equals(sKey)) {
                    PreferenceManager.this.setSeparatorForeground(XColor.decodeForeground(sValue));
                    PreferenceManager.this.setSeparatorBackground(XColor.decodeBackground(sValue));
                } else if ("textfield".equals(sKey)) {
                    PreferenceManager.this.setTextEntryBackground(XColor.decode(sValue));
                } else if ("selection".equals(sKey)) {
                    PreferenceManager.this.setSelectionForeground(XColor.decodeForeground(sValue));
                    PreferenceManager.this.setSelectionBackground(XColor.decodeBackground(sValue));
                } else if ("caret".equals(sKey)) {
                    PreferenceManager.this.setTextCaretForeground(XColor.decode(sValue));
                }
                PreferenceManager.this.repaint();
            }
        }
    }

    private static class ClassMessageHandler
    implements MessageListener {
        private ClassMessageHandler() {
        }

        public void messageReceived(Message aoMessage) {
            if (aoMessage instanceof ProgramStart) {
                // empty if block
            }
        }
    }

    private class MessageHandler
    implements MessageListener {
        private MessageHandler() {
        }

        public void messageReceived(Message aoMessage) {
            if (aoMessage instanceof ProgramStopRequested) {
                PreferenceManager.this.cancel();
            }
        }
    }

    public class ViewPaneHandler
    extends ViewPaneAdapter {
        public void paneClosed(ViewPaneEvent aoEvent) {
            PreferenceManager.this.getWorkPane().pull(PreferenceManager.this);
        }
    }

    private class CancelActionHandler
    implements ActionListener {
        private CancelActionHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            PreferenceManager.this.cancel();
        }
    }

    public static class ShowActionHandler
    extends AbstractAction {
        public void actionPerformed(ActionEvent aoEvent) {
            WorkFrame oWorkFrame = GuiEngine.get().getSelectedWorkFrame();
            WorkArea oWorkArea = oWorkFrame.getSelectedWorkArea();
            WorkPane oWorkPane = oWorkArea.getDefaultWorkPane();
            if (moInstance != null && moInstance.isAllocated()) {
                moInstance.getWorkPane().pull(moInstance);
            }
            WorkView oView = WorkViewEngine.get().getView((class$novaworx$view$preference$PreferenceManager == null ? (class$novaworx$view$preference$PreferenceManager = PreferenceManager.class$("novaworx.view.preference.PreferenceManager")) : class$novaworx$view$preference$PreferenceManager).getName());
            oWorkPane.push(oView);
            oView.requestFocusInWindow();
        }
    }

    private class OutlineHandler
    implements OutlineListener {
        private OutlineHandler() {
        }

        public void selectLink(Node aoNode) {
            InformationPage oPage = (InformationPage)aoNode.getResource("page");
            PreferenceManager.this.showPage(oPage);
        }

        public void selectDecl(Node aoNode) {
        }

        public void selectNode(Node aoNode) {
        }
    }
}

