/*
 * Decompiled with CFR 0.152.
 */
package novaworx.view.preference;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import novaworx.MainEngine;
import novaworx.PreferenceNode;
import novaworx.gui.ShortcutGrabber;
import novaworx.gui.ShortcutListener;
import novaworx.gui.TablePanel;
import novaworx.swing.XAction;
import novaworx.view.preference.PreferenceType;

public class KeymapPreferenceType
extends PreferenceType {
    private JTextField moField;

    public KeymapPreferenceType(PreferenceNode aoPreference) {
        super(aoPreference);
    }

    protected void setPreferenceValue(String asValue) {
        this.moField.setText(XAction.getShortcutDisplayText(asValue));
        super.setPreferenceValue(asValue);
    }

    public void addPreferenceRow(TablePanel aoPage) {
        String sValue = this.getPreferenceValue();
        String sLabel = this.moPreference.get("label");
        Vector vOptions = (Vector)this.moPreference.getResource("options");
        Hashtable hOptionLabels = (Hashtable)this.moPreference.getResource("option.labels");
        Hashtable hOptionLookup = (Hashtable)this.moPreference.getResource("option.lookup");
        if (hOptionLabels != null) {
            sValue = (String)hOptionLabels.get(sValue);
        }
        this.addLabel(aoPage, sLabel);
        aoPage.colspan(7);
        this.moField = this.addTextField(aoPage, XAction.getShortcutDisplayText(sValue), false, 4);
        JButton oButton = this.addIconButton(aoPage, "keymap");
        oButton.addActionListener(new KeymapTriggerHandler(this.moField));
    }

    private class KeymapTriggerHandler
    implements ActionListener,
    ShortcutListener,
    FocusListener {
        private ShortcutGrabber moGrabber = (ShortcutGrabber)MainEngine.get().getResource("shortcut.grabber");
        private JTextComponent moField;

        public KeymapTriggerHandler(JTextComponent aoField) {
            this.moField = aoField;
        }

        public void actionPerformed(ActionEvent aoEvent) {
            this.moField.setText("");
            this.moField.addFocusListener(this);
            this.moField.requestFocusInWindow();
        }

        public void shortcutTyped(String asShortcut) {
            this.moField.setText(XAction.getShortcutDisplayText(asShortcut));
        }

        public void shortcutAccept(String asShortcut) {
            KeymapPreferenceType.this.setPreferenceValue(asShortcut == null ? "" : asShortcut);
            this.moField.removeFocusListener(this);
        }

        public void shortcutCancel(String asShortcut) {
            this.moField.setText(XAction.getShortcutDisplayText(KeymapPreferenceType.this.getPreferenceValue()));
            this.moField.removeFocusListener(this);
        }

        public void focusGained(FocusEvent aoEvent) {
            this.moGrabber.setListener(this);
        }

        public void focusLost(FocusEvent aoEvent) {
            this.moGrabber.cancelShortcut();
        }
    }
}

