/*
 * Decompiled with CFR 0.152.
 */
package novaworx.view.preference;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JTextField;
import novaworx.PreferenceNode;
import novaworx.gui.TablePanel;
import novaworx.view.preference.PreferenceType;

public class FontPreferenceType
extends PreferenceType {
    private JTextField moNameField;
    private JTextField moStyleField;
    private JTextField moSizeField;
    private static final Vector mvNameOptions;
    private static final Hashtable mhNameLabels;
    private static final Hashtable mhNameLookup;
    private static final Vector mvStyleOptions;
    private static final Hashtable mhStyleLabels;
    private static final Hashtable mhStyleLookup;
    private static final Vector mvSizeOptions;
    private static final Hashtable mhSizeLabels;
    private static final Hashtable mhSizeLookup;

    public FontPreferenceType(PreferenceNode aoPreference) {
        super(aoPreference);
    }

    protected void setPreferenceValue(String asValue) {
        String sName = (String)mhNameLookup.get(this.moNameField.getText());
        String sStyle = (String)mhStyleLookup.get(this.moStyleField.getText());
        String sSize = (String)mhSizeLookup.get(this.moSizeField.getText());
        if (sSize == null) {
            sSize = this.moSizeField.getText();
        }
        super.setPreferenceValue(sName + "-" + sStyle + "-" + sSize);
    }

    public void addPreferenceRow(TablePanel aoPage) {
        String sValue = this.getPreferenceValue();
        String sLabel = this.moPreference.get("label");
        Font oFont = Font.decode(sValue);
        String sName = (String)mhNameLabels.get(oFont.getFamily());
        if (sName == null) {
            sName = oFont.getFamily();
        }
        String sStyle = "PLAIN";
        if (oFont.isBold() & oFont.isItalic()) {
            sStyle = "BOLDITALIC";
        } else if (oFont.isBold()) {
            sStyle = "BOLD";
        } else if (oFont.isItalic()) {
            sStyle = "ITALIC";
        }
        sStyle = (String)mhStyleLabels.get(sStyle);
        String sSize = (String)mhSizeLabels.get(String.valueOf(oFont.getSize()));
        this.addLabel(aoPage, sLabel);
        this.moNameField = this.addTextField(aoPage, sName, false, 2);
        JButton oNameButton = this.addIconButton(aoPage, "dropdown");
        this.addComboBoxPopup(this.moNameField, oNameButton, mvNameOptions, mhNameLabels, mhNameLookup, sName, 10);
        this.moStyleField = this.addTextField(aoPage, sStyle, false, 1);
        JButton oStyleButton = this.addIconButton(aoPage, "dropdown");
        this.addComboBoxPopup(this.moStyleField, oStyleButton, mvStyleOptions, mhStyleLabels, mhStyleLookup, sStyle);
        this.moSizeField = this.addTextField(aoPage, sSize, true, 1);
        JButton oSizeButton = this.addIconButton(aoPage, "dropdown");
        this.addComboBoxPopup(this.moSizeField, oSizeButton, mvSizeOptions, mhSizeLabels, mhSizeLookup, sSize);
    }

    static {
        int iIndex;
        mvNameOptions = new Vector();
        mhNameLabels = new Hashtable();
        mhNameLookup = new Hashtable();
        mvStyleOptions = new Vector();
        mhStyleLabels = new Hashtable();
        mhStyleLookup = new Hashtable();
        mvSizeOptions = new Vector();
        mhSizeLabels = new Hashtable();
        mhSizeLookup = new Hashtable();
        GraphicsEnvironment oEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] aFontFamilies = oEnvironment.getAvailableFontFamilyNames();
        int iCount = aFontFamilies.length;
        for (iIndex = 0; iIndex < iCount; ++iIndex) {
            String sFont = aFontFamilies[iIndex];
            String sKey = sFont.toLowerCase();
            mvNameOptions.add(sKey);
            mhNameLabels.put(sKey, sFont);
            mhNameLookup.put(sFont, sKey);
        }
        mvStyleOptions.add("PLAIN");
        mvStyleOptions.add("BOLD");
        mvStyleOptions.add("ITALIC");
        mvStyleOptions.add("BOLDITALIC");
        mhStyleLabels.put("PLAIN", "Plain");
        mhStyleLabels.put("BOLD", "Bold");
        mhStyleLabels.put("ITALIC", "Italic");
        mhStyleLabels.put("BOLDITALIC", "Bold Italic");
        mhStyleLookup.put("Plain", "PLAIN");
        mhStyleLookup.put("Bold", "BOLD");
        mhStyleLookup.put("Italic", "ITALIC");
        mhStyleLookup.put("Bold Italic", "BOLDITALIC");
        for (iIndex = 8; iIndex < 26; iIndex += 2) {
            String sSize;
            String sLabel = sSize = String.valueOf(iIndex);
            mvSizeOptions.add(sSize);
            mhSizeLabels.put(sSize, sLabel);
            mhSizeLookup.put(sLabel, sSize);
        }
    }
}

