/*
 * Decompiled with CFR 0.152.
 */
package novaworx.view.preference;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import novaworx.PreferenceNode;
import novaworx.gui.TablePanel;
import novaworx.swing.XColor;
import novaworx.swing.XColorPopup;
import novaworx.view.preference.ColorPreferenceDocument;
import novaworx.view.preference.PreferenceType;

public class ColorPreferenceType
extends PreferenceType {
    private JTextField moField;

    public ColorPreferenceType(PreferenceNode aoPreference) {
        super(aoPreference);
    }

    protected void setPreferenceValue(String asValue) {
        boolean bBackground;
        Color oColor = XColor.decode(asValue);
        String sOverride = (String)this.moField.getClientProperty("background.override");
        if (sOverride != null) {
            oColor = XColor.decode(sOverride);
        }
        if (!(bBackground = "true".equals(this.moPreference.get("background")))) {
            this.moField.setForeground(oColor);
        } else {
            this.moField.setBackground(oColor);
        }
        super.setPreferenceValue(asValue);
    }

    public void addPreferenceRow(TablePanel aoPage) {
        String sValue = this.getPreferenceValue();
        String sLabel = this.moPreference.get("label");
        Color oColor = XColor.decode(sValue);
        boolean bBackground = "true".equals(this.moPreference.get("background"));
        this.addLabel(aoPage, sLabel);
        aoPage.colspan(7);
        this.moField = this.addTextField(aoPage, sValue, true, 4);
        this.moField.setDocument(new ColorPreferenceDocument());
        this.moField.setText(sValue);
        if (!bBackground) {
            this.moField.putClientProperty("foreground.exempt", "true");
            this.moField.setForeground(oColor);
        } else {
            this.moField.putClientProperty("background.exempt", "true");
            this.moField.setBackground(oColor);
        }
        JButton oButton = this.addIconButton(aoPage, "dropdown");
        oButton.addActionListener(new ColorPopupTriggerHandler(this.moField));
    }

    private class ColorPopupTriggerHandler
    implements ActionListener {
        private JTextComponent moField;

        public ColorPopupTriggerHandler(JTextComponent aoField) {
            this.moField = aoField;
        }

        public void actionPerformed(ActionEvent aoEvent) {
            XColorPopup oPopup = new XColorPopup();
            int iFieldWidth = this.moField.getWidth();
            Dimension oPreferredSize = oPopup.getPreferredSize();
            int iWidth = Math.max(oPreferredSize.width, iFieldWidth);
            PreferenceType.PopupSelectionHandler oSelectionHandler = new PreferenceType.PopupSelectionHandler(ColorPreferenceType.this, this.moField, null);
            oPopup.addPopupListener(oSelectionHandler);
            oPopup.setSize(iWidth, oPreferredSize.height);
            oPopup.show(this.moField, 0, this.moField.getSize().height);
        }
    }
}

