/*
 * Decompiled with CFR 0.152.
 */
package novaworx.view.preference;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import novaworx.PreferenceNode;
import novaworx.gui.TablePanel;
import novaworx.swing.XColor;
import novaworx.swing.XPopup;
import novaworx.view.preference.ColorPairPreferenceDocument;
import novaworx.view.preference.PreferenceType;

public class ColorPairPreferenceType
extends PreferenceType {
    private JTextField moField;

    public ColorPairPreferenceType(PreferenceNode aoPreference) {
        super(aoPreference);
    }

    protected void setPreferenceValue(String asValue) {
        Color oForeground = XColor.decodeForeground(asValue);
        Color oBackground = XColor.decodeBackground(asValue);
        String sOverride = (String)this.moField.getClientProperty("background.override");
        if (sOverride != null) {
            oBackground = XColor.decode(sOverride);
        }
        this.moField.setForeground(oForeground);
        this.moField.setBackground(oBackground);
        super.setPreferenceValue(asValue);
    }

    public void addPreferenceRow(TablePanel aoPage) {
        String sValue = this.getPreferenceValue();
        String sLabel = this.moPreference.get("label");
        Color oForeground = XColor.decodeForeground(sValue);
        Color oBackground = XColor.decodeBackground(sValue);
        this.addLabel(aoPage, sLabel);
        aoPage.colspan(7);
        this.moField = this.addTextField(aoPage, sValue, true, 4);
        this.moField.setDocument(new ColorPairPreferenceDocument());
        this.moField.putClientProperty("foreground.exempt", "true");
        this.moField.putClientProperty("background.exempt", "true");
        this.moField.setText(sValue);
        this.moField.setForeground(oForeground);
        this.moField.setBackground(oBackground);
        JButton oButton = this.addIconButton(aoPage, "dropdown");
        oButton.addActionListener(new ColorPairPopupTriggerHandler(this.moField));
    }

    public static class ColorPairPopupTriggerHandler
    implements ActionListener {
        private JTextComponent moField;

        public ColorPairPopupTriggerHandler(JTextComponent aoField) {
            this.moField = aoField;
        }

        public void actionPerformed(ActionEvent aoEvent) {
            JColorChooser oColorChooser = new JColorChooser();
            XPopup oPopup = new XPopup();
            oPopup.setBackground(new Color(0, 0, 0, 0));
            int iFieldWidth = this.moField.getWidth();
            Dimension oPreferredSize = oPopup.getPreferredSize();
            int iWidth = Math.max(oPreferredSize.width, iFieldWidth);
            oPopup.setSize(iWidth, oPreferredSize.height);
            oPopup.show(this.moField, 0, this.moField.getSize().height);
        }
    }
}

