/*
 * Decompiled with CFR 0.152.
 */
package novaworx.view.outline;

import novaworx.data.Node;
import novaworx.resource.Resource;
import novaworx.syntax.Syntax;
import novaworx.textpane.SyntaxDocument;
import novaworx.textpane.SyntaxDocumentLineSource;
import novaworx.view.outline.JavaOutlineParser;
import novaworx.view.outline.OutlineModel;

public class OutlineModelFactory {
    private OutlineModelFactory() {
    }

    public static final OutlineModel createModel(Object aoObject) {
        if (aoObject == null) {
            return null;
        }
        if (aoObject instanceof Resource) {
            return OutlineModelFactory.createModel((Resource)aoObject);
        }
        if (aoObject instanceof SyntaxDocument) {
            return OutlineModelFactory.createModel((SyntaxDocument)aoObject);
        }
        if (aoObject instanceof Node) {
            return OutlineModelFactory.createModel((Node)aoObject);
        }
        return null;
    }

    protected static final OutlineModel createModel(Node aoNode) {
        return new OutlineModel(aoNode);
    }

    protected static final OutlineModel createModel(Resource aoResource) {
        return new OutlineModel(aoResource);
    }

    protected static final OutlineModel createModel(SyntaxDocument aoDocument) {
        Syntax oSyntax = aoDocument.getSyntax();
        if (oSyntax == null) {
            return null;
        }
        String sContentType = oSyntax.getName();
        if (sContentType == null) {
            return null;
        }
        JavaOutlineParser oParser = null;
        SyntaxDocumentLineSource oSource = new SyntaxDocumentLineSource(aoDocument);
        if ("java".equals(sContentType)) {
            oParser = new JavaOutlineParser();
        }
        Node oResult = null;
        if (oParser != null) {
            oResult = oParser.parse(oSource);
        }
        if (oResult != null) {
            return new OutlineModel(oResult);
        }
        return null;
    }
}

