/*
 * Decompiled with CFR 0.152.
 */
package novaworx.view.outline;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.dnd.DropTarget;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import novaworx.PreferenceEngine;
import novaworx.WorkView;
import novaworx.WorkViewException;
import novaworx.bus.Message;
import novaworx.bus.MessageBus;
import novaworx.bus.MessageListener;
import novaworx.data.DataNode;
import novaworx.data.Node;
import novaworx.data.NodeTreeModel;
import novaworx.gui.IconCache;
import novaworx.gui.ProgramTreeCellRenderer;
import novaworx.message.RequestOutline;
import novaworx.swing.XColor;
import novaworx.view.outline.OutlineListener;
import novaworx.view.outline.OutlineModel;

public class Outline
extends WorkView {
    private JTree moTree;
    private ProgramTreeCellRenderer moCellRenderer;
    private MessageHandler moMessageHandler;
    private TreeModel moEmptyModel;
    private OutlineListener moOutlineListener;
    private Color moBorderSelectionColor;
    private Color moBackgroundSelectionColor;
    private TreeSelectionHandler moSelectionHandler;
    private MouseClickHandler moMouseClickHandler = new MouseClickHandler();
    protected PreferenceChangeHandler moPreferenceChangeHandler;
    private Object moOutlineSource;
    static /* synthetic */ Class class$novaworx$message$RequestOutline;

    public Outline() {
        this.moSelectionHandler = new TreeSelectionHandler();
        this.moPreferenceChangeHandler = new PreferenceChangeHandler();
        DataNode oEmptyNode = new DataNode();
        oEmptyNode.setResource("icon", IconCache.getIcon("null"));
        oEmptyNode.setResource("label", "Not Available");
        this.moEmptyModel = new NodeTreeModel(oEmptyNode);
        this.moCellRenderer = new ProgramTreeCellRenderer();
        this.moBorderSelectionColor = this.moCellRenderer.getBorderSelectionColor();
        SystemColor oSelectionColor = SystemColor.textHighlight;
        this.moBackgroundSelectionColor = new Color(oSelectionColor.getRed(), oSelectionColor.getGreen(), oSelectionColor.getBlue(), 128);
        this.moCellRenderer.setBorderSelectionColor(new Color(0, 0, 0, 0));
        this.moCellRenderer.setBackgroundSelectionColor(new Color(0, 0, 0, 0));
        this.moTree = new JTree(this.moEmptyModel);
        this.moTree.setRootVisible(false);
        this.moTree.setShowsRootHandles(false);
        this.moTree.setCellRenderer(this.moCellRenderer);
        this.moTree.addMouseListener(this.moMouseClickHandler);
        JScrollPane oScroller = new JScrollPane(this.moTree);
        oScroller.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setOpaque(false);
        this.moTree.setOpaque(false);
        oScroller.setOpaque(false);
        oScroller.getViewport().setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)oScroller, "Center");
        this.setIcon(IconCache.getIcon("outline"));
        this.setTitle("Outline");
        this.moMessageHandler = new MessageHandler();
        MessageBus.registerListener(this.moMessageHandler, class$novaworx$message$RequestOutline == null ? (class$novaworx$message$RequestOutline = Outline.class$("novaworx.message.RequestOutline")) : class$novaworx$message$RequestOutline);
        this.moPreferenceChangeHandler.init();
    }

    public void setModel(OutlineModel aoModel) {
        TreePath oParentPath;
        if (aoModel == null) {
            throw new IllegalArgumentException("Outline model cannot be null. To hide the outline call getModel().setVisible( false ).");
        }
        int iSelectedRow = -1;
        int[] aSelectedRows = this.moTree.getSelectionRows();
        if (aSelectedRows != null && aSelectedRows.length > 0) {
            iSelectedRow = aSelectedRows[0];
        }
        aoModel.setVisible(true);
        this.moTree.setModel(aoModel);
        this.expandTree();
        this.moTree.setSelectionModel(aoModel);
        if (this.moTree.isVisible() && iSelectedRow >= 0 && (oParentPath = this.moTree.getPathForRow(iSelectedRow)) != null) {
            this.moTree.setSelectionRow(iSelectedRow);
            int iCount = ((Node)oParentPath.getLastPathComponent()).getChildCount();
            Rectangle oScrollArea = this.moTree.getRowBounds(iSelectedRow);
            Rectangle oEndArea = this.moTree.getRowBounds(iSelectedRow + iCount);
            oScrollArea.width = this.getWidth();
            oScrollArea.height = oEndArea.y + oEndArea.height - oScrollArea.y;
            this.moTree.scrollRectToVisible(oScrollArea);
        }
    }

    private void expandTree() {
        int iRow = 0;
        while (iRow < this.moTree.getRowCount()) {
            this.moTree.expandRow(iRow++);
        }
    }

    public void display() throws WorkViewException {
        this.setIcon(IconCache.getIcon("outline"));
        this.setTitle("Outline");
    }

    public void conceal() throws WorkViewException {
        this.setIcon(IconCache.getIcon("null"));
        this.setTitle("");
    }

    public boolean requestFocusInWindow() {
        return this.moTree.requestFocusInWindow();
    }

    public void addFocusListener(FocusListener aoListener) {
        if (this.moTree != null) {
            this.moTree.addFocusListener(aoListener);
        }
    }

    public void removeFocusListener(FocusListener aoListener) {
        if (this.moTree != null) {
            this.moTree.removeFocusListener(aoListener);
        }
    }

    public void setForeground(Color aoColor) {
        this.moTree.setForeground(aoColor);
    }

    public void setBackground(Color aoColor) {
        this.moTree.setBackground(aoColor);
    }

    public void setDropTarget(DropTarget aoDropTarget) {
        this.moTree.setDropTarget(aoDropTarget);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class PreferenceChangeHandler
    implements PreferenceChangeListener {
        private Preferences moLookAndFeelPreferences = PreferenceEngine.get().getPreferences("/program/lookandfeel");
        private Preferences moWorkareaPreferences = PreferenceEngine.get().getPreferences("/program/workarea");

        public PreferenceChangeHandler() {
            this.moLookAndFeelPreferences.addPreferenceChangeListener(this);
            this.moWorkareaPreferences.addPreferenceChangeListener(this);
        }

        public void init() {
            PreferenceEngine.get().initPreference(this.moLookAndFeelPreferences, "icon.size", this);
            PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "default", this);
            PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "highlight", this);
            PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "selection", this);
            PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "textfield", this);
            PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "caret", this);
        }

        public void preferenceChange(PreferenceChangeEvent aoEvent) {
            Preferences oPreferences = aoEvent.getNode();
            String sPath = oPreferences.absolutePath();
            String sKey = aoEvent.getKey();
            String sValue = aoEvent.getNewValue();
            if (oPreferences == this.moWorkareaPreferences) {
                if ("default".equals(sKey)) {
                    Outline.this.setForeground(XColor.decodeForeground(sValue));
                    Outline.this.setBackground(XColor.decodeBackground(sValue));
                } else if (!"highlight".equals(sKey) && !"textfield".equals(sKey)) {
                    if ("selection".equals(sKey)) {
                        Outline.this.moCellRenderer.setTextSelectionColor(XColor.decodeForeground(sValue));
                        Outline.this.moCellRenderer.setBackgroundSelectionColor(XColor.decodeBackground(sValue));
                    } else if ("caret".equals(sKey)) {
                        // empty if block
                    }
                }
                Outline.this.repaint();
            } else if (oPreferences == this.moLookAndFeelPreferences && "icon.size".equals(sKey)) {
                int iIconSize = Integer.parseInt(sValue);
                Outline.this.moTree.setRowHeight(iIconSize);
            }
        }
    }

    private class MouseClickHandler
    extends MouseAdapter {
        private ClickTimeout moClickTimeout = new ClickTimeout();
        private DataNode moLastNode;
        private int miClickCount;

        public void mousePressed(MouseEvent aoEvent) {
            TreePath oPath = Outline.this.moTree.getPathForLocation(aoEvent.getX(), aoEvent.getY());
            if (oPath == null) {
                return;
            }
            DataNode oNode = (DataNode)oPath.getLastPathComponent();
            if (oNode == this.moLastNode) {
                ++this.miClickCount;
            } else {
                this.moLastNode = oNode;
                this.miClickCount = 1;
            }
            if (this.miClickCount == 1) {
                if (Outline.this.moOutlineListener != null) {
                    Outline.this.moOutlineListener.selectLink(oNode);
                }
            } else if (this.miClickCount == 2) {
                if (Outline.this.moOutlineListener != null) {
                    Outline.this.moOutlineListener.selectDecl(oNode);
                }
            } else if (this.miClickCount == 3) {
                if (Outline.this.moOutlineListener != null) {
                    Outline.this.moOutlineListener.selectNode(oNode);
                }
            } else {
                this.miClickCount = 0;
            }
            this.moClickTimeout.reset();
        }

        private class ClickTimeout
        implements Runnable {
            private Thread moThread;

            private ClickTimeout() {
            }

            public void reset() {
                if (this.moThread != null) {
                    this.moThread.interrupt();
                }
                this.moThread = new Thread(this);
                this.moThread.start();
            }

            public void run() {
                try {
                    Thread.sleep(250L);
                    MouseClickHandler.this.miClickCount = 0;
                }
                catch (InterruptedException aoException) {
                    return;
                }
            }
        }
    }

    private class TreeSelectionHandler
    implements TreeSelectionListener {
        private TreeSelectionHandler() {
        }

        public void valueChanged(TreeSelectionEvent aoEvent) {
            if (Outline.this.moOutlineListener == null) {
                return;
            }
            TreePath[] aPaths = aoEvent.getPaths();
            for (int iIndex = 0; iIndex < aPaths.length; ++iIndex) {
                TreePath oPath;
                if (!aoEvent.isAddedPath(iIndex) || (oPath = aPaths[iIndex]) == null) continue;
                DataNode oNode = (DataNode)oPath.getLastPathComponent();
                Outline.this.moOutlineListener.selectLink(oNode);
                return;
            }
        }
    }

    private class SetModel
    implements Runnable {
        private OutlineModel moModel;

        public SetModel(OutlineModel aoModel) {
            this.moModel = aoModel;
            EventQueue.invokeLater(this);
        }

        public void run() {
            Outline.this.setModel(this.moModel);
        }
    }

    public class MessageHandler
    implements MessageListener {
        public void messageReceived(Message aoMessage) {
            if (aoMessage instanceof RequestOutline) {
                RequestOutline oMessage = (RequestOutline)aoMessage;
                Object oSource = oMessage.getSource();
                if (oMessage.getModel() == null) {
                    throw new RuntimeException("Outline model can not be null.");
                }
                if (oMessage.getModel() != null) {
                    Outline.this.setIcon(oMessage.getIcon());
                    Outline.this.setTitle(oMessage.getName());
                    new SetModel(oMessage.getModel());
                    Outline.this.moOutlineSource = oMessage.getSource();
                    Outline.this.moOutlineListener = oMessage.getListener();
                }
            }
        }
    }
}

