/*
 * Decompiled with CFR 0.152.
 */
package novaworx.view.outline;

import java.util.StringTokenizer;
import novaworx.log.Log;
import novaworx.view.outline.OutlineLineSource;

public class JavaTokenSource {
    private static final String DELIMITERS = "\t\n\r\f \"'*/{}()[],&|!~+-;:=\\";
    private OutlineLineSource moLineSource;
    private int miCurrentLineNumber = -1;
    private int miCurrentLineStartOffset = -1;
    private int miCurrentPosition = 0;
    private int miTokenizerOffset = 0;
    private String msLineString;
    private String msCurrentToken;
    private StringTokenizer moTokenizer;

    JavaTokenSource(OutlineLineSource aoLineSource) {
        this.moLineSource = aoLineSource;
        this.moTokenizer = new StringTokenizer(this.getNextLine(), DELIMITERS, true);
    }

    public final int getCurrentLineNumber() {
        return this.miCurrentLineNumber;
    }

    public final int getCurrentLineStartOffset() {
        return this.miCurrentLineStartOffset;
    }

    public final int getCurrentPosition() {
        return this.miCurrentPosition + this.miTokenizerOffset;
    }

    public final int getCurrentOffset() {
        return this.miCurrentLineStartOffset + this.getCurrentPosition();
    }

    public final String getCurrentLine() {
        return this.msLineString;
    }

    private final String getNextLine() {
        this.msLineString = this.moLineSource.getNextLine();
        this.miCurrentLineStartOffset = this.moLineSource.getStartOffset();
        return this.msLineString;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getNextToken() throws TokenSourceException {
        block12: while (true) {
            if (this.msCurrentToken != null) {
                this.miCurrentPosition += this.msCurrentToken.length();
            }
            while (!this.moTokenizer.hasMoreTokens() && !this.moLineSource.isExhausted()) {
                this.miCurrentPosition = 0;
                this.miTokenizerOffset = 0;
                try {
                    this.moTokenizer = new StringTokenizer(this.getNextLine(), DELIMITERS, true);
                }
                catch (Exception aoException) {
                    Log.write(2, (Throwable)aoException);
                    return null;
                }
            }
            if (!this.moTokenizer.hasMoreTokens()) {
                return null;
            }
            try {
                this.msCurrentToken = this.moTokenizer.nextToken();
            }
            catch (Exception aoException) {
                Log.write(2, (Throwable)aoException);
                return null;
            }
            int iPosition = this.miCurrentPosition + this.miTokenizerOffset;
            if (this.msCurrentToken.length() != 1) return this.msCurrentToken;
            char cChar = this.msCurrentToken.charAt(0);
            boolean bEscaped = false;
            switch (cChar) {
                case '\t': 
                case '\f': 
                case ' ': {
                    continue block12;
                }
                case '\'': {
                    while (true) {
                        if (!this.moTokenizer.hasMoreTokens()) {
                            throw new TokenSourceException("Unterminated char expression.");
                        }
                        this.msCurrentToken = this.msCurrentToken + this.moTokenizer.nextToken();
                        if (bEscaped) {
                            bEscaped = false;
                            continue;
                        }
                        if (this.msCurrentToken.charAt(this.msCurrentToken.length() - 1) == '\'') break;
                        if (this.msCurrentToken.charAt(this.msCurrentToken.length() - 1) != '\\') continue;
                        bEscaped = true;
                    }
                    Log.write(6, "Found char literal: " + this.msCurrentToken);
                    continue block12;
                }
                case '\"': {
                    while (true) {
                        if (!this.moTokenizer.hasMoreTokens()) {
                            throw new TokenSourceException("Unterminated String expression.");
                        }
                        this.msCurrentToken = this.msCurrentToken + this.moTokenizer.nextToken();
                        if (bEscaped) {
                            bEscaped = false;
                            continue;
                        }
                        if (this.msCurrentToken.charAt(this.msCurrentToken.length() - 1) == '\"') break;
                        if (this.msCurrentToken.charAt(this.msCurrentToken.length() - 1) != '\\') continue;
                        bEscaped = true;
                    }
                    Log.write(6, "Found string literal: " + this.msCurrentToken);
                    continue block12;
                }
                case '/': {
                    if (this.msLineString.length() <= iPosition + 1) return this.msCurrentToken;
                    if ('/' == this.msLineString.charAt(iPosition + 1)) {
                        this.skipRestOfLine();
                        this.msCurrentToken = null;
                        continue block12;
                    }
                    if ('*' != this.msLineString.charAt(iPosition + 1)) return this.msCurrentToken;
                    this.miTokenizerOffset = this.msLineString.indexOf("*/", iPosition + 2);
                    if (this.miTokenizerOffset == -1) {
                        do {
                            if (this.moLineSource.isExhausted()) {
                                throw new TokenSourceException("Unterminated multi-line comment.");
                            }
                            this.getNextLine();
                            if (this.msLineString == null) {
                                throw new TokenSourceException("Unterminated multi-line comment.");
                            }
                            this.miTokenizerOffset = this.msLineString.indexOf("*/");
                        } while (this.miTokenizerOffset == -1);
                    }
                    Log.write(6, "Found end of mulit-line comment.");
                    this.miTokenizerOffset += 2;
                    if (this.miTokenizerOffset >= this.msLineString.length()) {
                        if (this.moLineSource.isExhausted()) {
                            return null;
                        }
                        this.getNextLine();
                        if (this.msLineString == null) {
                            return null;
                        }
                        this.miTokenizerOffset = 0;
                    }
                    this.miCurrentPosition = 0;
                    try {
                        this.moTokenizer = new StringTokenizer(this.msLineString.substring(this.miTokenizerOffset), DELIMITERS, true);
                        this.msCurrentToken = null;
                    }
                    catch (Exception aoException) {
                        Log.write(2, (Throwable)aoException);
                        return null;
                    }
                }
                continue block12;
            }
            break;
        }
        return this.msCurrentToken;
    }

    public void skipRestOfLine() {
        this.miCurrentPosition = 0;
        this.miTokenizerOffset = 0;
        do {
            if (this.moLineSource.isExhausted()) {
                while (this.moTokenizer.hasMoreTokens()) {
                    this.moTokenizer.nextToken();
                }
                return;
            }
            this.moTokenizer = new StringTokenizer(this.getNextLine(), DELIMITERS, true);
        } while (!this.moTokenizer.hasMoreTokens());
    }

    public final boolean skipUntil(String asSkipToToken) throws TokenSourceException {
        String sCurrentToken = this.getNextToken();
        int iBraceCount = 0;
        int iParenCount = 0;
        while (sCurrentToken != null) {
            if (asSkipToToken.equals(sCurrentToken) && iBraceCount == 0 && iParenCount == 0) {
                return true;
            }
            if ("{".equals(sCurrentToken)) {
                ++iBraceCount;
            } else if ("(".equals(sCurrentToken)) {
                ++iParenCount;
            } else if ("}".equals(sCurrentToken)) {
                --iBraceCount;
            } else if (")".equals(sCurrentToken)) {
                --iParenCount;
            }
            if (iBraceCount < 0 || iParenCount < 0) break;
            sCurrentToken = this.getNextToken();
        }
        return false;
    }

    public final String skipUntilContaining(String asSkipToToken) throws Exception {
        String sCurrentToken = this.getNextToken();
        int iBraceCount = 0;
        int iParenCount = 0;
        while (sCurrentToken != null) {
            if (asSkipToToken.indexOf(sCurrentToken) != -1 && iBraceCount == 0 && iParenCount == 0) {
                return sCurrentToken;
            }
            if ("{".equals(sCurrentToken)) {
                ++iBraceCount;
            } else if ("(".equals(sCurrentToken)) {
                ++iParenCount;
            } else if ("}".equals(sCurrentToken)) {
                --iBraceCount;
            } else if (")".equals(sCurrentToken)) {
                --iParenCount;
            }
            if (iBraceCount < 0 || iParenCount < 0) break;
            sCurrentToken = this.getNextToken();
        }
        return null;
    }

    static class TokenSourceException
    extends Exception {
        static final String MESSAGE_UNTERM_COMMENT = "Unterminated multi-line comment.";
        static final String MESSAGE_STRING_EXPR = "Unterminated String expression.";
        static final String MESSAGE_CHAR_EXPR = "Unterminated char expression.";

        TokenSourceException(String message) {
            super(message);
        }
    }
}

