/*
 * Decompiled with CFR 0.152.
 */
package novaworx.view.outline;

import java.awt.Color;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import novaworx.data.DataNode;
import novaworx.data.Node;
import novaworx.gui.IconCache;
import novaworx.log.Log;
import novaworx.view.outline.JavaMutableModifier;
import novaworx.view.outline.JavaTokenSource;
import novaworx.view.outline.OutlineLineSource;
import novaworx.view.outline.OutlineParser;

public class JavaOutlineParser
implements OutlineParser {
    private static final String PRIMITIVES = ":boolean:byte:short:char:int:long:float:double:";
    private static final String MODIFIERS = ":abstract:final:native:private:protected:public:static:strictfp:synchronized:transient:volatile:";
    private static final String PACKAGE = "package";
    private static final String IMPORT = "import";
    private static final String CLASS = "class";
    private static final String INTERFACE = "interface";
    private static final String FIELD = "field";
    private static final String INITIALIZER = "initializer";
    private static final String CONSTRUCTOR = "constructor";
    private static final String METHOD = "method";
    private static final String NESTED_CLASS = "nested.class";
    private static final String NESTED_INTERFACE = "nested.interface";
    private DataNode moRoot;
    private Stack moNodeStack;
    private OutlineLineSource moLineSource;
    private JavaTokenSource moTokenizer;
    private String msToken;
    private int miOffset;
    private boolean mbExceptionThrown;
    private int miMask;
    private int miStart;
    private int miLink;
    private int miEnd;
    private String msPublicTopLevel;
    private DataNode moImports;

    public synchronized Node parse(OutlineLineSource aoSource) {
        return this.parse(aoSource, new DataNode(), 0, aoSource.getLineCount() - 1);
    }

    public synchronized Node parse(OutlineLineSource aoSource, DataNode aoRoot, int aiStartIndex, int aiStopIndex) {
        if (aoSource == null) {
            return null;
        }
        this.moLineSource = aoSource;
        this.moRoot = aoRoot;
        this.moTokenizer = new JavaTokenSource(this.moLineSource);
        this.moNodeStack = new Stack();
        this.moNodeStack.push(this.moRoot);
        this.getNextToken();
        while (this.msToken != null) {
            this.parseNext();
            this.getNextToken();
        }
        return this.moRoot;
    }

    private void parseNext() {
        this.miStart = this.miOffset;
        this.miLink = this.miOffset;
        if (PACKAGE.equals(this.msToken)) {
            this.parsePackage();
        } else if (IMPORT.equals(this.msToken)) {
            this.parseImport();
        } else {
            this.miMask = 0;
            while (this.msToken != null && this.isModifier(this.msToken)) {
                this.setModifier(this.miMask, this.msToken);
                this.getNextToken();
            }
            if (CLASS.equals(this.msToken) || INTERFACE.equals(this.msToken)) {
                this.parseClass();
            } else if ("{".equals(this.msToken)) {
                this.parseInitializer();
            } else {
                String sType = this.msToken;
                this.getNextToken();
                while ("[".equals(this.msToken) || "]".equals(this.msToken)) {
                    sType = sType + this.msToken;
                    this.getNextToken();
                }
                if ("(".equals(this.msToken)) {
                    this.parseConstructor(sType);
                } else {
                    String sName = this.msToken;
                    this.getNextToken();
                    while ("[".equals(this.msToken) || "]".equals(this.msToken)) {
                        sType = sType + this.msToken;
                        this.getNextToken();
                    }
                    if (",".equals(this.msToken) || "=".equals(this.msToken) || ";".equals(this.msToken)) {
                        this.parseField(sType, sName);
                    } else if ("(".equals(this.msToken)) {
                        this.parseMethod(sType, sName);
                    } else {
                        this.addMessage("Could not determine Java node: " + this.msToken, this.miOffset);
                    }
                }
            }
        }
    }

    private void parsePackage() {
        int iStart = this.miOffset;
        this.getNextToken();
        StringBuffer oBuffer = new StringBuffer();
        while (this.msToken != null && !";".equals(this.msToken)) {
            oBuffer.append(this.msToken);
            this.getNextToken();
        }
        this.miEnd = this.miOffset + 1;
        String sPackageName = oBuffer.toString();
        DataNode oPackage = new DataNode();
        oPackage.setResource("node.type", PACKAGE);
        oPackage.setResource("name", sPackageName);
        oPackage.setResource("display.name", sPackageName);
        oPackage.setResource("display.icon", IconCache.getIcon("java.package"));
        this.createPositions(oPackage);
        ((DataNode)this.moNodeStack.peek()).add(oPackage);
    }

    private void parseImport() {
        if (this.moImports == null) {
            this.moImports = new DataNode();
            this.moImports.setResource("node.type", IMPORT);
            this.moImports.setResource("name", "import ...");
            this.moImports.setResource("display.name", "import ...");
            this.moImports.setResource("display.icon", IconCache.getIcon("java.import"));
            this.moImports.setResource("start", this.createPosition(this.miStart));
            this.moImports.setResource("link", this.createPosition(this.miLink));
            ((DataNode)this.moNodeStack.peek()).add(this.moImports);
        }
        this.getNextToken();
        StringBuffer oBuffer = new StringBuffer();
        while (this.msToken != null && !";".equals(this.msToken)) {
            oBuffer.append(this.msToken);
            this.getNextToken();
        }
        this.miEnd = this.miOffset + 1;
        String sImportName = oBuffer.toString();
        this.moImports.setResource("end", this.createPosition(this.miEnd));
    }

    private void parseClass() {
        DataNode oParent = (DataNode)this.moNodeStack.peek();
        String sParentType = (String)oParent.getResource("type");
        boolean bNested = CLASS.equals(sParentType) || INTERFACE.equals(sParentType);
        String sNodeType = CLASS.equals(this.msToken) ? CLASS : INTERFACE;
        this.getNextToken();
        String sClassName = this.msToken;
        if (JavaMutableModifier.isPublic(this.miMask)) {
            if (this.msPublicTopLevel == null) {
                this.msPublicTopLevel = sClassName;
            } else {
                this.addMessage("Can not have more than one public class or interface.", this.miOffset);
            }
        }
        String sIcon = "error";
        if (sNodeType == CLASS) {
            sIcon = bNested ? "java.nested.class" : "java.class";
        } else if (sNodeType == INTERFACE) {
            sIcon = bNested ? "java.nested.interface" : "java.interface";
        }
        DataNode oClass = new DataNode();
        oClass.setResource("type", sNodeType);
        oClass.setResource("name", sClassName);
        oClass.setResource("display.name", sClassName);
        oClass.setResource("display.icon", IconCache.getIcon(sIcon));
        oClass.setResource("start", this.createPosition(this.miStart));
        oClass.setResource("link", this.createPosition(this.miLink));
        ((DataNode)this.moNodeStack.peek()).add(oClass);
        this.moNodeStack.push(oClass);
        this.getNextToken();
        if ("extends".equals(this.msToken)) {
            this.getNextToken();
            oClass.setResource("extends", this.msToken);
            this.getNextToken();
        }
        if ("implements".equals(this.msToken)) {
            this.getNextToken();
            while (this.msToken != null && !"{".equals(this.msToken)) {
                this.getNextToken();
            }
        }
        if ("{".equals(this.msToken)) {
            this.getNextToken();
            while (this.msToken != null && !"}".equals(this.msToken)) {
                this.parseNext();
                this.getNextToken();
            }
            if ("}".equals(this.msToken)) {
                this.moNodeStack.pop();
                this.miEnd = this.miOffset + 1;
                oClass.setResource("end", this.createPosition(this.miEnd));
            }
            if (";".equals(this.msToken)) {
                this.getNextToken();
            }
        } else {
            this.addMessage("Invalid class definition.", this.miOffset);
        }
    }

    private void parseField(String asType, String asName) {
        if ("[".equals(this.msToken)) {
            this.getNextToken();
            if ("]".equals(this.msToken)) {
                this.getNextToken();
                asType = asType + "[]";
            } else {
                this.addMessage("Invalid field type.", this.miOffset);
            }
        }
        DataNode oField = new DataNode();
        oField.setResource("type", FIELD);
        oField.setResource("field.type", asType);
        oField.setResource("display.name", asName);
        oField.setResource("display.icon", IconCache.getIcon("java.field"));
        ((DataNode)this.moNodeStack.peek()).add(oField);
        if ("=".equals(this.msToken)) {
            while (this.msToken != null && !";".equals(this.msToken)) {
                this.getNextToken();
            }
        }
        this.miEnd = this.miOffset + 1;
        this.createPositions(oField);
        if (",".equals(this.msToken)) {
            this.getNextToken();
            String sName = this.msToken;
            if (!"=".equals(this.msToken) && !";".equals(this.msToken)) {
                this.miStart = this.miOffset;
                this.miLink = this.miOffset;
                this.getNextToken();
                this.parseField(asType, sName);
            }
        }
    }

    private void parseInitializer() {
        DataNode oInitializer = new DataNode();
        oInitializer.setResource("type", INITIALIZER);
        oInitializer.setResource("display.name", "<Initializer>");
        oInitializer.setResource("display.icon", IconCache.getIcon("java.initializer"));
        ((DataNode)this.moNodeStack.peek()).add(oInitializer);
        this.skipUntil("}");
        this.miEnd = this.miOffset + 1;
        this.createPositions(oInitializer);
    }

    private void parseConstructor(String asName) {
        DataNode oParent = (DataNode)this.moNodeStack.peek();
        String sParentName = (String)oParent.getResource("name");
        DataNode oConstructor = new DataNode();
        oConstructor.setResource("type", CONSTRUCTOR);
        oConstructor.setResource("display.name", asName);
        oConstructor.setResource("display.icon", IconCache.getIcon("java.constructor"));
        ((DataNode)this.moNodeStack.peek()).add(oConstructor);
        this.skipUntil(")");
        if (sParentName != null && !sParentName.equals(asName)) {
            this.addMessage("Constructor name does not match class name.", this.miLink);
        }
        while (this.msToken != null && !"{".equals(this.msToken)) {
            this.getNextToken();
        }
        if ("{".equals(this.msToken)) {
            this.skipUntil("}");
        } else {
            this.addMessage("Constructor without body.", this.miLink);
        }
        this.miEnd = this.miOffset + 1;
        this.createPositions(oConstructor);
    }

    private void parseMethod(String asType, String asName) {
        DataNode oMethod = new DataNode();
        oMethod.setResource("type", METHOD);
        oMethod.setResource("display.name", asName);
        oMethod.setResource("display.icon", IconCache.getIcon("java.method"));
        ((DataNode)this.moNodeStack.peek()).add(oMethod);
        this.skipUntil(")");
        this.getNextToken();
        while (this.msToken != null && !"{".equals(this.msToken) && !";".equals(this.msToken)) {
            this.getNextToken();
        }
        if (";".equals(this.msToken)) {
            this.miEnd = this.miOffset + 1;
            this.createPositions(oMethod);
            return;
        }
        if ("{".equals(this.msToken)) {
            this.skipUntil("}");
        }
        this.miEnd = this.miOffset + 1;
        this.createPositions(oMethod);
    }

    private void addMessage(String asMessage, int aiOffset) {
        DataNode oMessage = new DataNode();
        oMessage.setResource("display.name", asMessage);
        oMessage.setResource("display.icon", IconCache.getIcon("error"));
        oMessage.setResource("link", this.createPosition(this.miOffset));
        oMessage.setResource("display.foreground", Color.RED);
        ((DataNode)this.moNodeStack.peek()).add(oMessage);
    }

    private void getNextToken() {
        try {
            this.msToken = this.moTokenizer.getNextToken();
            this.miOffset = this.moTokenizer.getCurrentOffset();
        }
        catch (Exception aoException) {
            Log.write(2, (Throwable)aoException);
            this.mbExceptionThrown = true;
            String sMessage = aoException.getMessage();
            if (sMessage == null) {
                sMessage = aoException.getClass().getName();
            }
            DataNode oMessage = new DataNode();
            oMessage.setResource("display.name", sMessage);
            oMessage.setResource("display.icon", IconCache.getIcon("error"));
            ((DataNode)this.moNodeStack.peek()).add(oMessage);
        }
    }

    private boolean skipUntil(String asSkipTo) {
        boolean bReturn = false;
        try {
            bReturn = this.moTokenizer.skipUntil(asSkipTo);
            this.miOffset = this.moTokenizer.getCurrentOffset();
        }
        catch (Exception aoException) {
            Log.write(2, (Throwable)aoException);
            this.mbExceptionThrown = true;
            String sMessage = aoException.getMessage();
            if (sMessage == null) {
                sMessage = aoException.getClass().getName();
            }
            DataNode oMessage = new DataNode();
            oMessage.setResource("display.name", sMessage);
            oMessage.setResource("display.icon", IconCache.getIcon("about"));
            ((DataNode)this.moNodeStack.peek()).add(oMessage);
        }
        return bReturn;
    }

    private void createPositions(DataNode aoNode) {
        aoNode.setResource("start", this.createPosition(this.miStart));
        aoNode.setResource("link", this.createPosition(this.miLink));
        aoNode.setResource("end", this.createPosition(this.miEnd));
    }

    private Object createPosition(int aiOffset) {
        Object oReturn = null;
        try {
            oReturn = this.moLineSource.createPosition(aiOffset);
        }
        catch (BadLocationException aoException) {
            Log.write(2, (Throwable)aoException);
        }
        return oReturn;
    }

    private boolean isModifier(String asToken) {
        return asToken == null ? false : MODIFIERS.indexOf(asToken) >= 0;
    }

    private int setModifier(int aiMask, String asToken) {
        if ("abstract".equals(asToken)) {
            return JavaMutableModifier.setAbstract(aiMask);
        }
        if ("final".equals(asToken)) {
            return JavaMutableModifier.setFinal(aiMask);
        }
        if ("native".equals(asToken)) {
            return JavaMutableModifier.setNative(aiMask);
        }
        if ("private".equals(asToken)) {
            return JavaMutableModifier.setPrivate(aiMask);
        }
        if ("protected".equals(asToken)) {
            return JavaMutableModifier.setProtected(aiMask);
        }
        if ("public".equals(asToken)) {
            return JavaMutableModifier.setPublic(aiMask);
        }
        if ("static".equals(asToken)) {
            return JavaMutableModifier.setStatic(aiMask);
        }
        if ("strictfp".equals(asToken)) {
            return JavaMutableModifier.setStrict(aiMask);
        }
        if ("synchronized".equals(asToken)) {
            return JavaMutableModifier.setSynchronized(aiMask);
        }
        if ("transient".equals(asToken)) {
            return JavaMutableModifier.setTransient(aiMask);
        }
        if ("volatile".equals(asToken)) {
            return JavaMutableModifier.setVolatile(aiMask);
        }
        return aiMask;
    }
}

