/*
 * Decompiled with CFR 0.152.
 */
package novaworx.view.editor;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.net.URI;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.TextAction;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import novaworx.GuiEngine;
import novaworx.MainEngine;
import novaworx.PreferenceEngine;
import novaworx.Startup;
import novaworx.WorkArea;
import novaworx.WorkFrame;
import novaworx.WorkPane;
import novaworx.WorkView;
import novaworx.WorkViewEngine;
import novaworx.WorkViewException;
import novaworx.bus.Message;
import novaworx.bus.MessageBus;
import novaworx.bus.MessageListener;
import novaworx.data.Node;
import novaworx.data.NodeEvent;
import novaworx.gui.ActionLibrary;
import novaworx.gui.IconCache;
import novaworx.gui.InputListener;
import novaworx.gui.ProgramAction;
import novaworx.gui.UtilityBar;
import novaworx.log.Log;
import novaworx.message.RequestOutline;
import novaworx.message.RequestResourceClose;
import novaworx.message.RequestResourceLoad;
import novaworx.message.RequestResourceSave;
import novaworx.message.ResourceClose;
import novaworx.message.ResourceSelect;
import novaworx.message.ResourceUnselect;
import novaworx.resource.Resource;
import novaworx.resource.ResourceAdapter;
import novaworx.resource.ResourceEvent;
import novaworx.resource.ResourceException;
import novaworx.resource.ResourceUndoManager;
import novaworx.swing.XColor;
import novaworx.swing.XLabel;
import novaworx.swing.XPanel;
import novaworx.syntax.SyntaxFactory;
import novaworx.textpane.SyntaxDocument;
import novaworx.textpane.SyntaxGutter;
import novaworx.textpane.SyntaxGutterBase;
import novaworx.textpane.SyntaxStyle;
import novaworx.textpane.SyntaxTextPane;
import novaworx.util.thread.ThreadPool;
import novaworx.view.outline.OutlineListener;
import novaworx.view.outline.OutlineModel;
import novaworx.view.outline.OutlineModelFactory;
import novaworx.view.preference.SyntaxStylePreferenceType;
import novaworx.viewarea.ViewPaneAdapter;
import novaworx.viewarea.ViewPaneEvent;

public class Editor
extends WorkView {
    private static final int MAX_DOCUMENT_LOAD_WAIT_TIME = 5000;
    private static final String EDITOR_DOCUMENT = "editor.document";
    private static final String EDITOR_SAVED_HASHCODE = "editor.saved.hashcode";
    private static final String BLANK_PANEL_CARD = "blank.panel.card";
    private static final String MESSAGE_LABEL_CARD = "message.label.card";
    private static final String TEXT_SCROLLER_CARD = "text.scroller.card";
    private static Editor moLastSelected;
    private static String msSearchExpression;
    private Resource moCurrentResource;
    private int miSavedHashCode;
    private XPanel moBlankPanel;
    private SyntaxTextPane moEditor;
    private SyntaxGutter moGutter;
    private SyntaxGutterBase moGutterBase;
    private XLabel moMessageLabel;
    private JScrollPane moTextScroller;
    private CardLayout moCardLayout;
    private SyntaxDocument moBlankDocument;
    private boolean mbInheritProgramColors;
    private ResourceHandler moResourceHandler;
    private OutlineHandler moOutlineHandler;
    private DocumentHandler moDocumentHandler;
    private ViewPaneHandler moViewPaneHandler;
    private MessageHandler moMessageHandler;
    private PreferenceChangeHandler moPreferenceChangeHandler;
    static /* synthetic */ Class class$novaworx$message$ResourceSelect;
    static /* synthetic */ Class class$novaworx$message$ResourceUnselect;
    static /* synthetic */ Class class$novaworx$message$ResourceClose;

    public Editor() {
        if (moLastSelected == null) {
            moLastSelected = this;
        }
        this.moBlankDocument = new SyntaxDocument();
        this.moResourceHandler = new ResourceHandler();
        this.moOutlineHandler = new OutlineHandler();
        this.moDocumentHandler = new DocumentHandler();
        this.moViewPaneHandler = new ViewPaneHandler();
        this.moPreferenceChangeHandler = new PreferenceChangeHandler();
        this.moEditor = new SyntaxTextPane();
        this.moEditor.setDocument(this.moBlankDocument);
        this.moEditor.setOpaque(false);
        this.moEditor.setLineHighlight(true);
        this.moEditor.setBracketHighlight(true);
        this.moEditor.addFocusListener(new FocusHandler());
        this.moEditor.getCaret().addChangeListener(new CaretChangeHandler());
        this.moGutter = new SyntaxGutter(this.moEditor);
        this.moGutter.setOpaque(false);
        this.moGutterBase = new SyntaxGutterBase(this.moGutter);
        this.moTextScroller = new JScrollPane(this.moEditor);
        this.moTextScroller.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.moTextScroller.setOpaque(false);
        this.moTextScroller.getViewport().setOpaque(false);
        this.moTextScroller.setRowHeaderView(this.moGutter);
        this.moTextScroller.getRowHeader().setOpaque(false);
        this.moGutterBase.setBackground(this.moTextScroller.getHorizontalScrollBar().getBackground());
        this.moTextScroller.setCorner("LOWER_LEFT_CORNER", this.moGutterBase);
        this.moBlankPanel = new XPanel();
        this.moMessageLabel = new XLabel("");
        this.moMessageLabel.setBackground(XColor.CLEAR);
        this.moMessageLabel.setFont(this.moMessageLabel.getFont().deriveFont((float)this.moMessageLabel.getFont().getSize() * 2.0f));
        this.moMessageLabel.setHorizontalAlignment(0);
        this.moCardLayout = new CardLayout();
        this.setLayout(this.moCardLayout);
        this.add((Component)this.moBlankPanel, BLANK_PANEL_CARD);
        this.add((Component)this.moMessageLabel, MESSAGE_LABEL_CARD);
        this.add((Component)this.moTextScroller, TEXT_SCROLLER_CARD);
        this.setTitle("Editor");
        this.setIcon(IconCache.getIcon("editor"));
        ActionMap oActionMap = this.moEditor.getActionMap();
        oActionMap.put("save", new SaveAction());
        oActionMap.put("undo", new UndoAction());
        oActionMap.put("redo", new RedoAction());
        oActionMap.put("jump.to.line", new JumpToLineAction());
        oActionMap.put("search.quick", new QuickFindAction());
        oActionMap.put("search.next", new FindNextAction());
        oActionMap.put("search.previous", new FindPreviousAction());
        this.moMessageHandler = new MessageHandler();
        MessageBus.registerListener(this.moMessageHandler, class$novaworx$message$ResourceSelect == null ? (class$novaworx$message$ResourceSelect = Editor.class$("novaworx.message.ResourceSelect")) : class$novaworx$message$ResourceSelect);
        MessageBus.registerListener(this.moMessageHandler, class$novaworx$message$ResourceUnselect == null ? (class$novaworx$message$ResourceUnselect = Editor.class$("novaworx.message.ResourceUnselect")) : class$novaworx$message$ResourceUnselect);
        MessageBus.registerListener(this.moMessageHandler, class$novaworx$message$ResourceClose == null ? (class$novaworx$message$ResourceClose = Editor.class$("novaworx.message.ResourceClose")) : class$novaworx$message$ResourceClose);
        this.moPreferenceChangeHandler.init();
    }

    public void display() throws WorkViewException {
        this.getWorkPane().addViewPaneListener(this.moViewPaneHandler);
        ActionMap oActionMap = this.moEditor.getActionMap();
        ((ProgramAction)ActionLibrary.get("save")).pushListener(oActionMap.get("save"), false);
        ((ProgramAction)ActionLibrary.get("undo")).pushListener(oActionMap.get("undo"), false);
        ((ProgramAction)ActionLibrary.get("redo")).pushListener(oActionMap.get("redo"), false);
        ((ProgramAction)ActionLibrary.get("cut")).pushListener(oActionMap.get("cut-to-clipboard"), false);
        ((ProgramAction)ActionLibrary.get("copy")).pushListener(oActionMap.get("copy-to-clipboard"), false);
        ((ProgramAction)ActionLibrary.get("paste")).pushListener(oActionMap.get("paste-from-clipboard"), false);
        ((ProgramAction)ActionLibrary.get("delete")).pushListener(oActionMap.get("delete-next"), false);
        ((ProgramAction)ActionLibrary.get("select.all")).pushListener(oActionMap.get("select-all"), false);
        ((ProgramAction)ActionLibrary.get("search.quick")).pushListener(oActionMap.get("search.quick"));
        ((ProgramAction)ActionLibrary.get("search.next")).pushListener(oActionMap.get("search.next"));
        ((ProgramAction)ActionLibrary.get("search.previous")).pushListener(oActionMap.get("search.previous"));
        ((ProgramAction)ActionLibrary.get("jump.to.line")).pushListener(oActionMap.get("jump.to.line"));
        this.showOutline(this.moCurrentResource);
        new UpdateActions(this.moCurrentResource);
    }

    public void select() throws WorkViewException {
        moLastSelected = this;
        this.showOutline(this.moCurrentResource);
        new UpdateActions(this.moCurrentResource);
    }

    public void unselect() throws WorkViewException {
    }

    public void conceal() throws WorkViewException {
        OutlineModel oOutlineModel;
        if (this.moCurrentResource != null && (oOutlineModel = (OutlineModel)this.moCurrentResource.getResource("resource.outline.model")) != null) {
            oOutlineModel.setVisible(false);
        }
        ActionMap oActionMap = this.moEditor.getActionMap();
        ((ProgramAction)ActionLibrary.get("save")).pullListener(oActionMap.get("save"));
        ((ProgramAction)ActionLibrary.get("undo")).pullListener(oActionMap.get("undo"));
        ((ProgramAction)ActionLibrary.get("redo")).pullListener(oActionMap.get("redo"));
        ((ProgramAction)ActionLibrary.get("cut")).pullListener(oActionMap.get("cut-to-clipboard"));
        ((ProgramAction)ActionLibrary.get("copy")).pullListener(oActionMap.get("copy-to-clipboard"));
        ((ProgramAction)ActionLibrary.get("paste")).pullListener(oActionMap.get("paste-from-clipboard"));
        ((ProgramAction)ActionLibrary.get("delete")).pullListener(oActionMap.get("delete-next"));
        ((ProgramAction)ActionLibrary.get("select.all")).pullListener(oActionMap.get("select-all"));
        ((ProgramAction)ActionLibrary.get("search.quick")).pullListener(oActionMap.get("search.quick"));
        ((ProgramAction)ActionLibrary.get("search.next")).pullListener(oActionMap.get("search.next"));
        ((ProgramAction)ActionLibrary.get("search.previous")).pullListener(oActionMap.get("search.previous"));
        ((ProgramAction)ActionLibrary.get("jump.to.line")).pullListener(oActionMap.get("jump.to.line"));
        this.getWorkPane().removeViewPaneListener(this.moViewPaneHandler);
    }

    public void deallocate() throws WorkViewException {
        WorkViewEngine.get().returnView(this);
    }

    public void setResource(Resource aoResource) {
        if (aoResource == this.moCurrentResource) {
            return;
        }
        if (aoResource != null && !aoResource.isLoaded()) {
            this.loadResource(aoResource);
        } else {
            this.showResource(aoResource);
        }
    }

    private void loadResource(Resource aoResource) {
        new LoadResource(aoResource);
    }

    private void showResource(Resource aoResource) {
        new ShowResource(aoResource);
    }

    private void showOutline(Resource aoResource) {
        if (aoResource != null) {
            Icon oIcon = (Icon)aoResource.getResource("display.icon");
            String sName = (String)aoResource.getResource("display.name");
            OutlineModel oOutlineModel = (OutlineModel)aoResource.getResource("resource.outline.model");
            if (oOutlineModel != null) {
                MessageBus.send(new RequestOutline(this, oIcon, sName, oOutlineModel, this.moOutlineHandler));
            }
        }
    }

    public void showMessage(String asText) {
        new ShowMessage(asText);
    }

    public void setAntiAlias(boolean abAntiAlias) {
        this.moEditor.setAntiAlias(abAntiAlias);
    }

    public boolean isAntiAlias() {
        return this.moEditor.isAntiAlias();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateModifiedFlag(Resource aoResource) {
        Resource resource = aoResource;
        synchronized (resource) {
            int iCurrentHashCode = this.getCurrentHashCode();
            boolean bModified = iCurrentHashCode != this.miSavedHashCode;
            aoResource.setModified(bModified);
        }
    }

    private synchronized int getCurrentHashCode() {
        return this.moEditor.getText().hashCode();
    }

    private synchronized void updateSavedHashCode() {
        this.miSavedHashCode = this.getCurrentHashCode();
    }

    public boolean requestFocusInWindow() {
        return this.moEditor.requestFocusInWindow();
    }

    public boolean hasFocus() {
        return this.moEditor.hasFocus();
    }

    public void addFocusListener(FocusListener aoListener) {
        if (this.moEditor != null) {
            this.moEditor.addFocusListener(aoListener);
        }
    }

    public void removeFocusListener(FocusListener aoListener) {
        if (this.moEditor != null) {
            this.moEditor.removeFocusListener(aoListener);
        }
    }

    public void setDropTarget(DropTarget aoDropTarget) {
        if (this.moCurrentResource == null) {
            super.setDropTarget(aoDropTarget);
        } else {
            this.moEditor.setDropTarget(aoDropTarget);
        }
    }

    private void showCard(String asCard) {
        this.moCardLayout.show(this, asCard);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Log.write(6, "Loading syntax definitions...");
        String sHomeDirectory = Startup.getHomeDirectory();
        File oEtc = new File(sHomeDirectory, "etc");
        File oCatalog = new File(oEtc, "syntax.catalog.xml");
        SyntaxFactory.setSyntaxCatalog(oCatalog);
        if (!SyntaxFactory.loadSyntaxes()) {
            Log.write(2, "Failed to load syntax definitions.");
        }
        Log.write(6, "Syntax definitions loaded.");
        ActionLibrary.add("indent", "Indent", IconCache.getIcon("indent"), 73, "a-right");
        ActionLibrary.add("unindent", "Unindent", IconCache.getIcon("unindent"), 85, "a-left");
    }

    private class PreferenceChangeHandler
    implements PreferenceChangeListener {
        private static final String TEXT_EDITOR_PREFERENCES = "/view/texteditor";
        private static final String TEXT_INDENT_PREFERENCES = "/view/texteditor/indent";
        private static final String TEXT_GUTTER_PREFERENCES = "/view/texteditor/gutter";
        private static final String TEXT_GUTTER_COLOR_PREFERENCES = "/view/texteditor/gutter/color";
        private static final String TEXT_SYNTAX_COLOR_PREFERENCES = "/view/texteditor/syntax/color";
        private static final String TEXT_SYNTAX_STYLE_PREFERENCES = "/view/texteditor/syntax/style";
        private Preferences moWorkareaPreferences = PreferenceEngine.get().getPreferences("/program/workarea");
        private Preferences moEditorPreferences = PreferenceEngine.get().getPreferences("/view/texteditor");
        private Preferences moIndentPreferences = PreferenceEngine.get().getPreferences("/view/texteditor/indent");
        private Preferences moGutterPreferences = PreferenceEngine.get().getPreferences("/view/texteditor/gutter");
        private Preferences moGutterColorPreferences = PreferenceEngine.get().getPreferences("/view/texteditor/gutter/color");
        private Preferences moSyntaxColorPreferences = PreferenceEngine.get().getPreferences("/view/texteditor/syntax/color");
        private Preferences moSyntaxStylePreferences = PreferenceEngine.get().getPreferences("/view/texteditor/syntax/style");

        public PreferenceChangeHandler() {
            this.moWorkareaPreferences.addPreferenceChangeListener(this);
            this.moEditorPreferences.addPreferenceChangeListener(this);
            this.moIndentPreferences.addPreferenceChangeListener(this);
            this.moGutterPreferences.addPreferenceChangeListener(this);
            this.moGutterColorPreferences.addPreferenceChangeListener(this);
            this.moSyntaxColorPreferences.addPreferenceChangeListener(this);
            this.moSyntaxStylePreferences.addPreferenceChangeListener(this);
        }

        public void init() {
            PreferenceEngine.get().initPreference(this.moEditorPreferences, "font", this);
            PreferenceEngine.get().initPreference(this.moIndentPreferences, "auto", this);
            PreferenceEngine.get().initPreference(this.moIndentPreferences, "indentsize", this);
            PreferenceEngine.get().initPreference(this.moIndentPreferences, "tabsize", this);
            PreferenceEngine.get().initPreference(this.moEditorPreferences, "currentline", this);
            PreferenceEngine.get().initPreference(this.moEditorPreferences, "bracketmatch", this);
            PreferenceEngine.get().initPreference(this.moEditorPreferences, "antialias", this);
            PreferenceEngine.get().initPreference(this.moEditorPreferences, "caret.on", this);
            PreferenceEngine.get().initPreference(this.moEditorPreferences, "caret.off", this);
            PreferenceEngine.get().initPreference(this.moEditorPreferences, "caret.block", this);
            PreferenceEngine.get().initPreference(this.moGutterPreferences, "linenumberfont", this);
            PreferenceEngine.get().initPreference(this.moGutterPreferences, "linenumberalignment", this);
            PreferenceEngine.get().initPreference(this.moGutterPreferences, "lineinterval", this);
            PreferenceEngine.get().initPreference(this.moGutterPreferences, "currentline", this);
            PreferenceEngine.get().initPreference(this.moGutterPreferences, "selection", this);
            PreferenceEngine.get().initPreference(this.moGutterPreferences, "bracketscope", this);
            PreferenceEngine.get().initPreference(this.moGutterPreferences, "lineintervalspacing", this);
            PreferenceEngine.get().initPreference(this.moGutterPreferences, "lineintervalfont", this);
            PreferenceEngine.get().initPreference(this.moGutterColorPreferences, "default", this);
            PreferenceEngine.get().initPreference(this.moGutterColorPreferences, "interval", this);
            PreferenceEngine.get().initPreference(this.moGutterColorPreferences, "currentline", this);
            PreferenceEngine.get().initPreference(this.moGutterColorPreferences, "selection", this);
            PreferenceEngine.get().initPreference(this.moGutterColorPreferences, "bracketscope", this);
            PreferenceEngine.get().initPreference(this.moGutterColorPreferences, "divider", this);
            PreferenceEngine.get().initPreference(this.moSyntaxColorPreferences, "inherit", this);
            PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "caret", this);
            PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "default", this);
            PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "selection", this);
            PreferenceEngine.get().initPreference(this.moSyntaxColorPreferences, "caret", this);
            PreferenceEngine.get().initPreference(this.moSyntaxColorPreferences, "default", this);
            PreferenceEngine.get().initPreference(this.moSyntaxColorPreferences, "selection", this);
            PreferenceEngine.get().initPreference(this.moSyntaxColorPreferences, "currentline", this);
            PreferenceEngine.get().initPreference(this.moSyntaxColorPreferences, "bracketmatch", this);
            PreferenceEngine.get().initPreference(this.moSyntaxStylePreferences, "comment1", this);
            PreferenceEngine.get().initPreference(this.moSyntaxStylePreferences, "comment2", this);
            PreferenceEngine.get().initPreference(this.moSyntaxStylePreferences, "comment3", this);
            PreferenceEngine.get().initPreference(this.moSyntaxStylePreferences, "digit", this);
            PreferenceEngine.get().initPreference(this.moSyntaxStylePreferences, "literal1", this);
            PreferenceEngine.get().initPreference(this.moSyntaxStylePreferences, "literal2", this);
            PreferenceEngine.get().initPreference(this.moSyntaxStylePreferences, "keyword1", this);
            PreferenceEngine.get().initPreference(this.moSyntaxStylePreferences, "keyword2", this);
            PreferenceEngine.get().initPreference(this.moSyntaxStylePreferences, "keyword3", this);
            PreferenceEngine.get().initPreference(this.moSyntaxStylePreferences, "keyword4", this);
            PreferenceEngine.get().initPreference(this.moSyntaxStylePreferences, "keyword5", this);
            PreferenceEngine.get().initPreference(this.moSyntaxStylePreferences, "function", this);
            PreferenceEngine.get().initPreference(this.moSyntaxStylePreferences, "operator", this);
            PreferenceEngine.get().initPreference(this.moSyntaxStylePreferences, "markup", this);
            PreferenceEngine.get().initPreference(this.moSyntaxStylePreferences, "label", this);
            PreferenceEngine.get().initPreference(this.moSyntaxStylePreferences, "invalid", this);
        }

        public void preferenceChange(PreferenceChangeEvent aoEvent) {
            Preferences oPreferences = aoEvent.getNode();
            String sKey = aoEvent.getKey();
            String sValue = aoEvent.getNewValue();
            if (oPreferences == this.moWorkareaPreferences) {
                this.programPreferenceChange(sKey, sValue);
            } else if (oPreferences == this.moEditorPreferences) {
                this.editorPreferenceChange(sKey, sValue);
            } else if (oPreferences == this.moIndentPreferences) {
                this.indentPreferenceChange(sKey, sValue);
            } else if (oPreferences == this.moGutterPreferences) {
                this.gutterPreferenceChange(sKey, sValue);
            } else if (oPreferences == this.moGutterColorPreferences) {
                this.gutterColorPreferenceChange(sKey, sValue);
            } else if (oPreferences == this.moSyntaxColorPreferences) {
                this.syntaxColorPreferenceChange(sKey, sValue);
            } else if (oPreferences == this.moSyntaxStylePreferences) {
                this.syntaxStylePreferenceChange(sKey, sValue);
            }
            Editor.this.repaint();
        }

        private void programPreferenceChange(String asKey, String asValue) {
            if ("default".equals(asKey)) {
                if (Editor.this.mbInheritProgramColors) {
                    Color oForeground = XColor.decodeForeground(asValue);
                    Color oBackground = XColor.decodeBackground(asValue);
                    Editor.this.moEditor.setForeground(oForeground);
                    Editor.this.moMessageLabel.setForeground(oForeground);
                }
            } else if (!"highlight".equals(asKey) && !"textfield".equals(asKey)) {
                if ("selection".equals(asKey)) {
                    if (Editor.this.mbInheritProgramColors) {
                        Color oForeground = XColor.decodeForeground(asValue);
                        Color oBackground = XColor.decodeBackground(asValue);
                        Editor.this.moEditor.setSelectedTextColor(oForeground);
                        Editor.this.moEditor.setSelectionColor(oBackground);
                    }
                } else if ("caret".equals(asKey) && Editor.this.mbInheritProgramColors) {
                    Color oForeground = XColor.decode(asValue);
                    Editor.this.moEditor.setCaretColor(oForeground);
                }
            }
        }

        private void editorPreferenceChange(String asKey, String asValue) {
            SyntaxStyle[] aStyles = Editor.this.moEditor.getSyntaxStyles();
            if ("font".equals(asKey)) {
                Font oFont = Font.decode(asValue);
                Editor.this.moEditor.setFont(oFont);
                aStyles[0].setFontStyle(oFont.getStyle());
            } else if ("antialias".equals(asKey)) {
                Editor.this.moEditor.setAntiAlias("true".equals(asValue));
            } else if ("currentline".equals(asKey)) {
                Editor.this.moEditor.setLineHighlight("true".equals(asValue));
            } else if ("bracketmatch".equals(asKey)) {
                Editor.this.moEditor.setBracketHighlight("true".equals(asValue));
            } else if ("caret.on".equals(asKey)) {
                try {
                    Editor.this.moEditor.setCaretOnDelay(Integer.parseInt(asValue));
                }
                catch (NumberFormatException aoException) {}
            } else if ("caret.off".equals(asKey)) {
                try {
                    Editor.this.moEditor.setCaretOffDelay(Integer.parseInt(asValue));
                }
                catch (NumberFormatException aoException) {}
            } else if ("caret.block".equals(asKey)) {
                Editor.this.moEditor.setBlockCaret("true".equals(asValue));
            }
        }

        private void indentPreferenceChange(String asKey, String asValue) {
            if (!"auto".equals(asKey)) {
                if ("indentsize".equals(asKey)) {
                    Editor.this.moEditor.setIndentSize(Integer.parseInt(asValue));
                } else if ("tabsize".equals(asKey)) {
                    Editor.this.moEditor.setTabSize(Integer.parseInt(asValue));
                }
            }
        }

        private void gutterPreferenceChange(String asKey, String asValue) {
            if ("linenumberfont".equals(asKey)) {
                Editor.this.moGutter.setFont(Font.decode(asValue));
            } else if ("linenumberalignment".equals(asKey)) {
                int iAlignment = 4;
                if ("right".equals(asValue)) {
                    iAlignment = 4;
                } else if ("center".equals(asValue)) {
                    iAlignment = 0;
                } else if ("left".equals(asValue)) {
                    iAlignment = 2;
                }
                Editor.this.moGutter.setLineNumberAlignment(iAlignment);
            } else if ("lineinterval".equals(asKey)) {
                Editor.this.moGutter.setShowLineInterval("true".equals(asValue));
            } else if ("currentline".equals(asKey)) {
                Editor.this.moGutter.setShowCurrentLine("true".equals(asValue));
            } else if ("selection".equals(asKey)) {
                Editor.this.moGutter.setShowSelection("true".equals(asValue));
            } else if ("bracketscope".equals(asKey)) {
                Editor.this.moGutter.setShowBracketScope("true".equals(asValue));
            } else if ("lineintervalspacing".equals(asKey)) {
                Editor.this.moGutter.setLineInterval(Integer.parseInt(asValue));
            } else if ("lineintervalfont".equals(asKey)) {
                Editor.this.moGutter.setLineIntervalFont(Font.decode(asValue));
            }
        }

        private void gutterColorPreferenceChange(String asKey, String asValue) {
            Color oForeground = XColor.decodeForeground(asValue);
            Color oBackground = XColor.decodeBackground(asValue);
            if ("default".equals(asKey)) {
                Editor.this.moGutter.setForeground(oForeground);
                Editor.this.moGutter.setBackground(oBackground);
            } else if ("interval".equals(asKey)) {
                Editor.this.moGutter.setLineIntervalForeground(oForeground);
                Editor.this.moGutter.setLineIntervalBackground(oBackground);
            } else if ("currentline".equals(asKey)) {
                Editor.this.moGutter.setCurrentLineForeground(oForeground);
                Editor.this.moGutter.setCurrentLineBackground(oBackground);
            } else if ("selection".equals(asKey)) {
                Editor.this.moGutter.setSelectionForeground(oForeground);
                Editor.this.moGutter.setSelectionBackground(oBackground);
            } else if ("divider".equals(asKey)) {
                Editor.this.moGutter.setDividerForeground(oForeground);
                Editor.this.moGutter.setDividerBackground(oBackground);
            } else if ("bracketscope".equals(asKey)) {
                Editor.this.moGutter.setBracketScopeForeground(oForeground);
                Editor.this.moGutter.setBracketScopeBackground(oBackground);
            }
        }

        private void syntaxColorPreferenceChange(String asKey, String asValue) {
            Color oForeground = XColor.decodeForeground(asValue);
            Color oBackground = XColor.decodeBackground(asValue);
            if ("inherit".equals(asKey)) {
                Editor.this.mbInheritProgramColors = "true".equals(asValue);
                if (Editor.this.mbInheritProgramColors) {
                    PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "caret", this);
                    PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "default", this);
                    PreferenceEngine.get().initPreference(this.moWorkareaPreferences, "selection", this);
                } else {
                    PreferenceEngine.get().initPreference(this.moSyntaxColorPreferences, "caret", this);
                    PreferenceEngine.get().initPreference(this.moSyntaxColorPreferences, "default", this);
                    PreferenceEngine.get().initPreference(this.moSyntaxColorPreferences, "selection", this);
                }
            } else if ("caret".equals(asKey)) {
                if (!Editor.this.mbInheritProgramColors) {
                    Editor.this.moEditor.setCaretColor(oForeground);
                }
            } else if ("default".equals(asKey)) {
                if (!Editor.this.mbInheritProgramColors) {
                    Editor.this.moEditor.setForeground(oForeground);
                    Editor.this.moEditor.setBackground(oBackground);
                    Editor.this.moMessageLabel.setForeground(oForeground);
                }
            } else if ("selection".equals(asKey)) {
                if (!Editor.this.mbInheritProgramColors) {
                    Editor.this.moEditor.setSelectedTextColor(oForeground);
                    Editor.this.moEditor.setSelectionColor(oBackground);
                }
            } else if ("currentline".equals(asKey)) {
                Editor.this.moEditor.setLineHighlightColor(oBackground);
            } else if ("bracketmatch".equals(asKey)) {
                Editor.this.moEditor.setBracketHighlightColor(oBackground);
            }
        }

        private void syntaxStylePreferenceChange(String asKey, String asValue) {
            SyntaxStyle[] aStyles = Editor.this.moEditor.getSyntaxStyles();
            Color oForeground = SyntaxStylePreferenceType.decodeForeground(asValue);
            Color oBackground = SyntaxStylePreferenceType.decodeBackground(asValue);
            int iFontStyle = SyntaxStylePreferenceType.decodeFontStyle(asValue);
            if ("comment1".equals(asKey)) {
                aStyles[1].setForeground(oForeground);
                aStyles[1].setBackground(oBackground);
                aStyles[1].setFontStyle(iFontStyle);
            } else if ("comment2".equals(asKey)) {
                aStyles[2].setForeground(oForeground);
                aStyles[2].setBackground(oBackground);
                aStyles[2].setFontStyle(iFontStyle);
            } else if ("comment3".equals(asKey)) {
                aStyles[3].setForeground(oForeground);
                aStyles[3].setBackground(oBackground);
                aStyles[3].setFontStyle(iFontStyle);
            } else if ("digit".equals(asKey)) {
                aStyles[4].setForeground(oForeground);
                aStyles[4].setBackground(oBackground);
                aStyles[4].setFontStyle(iFontStyle);
            } else if ("literal1".equals(asKey)) {
                aStyles[5].setForeground(oForeground);
                aStyles[5].setBackground(oBackground);
                aStyles[5].setFontStyle(iFontStyle);
            } else if ("literal2".equals(asKey)) {
                aStyles[6].setForeground(oForeground);
                aStyles[6].setBackground(oBackground);
                aStyles[6].setFontStyle(iFontStyle);
            } else if ("keyword1".equals(asKey)) {
                aStyles[7].setForeground(oForeground);
                aStyles[7].setBackground(oBackground);
                aStyles[7].setFontStyle(iFontStyle);
            } else if ("keyword2".equals(asKey)) {
                aStyles[8].setForeground(oForeground);
                aStyles[8].setBackground(oBackground);
                aStyles[8].setFontStyle(iFontStyle);
            } else if ("keyword3".equals(asKey)) {
                aStyles[9].setForeground(oForeground);
                aStyles[9].setBackground(oBackground);
                aStyles[9].setFontStyle(iFontStyle);
            } else if ("keyword4".equals(asKey)) {
                aStyles[10].setForeground(oForeground);
                aStyles[10].setBackground(oBackground);
                aStyles[10].setFontStyle(iFontStyle);
            } else if ("keyword5".equals(asKey)) {
                aStyles[11].setForeground(oForeground);
                aStyles[11].setBackground(oBackground);
                aStyles[11].setFontStyle(iFontStyle);
            } else if ("function".equals(asKey)) {
                aStyles[12].setForeground(oForeground);
                aStyles[12].setBackground(oBackground);
                aStyles[12].setFontStyle(iFontStyle);
            } else if ("operator".equals(asKey)) {
                aStyles[13].setForeground(oForeground);
                aStyles[13].setBackground(oBackground);
                aStyles[13].setFontStyle(iFontStyle);
            } else if ("markup".equals(asKey)) {
                aStyles[14].setForeground(oForeground);
                aStyles[14].setBackground(oBackground);
                aStyles[14].setFontStyle(iFontStyle);
            } else if ("label".equals(asKey)) {
                aStyles[15].setForeground(oForeground);
                aStyles[15].setBackground(oBackground);
                aStyles[15].setFontStyle(iFontStyle);
            } else if ("invalid".equals(asKey)) {
                aStyles[16].setForeground(oForeground);
                aStyles[16].setBackground(oBackground);
                aStyles[16].setFontStyle(iFontStyle);
            }
            Editor.this.moEditor.repaint();
        }
    }

    private class MessageHandler
    implements MessageListener {
        private MessageHandler() {
        }

        public void messageReceived(Message aoMessage) {
            block5: {
                block6: {
                    block4: {
                        if (!(aoMessage instanceof ResourceSelect)) break block4;
                        if (moLastSelected != Editor.this) {
                            return;
                        }
                        ResourceSelect oMessage = (ResourceSelect)aoMessage;
                        Resource[] aResources = oMessage.getResources();
                        Editor.this.setResource(aResources[0]);
                        break block5;
                    }
                    if (!(aoMessage instanceof ResourceUnselect)) break block6;
                    if (moLastSelected != Editor.this) {
                        return;
                    }
                    ResourceUnselect oMessage = (ResourceUnselect)aoMessage;
                    Resource[] aResources = oMessage.getResources();
                    for (int iIndex = 0; iIndex < aResources.length; ++iIndex) {
                        Resource oResource = aResources[iIndex];
                        if (Editor.this.moCurrentResource != oResource) continue;
                        Editor.this.setResource(null);
                    }
                    break block5;
                }
                if (!(aoMessage instanceof ResourceClose)) break block5;
                ResourceClose oMessage = (ResourceClose)aoMessage;
                Resource[] aResources = oMessage.getResources();
                for (int iIndex = 0; iIndex < aResources.length; ++iIndex) {
                    Resource oResource = aResources[iIndex];
                    if (Editor.this.moCurrentResource != oResource) continue;
                    Editor.this.setResource(null);
                }
            }
        }
    }

    private class ViewPaneHandler
    extends ViewPaneAdapter {
        private ViewPaneHandler() {
        }

        public void paneClosed(ViewPaneEvent aoEvent) {
            if (Editor.this.moCurrentResource != null) {
                MessageBus.send(new RequestResourceClose((Object)Editor.this, Editor.this.moCurrentResource));
            }
        }
    }

    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent aoEvent) {
            new UpdateActions(Editor.this.moCurrentResource);
            new UpdateStatus();
        }

        public void focusLost(FocusEvent aoEvent) {
            new UpdateActions(Editor.this.moCurrentResource);
            new UpdateStatus();
        }
    }

    private class CaretChangeHandler
    implements ChangeListener {
        private CaretChangeHandler() {
        }

        public void stateChanged(ChangeEvent aoEvent) {
            new UpdateStatus();
            new UpdateActions(Editor.this.moCurrentResource);
        }
    }

    private class DocumentHandler
    implements DocumentListener,
    UndoableEditListener {
        private DocumentHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changedUpdate(DocumentEvent aoEvent) {
            if (Editor.this.moCurrentResource == null) {
                return;
            }
            Resource resource = Editor.this.moCurrentResource;
            synchronized (resource) {
                Editor.this.updateModifiedFlag(Editor.this.moCurrentResource);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void insertUpdate(DocumentEvent aoEvent) {
            if (Editor.this.moCurrentResource == null) {
                return;
            }
            Resource resource = Editor.this.moCurrentResource;
            synchronized (resource) {
                Editor.this.updateModifiedFlag(Editor.this.moCurrentResource);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeUpdate(DocumentEvent aoEvent) {
            if (Editor.this.moCurrentResource == null) {
                return;
            }
            Resource resource = Editor.this.moCurrentResource;
            synchronized (resource) {
                Editor.this.updateModifiedFlag(Editor.this.moCurrentResource);
            }
        }

        public void undoableEditHappened(UndoableEditEvent aoEvent) {
            new UpdateActions(Editor.this.moCurrentResource);
        }
    }

    private class OutlineHandler
    implements OutlineListener {
        private OutlineHandler() {
        }

        public void selectLink(Node aoNode) {
            Position oPosition = (Position)aoNode.getResource("link");
            Editor.this.moEditor.jumpToOffset(oPosition.getOffset());
        }

        public void selectDecl(Node aoNode) {
            this.selectNode(aoNode);
        }

        public void selectNode(Node aoNode) {
            Position oStart = (Position)aoNode.getResource("start");
            Position oEnd = (Position)aoNode.getResource("end");
            Editor.this.moEditor.setCaretPosition(oStart.getOffset());
            Editor.this.moEditor.moveCaretPosition(oEnd.getOffset());
            Editor.this.moEditor.requestFocusInWindow();
        }
    }

    private class ResourceHandler
    extends ResourceAdapter {
        private ResourceHandler() {
        }

        public void nodeEventOccurred(NodeEvent aoEvent) {
            Log.write(6, "ResourceHandler.nodeEventOccurred() called...");
            Node oNode = aoEvent.getNode();
            Resource oResource = (Resource)oNode;
        }

        public void resourceLoaded(ResourceEvent aoEvent) {
        }

        public void resourceChanged(ResourceEvent aoEvent) {
            Resource oResource = aoEvent.getResource();
            if (aoEvent.isDateChanged()) {
                oResource.setResource(Editor.EDITOR_DOCUMENT, null);
                oResource.setResource(Editor.EDITOR_SAVED_HASHCODE, null);
                oResource.setResource("resource.outline.model", null);
                Editor.this.loadResource(oResource);
            } else if (aoEvent.isWritableFlagChanged()) {
                try {
                    Editor.this.moEditor.setReadOnly(!oResource.isWritable());
                }
                catch (ResourceException aoException) {
                    Log.write(aoException);
                }
            }
        }

        public void resourceSaved(ResourceEvent aoEvent) {
            Log.write(6, "ResourceHandler.resourceSaved() called...");
            Resource oResource = aoEvent.getResource();
            Editor.this.updateSavedHashCode();
            Editor.this.updateModifiedFlag(oResource);
            new UpdateSyntax(oResource.getType());
            SyntaxDocument oDocument = (SyntaxDocument)oResource.getResource(Editor.EDITOR_DOCUMENT);
            OutlineModel oOutlineModel = OutlineModelFactory.createModel((Object)oDocument);
            Icon oIcon = IconCache.getIcon(oResource.getIcon());
            String sName = oResource.getName();
            oResource.setResource("resource.outline.model", oOutlineModel);
            if (oOutlineModel != null && Editor.this.isSelected()) {
                MessageBus.send(new RequestOutline(this, oIcon, sName, oOutlineModel, Editor.this.moOutlineHandler));
            }
        }
    }

    private class JumpToLineAction
    extends TextAction
    implements InputListener {
        public JumpToLineAction() {
            super("jump.to.line");
        }

        public void actionPerformed(ActionEvent aoEvent) {
            WorkFrame oWorkFrame = GuiEngine.get().getSelectedWorkFrame();
            WorkArea oWorkArea = oWorkFrame.getSelectedWorkArea();
            oWorkArea.getUtilityBar().showInput("Line Number: ", this);
        }

        public void accept(String asInput) {
            int iLineNumber = -1;
            try {
                iLineNumber = Integer.parseInt(asInput);
            }
            catch (NumberFormatException aoException) {
                iLineNumber = -1;
            }
            if (iLineNumber >= 0) {
                Editor.this.moEditor.jumpToLineNumber(iLineNumber);
            }
            Editor.this.requestFocusInWindow();
        }

        public void cancel() {
            Editor.this.requestFocusInWindow();
        }
    }

    private class FindPreviousAction
    extends TextAction {
        public FindPreviousAction() {
            super("find.previous");
        }

        public void actionPerformed(ActionEvent aoEvent) {
            Editor.this.moEditor.findPrevious(msSearchExpression);
            Editor.this.requestFocusInWindow();
        }
    }

    private class FindNextAction
    extends TextAction {
        public FindNextAction() {
            super("find.next");
        }

        public void actionPerformed(ActionEvent aoEvent) {
            Editor.this.moEditor.findNext(msSearchExpression);
            Editor.this.requestFocusInWindow();
        }
    }

    private class QuickFindAction
    extends TextAction
    implements InputListener {
        public QuickFindAction() {
            super("find.quick");
        }

        public void actionPerformed(ActionEvent aoEvent) {
            UtilityBar oBar = Editor.this.getWorkPane().getWorkArea().getUtilityBar();
            oBar.showInput("Search: ", this);
        }

        public void accept(String asInput) {
            msSearchExpression = asInput;
            Editor.this.moEditor.findNext(asInput);
            Editor.this.requestFocusInWindow();
        }

        public void cancel() {
            Editor.this.requestFocusInWindow();
        }
    }

    private class RedoAction
    extends TextAction {
        public RedoAction() {
            super("redo");
        }

        public void actionPerformed(ActionEvent aoEvent) {
            ResourceUndoManager oUndoManager = (ResourceUndoManager)Editor.this.moCurrentResource.getResource("resource.undo.manager");
            UndoableEdit oEdit = oUndoManager.editToBeRedone();
            if (oUndoManager.canRedo()) {
                oUndoManager.redo();
            }
            if (oEdit == null || !(oEdit instanceof DocumentEvent)) {
                return;
            }
            DocumentEvent oEvent = (DocumentEvent)((Object)oEdit);
            DocumentEvent.EventType oType = oEvent.getType();
            if (oType == DocumentEvent.EventType.INSERT) {
                Editor.this.moEditor.setCaretPosition(oEvent.getOffset() + oEvent.getLength());
            } else if (oType == DocumentEvent.EventType.REMOVE) {
                Editor.this.moEditor.setCaretPosition(oEvent.getOffset());
            }
            Editor.this.moEditor.repaint();
            new UpdateActions(Editor.this.moCurrentResource);
        }
    }

    private class UndoAction
    extends TextAction {
        public UndoAction() {
            super("undo");
        }

        public void actionPerformed(ActionEvent aoEvent) {
            ResourceUndoManager oUndoManager = (ResourceUndoManager)Editor.this.moCurrentResource.getResource("resource.undo.manager");
            UndoableEdit oEdit = oUndoManager.editToBeUndone();
            if (oUndoManager.canUndo()) {
                oUndoManager.undo();
            }
            if (oEdit == null || !(oEdit instanceof DocumentEvent)) {
                return;
            }
            DocumentEvent oEvent = (DocumentEvent)((Object)oEdit);
            DocumentEvent.EventType oType = oEvent.getType();
            if (oType == DocumentEvent.EventType.INSERT) {
                Editor.this.moEditor.setCaretPosition(oEvent.getOffset());
            } else if (oType == DocumentEvent.EventType.REMOVE) {
                Editor.this.moEditor.setCaretPosition(oEvent.getOffset() + oEvent.getLength());
            }
            Editor.this.moEditor.repaint();
            new UpdateActions(Editor.this.moCurrentResource);
        }
    }

    private class SaveAction
    extends TextAction {
        public SaveAction() {
            super("save");
        }

        public void actionPerformed(ActionEvent aoEvent) {
            Editor.this.moCurrentResource.set("resource.data.buffer", Editor.this.moEditor.getText());
            Resource[] aResources = new Resource[]{Editor.this.moCurrentResource};
            URI oURI = Editor.this.moCurrentResource.getUri();
            if (oURI.getScheme().equals("new")) {
                ActionLibrary.get("save.as").actionPerformed(aoEvent);
                return;
            }
            MessageBus.send(new RequestResourceSave((Object)Editor.this, aResources));
        }
    }

    private class UpdateViewPort
    implements Runnable {
        private Resource moResource;

        public UpdateViewPort(Resource aoResource) {
            this.moResource = aoResource;
            if (EventQueue.isDispatchThread()) {
                this.run();
            } else {
                EventQueue.invokeLater(this);
            }
        }

        public void run() {
            int iCaretDot = 0;
            Integer oCaretDot = (Integer)this.moResource.getResource("text.caret.dot");
            if (oCaretDot != null) {
                iCaretDot = oCaretDot;
            }
            int iCaretMark = iCaretDot;
            Integer oCaretMark = (Integer)this.moResource.getResource("text.caret.mark");
            if (oCaretMark != null) {
                iCaretMark = oCaretMark;
            }
            Editor.this.moEditor.getCaret().setDot(iCaretMark);
            if (iCaretDot != iCaretMark) {
                Editor.this.moEditor.getCaret().moveDot(iCaretDot);
            }
            JViewport oViewport = Editor.this.moTextScroller.getViewport();
            Rectangle oViewArea = (Rectangle)this.moResource.getResource("text.view.area");
            if (oViewArea == null) {
                oViewArea = new Rectangle(0, 0, oViewport.getSize().width, Editor.this.moEditor.getLineHeight());
            }
            Editor.this.moEditor.scrollRectToVisible(oViewArea);
        }
    }

    private class UpdateStatus
    implements Runnable {
        public UpdateStatus() {
            if (EventQueue.isDispatchThread()) {
                this.run();
            } else {
                EventQueue.invokeLater(this);
            }
        }

        public void run() {
            UtilityBar oBar;
            WorkArea oWorkArea;
            if (Editor.this.moEditor == null) {
                return;
            }
            int iRow = Editor.this.moEditor.getCurrentRow();
            int iColumn = Editor.this.moEditor.getCurrentColumn();
            WorkPane oWorkPane = Editor.this.getWorkPane();
            if (oWorkPane != null && (oWorkArea = oWorkPane.getWorkArea()) != null && (oBar = oWorkArea.getUtilityBar()) != null) {
                oBar.showStatus(Editor.this.hasFocus() ? iRow + ", " + iColumn : "");
            }
        }
    }

    private class UpdateSyntax
    implements Runnable {
        String msSyntax;

        public UpdateSyntax(String asSyntax) {
            this.msSyntax = asSyntax;
            if (EventQueue.isDispatchThread()) {
                this.run();
            } else {
                EventQueue.invokeLater(this);
            }
        }

        public void run() {
            String sCurrentSyntax;
            String sDesiredSyntax = this.msSyntax;
            sDesiredSyntax = sDesiredSyntax == null ? "default" : sDesiredSyntax;
            String string = sCurrentSyntax = Editor.this.moEditor == null ? "default" : Editor.this.moEditor.getSyntaxName();
            if (!sCurrentSyntax.equals(sDesiredSyntax)) {
                Editor.this.moEditor.setSyntax(sDesiredSyntax);
            }
        }
    }

    private class UpdateActions
    implements Runnable {
        Resource moResource;

        public UpdateActions(Resource aoResource) {
            this.moResource = aoResource;
            if (EventQueue.isDispatchThread()) {
                this.run();
            } else {
                EventQueue.invokeLater(this);
            }
        }

        public void run() {
            if (this.moResource == null) {
                return;
            }
            boolean bEnabled = Editor.this.moEditor.isEnabled();
            UndoManager oUndoManager = (UndoManager)this.moResource.getResource("resource.undo.manager");
            ((ProgramAction)ActionLibrary.get("undo")).setEnabled(bEnabled && oUndoManager != null && oUndoManager.canUndo());
            ((ProgramAction)ActionLibrary.get("redo")).setEnabled(bEnabled && oUndoManager != null && oUndoManager.canRedo());
            int iDot = Editor.this.moEditor.getCaret().getDot();
            int iMark = Editor.this.moEditor.getCaret().getMark();
            int iDotLine = Editor.this.moEditor.getLineIndexForOffset(iDot);
            int iMarkLine = Editor.this.moEditor.getLineIndexForOffset(iMark);
            boolean bSelection = iDot != iMark;
            ((ProgramAction)ActionLibrary.get("cut")).setEnabled(bEnabled && bSelection);
            ((ProgramAction)ActionLibrary.get("copy")).setEnabled(bEnabled && bSelection);
            ((ProgramAction)ActionLibrary.get("delete")).setEnabled(bEnabled && bSelection);
            ((ProgramAction)ActionLibrary.get("select.all")).setEnabled(bEnabled && !bSelection);
            boolean bMultiLineSelection = iDotLine != iMarkLine;
            boolean bTransferable = false;
            try {
                bTransferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this) != null;
            }
            catch (Exception aoException) {
                // empty catch block
            }
            ((ProgramAction)ActionLibrary.get("paste")).setEnabled(bEnabled && bTransferable);
        }
    }

    private class ShowResource
    implements Runnable {
        private Resource moResource;
        private boolean mbBusy;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ShowResource(Resource aoResource) {
            if (EventQueue.isDispatchThread()) {
                this.run();
            } else {
                ShowResource showResource = this;
                synchronized (showResource) {
                    while (this.mbBusy) {
                        Log.write(6, "Busy while showing resource!");
                        try {
                            this.wait();
                        }
                        catch (InterruptedException aoException) {
                            Log.write(3, (Throwable)aoException);
                        }
                    }
                    this.moResource = aoResource;
                    EventQueue.invokeLater(this);
                }
            }
        }

        public synchronized void run() {
            this.mbBusy = true;
            Editor.this.requestFocusInWindow();
            if (Editor.this.moCurrentResource != null) {
                this.clearResource(Editor.this.moCurrentResource);
            }
            if (this.moResource != null) {
                this.setupResource(this.moResource);
            }
            Editor.this.moCurrentResource = this.moResource;
            this.mbBusy = false;
            this.notifyAll();
        }

        private void clearResource(Resource aoResource) {
            if (aoResource != null) {
                Log.write(5, "Clearing resource: " + aoResource.getName());
                SyntaxDocument oDocument = (SyntaxDocument)aoResource.getResource(Editor.EDITOR_DOCUMENT);
                if (oDocument != null) {
                    oDocument.removeDocumentListener(Editor.this.moDocumentHandler);
                    oDocument.removeUndoableEditListener(Editor.this.moDocumentHandler);
                    oDocument.removeUndoableEditListener((UndoManager)aoResource.getResource("resource.undo.manager"));
                }
                aoResource.removeResourceListener(Editor.this.moResourceHandler);
                aoResource.setResource(Editor.EDITOR_SAVED_HASHCODE, new Integer(Editor.this.miSavedHashCode));
                aoResource.setResource("text.caret.dot", new Integer(Editor.this.moEditor.getCaret().getDot()));
                aoResource.setResource("text.caret.mark", new Integer(Editor.this.moEditor.getCaret().getMark()));
                aoResource.setResource("text.view.area", Editor.this.moTextScroller.getViewport().getViewRect());
            }
            Editor.this.setTitle("Editor");
            Editor.this.setIcon(IconCache.getIcon("editor"));
            OutlineModel oOutlineModel = (OutlineModel)aoResource.getResource("resource.outline.model");
            if (oOutlineModel != null) {
                oOutlineModel.setVisible(false);
            }
            Editor.this.setDropTarget(Editor.this.moEditor.getDropTarget());
            Editor.this.moCardLayout.show(Editor.this, Editor.BLANK_PANEL_CARD);
        }

        private void setupResource(Resource aoResource) {
            String sIcon;
            Log.write(5, "Showing resource:  " + aoResource.getName());
            String sName = aoResource.getName();
            Resource oParent = (Resource)aoResource.getParent();
            if (oParent != null) {
                String sParent = oParent.getUri().getPath();
                Editor.this.setTitle(aoResource.getName() + "  [" + sParent + "]");
            }
            Editor.this.setIcon(IconCache.getIcon((sIcon = aoResource.getIcon()) == null ? "file" : sIcon));
            SyntaxDocument oDocument = (SyntaxDocument)aoResource.getResource(Editor.EDITOR_DOCUMENT);
            if (oDocument == null) {
                String sData = aoResource.get("resource.data.buffer", null);
                oDocument = new SyntaxDocument();
                oDocument.putProperty("__EndOfLine__", "\n");
                if (sData != null) {
                    try {
                        aoResource.setModifiedFlagEnabled(false);
                        oDocument.insertString(0, sData, null);
                        aoResource.setModifiedFlagEnabled(true);
                    }
                    catch (BadLocationException aoException) {
                        Log.write(aoException);
                    }
                }
                aoResource.setResource(Editor.EDITOR_DOCUMENT, oDocument);
            }
            Editor.this.moEditor.setDocument(oDocument);
            new UpdateSyntax(aoResource.getType());
            Integer oHashCode = (Integer)aoResource.getResource(Editor.EDITOR_SAVED_HASHCODE);
            if (oHashCode == null) {
                Editor.this.updateSavedHashCode();
            } else {
                Editor.this.miSavedHashCode = oHashCode;
            }
            Editor.this.updateModifiedFlag(aoResource);
            new UpdateActions(aoResource);
            OutlineModel oOutlineModel = (OutlineModel)aoResource.getResource("resource.outline.model");
            if (oOutlineModel == null) {
                oOutlineModel = OutlineModelFactory.createModel((Object)oDocument);
                aoResource.setResource("resource.outline.model", oOutlineModel);
            }
            if (oOutlineModel != null && Editor.this.isShowing()) {
                MessageBus.send(new RequestOutline(this, Editor.this.getIcon(), sName, oOutlineModel, Editor.this.moOutlineHandler));
            }
            try {
                Editor.this.moEditor.setReadOnly(!aoResource.isWritable());
            }
            catch (ResourceException aoException) {
                Log.write(2, (Throwable)aoException);
            }
            aoResource.addResourceListener(Editor.this.moResourceHandler);
            oDocument.addDocumentListener(Editor.this.moDocumentHandler);
            oDocument.addUndoableEditListener(Editor.this.moDocumentHandler);
            oDocument.addUndoableEditListener((UndoManager)aoResource.getResource("resource.undo.manager"));
            Editor.this.moEditor.setEnabled(true);
            if (Editor.this.isAllocated()) {
                Editor.this.getWorkPane().push(Editor.this);
            } else {
                WorkFrame oWorkFrame = GuiEngine.get().getSelectedWorkFrame();
                WorkArea oWorkArea = oWorkFrame.getSelectedWorkArea();
                WorkPane oWorkPane = oWorkArea.getDefaultWorkPane();
                oWorkPane.push(Editor.this);
            }
            new UpdateViewPort(aoResource);
            Editor.this.moEditor.setDropTarget(Editor.this.getDropTarget());
            Editor.this.showCard(Editor.TEXT_SCROLLER_CARD);
        }
    }

    private class LoadResource
    extends ResourceAdapter
    implements Runnable {
        private Resource moResource;

        public LoadResource(Resource aoResource) {
            this.moResource = aoResource;
            ThreadPool oThreadPool = (ThreadPool)MainEngine.get().getResource("thread.pool");
            oThreadPool.execute(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Editor.this.showMessage("Loading " + this.moResource.getName() + " ...");
            this.moResource.addResourceListener(this);
            MessageBus.send(new RequestResourceLoad((Object)Editor.this, this.moResource));
            Resource resource = this.moResource;
            synchronized (resource) {
                try {
                    this.moResource.wait(5000L);
                }
                catch (InterruptedException aoException) {
                    Log.write(2, (Throwable)aoException);
                    Editor.this.showMessage("Resource failed to load: " + this.moResource.getName());
                }
                finally {
                    this.moResource.removeResourceListener(this);
                }
            }
            String oDataBuffer = this.moResource.get("resource.data.buffer");
            if (oDataBuffer == null) {
                Editor.this.showMessage("Timeout loading resource: " + this.moResource.getName());
            } else if (this.moResource == Editor.this.moCurrentResource) {
                Editor.this.miSavedHashCode = oDataBuffer.hashCode();
            }
            Editor.this.showResource(this.moResource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resourceLoaded(ResourceEvent aoEvent) {
            Resource oResource;
            Resource resource = oResource = aoEvent.getResource();
            synchronized (resource) {
                Log.writePart(6, "Resource loaded, notifying threads...");
                oResource.notifyAll();
                Log.write(6, "done.");
            }
        }
    }

    private class ShowMessage
    implements Runnable {
        private String msText;

        public ShowMessage(String asText) {
            this.msText = asText == null ? "" : asText;
            EventQueue.invokeLater(this);
        }

        public void run() {
            Editor.this.moMessageLabel.setText(this.msText);
            Editor.this.moCardLayout.show(Editor.this, Editor.MESSAGE_LABEL_CARD);
        }
    }
}

