/*
 * Decompiled with CFR 0.152.
 */
package novaworx.view.about;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Properties;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import novaworx.GuiEngine;
import novaworx.MainEngine;
import novaworx.PeerEngine;
import novaworx.PreferenceEngine;
import novaworx.Version;
import novaworx.WorkArea;
import novaworx.WorkFrame;
import novaworx.WorkPane;
import novaworx.WorkView;
import novaworx.WorkViewEngine;
import novaworx.WorkViewException;
import novaworx.bus.Message;
import novaworx.bus.MessageBus;
import novaworx.bus.MessageListener;
import novaworx.data.DataNode;
import novaworx.data.Node;
import novaworx.gui.ActionLibrary;
import novaworx.gui.IconCache;
import novaworx.gui.InformationPage;
import novaworx.gui.MemoryLabel;
import novaworx.gui.ProgramAction;
import novaworx.message.DaemonModeDisabled;
import novaworx.message.DaemonModeEnabled;
import novaworx.message.ProgramStart;
import novaworx.message.ProgramStopRequested;
import novaworx.message.RequestOutline;
import novaworx.swing.XColor;
import novaworx.swing.XLabel;
import novaworx.util.CommandLine;
import novaworx.view.outline.OutlineListener;
import novaworx.view.outline.OutlineModel;
import novaworx.view.outline.OutlineModelFactory;
import novaworx.viewarea.ViewPaneAdapter;
import novaworx.viewarea.ViewPaneEvent;

public class About
extends WorkView {
    private static About moInstance;
    private DataNode moOutlineRoot;
    private OutlineModel moOutlineModel;
    private OutlineHandler moOutlineHandler;
    private InformationPage moCurrentPage;
    private JScrollPane moScroller;
    private InformationPage moAboutPanel;
    private ViewPaneHandler moViewPaneHandler;
    private MessageHandler moMessageHandler;
    private static ShowActionHandler moShowActionHandler;
    private CancelActionHandler moCancelActionHandler;
    private PreferenceChangeHandler moPreferenceChangeHandler;
    private Color moTextCaretForeground = XColor.YELLOW;
    private Color moTextCaretBackground = XColor.CLEAR;
    private Color moTextEntryForeground = XColor.WHITE;
    private Color moTextEntryBackground = XColor.SEMI_WHITE;
    private Color moSelectionForeground = XColor.WHITE;
    private Color moSelectionBackground = XColor.decode("808080FF");
    private Color moSeparatorForeground = XColor.WHITE;
    private Color moSeparatorBackground = XColor.SEMI_WHITE;
    private Color moDisabledForeground = XColor.WHITE;
    private Color moDisabledBackground = XColor.SEMI_WHITE;
    private XLabel moDaemonLabel;
    static /* synthetic */ Class class$novaworx$message$ProgramStart;
    static /* synthetic */ Class class$novaworx$message$ProgramStopRequested;
    static /* synthetic */ Class class$novaworx$message$DaemonModeEnabled;
    static /* synthetic */ Class class$novaworx$message$DaemonModeDisabled;
    static /* synthetic */ Class class$novaworx$view$about$About;

    public About() {
        moInstance = this;
        this.moOutlineRoot = new DataNode();
        this.moOutlineHandler = new OutlineHandler();
        this.moPreferenceChangeHandler = new PreferenceChangeHandler();
        this.moViewPaneHandler = new ViewPaneHandler();
        this.moCancelActionHandler = new CancelActionHandler();
        this.setIcon(IconCache.getIcon("about"));
        this.setTitle("About " + Version.name());
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.createPages(this.moOutlineRoot);
        this.moOutlineModel = OutlineModelFactory.createModel((Object)this.moOutlineRoot);
        this.moMessageHandler = new MessageHandler();
        MessageBus.registerListener(this.moMessageHandler, class$novaworx$message$ProgramStopRequested == null ? (class$novaworx$message$ProgramStopRequested = About.class$("novaworx.message.ProgramStopRequested")) : class$novaworx$message$ProgramStopRequested);
        MessageBus.registerListener(this.moMessageHandler, class$novaworx$message$DaemonModeEnabled == null ? (class$novaworx$message$DaemonModeEnabled = About.class$("novaworx.message.DaemonModeEnabled")) : class$novaworx$message$DaemonModeEnabled);
        MessageBus.registerListener(this.moMessageHandler, class$novaworx$message$DaemonModeDisabled == null ? (class$novaworx$message$DaemonModeDisabled = About.class$("novaworx.message.DaemonModeDisabled")) : class$novaworx$message$DaemonModeDisabled);
        this.moPreferenceChangeHandler.init();
    }

    public void allocate() throws WorkViewException {
    }

    public void display() throws WorkViewException {
        WorkPane oWorkPane = this.getWorkPane();
        if (oWorkPane == null) {
            return;
        }
        oWorkPane.addViewPaneListener(this.moViewPaneHandler);
        this.showPage(this.moOutlineRoot.getChild(0));
    }

    public void select() throws WorkViewException {
        MessageBus.send(new RequestOutline(this, IconCache.getIcon("about"), "About", this.moOutlineModel, this.moOutlineHandler));
        ((ProgramAction)ActionLibrary.get("cancel")).pushListener(this.moCancelActionHandler);
    }

    public void unselect() throws WorkViewException {
        ((ProgramAction)ActionLibrary.get("cancel")).pullListener(this.moCancelActionHandler);
    }

    public void conceal() throws WorkViewException {
        WorkPane oWorkPane = this.getWorkPane();
        if (oWorkPane == null) {
            return;
        }
        oWorkPane.removeViewPaneListener(this.moViewPaneHandler);
        this.moOutlineModel.setVisible(false);
    }

    public void deallocate() throws WorkViewException {
    }

    private void createPages(DataNode aoNode) {
        DataNode oApplicationNode = new DataNode();
        InformationPage oApplicationPage = new InformationPage();
        this.addApplicationInfo(oApplicationPage);
        oApplicationPage.done();
        oApplicationPage.putClientProperty("preference.group", oApplicationNode);
        oApplicationNode.setResource("page", oApplicationPage);
        oApplicationNode.setResource("display.name", "Application");
        oApplicationNode.setResource("display.icon", IconCache.getIcon("file"));
        aoNode.add(oApplicationNode);
        DataNode oEnvironmentNode = new DataNode();
        InformationPage oEnvironmentPage = new InformationPage();
        this.addEnvironmentInfo(oEnvironmentPage);
        oEnvironmentPage.done();
        oEnvironmentPage.putClientProperty("preference.group", oEnvironmentNode);
        oEnvironmentNode.setResource("page", oEnvironmentPage);
        oEnvironmentNode.setResource("display.name", "System Properties");
        oEnvironmentNode.setResource("display.icon", IconCache.getIcon("file"));
        aoNode.add(oEnvironmentNode);
    }

    private void addApplicationInfo(InformationPage aoPanel) {
        aoPanel.addSeparator(Version.fullName());
        aoPanel.rowLabel("Version: ");
        aoPanel.addLabel(Version.getVersion() + " ");
        aoPanel.addLabel(Version.getState() + " ");
        aoPanel.addLabel("(" + Version.getFullVersion() + ") ");
        aoPanel.addLabel(Version.getBuildDate());
        aoPanel.addSeparator("Copyright");
        aoPanel.rowLabel(Version.copyright(), 2);
        aoPanel.addSeparator("Java Runtime");
        aoPanel.rowLabel("Java Version: ");
        aoPanel.addLabel(System.getProperty("java.version"));
        aoPanel.rowLabel("Java Runtime: ");
        aoPanel.addLabel(System.getProperty("java.vm.name") + "(build " + System.getProperty("java.vm.version") + ", " + System.getProperty("java.vm.info") + ")");
        aoPanel.rowLabel("Java Virtual Machine: ");
        aoPanel.addLabel(System.getProperty("java.runtime.name") + "(" + System.getProperty("java.runtime.version") + ")");
        aoPanel.addSeparator("Application Memory");
        MemoryLabel.setGarbageCollect(false);
        aoPanel.rowLabel("VM Maximum: ");
        aoPanel.add(new MemoryLabel(true, false, false, false, false, false, false));
        aoPanel.rowLabel("Allocated: ");
        aoPanel.width(0);
        aoPanel.add(new MemoryLabel(false, true, false, false, false, false, false));
        aoPanel.width(0);
        aoPanel.add(Box.createHorizontalStrut(10));
        aoPanel.add(new MemoryLabel(false, false, true, false, false, false, false));
        aoPanel.rowLabel("Used: ");
        aoPanel.width(0);
        aoPanel.add(new MemoryLabel(false, false, false, true, false, false, false));
        aoPanel.width(0);
        aoPanel.add(Box.createHorizontalStrut(10));
        aoPanel.add(new MemoryLabel(false, false, false, false, true, false, false));
        aoPanel.rowLabel("Free: ");
        aoPanel.width(0);
        aoPanel.add(new MemoryLabel(false, false, false, false, false, true, false));
        aoPanel.width(0);
        aoPanel.add(Box.createHorizontalStrut(10));
        aoPanel.add(new MemoryLabel(false, false, false, false, false, false, true));
        MainEngine oMainEngine = MainEngine.get();
        CommandLine oCommandLine = (CommandLine)oMainEngine.getResource("command.line");
        aoPanel.addSeparator("Application Parameters");
        aoPanel.rowLabel("Peer Engine Port: ");
        aoPanel.addLabel(String.valueOf(PeerEngine.get().getPort()));
        aoPanel.rowLabel("Daemon Mode: ");
        this.moDaemonLabel = new XLabel(MainEngine.get().isDaemon() ? "Yes" : "No");
        aoPanel.add(this.moDaemonLabel);
        aoPanel.rowLabel("Devel Mode: ");
        aoPanel.addLabel(oMainEngine.isDevel() ? "Yes" : "No");
    }

    private void addEnvironmentInfo(InformationPage aoPanel) {
        aoPanel.addSeparator("System Properties");
        Properties oProperties = System.getProperties();
        Enumeration<?> oKeys = oProperties.propertyNames();
        while (oKeys.hasMoreElements()) {
            String sKey = (String)oKeys.nextElement();
            String sValue = oProperties.getProperty(sKey);
            aoPanel.rowLabel(sKey);
            aoPanel.addLabel(sValue);
        }
    }

    private JLabel createLabel(String asLabel) {
        JLabel oLabel = new JLabel(asLabel);
        oLabel.setFont(oLabel.getFont().deriveFont(0));
        return oLabel;
    }

    public void setForeground(Color aoColor) {
        super.setForeground(aoColor);
        if (this.moAboutPanel != null) {
            this.moAboutPanel.setForeground(aoColor);
        }
    }

    public void setBackground(Color aoColor) {
        super.setBackground(aoColor);
        if (this.moAboutPanel != null) {
            this.moAboutPanel.setBackground(aoColor);
        }
    }

    public void setTextCaretForeground(Color aoColor) {
        this.moTextCaretForeground = aoColor;
        if (this.moCurrentPage != null) {
            this.moCurrentPage.setTextCaretForeground(aoColor);
        }
    }

    public void setTextCaretBackground(Color aoColor) {
        this.moTextCaretBackground = aoColor;
        if (this.moCurrentPage != null) {
            this.moCurrentPage.setTextCaretBackground(aoColor);
        }
    }

    public void setTextEntryForeground(Color aoColor) {
        this.moTextEntryForeground = aoColor;
        if (this.moCurrentPage != null) {
            this.moCurrentPage.setTextEntryForeground(aoColor);
        }
    }

    public void setTextEntryBackground(Color aoColor) {
        this.moTextEntryBackground = aoColor;
        if (this.moCurrentPage != null) {
            this.moCurrentPage.setTextEntryBackground(aoColor);
        }
    }

    public void setSelectionForeground(Color aoColor) {
        this.moSelectionForeground = aoColor;
        if (this.moCurrentPage != null) {
            this.moCurrentPage.setSelectionForeground(aoColor);
        }
    }

    public void setSelectionBackground(Color aoColor) {
        this.moSelectionBackground = aoColor;
        if (this.moCurrentPage != null) {
            this.moCurrentPage.setSelectionBackground(aoColor);
        }
    }

    public void setSeparatorForeground(Color aoColor) {
        this.moSeparatorForeground = aoColor;
        if (this.moCurrentPage != null) {
            this.moCurrentPage.setSeparatorForeground(aoColor);
        }
    }

    public void setSeparatorBackground(Color aoColor) {
        this.moSeparatorBackground = aoColor;
        if (this.moCurrentPage != null) {
            this.moCurrentPage.setSeparatorBackground(aoColor);
        }
    }

    public void setDisabledForeground(Color aoColor) {
        this.moDisabledForeground = aoColor;
        if (this.moCurrentPage != null) {
            this.moCurrentPage.setDisabledForeground(aoColor);
        }
    }

    public void setDisabledBackground(Color aoColor) {
        this.moDisabledBackground = aoColor;
        if (this.moCurrentPage != null) {
            this.moCurrentPage.setDisabledBackground(aoColor);
        }
    }

    public void setDropTarget(DropTarget aoDropTarget) {
    }

    private void showPage(Node aoNode) {
        if (aoNode == null) {
            return;
        }
        InformationPage oPage = (InformationPage)aoNode.getResource("page");
        this.showPage(oPage);
    }

    private void showPage(InformationPage aoPage) {
        this.removeAll();
        Node oNode = (Node)aoPage.getClientProperty("preference.group");
        String sName = (String)oNode.getResource("display.name");
        this.setTitle(sName);
        this.moCurrentPage = aoPage;
        this.moCurrentPage.setForeground(this.getForeground());
        this.moCurrentPage.setBackground(this.getBackground());
        this.moCurrentPage.setTextCaretForeground(this.moTextCaretForeground);
        this.moCurrentPage.setTextCaretBackground(this.moTextCaretBackground);
        this.moCurrentPage.setTextEntryForeground(this.moTextEntryForeground);
        this.moCurrentPage.setTextEntryBackground(this.moTextEntryBackground);
        this.moCurrentPage.setSelectionForeground(this.moSelectionForeground);
        this.moCurrentPage.setSelectionBackground(this.moSelectionBackground);
        this.moCurrentPage.setSeparatorForeground(this.moSeparatorForeground);
        this.moCurrentPage.setSeparatorBackground(this.moSeparatorBackground);
        this.moCurrentPage.setDisabledForeground(this.moDisabledForeground);
        this.moCurrentPage.setDisabledBackground(this.moDisabledBackground);
        if (this.moScroller != null) {
            this.remove(this.moScroller);
        }
        this.moScroller = new JScrollPane(aoPage);
        this.moScroller.setOpaque(false);
        this.moScroller.getViewport().setOpaque(false);
        this.moScroller.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.add((Component)this.moScroller, "Center");
        this.revalidate();
        this.repaint();
        this.requestFocusInWindow();
    }

    public void cancel() {
        WorkPane oWorkPane = this.getWorkPane();
        if (oWorkPane != null) {
            oWorkPane.pull(this);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ClassMessageHandler oMessageHandler = new ClassMessageHandler();
        MessageBus.registerListener(oMessageHandler, class$novaworx$message$ProgramStart == null ? (class$novaworx$message$ProgramStart = About.class$("novaworx.message.ProgramStart")) : class$novaworx$message$ProgramStart);
        moShowActionHandler = new ShowActionHandler();
        ProgramAction oAction = (ProgramAction)ActionLibrary.get("about");
        oAction.pushListener(moShowActionHandler);
    }

    protected class PreferenceChangeHandler
    implements PreferenceChangeListener {
        private Preferences moWorkAreaPreferences = PreferenceEngine.get().getPreferences("/program/workarea");

        public PreferenceChangeHandler() {
            this.moWorkAreaPreferences.addPreferenceChangeListener(this);
        }

        public void init() {
            PreferenceEngine.get().initPreference(this.moWorkAreaPreferences, "default", this);
            PreferenceEngine.get().initPreference(this.moWorkAreaPreferences, "highlight", this);
        }

        public void preferenceChange(PreferenceChangeEvent aoEvent) {
            Preferences oPreferences = aoEvent.getNode();
            String sPath = oPreferences.absolutePath();
            String sKey = aoEvent.getKey();
            String sValue = aoEvent.getNewValue();
            if (oPreferences == this.moWorkAreaPreferences) {
                if ("default".equals(sKey)) {
                    About.this.setForeground(XColor.decodeForeground(sValue));
                    About.this.setBackground(XColor.decodeBackground(sValue));
                    About.this.setSelectionForeground(XColor.decodeForeground(sValue));
                } else if ("highlight".equals(sKey)) {
                    About.this.setSeparatorForeground(XColor.decodeForeground(sValue));
                    About.this.setSeparatorBackground(XColor.decodeBackground(sValue));
                } else if ("textfield".equals(sKey)) {
                    About.this.setTextEntryBackground(XColor.decode(sValue));
                } else if ("selection".equals(sKey)) {
                    About.this.setSelectionForeground(XColor.decodeForeground(sValue));
                    About.this.setSelectionBackground(XColor.decodeBackground(sValue));
                } else if ("caret".equals(sKey)) {
                    About.this.setTextCaretForeground(XColor.decode(sValue));
                }
                About.this.repaint();
            }
        }
    }

    private static class ClassMessageHandler
    implements MessageListener {
        private ClassMessageHandler() {
        }

        public void messageReceived(Message aoMessage) {
            if (aoMessage instanceof ProgramStart) {
                // empty if block
            }
        }
    }

    private class MessageHandler
    implements MessageListener {
        private MessageHandler() {
        }

        public void messageReceived(Message aoMessage) {
            if (aoMessage instanceof ProgramStopRequested) {
                About.this.cancel();
            } else if (aoMessage instanceof DaemonModeEnabled) {
                About.this.moDaemonLabel.setText("Yes");
            } else if (aoMessage instanceof DaemonModeDisabled) {
                About.this.moDaemonLabel.setText("No");
            }
        }
    }

    private class ViewPaneHandler
    extends ViewPaneAdapter {
        private ViewPaneHandler() {
        }

        public void paneClosed(ViewPaneEvent aoEvent) {
            About.this.cancel();
        }
    }

    private class CancelActionHandler
    implements ActionListener {
        private CancelActionHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            About.this.cancel();
        }
    }

    private static class ShowActionHandler
    extends AbstractAction {
        private ShowActionHandler() {
        }

        public void actionPerformed(ActionEvent aoEvent) {
            WorkFrame oWorkFrame = GuiEngine.get().getSelectedWorkFrame();
            WorkArea oWorkArea = oWorkFrame.getSelectedWorkArea();
            WorkPane oWorkPane = oWorkArea.getDefaultWorkPane();
            if (moInstance != null && moInstance.isAllocated()) {
                moInstance.getWorkPane().pull(moInstance);
            }
            WorkView oView = WorkViewEngine.get().getView((class$novaworx$view$about$About == null ? (class$novaworx$view$about$About = About.class$("novaworx.view.about.About")) : class$novaworx$view$about$About).getName());
            oWorkPane.push(oView);
            oView.requestFocusInWindow();
        }
    }

    private class OutlineHandler
    implements OutlineListener {
        private OutlineHandler() {
        }

        public void selectLink(Node aoNode) {
            InformationPage oPage = (InformationPage)aoNode.getResource("page");
            About.this.showPage(oPage);
        }

        public void selectDecl(Node aoNode) {
        }

        public void selectNode(Node aoNode) {
        }
    }
}

