/*
 * Decompiled with CFR 0.152.
 */
package novaworx.util.thread;

public abstract class Worker
implements Runnable {
    private boolean mbDaemon;
    private Thread moThread;
    private boolean mbExecuting;

    public Worker() {
        this(false);
    }

    public Worker(boolean abDaemon) {
        this.mbDaemon = abDaemon;
    }

    public boolean isExecuting() {
        return this.mbExecuting;
    }

    public void start() {
        if (this.isExecuting()) {
            return;
        }
        this.moThread = new Thread((Runnable)this, "novaworx.util.Worker");
        this.moThread.setDaemon(this.mbDaemon);
        this.mbExecuting = true;
        this.moThread.start();
    }

    public void stop() {
        if (!this.isExecuting()) {
            return;
        }
        this.mbExecuting = false;
        this.moThread.interrupt();
    }

    public void stopAndWait() {
        this.stop();
        try {
            this.moThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stopAndWait(int aiTimeout) {
        this.stop();
        try {
            this.moThread.join(aiTimeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Thread getWorkerThread() {
        return this.moThread;
    }
}

