/*
 * Decompiled with CFR 0.152.
 */
package novaworx.util.thread;

import novaworx.log.Log;
import novaworx.util.thread.ThreadPool;
import novaworx.util.thread.ThreadPoolThreadMonitor;

class ThreadPoolThread
extends Thread {
    private static int miThreadCount;
    private int miIndex = miThreadCount;
    ThreadPool moThreadPool;
    ThreadPoolThreadMonitor moMonitor;

    ThreadPoolThread(ThreadPool aoThreadPool) {
        super((ThreadGroup)aoThreadPool, "ThreadPoolThread-" + miThreadCount++);
        this.moThreadPool = aoThreadPool;
    }

    public int getIdentifier() {
        return this.miIndex;
    }

    public void setMonitor(ThreadPoolThreadMonitor aoMonitor) {
        this.moMonitor = aoMonitor;
    }

    public ThreadPoolThreadMonitor getMonitor() {
        return this.moMonitor;
    }

    public void run() {
        while (!this.isInterrupted()) {
            Runnable oRunnable = (Runnable)this.moThreadPool.getRunnableQueue().get();
            this.moThreadPool.decreaseAvailableThreadCount();
            if (this.moMonitor != null) {
                this.moMonitor.threadAllocated();
            }
            try {
                oRunnable.run();
            }
            catch (Throwable aoThrowable) {
                Log.write(2, aoThrowable);
            }
            if (this.moMonitor != null) {
                this.moMonitor.threadDeallocated();
            }
            this.moThreadPool.increaseAvailableThreadCount();
        }
        if (this.moMonitor != null) {
            this.moMonitor.threadTerminated();
        }
    }
}

