/*
 * Decompiled with CFR 0.152.
 */
package novaworx.util.thread;

import novaworx.log.Log;
import novaworx.util.thread.BlockingQueue;
import novaworx.util.thread.ThreadPoolMonitor;
import novaworx.util.thread.ThreadPoolThread;

public class ThreadPool
extends ThreadGroup {
    private boolean mbExecuting;
    private int miAvailable;
    private int miMinimumSize;
    private int miMaximumSize;
    private BlockingQueue moRunnableQueue = new BlockingQueue();
    private static int miThreadPoolCount;
    private ThreadPoolMonitor moMonitor;

    public ThreadPool() {
        this(0, 0);
    }

    public ThreadPool(int aiMinimum, int aiMaximum) {
        super("ThreadPool-" + miThreadPoolCount++);
        this.setMinimumSize(aiMinimum);
        this.setMaximumSize(aiMaximum);
    }

    public void setMinimumSize(int aiSize) {
        this.miMinimumSize = aiSize;
        if (this.activeCount() < aiSize) {
            this.grow(aiSize - this.activeCount());
        }
    }

    public int getMinimumSize() {
        return this.miMinimumSize;
    }

    public void setMaximumSize(int aiSize) {
        this.miMaximumSize = aiSize;
        if (this.activeCount() > aiSize) {
            this.shrink(this.activeCount() - aiSize);
        }
    }

    public int getMaximumSize() {
        return this.miMaximumSize;
    }

    public synchronized void allow() {
        this.mbExecuting = true;
    }

    public synchronized void execute(Runnable aoRunnable) {
        if (!this.mbExecuting) {
            return;
        }
        if (this.miAvailable == 0 & this.canGrow()) {
            this.grow(1);
        }
        this.moRunnableQueue.add(aoRunnable);
    }

    public synchronized void disallow() {
        this.mbExecuting = false;
    }

    private boolean canGrow() {
        return this.miMaximumSize == 0 | this.activeCount() < this.miMaximumSize;
    }

    private void grow(int aiSize) {
        for (int iIndex = 0; iIndex < aiSize; ++iIndex) {
            ThreadPoolThread oNewThread = new ThreadPoolThread(this);
            oNewThread.start();
            ++this.miAvailable;
        }
        if (this.moMonitor != null) {
            this.moMonitor.threadPoolGrew();
        }
    }

    private void shrink(int aiSize) {
    }

    public void uncaughtException(Thread aoThread, Throwable aoThrowable) {
        Log.write(2, aoThrowable);
    }

    public void setMonitor(ThreadPoolMonitor aoMonitor) {
        this.moMonitor = aoMonitor;
    }

    public ThreadPoolMonitor getMonitor() {
        return this.moMonitor;
    }

    BlockingQueue getRunnableQueue() {
        return this.moRunnableQueue;
    }

    void decreaseAvailableThreadCount() {
        --this.miAvailable;
    }

    void increaseAvailableThreadCount() {
        ++this.miAvailable;
    }
}

