/*
 * Decompiled with CFR 0.152.
 */
package novaworx.util.thread;

import java.util.LinkedList;

public class BlockingQueue {
    private LinkedList moQueue;
    private int miMaximumSize;
    private boolean mbActive;
    private boolean mbClosed;

    public BlockingQueue() {
        this(0);
    }

    public BlockingQueue(int aiMaximum) {
        this.miMaximumSize = aiMaximum;
        this.mbActive = true;
        this.moQueue = new LinkedList();
    }

    public synchronized boolean add(Object aoObject) {
        if (this.mbClosed || !this.mbActive) {
            return false;
        }
        while (this.miMaximumSize > 0 && this.moQueue.size() == this.miMaximumSize) {
            try {
                this.wait();
            }
            catch (InterruptedException aoException) {
                return false;
            }
        }
        this.moQueue.add(aoObject);
        this.notifyAll();
        return true;
    }

    public synchronized Object get() {
        while (this.moQueue.size() == 0) {
            if (this.mbClosed || !this.mbActive) {
                return null;
            }
            try {
                this.wait();
            }
            catch (InterruptedException aoException) {
                return null;
            }
        }
        Object oObject = this.moQueue.removeFirst();
        this.notifyAll();
        return oObject;
    }

    public synchronized void setActive(boolean abActive) {
        this.mbActive = abActive;
        this.notifyAll();
    }

    public synchronized void close() {
        this.mbClosed = true;
        this.notifyAll();
    }
}

