/*
 * Decompiled with CFR 0.152.
 */
package novaworx.util.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

public class Trimmer {
    public static final String trim(String asText, String asTrims) {
        if (asText == null || asText.length() == 0) {
            return asText;
        }
        int nLength = asText.length();
        int nStart = 0;
        int nEnd = nLength - 1;
        char[] aValue = new char[nLength];
        char[] aTrims = new char[asTrims.length()];
        asText.getChars(0, aValue.length, aValue, 0);
        asTrims.getChars(0, aTrims.length, aTrims, 0);
        char rChar = '\u0000';
        boolean bLeft = true;
        while (bLeft & nStart <= nEnd) {
            rChar = aValue[nStart];
            boolean bFound = false;
            for (int nCharIndex = 0; nCharIndex < aTrims.length; ++nCharIndex) {
                if (rChar != aTrims[nCharIndex]) continue;
                bFound = true;
            }
            bLeft = bFound;
            if (!bFound) continue;
            ++nStart;
        }
        rChar = '\u0000';
        boolean bRight = true;
        while (bRight & nEnd >= nStart) {
            rChar = aValue[nEnd];
            boolean bFound = false;
            for (int nCharIndex = 0; nCharIndex < aTrims.length; ++nCharIndex) {
                if (rChar != aTrims[nCharIndex]) continue;
                bFound = true;
            }
            bRight = bFound;
            if (!bFound) continue;
            --nEnd;
        }
        String sReturn = asText;
        if (nStart > 0 || nEnd < nLength - 1) {
            sReturn = new String(aValue, nStart, nEnd - nStart + 1);
        }
        return sReturn;
    }

    public static final String eat(String asText, String asTrims) {
        StringBuffer cLineBuffer = null;
        StringBuffer cBuffer = new StringBuffer();
        StringReader cStringReader = new StringReader(asText);
        BufferedReader cBufferedReader = new BufferedReader(cStringReader);
        try {
            String sLine = cBufferedReader.readLine();
            while (sLine != null && sLine.length() == 0) {
                cBuffer.append(Trimmer.trim("\n", asTrims));
                sLine = cBufferedReader.readLine();
            }
            if (sLine != null) {
                char rChar = sLine.charAt(0);
                while (sLine != null) {
                    cLineBuffer = new StringBuffer(sLine);
                    cLineBuffer.append("\n");
                    cBuffer.append(Trimmer.trim(cLineBuffer.toString(), asTrims));
                    sLine = cBufferedReader.readLine();
                }
            }
        }
        catch (IOException acException) {
            System.out.println("Error running unindent( String asText ).");
        }
        return cBuffer.toString();
    }
}

