/*
 * Decompiled with CFR 0.152.
 */
package novaworx.util.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;

public class Indenter {
    private static final void writeIndent(Writer acWriter, int anIndent) throws IOException {
        Indenter.writeIndent(acWriter, anIndent, '\t');
    }

    private static final void writeIndent(Writer acWriter, int anIndent, char arChar) throws IOException {
        for (int nIndex = 0; nIndex < anIndent; ++nIndex) {
            acWriter.write(arChar);
        }
    }

    private static final String createIndent(int anIndent) {
        return Indenter.createIndent(anIndent, '\t');
    }

    private static final String createIndent(int anIndent, char arChar) {
        StringBuffer cBuffer = new StringBuffer();
        for (int nCount = 0; nCount < anIndent; ++nCount) {
            cBuffer.append(arChar);
        }
        return cBuffer.toString();
    }

    private static final String createSoftTab(int anSoftTabWidth) {
        StringBuffer cBuffer = new StringBuffer();
        for (int nCount = 0; nCount < anSoftTabWidth; ++nCount) {
            cBuffer.append(" ");
        }
        return cBuffer.toString();
    }

    public static final String indent(String asText, int anIndent) {
        return Indenter.indent(asText, anIndent, '\t');
    }

    public static final String indent(String asText, int anIndent, char arChar) {
        if (asText == null) {
            return null;
        }
        String sIndent = Indenter.createIndent(anIndent, arChar);
        StringBuffer cBuffer = new StringBuffer(asText);
        cBuffer.insert(0, sIndent);
        for (int nIndex = 0; nIndex < cBuffer.length(); ++nIndex) {
            if (cBuffer.charAt(nIndex) == '\n') {
                cBuffer.replace(nIndex, nIndex + 1, "\n" + sIndent);
            }
            if (cBuffer.charAt(nIndex) != '\r') continue;
            if (cBuffer.charAt(nIndex + 1) == '\n') {
                cBuffer.replace(nIndex, nIndex + 2, "\r\n" + sIndent);
                continue;
            }
            cBuffer.replace(nIndex, nIndex + 1, "\r" + sIndent);
        }
        return cBuffer.toString();
    }

    public static final boolean canUnindent(String asText) {
        return Indenter.canUnindent(asText, '\t');
    }

    public static final boolean canUnindent(String asText, char acChar) {
        boolean bCan = true;
        StringReader cStringReader = new StringReader(asText);
        BufferedReader cBufferedReader = new BufferedReader(cStringReader);
        try {
            String sLine = cBufferedReader.readLine();
            while (sLine != null && sLine.length() == 0) {
                sLine = cBufferedReader.readLine();
            }
            if (sLine != null) {
                char rChar = sLine.charAt(0);
                if (rChar != acChar & rChar != ' ') {
                    bCan = false;
                }
                while (sLine != null & bCan) {
                    if (sLine.length() > 0 && sLine.charAt(0) != rChar) {
                        bCan = false;
                    }
                    sLine = cBufferedReader.readLine();
                }
            } else {
                bCan = false;
            }
        }
        catch (IOException acException) {
            System.out.println("Error running unindent( String asText ).");
        }
        return bCan;
    }

    public static final String unindent(String asText) {
        if (!Indenter.canUnindent(asText)) {
            return asText;
        }
        StringBuffer cBuffer = new StringBuffer();
        StringReader cStringReader = new StringReader(asText);
        BufferedReader cBufferedReader = new BufferedReader(cStringReader);
        try {
            String sLine = cBufferedReader.readLine();
            while (sLine != null && sLine.length() == 0) {
                cBuffer.append("\n");
                sLine = cBufferedReader.readLine();
            }
            if (sLine != null) {
                char rChar = sLine.charAt(0);
                while (sLine != null) {
                    if (sLine.length() > 0 && sLine.charAt(0) == rChar) {
                        cBuffer.append(sLine.substring(1));
                    }
                    cBuffer.append("\n");
                    sLine = cBufferedReader.readLine();
                }
            }
        }
        catch (IOException acException) {
            System.out.println("Error running unindent( String asText ).");
        }
        return cBuffer.toString();
    }
}

