/*
 * Decompiled with CFR 0.152.
 */
package novaworx.util;

import java.io.File;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class CommandLine
implements Serializable {
    private String[] maParameters;
    private Hashtable mhParameters;
    private Vector mvFiles;
    private String[] maFlags;

    public CommandLine(String[] aaParameters) {
        this(aaParameters, null);
    }

    public CommandLine(String[] aaParameters, String[] aaFlags) {
        this.maParameters = new String[aaParameters.length];
        System.arraycopy(aaParameters, 0, this.maParameters, 0, aaParameters.length);
        this.mhParameters = new Hashtable();
        this.mvFiles = new Vector();
        this.maFlags = aaFlags;
        String sUserDir = System.getProperty("user.dir");
        for (int iIndex = 0; iIndex < aaParameters.length; ++iIndex) {
            String sCommand = aaParameters[iIndex];
            if (sCommand.startsWith("-")) {
                String sValue = null;
                if (++iIndex < aaParameters.length) {
                    sValue = aaParameters[iIndex];
                }
                if (this.isFlag(sCommand) || sValue == null || sValue.startsWith("-")) {
                    --iIndex;
                    this.mhParameters.put(sCommand.substring(1).toLowerCase(), "true");
                    continue;
                }
                this.mhParameters.put(sCommand.substring(1).toLowerCase(), sValue);
                continue;
            }
            File oFile = new File(sCommand);
            String sFile = oFile.isAbsolute() ? oFile.toString() : sUserDir + File.separator + sCommand;
            this.mvFiles.add(sFile);
        }
    }

    private boolean isFlag(String asCommand) {
        boolean bFlag = false;
        if (this.maFlags == null) {
            return false;
        }
        for (int iIndex = 0; iIndex < this.maFlags.length; ++iIndex) {
            boolean bl = bFlag = asCommand != null && asCommand.equals("-" + this.maFlags[iIndex]);
            if (bFlag) break;
        }
        return bFlag;
    }

    public String get(String asKey) {
        return (String)this.mhParameters.get(asKey.toLowerCase());
    }

    public String get(String asKey, String asDefault) {
        String sValue = (String)this.mhParameters.get(asKey.toLowerCase());
        return sValue == null ? asDefault : sValue;
    }

    public Vector getFiles() {
        return this.mvFiles;
    }

    public String toString() {
        StringBuffer oBuffer = new StringBuffer();
        int iCount = this.maParameters.length;
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            if (iIndex > 0) {
                oBuffer.append(" ");
            }
            oBuffer.append(this.maParameters[iIndex]);
        }
        return oBuffer.toString();
    }
}

