/*
 * Decompiled with CFR 0.152.
 */
package novaworx.syntax;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;

public class SyntaxUtilities {
    private SyntaxUtilities() {
    }

    public static boolean regionMatches(boolean abIgnoreCase, Segment aoText, int aiOffset, String asMatch) {
        return SyntaxUtilities.regionMatches(abIgnoreCase, aoText, aiOffset, asMatch.toCharArray());
    }

    public static boolean regionMatches(boolean ignoreCase, Segment text, int offset, char[] match) {
        int length = offset + match.length;
        char[] textArray = text.array;
        if (length > text.offset + text.count) {
            return false;
        }
        int i = offset;
        int j = 0;
        while (i < length) {
            char c1 = textArray[i];
            char c2 = match[j];
            if (ignoreCase) {
                c1 = Character.toUpperCase(c1);
                c2 = Character.toUpperCase(c2);
            }
            if (c1 != c2) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static int locateBracketBackward(Document doc, int dot, char openBracket, char closeBracket) throws BadLocationException {
        Element map = doc.getDefaultRootElement();
        int lineNo = map.getElementIndex(dot);
        Element lineElement = map.getElement(lineNo);
        int start = lineElement.getStartOffset();
        int offset = SyntaxUtilities.scanBackwardLine(doc.getText(start, dot - start), openBracket, closeBracket, 0);
        int count = -offset - 1;
        if (offset >= 0) {
            return start + offset;
        }
        for (int i = lineNo - 1; i >= 0; --i) {
            lineElement = map.getElement(i);
            start = lineElement.getStartOffset();
            offset = SyntaxUtilities.scanBackwardLine(doc.getText(start, lineElement.getEndOffset() - start), openBracket, closeBracket, count);
            count = -offset - 1;
            if (offset < 0) continue;
            return start + offset;
        }
        return -1;
    }

    public static int locateBracketForward(Document doc, int dot, char openBracket, char closeBracket) throws BadLocationException {
        Element map = doc.getDefaultRootElement();
        int lineNo = map.getElementIndex(dot);
        Element lineElement = map.getElement(lineNo);
        int start = lineElement.getStartOffset();
        int end = lineElement.getEndOffset();
        int offset = SyntaxUtilities.scanForwardLine(doc.getText(dot + 1, end - (dot + 1)), openBracket, closeBracket, 0);
        int count = -offset - 1;
        if (offset >= 0) {
            return dot + offset + 1;
        }
        for (int i = lineNo + 1; i < map.getElementCount(); ++i) {
            lineElement = map.getElement(i);
            start = lineElement.getStartOffset();
            offset = SyntaxUtilities.scanForwardLine(doc.getText(start, lineElement.getEndOffset() - start), openBracket, closeBracket, count);
            count = -offset - 1;
            if (offset < 0) continue;
            return start + offset;
        }
        return -1;
    }

    private static int scanBackwardLine(String line, char openBracket, char closeBracket, int count) {
        for (int i = line.length() - 1; i >= 0; --i) {
            char c = line.charAt(i);
            if (c == closeBracket) {
                ++count;
                continue;
            }
            if (c != openBracket || --count >= 0) continue;
            return i;
        }
        return -1 - count;
    }

    private static int scanForwardLine(String line, char openBracket, char closeBracket, int count) {
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == openBracket) {
                ++count;
                continue;
            }
            if (c != closeBracket || --count >= 0) continue;
            return i;
        }
        return -1 - count;
    }

    public static String globToRE(String glob) {
        StringBuffer buf = new StringBuffer();
        boolean backslash = false;
        boolean insideGroup = false;
        block9: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            if (backslash) {
                buf.append('\\');
                buf.append(c);
                backslash = false;
                continue;
            }
            switch (c) {
                case '\\': {
                    backslash = true;
                    continue block9;
                }
                case '?': {
                    buf.append('.');
                    continue block9;
                }
                case '.': {
                    buf.append("\\.");
                    continue block9;
                }
                case '*': {
                    buf.append(".*");
                    continue block9;
                }
                case '{': {
                    buf.append('(');
                    insideGroup = true;
                    continue block9;
                }
                case ',': {
                    if (insideGroup) {
                        buf.append('|');
                        continue block9;
                    }
                    buf.append(',');
                    continue block9;
                }
                case '}': {
                    buf.append(')');
                    insideGroup = false;
                    continue block9;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }
}

