/*
 * Decompiled with CFR 0.152.
 */
package novaworx.syntax;

import java.util.Hashtable;
import java.util.Stack;
import novaworx.log.Log;
import novaworx.syntax.KeywordMap;
import novaworx.syntax.ParserRuleFactory;
import novaworx.syntax.ParserRuleSet;
import novaworx.syntax.Syntax;
import novaworx.syntax.TokenMarker;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class SyntaxHandler
extends DefaultHandler {
    private Syntax moSyntax;
    private TokenMarker moTokenMarker;
    private KeywordMap moKeywords;
    private Stack msStateStack = new Stack();
    private String msPropertyName;
    private String msPropertyValue;
    private Hashtable mhProperties;
    private String msLastStart;
    private String msLastEnd;
    private String msLastKeyword;
    private String msLastSetName;
    private String msLastEscape;
    private String msLastDelegateSet;
    private ParserRuleSet moRules;
    private byte myLastDefaultID = 0;
    private byte myLastTokenID;
    private int miTermChar = -1;
    private boolean mbLastNoLineBreak;
    private boolean mbLastNoWordBreak;
    private boolean mbLastAtLineStart;
    private boolean mbLastExcludeMatch;
    private boolean mbLastIgnoreCase;
    private boolean mbLastHighlightDigits;

    public void setSyntax(Syntax aoSyntax) {
        this.moSyntax = aoSyntax;
    }

    public InputSource resolveEntity(String asPublicID, String asSystemID) {
        String sSyntaxDTD = "syntax.dtd";
        if (asSystemID != null && asSystemID.endsWith(sSyntaxDTD)) {
            try {
                return new InputSource(this.getClass().getResourceAsStream(sSyntaxDTD));
            }
            catch (Exception aoException) {
                Log.write(2, "Error while loading DTD: " + sSyntaxDTD);
                Log.write(2, (Throwable)aoException);
            }
        }
        return null;
    }

    public void attribute(String asName, String asValue) {
        asName = asName == null ? null : asName.intern();
        String string = asValue = asValue == null ? null : asValue.intern();
        if (asName == "NAME") {
            this.msPropertyName = asValue;
        } else if (asName == "VALUE") {
            this.msPropertyValue = asValue;
        } else if (asName == "TYPE") {
            this.myLastTokenID = this.stringToToken(asValue);
        } else if (asName == "AT_LINE_START") {
            this.mbLastAtLineStart = asValue == "TRUE";
        } else if (asName == "NO_LINE_BREAK") {
            this.mbLastNoLineBreak = asValue == "TRUE";
        } else if (asName == "NO_WORD_BREAK") {
            this.mbLastNoWordBreak = asValue == "TRUE";
        } else if (asName == "EXCLUDE_MATCH") {
            this.mbLastExcludeMatch = asValue == "TRUE";
        } else if (asName == "IGNORE_CASE") {
            this.mbLastIgnoreCase = asValue == "TRUE";
        } else if (asName == "HIGHLIGHT_DIGITS") {
            this.mbLastHighlightDigits = asValue == "TRUE";
        } else if (asName == "AT_CHAR") {
            try {
                this.miTermChar = Integer.parseInt(asValue);
            }
            catch (NumberFormatException aoException) {
                this.miTermChar = -1;
            }
        } else if (asName == "ESCAPE") {
            this.msLastEscape = asValue;
        } else if (asName == "SET") {
            this.msLastSetName = asValue;
        } else if (asName == "DELEGATE") {
            this.msLastDelegateSet = asValue;
        } else if (asName == "DEFAULT") {
            this.myLastDefaultID = this.stringToToken(asValue);
        }
    }

    public void doctypeDecl(String asName, String asPublicID, String asSystemID) throws Exception {
        if ("MODE".equalsIgnoreCase(asName)) {
            return;
        }
        Log.write("Invalid doctype: " + asName);
    }

    public void characters(char[] aaData, int aiOffset, int aiLength) {
        String sTag = this.peekElement();
        String sText = new String(aaData, aiOffset, aiLength);
        if (sTag == "WHITESPACE" || sTag == "EOL_SPAN" || sTag == "MARK_PREVIOUS" || sTag == "MARK_FOLLOWING" || sTag == "SEQ" || sTag == "BEGIN") {
            this.msLastStart = this.msLastStart == null ? sText : this.msLastStart.concat(sText);
        } else if (sTag == "END") {
            this.msLastEnd = this.msLastEnd == null ? sText : this.msLastEnd.concat(sText);
        } else {
            this.msLastKeyword = this.msLastKeyword == null ? sText : this.msLastKeyword.concat(sText);
        }
    }

    public void startElement(String asNamespace, String asLocalName, String asQualifiedName, Attributes aoAttributes) {
        for (int iIndex = 0; iIndex < aoAttributes.getLength(); ++iIndex) {
            String sName = aoAttributes.getQName(iIndex);
            String sValue = aoAttributes.getValue(iIndex);
            this.attribute(sName, sValue);
        }
        if ((asQualifiedName = this.pushElement(asQualifiedName)) == "KEYWORDS") {
            this.moKeywords = new KeywordMap(true);
        } else if (asQualifiedName == "RULES") {
            this.moRules = new ParserRuleSet(this.msLastSetName, this.moSyntax);
            this.moRules.setIgnoreCase(this.mbLastIgnoreCase);
            this.moRules.setHighlightDigits(this.mbLastHighlightDigits);
            this.moRules.setEscape(this.msLastEscape);
            this.moRules.setDefault(this.myLastDefaultID);
        }
    }

    public void endElement(String asNamespace, String asLocalName, String asQualifiedName) {
        if (asQualifiedName == null) {
            return;
        }
        String sTag = this.popElement();
        if (asQualifiedName.equalsIgnoreCase(sTag)) {
            if (sTag == "MODE") {
                this.moSyntax.init();
                this.moSyntax.setTokenMarker(this.moTokenMarker);
            } else if (sTag == "PROPERTY") {
                this.mhProperties.put(this.msPropertyName, this.msPropertyValue);
            } else if (sTag == "PROPS") {
                if (this.peekElement().equals("RULES")) {
                    this.moRules.setProperties(this.mhProperties);
                } else {
                    this.moSyntax.setProperties(this.mhProperties);
                }
                this.mhProperties = new Hashtable();
            } else if (sTag == "KEYWORDS") {
                this.moKeywords.setIgnoreCase(this.mbLastIgnoreCase);
                this.mbLastIgnoreCase = true;
            } else if (sTag == "RULES") {
                this.moRules.setKeywords(this.moKeywords);
                this.moTokenMarker.addRuleSet(this.msLastSetName, this.moRules);
                this.moKeywords = null;
                this.msLastSetName = null;
                this.msLastEscape = null;
                this.mbLastIgnoreCase = true;
                this.mbLastHighlightDigits = false;
                this.myLastDefaultID = 0;
                this.moRules = null;
            } else if (sTag == "TERMINATE") {
                this.moRules.setTerminateChar(this.miTermChar);
                this.miTermChar = -1;
            } else if (sTag == "WHITESPACE") {
                if (this.msLastStart == null) {
                    return;
                }
                this.moRules.addRule(ParserRuleFactory.createWhitespaceRule(this.msLastStart));
                this.msLastStart = null;
                this.msLastEnd = null;
            } else if (sTag == "EOL_SPAN") {
                if (this.msLastStart == null) {
                    return;
                }
                this.moRules.addRule(ParserRuleFactory.createEOLSpanRule(this.msLastStart, this.myLastTokenID, this.mbLastAtLineStart, this.mbLastExcludeMatch));
                this.msLastStart = null;
                this.msLastEnd = null;
                this.myLastTokenID = 0;
                this.mbLastAtLineStart = false;
                this.mbLastExcludeMatch = false;
            } else if (sTag == "MARK_PREVIOUS") {
                if (this.msLastStart == null) {
                    return;
                }
                this.moRules.addRule(ParserRuleFactory.createMarkPreviousRule(this.msLastStart, this.myLastTokenID, this.mbLastAtLineStart, this.mbLastExcludeMatch));
                this.msLastStart = null;
                this.msLastEnd = null;
                this.myLastTokenID = 0;
                this.mbLastAtLineStart = false;
                this.mbLastExcludeMatch = false;
            } else if (sTag == "MARK_FOLLOWING") {
                if (this.msLastStart == null) {
                    return;
                }
                this.moRules.addRule(ParserRuleFactory.createMarkFollowingRule(this.msLastStart, this.myLastTokenID, this.mbLastAtLineStart, this.mbLastExcludeMatch));
                this.msLastStart = null;
                this.msLastEnd = null;
                this.myLastTokenID = 0;
                this.mbLastAtLineStart = false;
                this.mbLastExcludeMatch = false;
            } else if (sTag == "SEQ") {
                if (this.msLastStart == null) {
                    return;
                }
                this.moRules.addRule(ParserRuleFactory.createSequenceRule(this.msLastStart, this.myLastTokenID, this.mbLastAtLineStart));
                this.msLastStart = null;
                this.msLastEnd = null;
                this.myLastTokenID = 0;
                this.mbLastAtLineStart = false;
            } else if (sTag == "END") {
                if (this.msLastDelegateSet == null) {
                    this.moRules.addRule(ParserRuleFactory.createSpanRule(this.msLastStart, this.msLastEnd, this.myLastTokenID, this.mbLastNoLineBreak, this.mbLastAtLineStart, this.mbLastExcludeMatch, this.mbLastNoWordBreak));
                } else {
                    if (this.msLastDelegateSet.indexOf("::") == -1) {
                        this.msLastDelegateSet = this.moSyntax.getName() + "::" + this.msLastDelegateSet;
                    }
                    this.moRules.addRule(ParserRuleFactory.createDelegateSpanRule(this.msLastStart, this.msLastEnd, this.msLastDelegateSet, this.myLastTokenID, this.mbLastNoLineBreak, this.mbLastAtLineStart, this.mbLastExcludeMatch, this.mbLastNoWordBreak));
                }
                this.msLastStart = null;
                this.msLastEnd = null;
                this.myLastTokenID = 0;
                this.mbLastAtLineStart = false;
                this.mbLastNoLineBreak = false;
                this.mbLastExcludeMatch = false;
                this.mbLastNoWordBreak = false;
                this.msLastDelegateSet = null;
            } else if (sTag == "NULL") {
                this.addKeyword(this.msLastKeyword, (byte)0);
            } else if (sTag == "COMMENT1") {
                this.addKeyword(this.msLastKeyword, (byte)1);
            } else if (sTag == "COMMENT2") {
                this.addKeyword(this.msLastKeyword, (byte)2);
            } else if (sTag == "COMMENT3") {
                this.addKeyword(this.msLastKeyword, (byte)3);
            } else if (sTag == "LITERAL1") {
                this.addKeyword(this.msLastKeyword, (byte)5);
            } else if (sTag == "LITERAL2") {
                this.addKeyword(this.msLastKeyword, (byte)6);
            } else if (sTag == "DIGIT") {
                this.addKeyword(this.msLastKeyword, (byte)4);
            } else if (sTag == "KEYWORD1") {
                this.addKeyword(this.msLastKeyword, (byte)7);
            } else if (sTag == "KEYWORD2") {
                this.addKeyword(this.msLastKeyword, (byte)8);
            } else if (sTag == "KEYWORD3") {
                this.addKeyword(this.msLastKeyword, (byte)9);
            } else if (sTag == "KEYWORD4") {
                this.addKeyword(this.msLastKeyword, (byte)10);
            } else if (sTag == "KEYWORD5") {
                this.addKeyword(this.msLastKeyword, (byte)11);
            } else if (sTag == "FUNCTION") {
                this.addKeyword(this.msLastKeyword, (byte)12);
            } else if (sTag == "OPERATOR") {
                this.addKeyword(this.msLastKeyword, (byte)13);
            } else if (sTag == "MARKUP") {
                this.addKeyword(this.msLastKeyword, (byte)14);
            } else if (sTag == "LABEL") {
                this.addKeyword(this.msLastKeyword, (byte)15);
            }
        } else {
            throw new InternalError();
        }
        this.msLastKeyword = null;
    }

    public void startDocument() {
        this.moTokenMarker = new TokenMarker();
        this.moTokenMarker.setName(this.moSyntax.getName());
        this.mhProperties = new Hashtable();
        this.pushElement(null);
    }

    private byte stringToToken(String value) {
        if (value == "NULL") {
            return 0;
        }
        if (value == "COMMENT1") {
            return 1;
        }
        if (value == "COMMENT2") {
            return 2;
        }
        if (value == "COMMENT3") {
            return 3;
        }
        if (value == "DIGIT") {
            return 4;
        }
        if (value == "LITERAL1") {
            return 5;
        }
        if (value == "LITERAL2") {
            return 6;
        }
        if (value == "KEYWORD1") {
            return 7;
        }
        if (value == "KEYWORD2") {
            return 8;
        }
        if (value == "KEYWORD3") {
            return 9;
        }
        if (value == "KEYWORD4") {
            return 10;
        }
        if (value == "KEYWORD5") {
            return 11;
        }
        if (value == "FUNCTION") {
            return 12;
        }
        if (value == "OPERATOR") {
            return 13;
        }
        if (value == "MARKUP") {
            return 14;
        }
        if (value == "LABEL") {
            return 15;
        }
        if (value == "INVALID") {
            return 16;
        }
        return 0;
    }

    private void addKeyword(String asKeyword, byte ayID) {
        if (asKeyword == null) {
            return;
        }
        if (this.moKeywords == null) {
            return;
        }
        this.moKeywords.add(asKeyword, ayID);
    }

    private String pushElement(String asName) {
        asName = asName == null ? null : asName.intern();
        this.msStateStack.push(asName);
        return asName;
    }

    private String peekElement() {
        return (String)this.msStateStack.peek();
    }

    private String popElement() {
        return (String)this.msStateStack.pop();
    }
}

