/*
 * Decompiled with CFR 0.152.
 */
package novaworx.syntax;

import novaworx.log.Log;
import novaworx.syntax.Syntax;
import novaworx.syntax.SyntaxFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class SyntaxCatalogHandler
extends DefaultHandler {
    private String msName;
    private String msGrammar;
    private String msFilenameGLOB;
    private String msFirstLineGLOB;

    SyntaxCatalogHandler() {
    }

    public InputSource resolveEntity(String asPublicID, String asSystemID) {
        String sCatalogDTD = "catalog.dtd";
        if (asSystemID != null && asSystemID.endsWith(sCatalogDTD)) {
            try {
                return new InputSource(this.getClass().getResourceAsStream(sCatalogDTD));
            }
            catch (Exception aoException) {
                Log.write(2, "Error while loading DTD: " + sCatalogDTD);
                Log.write(2, (Throwable)aoException);
            }
        }
        return null;
    }

    public void doctypeDecl(String asName, String asPublicID, String asSystemID) throws Exception {
        if ("CATALOG".equals(asName)) {
            return;
        }
        Log.write(2, "Loading catalog: DOCTYPE must be CATALOG.");
    }

    public void attribute(String asName, String asValue) {
        asName = asName == null ? null : asName.intern();
        String string = asValue = asValue == null ? null : asValue.intern();
        if (asName == "NAME") {
            this.msName = asValue;
        } else if (asName == "GRAMMAR") {
            this.msGrammar = asValue;
        } else if (asName == "FILE_NAME_GLOB") {
            this.msFilenameGLOB = asValue;
        } else if (asName == "FIRST_LINE_GLOB") {
            this.msFirstLineGLOB = asValue;
        }
    }

    public void startElement(String asNamespace, String asLocalName, String asQualifiedName, Attributes aoAttributes) {
        for (int iIndex = 0; iIndex < aoAttributes.getLength(); ++iIndex) {
            String sName = aoAttributes.getQName(iIndex);
            String sValue = aoAttributes.getValue(iIndex);
            this.attribute(sName, sValue);
        }
    }

    public void endElement(String asNamespace, String asLocalName, String asQualifiedName) {
        if ("MODE".equals(asQualifiedName)) {
            Syntax oSyntax = SyntaxFactory.getSyntax(this.msName);
            if (oSyntax == null) {
                oSyntax = new Syntax(this.msName);
                SyntaxFactory.addSyntax(oSyntax);
            }
            oSyntax.setProperty("grammar", this.msGrammar);
            if (this.msFilenameGLOB != null) {
                oSyntax.setProperty("filenameglob", this.msFilenameGLOB);
            } else {
                oSyntax.unsetProperty("filenameglob");
            }
            if (this.msFirstLineGLOB != null) {
                oSyntax.setProperty("firstlineglob", this.msFirstLineGLOB);
            } else {
                oSyntax.unsetProperty("firstlineglob");
            }
            oSyntax.init();
            this.msFirstLineGLOB = null;
            this.msFilenameGLOB = null;
            this.msGrammar = null;
            this.msName = null;
        }
    }
}

