/*
 * Decompiled with CFR 0.152.
 */
package novaworx.syntax;

import java.util.Hashtable;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import novaworx.log.Log;
import novaworx.syntax.SyntaxFactory;
import novaworx.syntax.SyntaxUtilities;
import novaworx.syntax.TokenMarker;

public class Syntax
implements Comparable {
    private String msName;
    private Hashtable mhProperties;
    private Pattern moFirstLineRE;
    private Pattern moFileNameRE;
    private TokenMarker moTokenMarker;

    public Syntax(String asName) {
        if (asName == null) {
            throw new IllegalArgumentException("Syntax name can not be null.");
        }
        this.msName = asName;
        this.mhProperties = new Hashtable();
    }

    public void init() {
        try {
            String sFileNameGlob = (String)this.getProperty("filenameglob");
            if (sFileNameGlob != null) {
                this.moFileNameRE = Pattern.compile(SyntaxUtilities.globToRE(sFileNameGlob), 2);
            }
        }
        catch (PatternSyntaxException aoException) {
            Log.write(2, "Invalid filename glob in syntax: " + this.msName);
            Log.write(2, (Throwable)aoException);
        }
        try {
            String sFirstLineGlob = (String)this.getProperty("firstlineglob");
            if (sFirstLineGlob != null) {
                this.moFirstLineRE = Pattern.compile(SyntaxUtilities.globToRE(sFirstLineGlob), 2);
            }
        }
        catch (PatternSyntaxException aoException) {
            Log.write(2, "Invalid firstline glob in syntax " + this.msName);
            Log.write(2, (Throwable)aoException);
        }
    }

    public void setTokenMarker(TokenMarker aoMarker) {
        this.moTokenMarker = aoMarker;
    }

    public TokenMarker getTokenMarker() {
        if (this.moTokenMarker == null) {
            SyntaxFactory.loadGrammar(this);
        }
        return this.moTokenMarker;
    }

    public Object getProperty(String asKey) {
        return this.mhProperties.get(asKey);
    }

    public boolean getBooleanProperty(String asKey) {
        Object oValue = this.getProperty(asKey);
        return "true".equals(oValue) || "on".equals(oValue) || "yes".equals(oValue);
    }

    public void setProperty(String asKey, Object aoValue) {
        if (asKey == null) {
            Log.write(2, "Property key can not be null.");
        }
        if (aoValue == null) {
            Log.write(2, "Value for key can not be null: " + asKey);
        }
        if (asKey == null || aoValue == null) {
            return;
        }
        this.mhProperties.put(asKey, aoValue);
    }

    public void unsetProperty(String asKey) {
        this.mhProperties.remove(asKey);
    }

    public void setProperties(Hashtable ahProperties) {
        String sFilenameGlob = (String)this.getProperty("filenameglob");
        String sFirstlineGlob = (String)this.getProperty("firstlineglob");
        this.mhProperties = ahProperties;
        if (sFilenameGlob != null) {
            this.mhProperties.put("filenameglob", sFilenameGlob);
        }
        if (sFirstlineGlob != null) {
            this.mhProperties.put("firstlineglob", sFirstlineGlob);
        }
    }

    public boolean accept(String asFileName, String asFirstLine) {
        if (this.moFileNameRE != null && asFileName != null && this.moFileNameRE.matcher(asFileName).matches()) {
            return true;
        }
        return this.moFirstLineRE != null && asFirstLine != null && this.moFirstLineRE.matcher(asFirstLine).matches();
    }

    public String getName() {
        return this.msName;
    }

    public int compareTo(Object oObject) {
        return this.getName().compareTo(((Syntax)oObject).getName());
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getName() + "]";
    }
}

