/*
 * Decompiled with CFR 0.152.
 */
package novaworx.syntax;

import java.util.Vector;
import javax.swing.text.Segment;
import novaworx.syntax.SyntaxUtilities;

public class KeywordMap {
    private Keyword[] maKeywords;
    private boolean mbIgnoreCase;
    private StringBuffer moNoWordSeparators;
    protected int miMapLength;

    public KeywordMap(boolean abIgnoreCase) {
        this(abIgnoreCase, 52);
    }

    public KeywordMap(boolean abIgnoreCase, int aiMapLength) {
        this.miMapLength = aiMapLength;
        this.mbIgnoreCase = abIgnoreCase;
        this.moNoWordSeparators = new StringBuffer();
        this.maKeywords = new Keyword[aiMapLength];
    }

    public byte lookup(Segment aoText, int aiOffset, int aiLength) {
        if (aiLength == 0) {
            return 0;
        }
        Keyword oKeyword = this.maKeywords[this.getSegmentMapKey(aoText, aiOffset, aiLength)];
        while (oKeyword != null) {
            if (aiLength != oKeyword.maKeyword.length) {
                oKeyword = oKeyword.moNext;
                continue;
            }
            if (SyntaxUtilities.regionMatches(this.mbIgnoreCase, aoText, aiOffset, oKeyword.maKeyword)) {
                return oKeyword.myID;
            }
            oKeyword = oKeyword.moNext;
        }
        return 0;
    }

    public void add(String asKeyword, byte ayID) {
        int iKey = this.getStringMapKey(asKeyword);
        char[] aKeyword = asKeyword.toCharArray();
        block0: for (int iIndex = 0; iIndex < aKeyword.length; ++iIndex) {
            char cChar = aKeyword[iIndex];
            if (Character.isLetterOrDigit(cChar)) continue;
            for (int iSeparatorIndex = 0; iSeparatorIndex < this.moNoWordSeparators.length(); ++iSeparatorIndex) {
                if (this.moNoWordSeparators.charAt(iSeparatorIndex) == cChar) continue block0;
            }
            this.moNoWordSeparators.append(cChar);
        }
        this.maKeywords[iKey] = new Keyword(aKeyword, ayID, this.maKeywords[iKey]);
    }

    public String getNonAlphaNumericChars() {
        return this.moNoWordSeparators.toString();
    }

    public String[] getKeywords() {
        Vector<String> vVector = new Vector<String>(100);
        for (int iIndex = 0; iIndex < this.maKeywords.length; ++iIndex) {
            Keyword oKeyword = this.maKeywords[iIndex];
            while (oKeyword != null) {
                vVector.addElement(new String(oKeyword.maKeyword));
                oKeyword = oKeyword.moNext;
            }
        }
        Object[] aReturn = new String[vVector.size()];
        vVector.copyInto(aReturn);
        return aReturn;
    }

    public boolean getIgnoreCase() {
        return this.mbIgnoreCase;
    }

    public void setIgnoreCase(boolean abIgnoreCase) {
        this.mbIgnoreCase = abIgnoreCase;
    }

    protected int getStringMapKey(String asString) {
        return (Character.toUpperCase(asString.charAt(0)) + Character.toUpperCase(asString.charAt(asString.length() - 1))) % this.miMapLength;
    }

    protected int getSegmentMapKey(Segment aoSegment, int aiOffset, int aiLength) {
        return (Character.toUpperCase(aoSegment.array[aiOffset]) + Character.toUpperCase(aoSegment.array[aiOffset + aiLength - 1])) % this.miMapLength;
    }

    private class Keyword {
        public char[] maKeyword;
        public byte myID;
        public Keyword moNext;

        public Keyword(char[] aaKeyword, byte ayID, Keyword aoNext) {
            this.maKeyword = aaKeyword;
            this.myID = ayID;
            this.moNext = aoNext;
        }
    }
}

