/*
 * Decompiled with CFR 0.152.
 */
package novaworx.swing;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import novaworx.swing.XColor;

public class XWallpaper
extends JComponent
implements SwingConstants {
    public static final int NONE = 0;
    public static final int TILE = 10;
    public static final int SINGLE = 20;
    public static final int STRETCH = 30;
    public static final int STRETCH_ASPECT = 31;
    public static final int STRETCH_ASPECT_CROP = 32;
    private boolean mbShowWallpaper;
    private Image moSource;
    private BufferedImage moWallpaper;
    private double mdWallpaperOpacity;
    private int miWallpaperOrientation;
    private int miWallpaperStyle;

    public XWallpaper() {
        super.setOpaque(true);
        super.setBackground(Color.WHITE);
        super.setLayout(new BorderLayout());
        this.mbShowWallpaper = true;
        this.mdWallpaperOpacity = 1.0;
        this.miWallpaperOrientation = 0;
        this.miWallpaperStyle = 32;
    }

    public void setBackground(Color aoColor) {
        super.setBackground(new XColor(aoColor, 255));
        this.generateWallpaper();
    }

    public void setImage(Image aoImage) {
        this.moSource = aoImage;
        if (this.moSource == null) {
            this.moWallpaper = null;
        }
        this.generateWallpaper();
    }

    public Image getImage() {
        return this.moSource;
    }

    public BufferedImage getSubimage(int aiX, int aiY, int aiW, int aiH) {
        if (this.moWallpaper == null || this.miWallpaperStyle == 0) {
            BufferedImage oImage = new BufferedImage(aiW, aiH, 1);
            Graphics oGraphics = oImage.getGraphics();
            oGraphics.setColor(this.getBackground());
            oGraphics.fillRect(0, 0, aiW, aiH);
            return oImage;
        }
        return this.moWallpaper.getSubimage(aiX, aiY, aiW, aiH);
    }

    public void setOpacity(double adOpacity) {
        if (adOpacity < 0.0 || adOpacity > 1.0) {
            throw new IllegalArgumentException("Wallpaper opacity must be between 0.0 and 1.0.");
        }
        this.mdWallpaperOpacity = adOpacity;
        this.generateWallpaper();
    }

    public double getOpacity() {
        return this.mdWallpaperOpacity;
    }

    public void setOrientation(int aiOrientation) {
        switch (aiOrientation) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.miWallpaperOrientation = aiOrientation;
                break;
            }
            default: {
                this.miWallpaperOrientation = 0;
            }
        }
        this.generateWallpaper();
    }

    public int getOrientation() {
        return this.miWallpaperOrientation;
    }

    public void setStyle(int aiStyle) {
        switch (aiStyle) {
            case 0: 
            case 10: 
            case 20: 
            case 30: 
            case 31: 
            case 32: {
                this.miWallpaperStyle = aiStyle;
                break;
            }
            default: {
                this.miWallpaperStyle = 0;
            }
        }
        this.generateWallpaper();
    }

    public int getStyle() {
        return this.miWallpaperStyle;
    }

    public void paint(Graphics aoGraphics) {
        Rectangle oBounds = this.getBounds();
        Graphics2D oGraphics = (Graphics2D)aoGraphics;
        if (!this.mbShowWallpaper || this.miWallpaperStyle == 0) {
            this.paintBackground(oGraphics, oBounds);
        } else {
            if (this.moWallpaper == null || oBounds.width != this.moWallpaper.getWidth(this) || oBounds.height != this.moWallpaper.getHeight(this)) {
                this.generateWallpaper();
            }
            if (this.moWallpaper == null) {
                this.paintBackground(oGraphics, oBounds);
            } else {
                oGraphics.drawImage((Image)this.moWallpaper, 0, 0, this);
            }
        }
        Boolean oAntiAlias = (Boolean)this.getRootPane().getClientProperty("anti.alias.text");
        oGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oAntiAlias != null && oAntiAlias != false ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.paintChildren(aoGraphics);
    }

    private void paintBackground(Graphics aoGraphics, Rectangle aoBounds) {
        aoGraphics.setColor(this.getBackground());
        aoGraphics.fillRect(aoBounds.x, aoBounds.y, aoBounds.width, aoBounds.height);
    }

    private void generateWallpaper() {
        if (this.moSource == null) {
            return;
        }
        Rectangle oBounds = this.getBounds();
        int iWidth = oBounds.width;
        int iHeight = oBounds.height;
        int iSourceWidth = this.moSource.getWidth(this);
        int iSourceHeight = this.moSource.getHeight(this);
        if (iWidth == 0 || iHeight == 0) {
            return;
        }
        BufferedImage oCombinedImage = new BufferedImage(iSourceWidth, iSourceHeight, 1);
        Graphics2D oCombinedGraphics = oCombinedImage.createGraphics();
        oCombinedGraphics.setColor(this.getBackground());
        oCombinedGraphics.fillRect(0, 0, iSourceWidth, iSourceHeight);
        oCombinedGraphics.setComposite(AlphaComposite.getInstance(3, (float)this.mdWallpaperOpacity));
        oCombinedGraphics.drawImage(this.moSource, 0, 0, this);
        BufferedImage oWallpaper = new BufferedImage(iWidth, iHeight, 1);
        Graphics2D oWallpaperGraphics = oWallpaper.createGraphics();
        this.drawWallpaper(oWallpaperGraphics, oBounds, oCombinedImage);
        this.moWallpaper = oWallpaper;
        this.repaint();
    }

    private void drawWallpaper(Graphics aoGraphics, Rectangle aoBounds, Image aoWallpaper) {
        Graphics2D oGraphics = (Graphics2D)aoGraphics;
        int iOrientation = this.miWallpaperOrientation;
        int iX = 0;
        int iY = 0;
        int iWidth = aoWallpaper.getWidth(this);
        int iHeight = aoWallpaper.getHeight(this);
        aoGraphics.setColor(this.getBackground());
        aoGraphics.fillRect(0, 0, aoBounds.width, aoBounds.height);
        switch (iOrientation) {
            case 0: {
                iX = (aoBounds.width - iWidth) / 2;
                iY = (aoBounds.height - iHeight) / 2;
                break;
            }
            case 7: {
                iX = 0;
                iY = (aoBounds.height - iHeight) / 2;
                break;
            }
            case 8: {
                iX = 0;
                iY = 0;
                break;
            }
            case 1: {
                iX = (aoBounds.width - iWidth) / 2;
                iY = 0;
                break;
            }
            case 2: {
                iX = aoBounds.width - iWidth;
                iY = 0;
                break;
            }
            case 3: {
                iX = aoBounds.width - iWidth;
                iY = (aoBounds.height - iHeight) / 2;
                break;
            }
            case 4: {
                iX = aoBounds.width - iWidth;
                iY = aoBounds.height - iHeight;
                break;
            }
            case 5: {
                iX = (aoBounds.width - iWidth) / 2;
                iY = aoBounds.height - iHeight;
                break;
            }
            case 6: {
                iX = 0;
                iY = aoBounds.height - iHeight;
            }
        }
        if (this.miWallpaperStyle == 20) {
            oGraphics.drawImage(aoWallpaper, iX, iY, this);
            return;
        }
        if (this.miWallpaperStyle == 10) {
            this.drawTiledWallpaper(aoGraphics, aoBounds, aoWallpaper, iX, iY);
            return;
        }
        double dWallpaperRatio = (double)iWidth / (double)iHeight;
        double dComponentRatio = (double)aoBounds.width / (double)aoBounds.height;
        iX = 0;
        iY = 0;
        iWidth = aoBounds.width;
        iHeight = aoBounds.height;
        if (this.miWallpaperStyle >= 31 & this.miWallpaperStyle <= 32) {
            boolean bShrink;
            boolean bl = bShrink = this.miWallpaperStyle == 31;
            if (dComponentRatio > dWallpaperRatio) {
                if (bShrink) {
                    iWidth = (int)((double)aoBounds.height * dWallpaperRatio);
                    iX = (aoBounds.width - iWidth) / 2;
                } else {
                    iHeight = (int)((double)aoBounds.width * (1.0 / dWallpaperRatio));
                    iY = (aoBounds.height - iHeight) / 2;
                }
            } else if (dComponentRatio < dWallpaperRatio) {
                if (bShrink) {
                    iHeight = (int)((double)aoBounds.width * (1.0 / dWallpaperRatio));
                    iY = (aoBounds.height - iHeight) / 2;
                } else {
                    iWidth = (int)((double)aoBounds.height * dWallpaperRatio);
                    iX = (aoBounds.width - iWidth) / 2;
                }
            }
        }
        oGraphics.drawImage(aoWallpaper, iX, iY, iWidth, iHeight, this);
    }

    private void drawTiledWallpaper(Graphics aoGraphics, Rectangle aoBounds, Image aoWallpaper, int aiX, int aiY) {
        Graphics2D oGraphics = (Graphics2D)aoGraphics;
        int iWidth = aoWallpaper.getWidth(this);
        int iHeight = aoWallpaper.getHeight(this);
        int iOrigenX = aiX % iWidth - iWidth;
        int iOrigenY = aiY % iHeight - iHeight;
        int iColumns = aoBounds.width / iWidth + 2;
        int iRows = aoBounds.height / iHeight + 2;
        for (int iRowIndex = 0; iRowIndex < iRows; ++iRowIndex) {
            for (int iColumnIndex = 0; iColumnIndex < iColumns; ++iColumnIndex) {
                oGraphics.drawImage(aoWallpaper, iOrigenX + iColumnIndex * iWidth, iOrigenY + iRowIndex * iHeight, this);
            }
        }
    }
}

