/*
 * Decompiled with CFR 0.152.
 */
package novaworx.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import novaworx.swing.XColor;
import novaworx.swing.XWallpaper;
import novaworx.swing.event.PopupEvent;
import novaworx.swing.event.PopupListener;

public class XPopup
extends JComponent {
    private static transient XPopup moPopup;
    private static transient PopupHider moHider;
    private transient Vector mvListeners = new Vector();
    private transient JLayeredPane moLayeredPane;
    private transient Image moBackgroundImage;

    public XPopup() {
        this.setOpaque(false);
        this.setBackground(new Color(0, 0, 0, 0));
    }

    public void pack() {
    }

    public void show(JComponent aoComponent, int aiX, int aiY) {
        moPopup = this;
        Dimension oSize = this.getSize();
        XWallpaper oWallpaper = XPopup.getWallpaper(aoComponent);
        if (oWallpaper == null) {
            this.setBackground(new XColor(this.getBackground(), 255));
        } else {
            Point oLocation = SwingUtilities.convertPoint(aoComponent, aiX, aiY, oWallpaper);
            this.moBackgroundImage = oWallpaper.getSubimage(oLocation.x, oLocation.y, oSize.width, oSize.height);
        }
        this.moLayeredPane = aoComponent.getRootPane().getLayeredPane();
        if (aoComponent != null) {
            Point oOrigin = new Point(aiX, aiY);
            Point oLocation = SwingUtilities.convertPoint(aoComponent, oOrigin, this.moLayeredPane);
            this.setLocation(oLocation);
        } else {
            this.setLocation(aiX, aiY);
        }
        moHider.grab(aoComponent);
        this.moLayeredPane.add((Component)this, JLayeredPane.POPUP_LAYER);
        this.setVisible(true);
    }

    public void cancel() {
        this.setVisible(false);
        this.moLayeredPane.remove(this);
        moHider.ungrab();
        moPopup = null;
    }

    public void paint(Graphics aoGraphics) {
        if (this.moBackgroundImage == null) {
            aoGraphics.setColor(this.getBackground());
            aoGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            aoGraphics.drawImage(this.moBackgroundImage, 0, 0, this);
            aoGraphics.setColor(this.getBackground());
            aoGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paint(aoGraphics);
    }

    private static XWallpaper getWallpaper(Component aoParent) {
        while (aoParent != null && !(aoParent instanceof XWallpaper)) {
            aoParent = aoParent.getParent();
        }
        return (XWallpaper)aoParent;
    }

    public void addPopupListener(PopupListener aoListener) {
        this.mvListeners.add(aoListener);
    }

    public void removePopupListener(PopupListener aoListener) {
        this.mvListeners.remove(aoListener);
    }

    protected void fireSelectionMade(Object aoSelection) {
        PopupEvent oEvent = new PopupEvent((Object)this, aoSelection);
        int iCount = this.mvListeners.size();
        for (int iIndex = 0; iIndex < iCount; ++iIndex) {
            ((PopupListener)this.mvListeners.get(iIndex)).selectionMade(oEvent);
        }
    }

    static {
        moHider = new PopupHider();
    }

    private static class PopupHider
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener,
    WindowListener,
    ComponentListener {
        Vector mvGrabbed = new Vector();

        void grab(Component aoCompnent) {
            this.grabContainer(PopupHider.getWindow(aoCompnent), moPopup);
        }

        void ungrab() {
            this.ungrabContainers();
        }

        void cancelPopup() {
            if (moPopup != null) {
                moPopup.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void grabContainer(Container aoContainer, Component aoExcluded) {
            if (aoContainer == aoExcluded) {
                return;
            }
            if (aoContainer instanceof Window) {
                ((Window)aoContainer).addWindowListener(this);
                ((Window)aoContainer).addComponentListener(this);
                this.mvGrabbed.addElement(aoContainer);
            }
            Object object = aoContainer.getTreeLock();
            synchronized (object) {
                int iComponentCount = aoContainer.getComponentCount();
                Component[] aComponents = aoContainer.getComponents();
                for (int iIndex = 0; iIndex < iComponentCount; ++iIndex) {
                    Component oComponent = aComponents[iIndex];
                    if (!oComponent.isVisible()) continue;
                    oComponent.addMouseListener(this);
                    oComponent.addMouseMotionListener(this);
                    oComponent.addMouseWheelListener(this);
                    this.mvGrabbed.addElement(oComponent);
                    if (!(oComponent instanceof Container)) continue;
                    Container oContainer = (Container)oComponent;
                    this.grabContainer(oContainer, aoExcluded);
                }
            }
        }

        void ungrabContainers() {
            int iCount = this.mvGrabbed.size();
            for (int iIndex = 0; iIndex < iCount; ++iIndex) {
                Component oComponent = (Component)this.mvGrabbed.elementAt(0);
                if (oComponent instanceof Window) {
                    ((Window)oComponent).removeWindowListener(this);
                    ((Window)oComponent).removeComponentListener(this);
                    continue;
                }
                oComponent.removeMouseListener(this);
                oComponent.removeMouseMotionListener(this);
                oComponent.removeMouseWheelListener(this);
            }
            this.mvGrabbed = new Vector();
        }

        private static Window getWindow(Component aoComponent) {
            Component oWindow;
            for (oWindow = aoComponent; !(oWindow instanceof Window) && oWindow != null; oWindow = oWindow.getParent()) {
            }
            return (Window)oWindow;
        }

        public void mousePressed(MouseEvent e) {
            this.cancelPopup();
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            this.cancelPopup();
        }

        public void componentResized(ComponentEvent e) {
            this.cancelPopup();
        }

        public void componentMoved(ComponentEvent e) {
            this.cancelPopup();
        }

        public void componentShown(ComponentEvent e) {
            this.cancelPopup();
        }

        public void componentHidden(ComponentEvent e) {
            this.cancelPopup();
        }

        public void windowOpened(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            this.cancelPopup();
        }

        public void windowClosed(WindowEvent e) {
            this.cancelPopup();
        }

        public void windowIconified(WindowEvent e) {
            this.cancelPopup();
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
        }
    }
}

