/*
 * Decompiled with CFR 0.152.
 */
package novaworx.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import novaworx.swing.XAction;

public class XMenuItem
extends JMenuItem {
    private Action moAction;
    private String msShortcut;
    private static final int miArrowSpace = 10;
    private static Font moShortcutFont = UIManager.getFont("MenuItem.acceleratorFont");
    private static Color moShortcutForeground;
    private static Color moShortcutDisabledForeground;
    private static Color moShortcutSelectedForeground;

    public XMenuItem(Action aoAction) {
        super(aoAction);
        this.moAction = aoAction;
    }

    public String getShortcut() {
        String sShortcut = (String)this.moAction.getValue("shortcut.key.sequence");
        return sShortcut == null ? "" : sShortcut;
    }

    public String getShortcutText() {
        return XAction.getShortcutDisplayText(this.getShortcut());
    }

    public int getShortcutWidth() {
        return this.getFontMetrics(moShortcutFont).stringWidth(this.getShortcutText());
    }

    public Dimension getPreferredSize() {
        String sShortcut = this.getShortcut();
        Dimension oSize = super.getPreferredSize();
        if (sShortcut != null) {
            boolean iShortcutOffset = false;
            Container oContainer = this.getParent();
            if (oContainer != null && oContainer instanceof JComponent) {
                JComponent oParent = (JComponent)oContainer;
                Integer oMaxValue = (Integer)oParent.getClientProperty("max.shortcut.width");
                int iMaxValue = oMaxValue != null ? oMaxValue.intValue() : this.getShortcutWidth();
                oSize.width += iMaxValue + 10;
            }
        }
        return oSize;
    }

    public void paint(Graphics aoGraphics) {
        Graphics2D oGraphics = (Graphics2D)aoGraphics;
        Boolean oAntiAlias = (Boolean)this.getRootPane().getClientProperty("anti.alias.text");
        oGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oAntiAlias != null && oAntiAlias != false ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        super.paint(aoGraphics);
        String sShortcut = this.getShortcutText();
        if (sShortcut != null) {
            aoGraphics.setFont(moShortcutFont);
            aoGraphics.setColor(this.getModel().isArmed() ? moShortcutSelectedForeground : moShortcutForeground);
            if (!this.isEnabled()) {
                aoGraphics.setColor(moShortcutDisabledForeground);
            }
            Insets oInsets = this.getInsets();
            FontMetrics oMetrics = aoGraphics.getFontMetrics();
            int iShortcutWidth = oMetrics.stringWidth(sShortcut);
            int iShortcutAscent = oMetrics.getAscent();
            int iShortcutOffset = 0;
            Container oContainer = this.getParent();
            if (oContainer != null && oContainer instanceof JComponent) {
                JComponent oParent = (JComponent)oContainer;
                Integer oMaxValue = (Integer)oParent.getClientProperty("max.shortcut.width");
                int iMaxValue = oMaxValue != null ? oMaxValue : iShortcutWidth;
                iShortcutOffset = iMaxValue - iShortcutWidth;
            }
            aoGraphics.drawString(sShortcut, this.getWidth() - (iShortcutOffset + iShortcutWidth + 10 + oInsets.right + oInsets.left), (this.getHeight() + iShortcutAscent - 2) / 2 - 1);
        }
    }

    static {
        if (moShortcutFont == null) {
            moShortcutFont = new Font("Monospaced", 0, 8);
        }
        moShortcutForeground = UIManager.getColor("MenuItem.acceleratorForeground");
        moShortcutDisabledForeground = UIManager.getColor("MenuItem.disabledForeground");
        moShortcutSelectedForeground = UIManager.getColor("MenuItem.acceleratorSelectionForeground");
    }
}

