/*
 * Decompiled with CFR 0.152.
 */
package novaworx.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Collection;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import novaworx.swing.XColor;
import novaworx.swing.XList;
import novaworx.swing.XPopup;

public class XListPopup
extends XPopup {
    private XList moList;
    private JScrollPane moScroller;
    private DefaultComboBoxModel moListModel;
    private int miMaxRows;
    private ListSelectionHandler moListSelectionHandler;

    public XListPopup() {
        this((Collection)null);
    }

    public XListPopup(Object[] aaItems) {
        this(Arrays.asList(aaItems));
    }

    public XListPopup(Collection aoItems) {
        this.moListModel = aoItems == null ? new DefaultComboBoxModel() : new DefaultComboBoxModel(new Vector(aoItems));
        this.moListSelectionHandler = new ListSelectionHandler();
        this.moList = new XList((ListModel)this.moListModel);
        this.moList.setSelectionMode(0);
        this.moList.addListSelectionListener(this.moListSelectionHandler);
        super.setOpaque(false);
        super.setBackground(XColor.CLEAR);
        super.setLayout(new BorderLayout());
        this.moScroller = new JScrollPane(this.moList);
        this.moScroller.setOpaque(false);
        this.moScroller.getViewport().setOpaque(false);
        this.moScroller.setBorder(new LineBorder(this.getForeground(), 1));
        super.add((Component)this.moScroller, "Center");
    }

    public void add(Object aoObject) {
        this.moListModel.addElement(aoObject);
        this.updateSize();
    }

    public void setForeground(Color aoColor) {
        super.setForeground(aoColor);
        if (this.moList != null) {
            this.moList.setForeground(aoColor);
        }
        this.moScroller.setBorder(new LineBorder(aoColor, 1));
    }

    public void setBackground(Color aoColor) {
        super.setBackground(aoColor);
    }

    public void setMaximumRowCount(int aiCount) {
        this.miMaxRows = aiCount;
        this.updateSize();
    }

    public int getMaximumRowCount() {
        return this.miMaxRows;
    }

    private void updateSize() {
        int iRowHeight;
        int iMaxHeight;
        Dimension oPreferredSize = this.moList.getPreferredSize();
        int iHeight = oPreferredSize.height;
        int iRows = this.moList.getModel().getSize();
        if (iRows > 0 && (iMaxHeight = (iRowHeight = oPreferredSize.height / iRows) * this.miMaxRows) > 0) {
            iHeight = Math.min(iHeight, iMaxHeight);
        }
        this.moScroller.setPreferredSize(new Dimension(oPreferredSize.width, iHeight + 2));
    }

    private class ListSelectionHandler
    implements ListSelectionListener {
        private ListSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent aoEvent) {
            if (aoEvent.getValueIsAdjusting()) {
                return;
            }
            XListPopup.this.cancel();
            int iIndex = aoEvent.getFirstIndex();
            XListPopup.this.fireSelectionMade(XListPopup.this.moList.getModel().getElementAt(iIndex));
        }
    }
}

